"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readFile = readFile;
const upath_1 = require("upath");
const fs_extra_1 = require("fs-extra");
async function readFile(path, file) {
    try {
        const fullPath = (0, upath_1.join)(path, file);
        return await (0, fs_extra_1.readFile)(fullPath, 'utf8');
    }
    catch (_) {
        return null;
    }
}
