"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeProjectManifest = void 0;
const fs_1 = require("fs");
const path_1 = __importDefault(require("path"));
const text_comments_parser_1 = require("@pnpm/text.comments-parser");
const json5_1 = __importDefault(require("json5"));
const write_file_atomic_1 = __importDefault(require("write-file-atomic"));
const write_yaml_file_1 = __importDefault(require("write-yaml-file"));
const YAML_FORMAT = {
    noCompatMode: true,
    noRefs: true,
};
async function writeProjectManifest(filePath, manifest, opts) {
    const fileType = filePath.slice(filePath.lastIndexOf('.') + 1).toLowerCase();
    if (fileType === 'yaml') {
        return (0, write_yaml_file_1.default)(filePath, manifest, YAML_FORMAT);
    }
    await fs_1.promises.mkdir(path_1.default.dirname(filePath), { recursive: true });
    const trailingNewline = opts?.insertFinalNewline === false ? '' : '\n';
    const indent = opts?.indent ?? '\t';
    const json = (fileType === 'json5'
        ? stringifyJson5(manifest, indent, opts?.comments)
        : JSON.stringify(manifest, undefined, indent));
    return (0, write_file_atomic_1.default)(filePath, `${json}${trailingNewline}`);
}
exports.writeProjectManifest = writeProjectManifest;
function stringifyJson5(obj, indent, comments) {
    const json5 = json5_1.default.stringify(obj, undefined, indent);
    if (comments) {
        return (0, text_comments_parser_1.insertComments)(json5, comments);
    }
    return json5;
}
//# sourceMappingURL=index.js.map