'use strict';

var require$$0 = require('util');
var require$$1 = require('path');
var require$$2 = require('fs');

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function commonjsRequire(path) {
	throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
}

var js_rattler = {exports: {}};

js_rattler.exports;

var hasRequiredJs_rattler;

function requireJs_rattler () {
	if (hasRequiredJs_rattler) return js_rattler.exports;
	hasRequiredJs_rattler = 1;
	(function (module) {
		let imports = {};
		imports['__wbindgen_placeholder__'] = module.exports;
		let wasm;
		const { TextEncoder, TextDecoder } = require$$0;

		let WASM_VECTOR_LEN = 0;

		let cachedUint8ArrayMemory0 = null;

		function getUint8ArrayMemory0() {
		    if (cachedUint8ArrayMemory0 === null || cachedUint8ArrayMemory0.byteLength === 0) {
		        cachedUint8ArrayMemory0 = new Uint8Array(wasm.memory.buffer);
		    }
		    return cachedUint8ArrayMemory0;
		}

		let cachedTextEncoder = new TextEncoder('utf-8');

		const encodeString = (typeof cachedTextEncoder.encodeInto === 'function'
		    ? function (arg, view) {
		    return cachedTextEncoder.encodeInto(arg, view);
		}
		    : function (arg, view) {
		    const buf = cachedTextEncoder.encode(arg);
		    view.set(buf);
		    return {
		        read: arg.length,
		        written: buf.length
		    };
		});

		function passStringToWasm0(arg, malloc, realloc) {

		    if (realloc === undefined) {
		        const buf = cachedTextEncoder.encode(arg);
		        const ptr = malloc(buf.length, 1) >>> 0;
		        getUint8ArrayMemory0().subarray(ptr, ptr + buf.length).set(buf);
		        WASM_VECTOR_LEN = buf.length;
		        return ptr;
		    }

		    let len = arg.length;
		    let ptr = malloc(len, 1) >>> 0;

		    const mem = getUint8ArrayMemory0();

		    let offset = 0;

		    for (; offset < len; offset++) {
		        const code = arg.charCodeAt(offset);
		        if (code > 0x7F) break;
		        mem[ptr + offset] = code;
		    }

		    if (offset !== len) {
		        if (offset !== 0) {
		            arg = arg.slice(offset);
		        }
		        ptr = realloc(ptr, len, len = offset + arg.length * 3, 1) >>> 0;
		        const view = getUint8ArrayMemory0().subarray(ptr + offset, ptr + len);
		        const ret = encodeString(arg, view);

		        offset += ret.written;
		        ptr = realloc(ptr, len, offset, 1) >>> 0;
		    }

		    WASM_VECTOR_LEN = offset;
		    return ptr;
		}

		let cachedDataViewMemory0 = null;

		function getDataViewMemory0() {
		    if (cachedDataViewMemory0 === null || cachedDataViewMemory0.buffer.detached === true || (cachedDataViewMemory0.buffer.detached === undefined && cachedDataViewMemory0.buffer !== wasm.memory.buffer)) {
		        cachedDataViewMemory0 = new DataView(wasm.memory.buffer);
		    }
		    return cachedDataViewMemory0;
		}

		let cachedTextDecoder = new TextDecoder('utf-8', { ignoreBOM: true, fatal: true });

		cachedTextDecoder.decode();

		function getStringFromWasm0(ptr, len) {
		    ptr = ptr >>> 0;
		    return cachedTextDecoder.decode(getUint8ArrayMemory0().subarray(ptr, ptr + len));
		}

		function addToExternrefTable0(obj) {
		    const idx = wasm.__externref_table_alloc();
		    wasm.__wbindgen_export_4.set(idx, obj);
		    return idx;
		}

		function handleError(f, args) {
		    try {
		        return f.apply(this, args);
		    } catch (e) {
		        const idx = addToExternrefTable0(e);
		        wasm.__wbindgen_exn_store(idx);
		    }
		}

		function isLikeNone(x) {
		    return x === undefined || x === null;
		}

		const CLOSURE_DTORS = (typeof FinalizationRegistry === 'undefined')
		    ? { register: () => {}, unregister: () => {} }
		    : new FinalizationRegistry(state => {
		    wasm.__wbindgen_export_6.get(state.dtor)(state.a, state.b);
		});

		function makeMutClosure(arg0, arg1, dtor, f) {
		    const state = { a: arg0, b: arg1, cnt: 1, dtor };
		    const real = (...args) => {
		        // First up with a closure we increment the internal reference
		        // count. This ensures that the Rust closure environment won't
		        // be deallocated while we're invoking it.
		        state.cnt++;
		        const a = state.a;
		        state.a = 0;
		        try {
		            return f(a, state.b, ...args);
		        } finally {
		            if (--state.cnt === 0) {
		                wasm.__wbindgen_export_6.get(state.dtor)(a, state.b);
		                CLOSURE_DTORS.unregister(state);
		            } else {
		                state.a = a;
		            }
		        }
		    };
		    real.original = state;
		    CLOSURE_DTORS.register(real, state, state);
		    return real;
		}

		function debugString(val) {
		    // primitive types
		    const type = typeof val;
		    if (type == 'number' || type == 'boolean' || val == null) {
		        return  `${val}`;
		    }
		    if (type == 'string') {
		        return `"${val}"`;
		    }
		    if (type == 'symbol') {
		        const description = val.description;
		        if (description == null) {
		            return 'Symbol';
		        } else {
		            return `Symbol(${description})`;
		        }
		    }
		    if (type == 'function') {
		        const name = val.name;
		        if (typeof name == 'string' && name.length > 0) {
		            return `Function(${name})`;
		        } else {
		            return 'Function';
		        }
		    }
		    // objects
		    if (Array.isArray(val)) {
		        const length = val.length;
		        let debug = '[';
		        if (length > 0) {
		            debug += debugString(val[0]);
		        }
		        for(let i = 1; i < length; i++) {
		            debug += ', ' + debugString(val[i]);
		        }
		        debug += ']';
		        return debug;
		    }
		    // Test for built-in
		    const builtInMatches = /\[object ([^\]]+)\]/.exec(toString.call(val));
		    let className;
		    if (builtInMatches && builtInMatches.length > 1) {
		        className = builtInMatches[1];
		    } else {
		        // Failed to match the standard '[object ClassName]'
		        return toString.call(val);
		    }
		    if (className == 'Object') {
		        // we're a user defined class or Object
		        // JSON.stringify avoids problems with cycles, and is generally much
		        // easier than looping through ownProperties of `val`.
		        try {
		            return 'Object(' + JSON.stringify(val) + ')';
		        } catch (_) {
		            return 'Object';
		        }
		    }
		    // errors
		    if (val instanceof Error) {
		        return `${val.name}: ${val.message}\n${val.stack}`;
		    }
		    // TODO we could test for more things here, like `Set`s and `Map`s.
		    return className;
		}

		function takeFromExternrefTable0(idx) {
		    const value = wasm.__wbindgen_export_4.get(idx);
		    wasm.__externref_table_dealloc(idx);
		    return value;
		}

		function passArrayJsValueToWasm0(array, malloc) {
		    const ptr = malloc(array.length * 4, 4) >>> 0;
		    for (let i = 0; i < array.length; i++) {
		        const add = addToExternrefTable0(array[i]);
		        getDataViewMemory0().setUint32(ptr + 4 * i, add, true);
		    }
		    WASM_VECTOR_LEN = array.length;
		    return ptr;
		}
		/**
		 * Solve a set of specs with the given channels and platforms.
		 * @public
		 * @param {string[]} specs - Matchspecs of packages that must be included.
		 * @param {string[]} channels - The channels to request for repodata of packages
		 * @param {Platform[]} platforms - The platforms to solve for
		 * @returns {Promise<SolvedPackage[]>}
		 */
		module.exports.simpleSolve = function(specs, channels, platforms) {
		    const ptr0 = passArrayJsValueToWasm0(specs, wasm.__wbindgen_malloc);
		    const len0 = WASM_VECTOR_LEN;
		    const ptr1 = passArrayJsValueToWasm0(channels, wasm.__wbindgen_malloc);
		    const len1 = WASM_VECTOR_LEN;
		    const ptr2 = passArrayJsValueToWasm0(platforms, wasm.__wbindgen_malloc);
		    const len2 = WASM_VECTOR_LEN;
		    const ret = wasm.simpleSolve(ptr0, len0, ptr1, len1, ptr2, len2);
		    return ret;
		};

		function getArrayJsValueFromWasm0(ptr, len) {
		    ptr = ptr >>> 0;
		    const mem = getDataViewMemory0();
		    const result = [];
		    for (let i = ptr; i < ptr + 4 * len; i += 4) {
		        result.push(wasm.__wbindgen_export_4.get(mem.getUint32(i, true)));
		    }
		    wasm.__externref_drop_slice(ptr, len);
		    return result;
		}

		function _assertClass(instance, klass) {
		    if (!(instance instanceof klass)) {
		        throw new Error(`expected instance of ${klass.name}`);
		    }
		}
		/**
		 * This function is called when the wasm module is instantiated.
		 */
		module.exports.start = function() {
		    wasm.start();
		};

		function __wbg_adapter_60(arg0, arg1) {
		    wasm._dyn_core__ops__function__FnMut_____Output___R_as_wasm_bindgen__closure__WasmClosure___describe__invoke__hf53fc962b8a60a88(arg0, arg1);
		}

		function __wbg_adapter_63(arg0, arg1, arg2) {
		    wasm.closure1596_externref_shim(arg0, arg1, arg2);
		}

		function __wbg_adapter_321(arg0, arg1, arg2, arg3) {
		    wasm.closure1629_externref_shim(arg0, arg1, arg2, arg3);
		}

		const __wbindgen_enum_ReadableStreamType = ["bytes"];

		const __wbindgen_enum_RequestCredentials = ["omit", "same-origin", "include"];

		const __wbindgen_enum_RequestMode = ["same-origin", "no-cors", "cors", "navigate"];

		const IntoUnderlyingByteSourceFinalization = (typeof FinalizationRegistry === 'undefined')
		    ? { register: () => {}, unregister: () => {} }
		    : new FinalizationRegistry(ptr => wasm.__wbg_intounderlyingbytesource_free(ptr >>> 0, 1));

		class IntoUnderlyingByteSource {

		    __destroy_into_raw() {
		        const ptr = this.__wbg_ptr;
		        this.__wbg_ptr = 0;
		        IntoUnderlyingByteSourceFinalization.unregister(this);
		        return ptr;
		    }

		    free() {
		        const ptr = this.__destroy_into_raw();
		        wasm.__wbg_intounderlyingbytesource_free(ptr, 0);
		    }
		    /**
		     * @returns {ReadableStreamType}
		     */
		    get type() {
		        const ret = wasm.intounderlyingbytesource_type(this.__wbg_ptr);
		        return __wbindgen_enum_ReadableStreamType[ret];
		    }
		    /**
		     * @returns {number}
		     */
		    get autoAllocateChunkSize() {
		        const ret = wasm.intounderlyingbytesource_autoAllocateChunkSize(this.__wbg_ptr);
		        return ret >>> 0;
		    }
		    /**
		     * @param {ReadableByteStreamController} controller
		     */
		    start(controller) {
		        wasm.intounderlyingbytesource_start(this.__wbg_ptr, controller);
		    }
		    /**
		     * @param {ReadableByteStreamController} controller
		     * @returns {Promise<any>}
		     */
		    pull(controller) {
		        const ret = wasm.intounderlyingbytesource_pull(this.__wbg_ptr, controller);
		        return ret;
		    }
		    cancel() {
		        const ptr = this.__destroy_into_raw();
		        wasm.intounderlyingbytesource_cancel(ptr);
		    }
		}
		module.exports.IntoUnderlyingByteSource = IntoUnderlyingByteSource;

		const IntoUnderlyingSinkFinalization = (typeof FinalizationRegistry === 'undefined')
		    ? { register: () => {}, unregister: () => {} }
		    : new FinalizationRegistry(ptr => wasm.__wbg_intounderlyingsink_free(ptr >>> 0, 1));

		class IntoUnderlyingSink {

		    __destroy_into_raw() {
		        const ptr = this.__wbg_ptr;
		        this.__wbg_ptr = 0;
		        IntoUnderlyingSinkFinalization.unregister(this);
		        return ptr;
		    }

		    free() {
		        const ptr = this.__destroy_into_raw();
		        wasm.__wbg_intounderlyingsink_free(ptr, 0);
		    }
		    /**
		     * @param {any} chunk
		     * @returns {Promise<any>}
		     */
		    write(chunk) {
		        const ret = wasm.intounderlyingsink_write(this.__wbg_ptr, chunk);
		        return ret;
		    }
		    /**
		     * @returns {Promise<any>}
		     */
		    close() {
		        const ptr = this.__destroy_into_raw();
		        const ret = wasm.intounderlyingsink_close(ptr);
		        return ret;
		    }
		    /**
		     * @param {any} reason
		     * @returns {Promise<any>}
		     */
		    abort(reason) {
		        const ptr = this.__destroy_into_raw();
		        const ret = wasm.intounderlyingsink_abort(ptr, reason);
		        return ret;
		    }
		}
		module.exports.IntoUnderlyingSink = IntoUnderlyingSink;

		const IntoUnderlyingSourceFinalization = (typeof FinalizationRegistry === 'undefined')
		    ? { register: () => {}, unregister: () => {} }
		    : new FinalizationRegistry(ptr => wasm.__wbg_intounderlyingsource_free(ptr >>> 0, 1));

		class IntoUnderlyingSource {

		    __destroy_into_raw() {
		        const ptr = this.__wbg_ptr;
		        this.__wbg_ptr = 0;
		        IntoUnderlyingSourceFinalization.unregister(this);
		        return ptr;
		    }

		    free() {
		        const ptr = this.__destroy_into_raw();
		        wasm.__wbg_intounderlyingsource_free(ptr, 0);
		    }
		    /**
		     * @param {ReadableStreamDefaultController} controller
		     * @returns {Promise<any>}
		     */
		    pull(controller) {
		        const ret = wasm.intounderlyingsource_pull(this.__wbg_ptr, controller);
		        return ret;
		    }
		    cancel() {
		        const ptr = this.__destroy_into_raw();
		        wasm.intounderlyingsource_cancel(ptr);
		    }
		}
		module.exports.IntoUnderlyingSource = IntoUnderlyingSource;

		const JsGatewayFinalization = (typeof FinalizationRegistry === 'undefined')
		    ? { register: () => {}, unregister: () => {} }
		    : new FinalizationRegistry(ptr => wasm.__wbg_jsgateway_free(ptr >>> 0, 1));

		class JsGateway {

		    __destroy_into_raw() {
		        const ptr = this.__wbg_ptr;
		        this.__wbg_ptr = 0;
		        JsGatewayFinalization.unregister(this);
		        return ptr;
		    }

		    free() {
		        const ptr = this.__destroy_into_raw();
		        wasm.__wbg_jsgateway_free(ptr, 0);
		    }
		    /**
		     * @param {any} input
		     */
		    constructor(input) {
		        const ret = wasm.jsgateway_new(input);
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        this.__wbg_ptr = ret[0] >>> 0;
		        JsGatewayFinalization.register(this, this.__wbg_ptr, this);
		        return this;
		    }
		    /**
		     * @param {string[]} channels
		     * @param {string[]} platforms
		     * @returns {Promise<string[]>}
		     */
		    names(channels, platforms) {
		        const ptr0 = passArrayJsValueToWasm0(channels, wasm.__wbindgen_malloc);
		        const len0 = WASM_VECTOR_LEN;
		        const ptr1 = passArrayJsValueToWasm0(platforms, wasm.__wbindgen_malloc);
		        const len1 = WASM_VECTOR_LEN;
		        const ret = wasm.jsgateway_names(this.__wbg_ptr, ptr0, len0, ptr1, len1);
		        return ret;
		    }
		}
		module.exports.JsGateway = JsGateway;

		const PackageRecordFinalization = (typeof FinalizationRegistry === 'undefined')
		    ? { register: () => {}, unregister: () => {} }
		    : new FinalizationRegistry(ptr => wasm.__wbg_packagerecord_free(ptr >>> 0, 1));
		/**
		 * A single record in the Conda repodata. A single record refers to a single
		 * binary distribution of a package on a Conda channel.
		 *
		 * @public
		 */
		class PackageRecord {

		    __destroy_into_raw() {
		        const ptr = this.__wbg_ptr;
		        this.__wbg_ptr = 0;
		        PackageRecordFinalization.unregister(this);
		        return ptr;
		    }

		    free() {
		        const ptr = this.__destroy_into_raw();
		        wasm.__wbg_packagerecord_free(ptr, 0);
		    }
		    /**
		     * Constructs a new instance from the json representation of a
		     * PackageRecord.
		     * @param {PackageRecordJson} json
		     */
		    constructor(json) {
		        const ret = wasm.packagerecord_new(json);
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        this.__wbg_ptr = ret[0] >>> 0;
		        PackageRecordFinalization.register(this, this.__wbg_ptr, this);
		        return this;
		    }
		    /**
		     * Convert this instance to the canonical json representation of a
		     * PackageRecord.
		     * @returns {PackageRecordJson}
		     */
		    toJson() {
		        const ret = wasm.packagerecord_toJson(this.__wbg_ptr);
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        return takeFromExternrefTable0(ret[0]);
		    }
		    /**
		     * Optionally the architecture the package supports. This is almost
		     * always the second part of the `subdir` field. Except for `64` which
		     * maps to `x86_64` and `32` which maps to `x86`. This will be undefined if
		     * the package is `noarch`.
		     * @returns {Arch | undefined}
		     */
		    get arch() {
		        const ret = wasm.packagerecord_arch(this.__wbg_ptr);
		        return ret;
		    }
		    /**
		     * @param {Arch | undefined} arch
		     */
		    set arch(arch) {
		        const ret = wasm.packagerecord_set_arch(this.__wbg_ptr, arch);
		        if (ret[1]) {
		            throw takeFromExternrefTable0(ret[0]);
		        }
		    }
		    /**
		     * The build string of the package.
		     * @returns {string}
		     */
		    get build() {
		        let deferred1_0;
		        let deferred1_1;
		        try {
		            const ret = wasm.packagerecord_build(this.__wbg_ptr);
		            deferred1_0 = ret[0];
		            deferred1_1 = ret[1];
		            return getStringFromWasm0(ret[0], ret[1]);
		        } finally {
		            wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
		        }
		    }
		    /**
		     * @param {string} build
		     */
		    set build(build) {
		        const ptr0 = passStringToWasm0(build, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        const len0 = WASM_VECTOR_LEN;
		        wasm.packagerecord_set_build(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * The build number of the package.
		     * @returns {number}
		     */
		    get buildNumber() {
		        const ret = wasm.packagerecord_buildNumber(this.__wbg_ptr);
		        return ret >>> 0;
		    }
		    /**
		     * @param {number} build_number
		     */
		    set buildNumber(build_number) {
		        wasm.packagerecord_set_buildNumber(this.__wbg_ptr, build_number);
		    }
		    /**
		     * Additional constraints on packages. `constrains` are different from
		     * `depends` in that packages specified in `depends` must be installed
		     * next to this package, whereas packages specified in `constrains` are
		     * not required to be installed, but if they are installed they must follow
		     * these constraints.
		     * @returns {string[]}
		     */
		    get constrains() {
		        const ret = wasm.packagerecord_constrains(this.__wbg_ptr);
		        var v1 = getArrayJsValueFromWasm0(ret[0], ret[1]).slice();
		        wasm.__wbindgen_free(ret[0], ret[1] * 4, 4);
		        return v1;
		    }
		    /**
		     * @param {string[]} constraints
		     */
		    set constrains(constraints) {
		        const ptr0 = passArrayJsValueToWasm0(constraints, wasm.__wbindgen_malloc);
		        const len0 = WASM_VECTOR_LEN;
		        wasm.packagerecord_set_constrains(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * Specification of packages this package depends on
		     * @returns {string[]}
		     */
		    get depends() {
		        const ret = wasm.packagerecord_depends(this.__wbg_ptr);
		        var v1 = getArrayJsValueFromWasm0(ret[0], ret[1]).slice();
		        wasm.__wbindgen_free(ret[0], ret[1] * 4, 4);
		        return v1;
		    }
		    /**
		     * @param {string[]} depends
		     */
		    set depends(depends) {
		        const ptr0 = passArrayJsValueToWasm0(depends, wasm.__wbindgen_malloc);
		        const len0 = WASM_VECTOR_LEN;
		        wasm.packagerecord_set_depends(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * Features are a deprecated way to specify different feature sets for the
		     * conda solver. This is not supported anymore and should not be used.
		     * Instead, `mutex` packages should be used to specify
		     * mutually exclusive features.
		     * @returns {string | undefined}
		     */
		    get features() {
		        const ret = wasm.packagerecord_features(this.__wbg_ptr);
		        let v1;
		        if (ret[0] !== 0) {
		            v1 = getStringFromWasm0(ret[0], ret[1]).slice();
		            wasm.__wbindgen_free(ret[0], ret[1] * 1, 1);
		        }
		        return v1;
		    }
		    /**
		     * @param {string | undefined} features
		     */
		    set features(features) {
		        var ptr0 = isLikeNone(features) ? 0 : passStringToWasm0(features, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        var len0 = WASM_VECTOR_LEN;
		        wasm.packagerecord_set_features(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * The specific license of the package
		     * @returns {string | undefined}
		     */
		    get license() {
		        const ret = wasm.packagerecord_license(this.__wbg_ptr);
		        let v1;
		        if (ret[0] !== 0) {
		            v1 = getStringFromWasm0(ret[0], ret[1]).slice();
		            wasm.__wbindgen_free(ret[0], ret[1] * 1, 1);
		        }
		        return v1;
		    }
		    /**
		     * @param {string | undefined} license
		     */
		    set license(license) {
		        var ptr0 = isLikeNone(license) ? 0 : passStringToWasm0(license, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        var len0 = WASM_VECTOR_LEN;
		        wasm.packagerecord_set_license(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * The license family
		     * @returns {string | undefined}
		     */
		    get licenseFamily() {
		        const ret = wasm.packagerecord_licenseFamily(this.__wbg_ptr);
		        let v1;
		        if (ret[0] !== 0) {
		            v1 = getStringFromWasm0(ret[0], ret[1]).slice();
		            wasm.__wbindgen_free(ret[0], ret[1] * 1, 1);
		        }
		        return v1;
		    }
		    /**
		     * @param {string | undefined} license_family
		     */
		    set licenseFamily(license_family) {
		        var ptr0 = isLikeNone(license_family) ? 0 : passStringToWasm0(license_family, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        var len0 = WASM_VECTOR_LEN;
		        wasm.packagerecord_set_licenseFamily(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * The name of the package
		     * @returns {PackageName}
		     */
		    get name() {
		        const ret = wasm.packagerecord_name(this.__wbg_ptr);
		        return ret;
		    }
		    /**
		     * @param {PackageName} name
		     */
		    set name(name) {
		        const ret = wasm.packagerecord_set_name(this.__wbg_ptr, name);
		        if (ret[1]) {
		            throw takeFromExternrefTable0(ret[0]);
		        }
		    }
		    /**
		     * Optionally a MD5 hash of the package archive encoded as a hex string
		     * @returns {string | undefined}
		     */
		    get md5() {
		        const ret = wasm.packagerecord_md5(this.__wbg_ptr);
		        let v1;
		        if (ret[0] !== 0) {
		            v1 = getStringFromWasm0(ret[0], ret[1]).slice();
		            wasm.__wbindgen_free(ret[0], ret[1] * 1, 1);
		        }
		        return v1;
		    }
		    /**
		     * @param {string | undefined} md5
		     */
		    set md5(md5) {
		        var ptr0 = isLikeNone(md5) ? 0 : passStringToWasm0(md5, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        var len0 = WASM_VECTOR_LEN;
		        const ret = wasm.packagerecord_set_md5(this.__wbg_ptr, ptr0, len0);
		        if (ret[1]) {
		            throw takeFromExternrefTable0(ret[0]);
		        }
		    }
		    /**
		     * Deprecated md5 hash
		     * @deprecated Use `md5` instead
		     * @returns {string | undefined}
		     */
		    get legacyBz2Md5() {
		        const ret = wasm.packagerecord_legacyBz2Md5(this.__wbg_ptr);
		        let v1;
		        if (ret[0] !== 0) {
		            v1 = getStringFromWasm0(ret[0], ret[1]).slice();
		            wasm.__wbindgen_free(ret[0], ret[1] * 1, 1);
		        }
		        return v1;
		    }
		    /**
		     * @param {string | undefined} legacy_bz2_md5
		     */
		    set legacyBz2Md5(legacy_bz2_md5) {
		        var ptr0 = isLikeNone(legacy_bz2_md5) ? 0 : passStringToWasm0(legacy_bz2_md5, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        var len0 = WASM_VECTOR_LEN;
		        const ret = wasm.packagerecord_set_legacyBz2Md5(this.__wbg_ptr, ptr0, len0);
		        if (ret[1]) {
		            throw takeFromExternrefTable0(ret[0]);
		        }
		    }
		    /**
		     * Deprecated size of the package archive.
		     * @deprecated Use `size` instead
		     * @returns {number | undefined}
		     */
		    get legacyBz2Size() {
		        const ret = wasm.packagerecord_legacyBz2Size(this.__wbg_ptr);
		        return ret === 0x100000001 ? undefined : ret;
		    }
		    /**
		     * @param {number | undefined} legacy_bz2_size
		     */
		    set legacyBz2Size(legacy_bz2_size) {
		        wasm.packagerecord_set_legacyBz2Size(this.__wbg_ptr, isLikeNone(legacy_bz2_size) ? 0x100000001 : (legacy_bz2_size) >>> 0);
		    }
		    /**
		     * Optionally a Sha256 hash of the package archive encoded as a hex string
		     * @returns {string | undefined}
		     */
		    get sha256() {
		        const ret = wasm.packagerecord_sha256(this.__wbg_ptr);
		        let v1;
		        if (ret[0] !== 0) {
		            v1 = getStringFromWasm0(ret[0], ret[1]).slice();
		            wasm.__wbindgen_free(ret[0], ret[1] * 1, 1);
		        }
		        return v1;
		    }
		    /**
		     * @param {string | undefined} sha256
		     */
		    set sha256(sha256) {
		        var ptr0 = isLikeNone(sha256) ? 0 : passStringToWasm0(sha256, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        var len0 = WASM_VECTOR_LEN;
		        const ret = wasm.packagerecord_set_sha256(this.__wbg_ptr, ptr0, len0);
		        if (ret[1]) {
		            throw takeFromExternrefTable0(ret[0]);
		        }
		    }
		    /**
		     * Optionally the platform the package supports.
		     * Note that this does not match the `Platform` type, but is only the first
		     * part of the platform (e.g. `linux`, `osx`, `win`, ...).
		     * The `subdir` field contains the `Platform` enum.
		     * @returns {string | undefined}
		     */
		    get platform() {
		        const ret = wasm.packagerecord_platform(this.__wbg_ptr);
		        let v1;
		        if (ret[0] !== 0) {
		            v1 = getStringFromWasm0(ret[0], ret[1]).slice();
		            wasm.__wbindgen_free(ret[0], ret[1] * 1, 1);
		        }
		        return v1;
		    }
		    /**
		     * @param {string | undefined} platform
		     */
		    set platform(platform) {
		        var ptr0 = isLikeNone(platform) ? 0 : passStringToWasm0(platform, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        var len0 = WASM_VECTOR_LEN;
		        wasm.packagerecord_set_platform(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * Optionally a path within the environment of the site-packages directory.
		     * This field is only present for python interpreter packages.
		     * @returns {string | undefined}
		     */
		    get pythonSitePackagesPath() {
		        const ret = wasm.packagerecord_pythonSitePackagesPath(this.__wbg_ptr);
		        let v1;
		        if (ret[0] !== 0) {
		            v1 = getStringFromWasm0(ret[0], ret[1]).slice();
		            wasm.__wbindgen_free(ret[0], ret[1] * 1, 1);
		        }
		        return v1;
		    }
		    /**
		     * @param {string | undefined} python_site_packages_path
		     */
		    set pythonSitePackagesPath(python_site_packages_path) {
		        var ptr0 = isLikeNone(python_site_packages_path) ? 0 : passStringToWasm0(python_site_packages_path, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        var len0 = WASM_VECTOR_LEN;
		        wasm.packagerecord_set_pythonSitePackagesPath(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * The size of the package archive in bytes
		     * @returns {number | undefined}
		     */
		    get size() {
		        const ret = wasm.packagerecord_size(this.__wbg_ptr);
		        return ret === 0x100000001 ? undefined : ret;
		    }
		    /**
		     * @param {number | undefined} size
		     */
		    set size(size) {
		        wasm.packagerecord_set_size(this.__wbg_ptr, isLikeNone(size) ? 0x100000001 : (size) >>> 0);
		    }
		    /**
		     * The subdirectory where the package can be found
		     * @returns {Platform}
		     */
		    get subdir() {
		        const ret = wasm.packagerecord_subdir(this.__wbg_ptr);
		        return ret;
		    }
		    /**
		     * @param {Platform} platform
		     */
		    set subdir(platform) {
		        const ret = wasm.packagerecord_set_subdir(this.__wbg_ptr, platform);
		        if (ret[1]) {
		            throw takeFromExternrefTable0(ret[0]);
		        }
		    }
		    /**
		     * If this package is independent of architecture this field specifies in
		     * what way. See [`NoArchType`] for more information.
		     * @returns {NoArchType}
		     */
		    get noarch() {
		        const ret = wasm.packagerecord_noarch(this.__wbg_ptr);
		        return ret;
		    }
		    /**
		     * @param {NoArchType} noarch
		     */
		    set noarch(noarch) {
		        const ret = wasm.packagerecord_set_noarch(this.__wbg_ptr, noarch);
		        if (ret[1]) {
		            throw takeFromExternrefTable0(ret[0]);
		        }
		    }
		    /**
		     * The date this entry was created.
		     * @returns {Date | undefined}
		     */
		    get timestamp() {
		        const ret = wasm.packagerecord_timestamp(this.__wbg_ptr);
		        return ret;
		    }
		    /**
		     * @param {Date | undefined} timestamp
		     */
		    set timestamp(timestamp) {
		        wasm.packagerecord_set_timestamp(this.__wbg_ptr, isLikeNone(timestamp) ? 0 : addToExternrefTable0(timestamp));
		    }
		    /**
		     * Track features are nowadays only used to downweight packages (ie. give
		     * them less priority). To that effect, the package is downweighted
		     * by the number of track_features.
		     * @returns {string[]}
		     */
		    get trackFeatures() {
		        const ret = wasm.packagerecord_trackFeatures(this.__wbg_ptr);
		        var v1 = getArrayJsValueFromWasm0(ret[0], ret[1]).slice();
		        wasm.__wbindgen_free(ret[0], ret[1] * 4, 4);
		        return v1;
		    }
		    /**
		     * @param {string[]} track_features
		     */
		    set trackFeatures(track_features) {
		        const ptr0 = passArrayJsValueToWasm0(track_features, wasm.__wbindgen_malloc);
		        const len0 = WASM_VECTOR_LEN;
		        wasm.packagerecord_set_trackFeatures(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * The version of the package
		     * @returns {VersionWithSource}
		     */
		    get version() {
		        const ret = wasm.packagerecord_version(this.__wbg_ptr);
		        return VersionWithSource.__wrap(ret);
		    }
		    /**
		     * @param {VersionWithSource} version
		     */
		    set version(version) {
		        _assertClass(version, VersionWithSource);
		        var ptr0 = version.__destroy_into_raw();
		        wasm.packagerecord_set_version(this.__wbg_ptr, ptr0);
		    }
		}
		module.exports.PackageRecord = PackageRecord;

		const SolvedPackageFinalization = (typeof FinalizationRegistry === 'undefined')
		    ? { register: () => {}, unregister: () => {} }
		    : new FinalizationRegistry(ptr => wasm.__wbg_solvedpackage_free(ptr >>> 0, 1));
		/**
		 * A package that has been solved by the solver.
		 * @public
		 */
		class SolvedPackage {

		    static __wrap(ptr) {
		        ptr = ptr >>> 0;
		        const obj = Object.create(SolvedPackage.prototype);
		        obj.__wbg_ptr = ptr;
		        SolvedPackageFinalization.register(obj, obj.__wbg_ptr, obj);
		        return obj;
		    }

		    __destroy_into_raw() {
		        const ptr = this.__wbg_ptr;
		        this.__wbg_ptr = 0;
		        SolvedPackageFinalization.unregister(this);
		        return ptr;
		    }

		    free() {
		        const ptr = this.__destroy_into_raw();
		        wasm.__wbg_solvedpackage_free(ptr, 0);
		    }
		    /**
		     * @returns {string}
		     */
		    get url() {
		        let deferred1_0;
		        let deferred1_1;
		        try {
		            const ret = wasm.__wbg_get_solvedpackage_url(this.__wbg_ptr);
		            deferred1_0 = ret[0];
		            deferred1_1 = ret[1];
		            return getStringFromWasm0(ret[0], ret[1]);
		        } finally {
		            wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
		        }
		    }
		    /**
		     * @param {string} arg0
		     */
		    set url(arg0) {
		        const ptr0 = passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        const len0 = WASM_VECTOR_LEN;
		        wasm.__wbg_set_solvedpackage_url(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * @returns {string}
		     */
		    get packageName() {
		        let deferred1_0;
		        let deferred1_1;
		        try {
		            const ret = wasm.__wbg_get_solvedpackage_packageName(this.__wbg_ptr);
		            deferred1_0 = ret[0];
		            deferred1_1 = ret[1];
		            return getStringFromWasm0(ret[0], ret[1]);
		        } finally {
		            wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
		        }
		    }
		    /**
		     * @param {string} arg0
		     */
		    set packageName(arg0) {
		        const ptr0 = passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        const len0 = WASM_VECTOR_LEN;
		        wasm.__wbg_set_solvedpackage_packageName(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * @returns {string}
		     */
		    get build() {
		        let deferred1_0;
		        let deferred1_1;
		        try {
		            const ret = wasm.__wbg_get_solvedpackage_build(this.__wbg_ptr);
		            deferred1_0 = ret[0];
		            deferred1_1 = ret[1];
		            return getStringFromWasm0(ret[0], ret[1]);
		        } finally {
		            wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
		        }
		    }
		    /**
		     * @param {string} arg0
		     */
		    set build(arg0) {
		        const ptr0 = passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        const len0 = WASM_VECTOR_LEN;
		        wasm.__wbg_set_solvedpackage_build(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * @returns {bigint}
		     */
		    get buildNumber() {
		        const ret = wasm.__wbg_get_solvedpackage_buildNumber(this.__wbg_ptr);
		        return BigInt.asUintN(64, ret);
		    }
		    /**
		     * @param {bigint} arg0
		     */
		    set buildNumber(arg0) {
		        wasm.__wbg_set_solvedpackage_buildNumber(this.__wbg_ptr, arg0);
		    }
		    /**
		     * @returns {string | undefined}
		     */
		    get repoName() {
		        const ret = wasm.__wbg_get_solvedpackage_repoName(this.__wbg_ptr);
		        let v1;
		        if (ret[0] !== 0) {
		            v1 = getStringFromWasm0(ret[0], ret[1]).slice();
		            wasm.__wbindgen_free(ret[0], ret[1] * 1, 1);
		        }
		        return v1;
		    }
		    /**
		     * @param {string | null} [arg0]
		     */
		    set repoName(arg0) {
		        var ptr0 = isLikeNone(arg0) ? 0 : passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        var len0 = WASM_VECTOR_LEN;
		        wasm.__wbg_set_solvedpackage_repoName(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * @returns {string}
		     */
		    get filename() {
		        let deferred1_0;
		        let deferred1_1;
		        try {
		            const ret = wasm.__wbg_get_solvedpackage_filename(this.__wbg_ptr);
		            deferred1_0 = ret[0];
		            deferred1_1 = ret[1];
		            return getStringFromWasm0(ret[0], ret[1]);
		        } finally {
		            wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
		        }
		    }
		    /**
		     * @param {string} arg0
		     */
		    set filename(arg0) {
		        const ptr0 = passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        const len0 = WASM_VECTOR_LEN;
		        wasm.__wbg_set_solvedpackage_filename(this.__wbg_ptr, ptr0, len0);
		    }
		    /**
		     * @returns {string}
		     */
		    get version() {
		        let deferred1_0;
		        let deferred1_1;
		        try {
		            const ret = wasm.__wbg_get_solvedpackage_version(this.__wbg_ptr);
		            deferred1_0 = ret[0];
		            deferred1_1 = ret[1];
		            return getStringFromWasm0(ret[0], ret[1]);
		        } finally {
		            wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
		        }
		    }
		    /**
		     * @param {string} arg0
		     */
		    set version(arg0) {
		        const ptr0 = passStringToWasm0(arg0, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        const len0 = WASM_VECTOR_LEN;
		        wasm.__wbg_set_solvedpackage_version(this.__wbg_ptr, ptr0, len0);
		    }
		}
		module.exports.SolvedPackage = SolvedPackage;

		const VersionFinalization = (typeof FinalizationRegistry === 'undefined')
		    ? { register: () => {}, unregister: () => {} }
		    : new FinalizationRegistry(ptr => wasm.__wbg_version_free(ptr >>> 0, 1));
		/**
		 * This class implements an order relation between version strings. Version
		 * strings can contain the usual alphanumeric characters (A-Za-z0-9), separated
		 * into segments by dots and underscores. Empty segments (i.e. two consecutive
		 * dots, a leading/trailing underscore) are not permitted. An optional epoch
		 * number - an integer followed by '!' - can precede the actual version string
		 * (this is useful to indicate a change in the versioning scheme itself).
		 * Version comparison is case-insensitive.
		 *
		 * @public
		 */
		class Version {

		    static __wrap(ptr) {
		        ptr = ptr >>> 0;
		        const obj = Object.create(Version.prototype);
		        obj.__wbg_ptr = ptr;
		        VersionFinalization.register(obj, obj.__wbg_ptr, obj);
		        return obj;
		    }

		    __destroy_into_raw() {
		        const ptr = this.__wbg_ptr;
		        this.__wbg_ptr = 0;
		        VersionFinalization.unregister(this);
		        return ptr;
		    }

		    free() {
		        const ptr = this.__destroy_into_raw();
		        wasm.__wbg_version_free(ptr, 0);
		    }
		    /**
		     * Constructs a new Version object from a string representation.
		     * @param {string} version - The string representation of the version.
		     */
		    constructor(version) {
		        const ptr0 = passStringToWasm0(version, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        const len0 = WASM_VECTOR_LEN;
		        const ret = wasm.version_new(ptr0, len0);
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        this.__wbg_ptr = ret[0] >>> 0;
		        VersionFinalization.register(this, this.__wbg_ptr, this);
		        return this;
		    }
		    /**
		     * Returns the string representation of the version.
		     *
		     * An attempt is made to return the version in the same format as the input
		     * string but this is not guaranteed.
		     * @returns {string}
		     */
		    toString() {
		        let deferred1_0;
		        let deferred1_1;
		        try {
		            const ret = wasm.version_toString(this.__wbg_ptr);
		            deferred1_0 = ret[0];
		            deferred1_1 = ret[1];
		            return getStringFromWasm0(ret[0], ret[1]);
		        } finally {
		            wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
		        }
		    }
		    /**
		     * The epoch part of the version. E.g. `1` in `1!2.3`.
		     * @returns {number | undefined}
		     */
		    get epoch() {
		        const ret = wasm.version_epoch(this.__wbg_ptr);
		        return ret === 0x100000001 ? undefined : ret;
		    }
		    /**
		     * `true` if the version has a local part. E.g. `2.3` in `1+2.3`.
		     * @returns {boolean}
		     */
		    get hasLocal() {
		        const ret = wasm.version_hasLocal(this.__wbg_ptr);
		        return ret !== 0;
		    }
		    /**
		     * `true` if the version is considered a development version.
		     *
		     * A development version is a version that contains the string `dev` in the
		     * version string.
		     * @returns {boolean}
		     */
		    get isDev() {
		        const ret = wasm.version_isDev(this.__wbg_ptr);
		        return ret !== 0;
		    }
		    /**
		     * Returns the major and minor part of the version if the version does not
		     * represent a typical major minor version. If any of the parts are not a
		     * single number, undefined is returned.
		     * @returns {[number, number] | undefined}
		     */
		    asMajorMinor() {
		        const ret = wasm.version_asMajorMinor(this.__wbg_ptr);
		        let v1;
		        if (ret[0] !== 0) {
		            v1 = getArrayJsValueFromWasm0(ret[0], ret[1]).slice();
		            wasm.__wbindgen_free(ret[0], ret[1] * 4, 4);
		        }
		        return v1;
		    }
		    /**
		     * Returns true if this version starts with the other version. This is
		     * defined as the other version being a prefix of this version.
		     * @param {Version} other - The version to use for the comparison
		     * @returns {boolean}
		     */
		    startsWith(other) {
		        _assertClass(other, Version);
		        const ret = wasm.version_startsWith(this.__wbg_ptr, other.__wbg_ptr);
		        return ret !== 0;
		    }
		    /**
		     * Returns true if this version is compatible with the other version.
		     * @param {Version} other - The version to use for the comparison
		     * @returns {boolean}
		     */
		    compatibleWith(other) {
		        _assertClass(other, Version);
		        const ret = wasm.version_compatibleWith(this.__wbg_ptr, other.__wbg_ptr);
		        return ret !== 0;
		    }
		    /**
		     * Pop the last `n` segments from the version.
		     * @param {number} n - The number of segments to pop
		     * @returns {Version | undefined}
		     */
		    popSegments(n) {
		        const ret = wasm.version_popSegments(this.__wbg_ptr, n);
		        return ret === 0 ? undefined : Version.__wrap(ret);
		    }
		    /**
		     * Extend the version to the given length by adding zeros. If the version
		     * is already at the specified length or longer the original version
		     * will be returned.
		     * @param {number} length - The length to extend to
		     * @returns {Version}
		     */
		    extendToLength(length) {
		        const ret = wasm.version_extendToLength(this.__wbg_ptr, length);
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        return Version.__wrap(ret[0]);
		    }
		    /**
		     * Returns a new version with the segments from start to end (exclusive).
		     *
		     * Returns undefined if the start or end index is out of bounds.
		     * @param {number} start - The start index
		     * @param {number} end - The end index
		     * @returns {Version | undefined}
		     */
		    withSegments(start, end) {
		        const ret = wasm.version_withSegments(this.__wbg_ptr, start, end);
		        return ret === 0 ? undefined : Version.__wrap(ret);
		    }
		    /**
		     * The number of segments in the version.
		     * @returns {number}
		     */
		    get length() {
		        const ret = wasm.version_length(this.__wbg_ptr);
		        return ret >>> 0;
		    }
		    /**
		     * Returns the version without the local part. E.g. `1+2.3` becomes `1`.
		     * @returns {Version}
		     */
		    stripLocal() {
		        const ret = wasm.version_stripLocal(this.__wbg_ptr);
		        return Version.__wrap(ret);
		    }
		    /**
		     * Returns a new version where the major segment of this version has been
		     * bumped.
		     * @returns {Version}
		     */
		    bumpMajor() {
		        const ret = wasm.version_bumpMajor(this.__wbg_ptr);
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        return Version.__wrap(ret[0]);
		    }
		    /**
		     * Returns a new version where the minor segment of this version has been
		     * bumped.
		     * @returns {Version}
		     */
		    bumpMinor() {
		        const ret = wasm.version_bumpMinor(this.__wbg_ptr);
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        return Version.__wrap(ret[0]);
		    }
		    /**
		     * Returns a new version where the patch segment of this version has been
		     * bumped.
		     * @returns {Version}
		     */
		    bumpPatch() {
		        const ret = wasm.version_bumpPatch(this.__wbg_ptr);
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        return Version.__wrap(ret[0]);
		    }
		    /**
		     * Returns a new version where the last segment of this version has been
		     * bumped.
		     * @returns {Version}
		     */
		    bumpLast() {
		        const ret = wasm.version_bumpLast(this.__wbg_ptr);
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        return Version.__wrap(ret[0]);
		    }
		    /**
		     * Returns a new version where the given segment of this version has been
		     * bumped.
		     * @param {number} index - The index of the segment to bump
		     * @returns {Version}
		     */
		    bumpSegment(index) {
		        const ret = wasm.version_bumpSegment(this.__wbg_ptr, index);
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        return Version.__wrap(ret[0]);
		    }
		    /**
		     * Returns a new version where the last segment is an "alpha" segment (ie.
		     * `.0a0`)
		     * @returns {Version}
		     */
		    withAlpha() {
		        const ret = wasm.version_withAlpha(this.__wbg_ptr);
		        return Version.__wrap(ret);
		    }
		    /**
		     * Compares this version with another version. Returns `true` if the
		     * versions are considered equal.
		     *
		     * Note that two version strings can be considered equal even if they are
		     * not exactly the same. For example, `1.0` and `1` are considered equal.
		     * @param {Version} other - The version to compare with
		     * @returns {boolean}
		     */
		    equals(other) {
		        _assertClass(other, Version);
		        const ret = wasm.version_equals(this.__wbg_ptr, other.__wbg_ptr);
		        return ret !== 0;
		    }
		    /**
		     * Compare two versions.
		     *
		     * Returns `-1` if this instance should be ordered before `other`, `0` if
		     * this version and `other` are considered equal, `1` if this version
		     * should be ordered after `other`.
		     * @param {Version} other - The version to compare with
		     * @returns {number}
		     */
		    compare(other) {
		        _assertClass(other, Version);
		        const ret = wasm.version_compare(this.__wbg_ptr, other.__wbg_ptr);
		        return ret;
		    }
		}
		module.exports.Version = Version;

		const VersionSpecFinalization = (typeof FinalizationRegistry === 'undefined')
		    ? { register: () => {}, unregister: () => {} }
		    : new FinalizationRegistry(ptr => wasm.__wbg_versionspec_free(ptr >>> 0, 1));
		/**
		 * Represents a version specification in the conda ecosystem.
		 *
		 * @public
		 */
		class VersionSpec {

		    __destroy_into_raw() {
		        const ptr = this.__wbg_ptr;
		        this.__wbg_ptr = 0;
		        VersionSpecFinalization.unregister(this);
		        return ptr;
		    }

		    free() {
		        const ptr = this.__destroy_into_raw();
		        wasm.__wbg_versionspec_free(ptr, 0);
		    }
		    /**
		     * Constructs a new VersionSpec object from a string representation.
		     * @param {string} version_spec - The string representation of the version spec.
		     * @param {ParseStrictness | null} [parse_strictness] - The strictness of the parser.
		     */
		    constructor(version_spec, parse_strictness) {
		        const ptr0 = passStringToWasm0(version_spec, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        const len0 = WASM_VECTOR_LEN;
		        const ret = wasm.versionspec_new(ptr0, len0, isLikeNone(parse_strictness) ? 0 : addToExternrefTable0(parse_strictness));
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        this.__wbg_ptr = ret[0] >>> 0;
		        VersionSpecFinalization.register(this, this.__wbg_ptr, this);
		        return this;
		    }
		    /**
		     * Returns the string representation of the version spec.
		     * @returns {string}
		     */
		    toString() {
		        let deferred1_0;
		        let deferred1_1;
		        try {
		            const ret = wasm.versionspec_toString(this.__wbg_ptr);
		            deferred1_0 = ret[0];
		            deferred1_1 = ret[1];
		            return getStringFromWasm0(ret[0], ret[1]);
		        } finally {
		            wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
		        }
		    }
		    /**
		     * Returns true if the version matches this version spec.
		     * @param {Version} version - The version to match
		     * @returns {boolean}
		     */
		    matches(version) {
		        _assertClass(version, Version);
		        const ret = wasm.versionspec_matches(this.__wbg_ptr, version.__wbg_ptr);
		        return ret !== 0;
		    }
		}
		module.exports.VersionSpec = VersionSpec;

		const VersionWithSourceFinalization = (typeof FinalizationRegistry === 'undefined')
		    ? { register: () => {}, unregister: () => {} }
		    : new FinalizationRegistry(ptr => wasm.__wbg_versionwithsource_free(ptr >>> 0, 1));
		/**
		 * Holds a version and the string it was created from. This is useful if you
		 * want to retain the original string the version was created from. This might
		 * be useful in cases where you have multiple strings that are represented by
		 * the same `Version` but you still want to be able to distinguish them.
		 *
		 * The string `1.0` and `1.01` represent the same version. When you print the
		 * parsed version though it will come out as `1.0`. You loose the original
		 * representation. This struct stores the original source string.
		 *
		 * @public
		 */
		class VersionWithSource {

		    static __wrap(ptr) {
		        ptr = ptr >>> 0;
		        const obj = Object.create(VersionWithSource.prototype);
		        obj.__wbg_ptr = ptr;
		        VersionWithSourceFinalization.register(obj, obj.__wbg_ptr, obj);
		        return obj;
		    }

		    __destroy_into_raw() {
		        const ptr = this.__wbg_ptr;
		        this.__wbg_ptr = 0;
		        VersionWithSourceFinalization.unregister(this);
		        return ptr;
		    }

		    free() {
		        const ptr = this.__destroy_into_raw();
		        wasm.__wbg_versionwithsource_free(ptr, 0);
		    }
		    /**
		     * @param {string} source
		     */
		    constructor(source) {
		        const ptr0 = passStringToWasm0(source, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		        const len0 = WASM_VECTOR_LEN;
		        const ret = wasm.versionwithsource_new(ptr0, len0);
		        if (ret[2]) {
		            throw takeFromExternrefTable0(ret[1]);
		        }
		        this.__wbg_ptr = ret[0] >>> 0;
		        VersionWithSourceFinalization.register(this, this.__wbg_ptr, this);
		        return this;
		    }
		    /**
		     * @returns {Version}
		     */
		    get version() {
		        const ret = wasm.versionwithsource_version(this.__wbg_ptr);
		        return Version.__wrap(ret);
		    }
		    /**
		     * @returns {string}
		     */
		    get source() {
		        const ret = wasm.versionwithsource_source(this.__wbg_ptr);
		        return ret;
		    }
		}
		module.exports.VersionWithSource = VersionWithSource;

		module.exports.__wbg_String_8f0eb39a4a4c2f66 = function(arg0, arg1) {
		    const ret = String(arg1);
		    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		    const len1 = WASM_VECTOR_LEN;
		    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
		    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
		};

		module.exports.__wbg_abort_775ef1d17fc65868 = function(arg0) {
		    arg0.abort();
		};

		module.exports.__wbg_append_8c7dd8d641a5f01b = function() { return handleError(function (arg0, arg1, arg2, arg3, arg4) {
		    arg0.append(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
		}, arguments) };

		module.exports.__wbg_body_0b8fd1fe671660df = function(arg0) {
		    const ret = arg0.body;
		    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
		};

		module.exports.__wbg_buffer_09165b52af8c5237 = function(arg0) {
		    const ret = arg0.buffer;
		    return ret;
		};

		module.exports.__wbg_buffer_609cc3eee51ed158 = function(arg0) {
		    const ret = arg0.buffer;
		    return ret;
		};

		module.exports.__wbg_byobRequest_77d9adf63337edfb = function(arg0) {
		    const ret = arg0.byobRequest;
		    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
		};

		module.exports.__wbg_byteLength_e674b853d9c77e1d = function(arg0) {
		    const ret = arg0.byteLength;
		    return ret;
		};

		module.exports.__wbg_byteOffset_fd862df290ef848d = function(arg0) {
		    const ret = arg0.byteOffset;
		    return ret;
		};

		module.exports.__wbg_call_672a4d21634d4a24 = function() { return handleError(function (arg0, arg1) {
		    const ret = arg0.call(arg1);
		    return ret;
		}, arguments) };

		module.exports.__wbg_call_7cccdd69e0791ae2 = function() { return handleError(function (arg0, arg1, arg2) {
		    const ret = arg0.call(arg1, arg2);
		    return ret;
		}, arguments) };

		module.exports.__wbg_cancel_8a308660caa6cadf = function(arg0) {
		    const ret = arg0.cancel();
		    return ret;
		};

		module.exports.__wbg_catch_a6e601879b2610e9 = function(arg0, arg1) {
		    const ret = arg0.catch(arg1);
		    return ret;
		};

		module.exports.__wbg_close_304cc1fef3466669 = function() { return handleError(function (arg0) {
		    arg0.close();
		}, arguments) };

		module.exports.__wbg_close_5ce03e29be453811 = function() { return handleError(function (arg0) {
		    arg0.close();
		}, arguments) };

		module.exports.__wbg_codePointAt_78181f32881e5b59 = function(arg0, arg1) {
		    const ret = arg0.codePointAt(arg1 >>> 0);
		    return ret;
		};

		module.exports.__wbg_crypto_ed58b8e10a292839 = function(arg0) {
		    const ret = arg0.crypto;
		    return ret;
		};

		module.exports.__wbg_done_769e5ede4b31c67b = function(arg0) {
		    const ret = arg0.done;
		    return ret;
		};

		module.exports.__wbg_enqueue_bb16ba72f537dc9e = function() { return handleError(function (arg0, arg1) {
		    arg0.enqueue(arg1);
		}, arguments) };

		module.exports.__wbg_entries_3265d4158b33e5dc = function(arg0) {
		    const ret = Object.entries(arg0);
		    return ret;
		};

		module.exports.__wbg_error_7534b8e9a36f1ab4 = function(arg0, arg1) {
		    let deferred0_0;
		    let deferred0_1;
		    try {
		        deferred0_0 = arg0;
		        deferred0_1 = arg1;
		        console.error(getStringFromWasm0(arg0, arg1));
		    } finally {
		        wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
		    }
		};

		module.exports.__wbg_fetch_4465c2b10f21a927 = function(arg0) {
		    const ret = fetch(arg0);
		    return ret;
		};

		module.exports.__wbg_fetch_509096533071c657 = function(arg0, arg1) {
		    const ret = arg0.fetch(arg1);
		    return ret;
		};

		module.exports.__wbg_getRandomValues_bcb4912f16000dc4 = function() { return handleError(function (arg0, arg1) {
		    arg0.getRandomValues(arg1);
		}, arguments) };

		module.exports.__wbg_getReader_48e00749fe3f6089 = function() { return handleError(function (arg0) {
		    const ret = arg0.getReader();
		    return ret;
		}, arguments) };

		module.exports.__wbg_getTime_46267b1c24877e30 = function(arg0) {
		    const ret = arg0.getTime();
		    return ret;
		};

		module.exports.__wbg_get_67b2ba62fc30de12 = function() { return handleError(function (arg0, arg1) {
		    const ret = Reflect.get(arg0, arg1);
		    return ret;
		}, arguments) };

		module.exports.__wbg_get_b9b93047fe3cf45b = function(arg0, arg1) {
		    const ret = arg0[arg1 >>> 0];
		    return ret;
		};

		module.exports.__wbg_getdone_d47073731acd3e74 = function(arg0) {
		    const ret = arg0.done;
		    return isLikeNone(ret) ? 0xFFFFFF : ret ? 1 : 0;
		};

		module.exports.__wbg_getvalue_009dcd63692bee1f = function(arg0) {
		    const ret = arg0.value;
		    return ret;
		};

		module.exports.__wbg_getwithrefkey_1dc361bd10053bfe = function(arg0, arg1) {
		    const ret = arg0[arg1];
		    return ret;
		};

		module.exports.__wbg_has_a5ea9117f258a0ec = function() { return handleError(function (arg0, arg1) {
		    const ret = Reflect.has(arg0, arg1);
		    return ret;
		}, arguments) };

		module.exports.__wbg_headers_9cb51cfd2ac780a4 = function(arg0) {
		    const ret = arg0.headers;
		    return ret;
		};

		module.exports.__wbg_instanceof_ArrayBuffer_e14585432e3737fc = function(arg0) {
		    let result;
		    try {
		        result = arg0 instanceof ArrayBuffer;
		    } catch (_) {
		        result = false;
		    }
		    const ret = result;
		    return ret;
		};

		module.exports.__wbg_instanceof_Map_f3469ce2244d2430 = function(arg0) {
		    let result;
		    try {
		        result = arg0 instanceof Map;
		    } catch (_) {
		        result = false;
		    }
		    const ret = result;
		    return ret;
		};

		module.exports.__wbg_instanceof_Response_f2cc20d9f7dfd644 = function(arg0) {
		    let result;
		    try {
		        result = arg0 instanceof Response;
		    } catch (_) {
		        result = false;
		    }
		    const ret = result;
		    return ret;
		};

		module.exports.__wbg_instanceof_Uint8Array_17156bcf118086a9 = function(arg0) {
		    let result;
		    try {
		        result = arg0 instanceof Uint8Array;
		    } catch (_) {
		        result = false;
		    }
		    const ret = result;
		    return ret;
		};

		module.exports.__wbg_isArray_a1eab7e0d067391b = function(arg0) {
		    const ret = Array.isArray(arg0);
		    return ret;
		};

		module.exports.__wbg_isSafeInteger_343e2beeeece1bb0 = function(arg0) {
		    const ret = Number.isSafeInteger(arg0);
		    return ret;
		};

		module.exports.__wbg_iterator_9a24c88df860dc65 = function() {
		    const ret = Symbol.iterator;
		    return ret;
		};

		module.exports.__wbg_length_a446193dc22c12f8 = function(arg0) {
		    const ret = arg0.length;
		    return ret;
		};

		module.exports.__wbg_length_d56737991078581b = function(arg0) {
		    const ret = arg0.length;
		    return ret;
		};

		module.exports.__wbg_length_e2d2a49132c1b256 = function(arg0) {
		    const ret = arg0.length;
		    return ret;
		};

		module.exports.__wbg_msCrypto_0a36e2ec3a343d26 = function(arg0) {
		    const ret = arg0.msCrypto;
		    return ret;
		};

		module.exports.__wbg_new_018dcc2d6c8c2f6a = function() { return handleError(function () {
		    const ret = new Headers();
		    return ret;
		}, arguments) };

		module.exports.__wbg_new_23a2665fac83c611 = function(arg0, arg1) {
		    try {
		        var state0 = {a: arg0, b: arg1};
		        var cb0 = (arg0, arg1) => {
		            const a = state0.a;
		            state0.a = 0;
		            try {
		                return __wbg_adapter_321(a, state0.b, arg0, arg1);
		            } finally {
		                state0.a = a;
		            }
		        };
		        const ret = new Promise(cb0);
		        return ret;
		    } finally {
		        state0.a = state0.b = 0;
		    }
		};

		module.exports.__wbg_new_31a97dac4f10fab7 = function(arg0) {
		    const ret = new Date(arg0);
		    return ret;
		};

		module.exports.__wbg_new_405e22f390576ce2 = function() {
		    const ret = new Object();
		    return ret;
		};

		module.exports.__wbg_new_5e0be73521bc8c17 = function() {
		    const ret = new Map();
		    return ret;
		};

		module.exports.__wbg_new_78feb108b6472713 = function() {
		    const ret = new Array();
		    return ret;
		};

		module.exports.__wbg_new_8a6f238a6ece86ea = function() {
		    const ret = new Error();
		    return ret;
		};

		module.exports.__wbg_new_a12002a7f91c75be = function(arg0) {
		    const ret = new Uint8Array(arg0);
		    return ret;
		};

		module.exports.__wbg_new_c68d7209be747379 = function(arg0, arg1) {
		    const ret = new Error(getStringFromWasm0(arg0, arg1));
		    return ret;
		};

		module.exports.__wbg_new_e25e5aab09ff45db = function() { return handleError(function () {
		    const ret = new AbortController();
		    return ret;
		}, arguments) };

		module.exports.__wbg_newnoargs_105ed471475aaf50 = function(arg0, arg1) {
		    const ret = new Function(getStringFromWasm0(arg0, arg1));
		    return ret;
		};

		module.exports.__wbg_newwithbyteoffsetandlength_d97e637ebe145a9a = function(arg0, arg1, arg2) {
		    const ret = new Uint8Array(arg0, arg1 >>> 0, arg2 >>> 0);
		    return ret;
		};

		module.exports.__wbg_newwithlength_a381634e90c276d4 = function(arg0) {
		    const ret = new Uint8Array(arg0 >>> 0);
		    return ret;
		};

		module.exports.__wbg_newwithstrandinit_06c535e0a867c635 = function() { return handleError(function (arg0, arg1, arg2) {
		    const ret = new Request(getStringFromWasm0(arg0, arg1), arg2);
		    return ret;
		}, arguments) };

		module.exports.__wbg_next_25feadfc0913fea9 = function(arg0) {
		    const ret = arg0.next;
		    return ret;
		};

		module.exports.__wbg_next_6574e1a8a62d1055 = function() { return handleError(function (arg0) {
		    const ret = arg0.next();
		    return ret;
		}, arguments) };

		module.exports.__wbg_node_02999533c4ea02e3 = function(arg0) {
		    const ret = arg0.node;
		    return ret;
		};

		module.exports.__wbg_now_807e54c39636c349 = function() {
		    const ret = Date.now();
		    return ret;
		};

		module.exports.__wbg_now_fb0466b5460cff09 = function(arg0) {
		    const ret = arg0.now();
		    return ret;
		};

		module.exports.__wbg_performance_71b063e177862740 = function(arg0) {
		    const ret = arg0.performance;
		    return ret;
		};

		module.exports.__wbg_process_5c1d670bc53614b8 = function(arg0) {
		    const ret = arg0.process;
		    return ret;
		};

		module.exports.__wbg_queueMicrotask_97d92b4fcc8a61c5 = function(arg0) {
		    queueMicrotask(arg0);
		};

		module.exports.__wbg_queueMicrotask_d3219def82552485 = function(arg0) {
		    const ret = arg0.queueMicrotask;
		    return ret;
		};

		module.exports.__wbg_randomFillSync_ab2cfe79ebbf2740 = function() { return handleError(function (arg0, arg1) {
		    arg0.randomFillSync(arg1);
		}, arguments) };

		module.exports.__wbg_read_a2434af1186cb56c = function(arg0) {
		    const ret = arg0.read();
		    return ret;
		};

		module.exports.__wbg_releaseLock_091899af97991d2e = function(arg0) {
		    arg0.releaseLock();
		};

		module.exports.__wbg_require_79b1e9274cde3c87 = function() { return handleError(function () {
		    const ret = commonjsRequire;
		    return ret;
		}, arguments) };

		module.exports.__wbg_resolve_4851785c9c5f573d = function(arg0) {
		    const ret = Promise.resolve(arg0);
		    return ret;
		};

		module.exports.__wbg_respond_1f279fa9f8edcb1c = function() { return handleError(function (arg0, arg1) {
		    arg0.respond(arg1 >>> 0);
		}, arguments) };

		module.exports.__wbg_setTimeout_25eabdb2fc442ea2 = function() { return handleError(function (arg0, arg1, arg2) {
		    const ret = arg0.setTimeout(arg1, arg2);
		    return ret;
		}, arguments) };

		module.exports.__wbg_set_37837023f3d740e8 = function(arg0, arg1, arg2) {
		    arg0[arg1 >>> 0] = arg2;
		};

		module.exports.__wbg_set_3f1d0b984ed272ed = function(arg0, arg1, arg2) {
		    arg0[arg1] = arg2;
		};

		module.exports.__wbg_set_65595bdd868b3009 = function(arg0, arg1, arg2) {
		    arg0.set(arg1, arg2 >>> 0);
		};

		module.exports.__wbg_set_8fc6bf8a5b1071d1 = function(arg0, arg1, arg2) {
		    const ret = arg0.set(arg1, arg2);
		    return ret;
		};

		module.exports.__wbg_setbody_5923b78a95eedf29 = function(arg0, arg1) {
		    arg0.body = arg1;
		};

		module.exports.__wbg_setcredentials_c3a22f1cd105a2c6 = function(arg0, arg1) {
		    arg0.credentials = __wbindgen_enum_RequestCredentials[arg1];
		};

		module.exports.__wbg_setheaders_834c0bdb6a8949ad = function(arg0, arg1) {
		    arg0.headers = arg1;
		};

		module.exports.__wbg_setmethod_3c5280fe5d890842 = function(arg0, arg1, arg2) {
		    arg0.method = getStringFromWasm0(arg1, arg2);
		};

		module.exports.__wbg_setmode_5dc300b865044b65 = function(arg0, arg1) {
		    arg0.mode = __wbindgen_enum_RequestMode[arg1];
		};

		module.exports.__wbg_setsignal_75b21ef3a81de905 = function(arg0, arg1) {
		    arg0.signal = arg1;
		};

		module.exports.__wbg_signal_aaf9ad74119f20a4 = function(arg0) {
		    const ret = arg0.signal;
		    return ret;
		};

		module.exports.__wbg_solvedpackage_new = function(arg0) {
		    const ret = SolvedPackage.__wrap(arg0);
		    return ret;
		};

		module.exports.__wbg_stack_0ed75d68575b0f3c = function(arg0, arg1) {
		    const ret = arg1.stack;
		    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		    const len1 = WASM_VECTOR_LEN;
		    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
		    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
		};

		module.exports.__wbg_static_accessor_GLOBAL_88a902d13a557d07 = function() {
		    const ret = typeof commonjsGlobal === 'undefined' ? null : commonjsGlobal;
		    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
		};

		module.exports.__wbg_static_accessor_GLOBAL_THIS_56578be7e9f832b0 = function() {
		    const ret = typeof globalThis === 'undefined' ? null : globalThis;
		    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
		};

		module.exports.__wbg_static_accessor_SELF_37c5d418e4bf5819 = function() {
		    const ret = typeof self === 'undefined' ? null : self;
		    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
		};

		module.exports.__wbg_static_accessor_WINDOW_5de37043a91a9c40 = function() {
		    const ret = typeof window === 'undefined' ? null : window;
		    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
		};

		module.exports.__wbg_status_f6360336ca686bf0 = function(arg0) {
		    const ret = arg0.status;
		    return ret;
		};

		module.exports.__wbg_string_GENERIC_f2826283316ea62c = function() {
		    const ret = `generic`;
		    return ret;
		};

		module.exports.__wbg_string_PYTHON_44cd839af7eb6216 = function() {
		    const ret = `python`;
		    return ret;
		};

		module.exports.__wbg_stringify_f7ed6987935b4a24 = function() { return handleError(function (arg0) {
		    const ret = JSON.stringify(arg0);
		    return ret;
		}, arguments) };

		module.exports.__wbg_subarray_aa9065fa9dc5df96 = function(arg0, arg1, arg2) {
		    const ret = arg0.subarray(arg1 >>> 0, arg2 >>> 0);
		    return ret;
		};

		module.exports.__wbg_then_44b73946d2fb3e7d = function(arg0, arg1) {
		    const ret = arg0.then(arg1);
		    return ret;
		};

		module.exports.__wbg_then_48b406749878a531 = function(arg0, arg1, arg2) {
		    const ret = arg0.then(arg1, arg2);
		    return ret;
		};

		module.exports.__wbg_url_ae10c34ca209681d = function(arg0, arg1) {
		    const ret = arg1.url;
		    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		    const len1 = WASM_VECTOR_LEN;
		    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
		    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
		};

		module.exports.__wbg_value_cd1ffa7b1ab794f1 = function(arg0) {
		    const ret = arg0.value;
		    return ret;
		};

		module.exports.__wbg_versions_c71aa1626a93e0a1 = function(arg0) {
		    const ret = arg0.versions;
		    return ret;
		};

		module.exports.__wbg_view_fd8a56e8983f448d = function(arg0) {
		    const ret = arg0.view;
		    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
		};

		module.exports.__wbindgen_array_new = function() {
		    const ret = [];
		    return ret;
		};

		module.exports.__wbindgen_array_push = function(arg0, arg1) {
		    arg0.push(arg1);
		};

		module.exports.__wbindgen_as_number = function(arg0) {
		    const ret = +arg0;
		    return ret;
		};

		module.exports.__wbindgen_bigint_from_i64 = function(arg0) {
		    const ret = arg0;
		    return ret;
		};

		module.exports.__wbindgen_bigint_from_u64 = function(arg0) {
		    const ret = BigInt.asUintN(64, arg0);
		    return ret;
		};

		module.exports.__wbindgen_bigint_get_as_i64 = function(arg0, arg1) {
		    const v = arg1;
		    const ret = typeof(v) === 'bigint' ? v : undefined;
		    getDataViewMemory0().setBigInt64(arg0 + 8 * 1, isLikeNone(ret) ? BigInt(0) : ret, true);
		    getDataViewMemory0().setInt32(arg0 + 4 * 0, !isLikeNone(ret), true);
		};

		module.exports.__wbindgen_boolean_get = function(arg0) {
		    const v = arg0;
		    const ret = typeof(v) === 'boolean' ? (v ? 1 : 0) : 2;
		    return ret;
		};

		module.exports.__wbindgen_cb_drop = function(arg0) {
		    const obj = arg0.original;
		    if (obj.cnt-- == 1) {
		        obj.a = 0;
		        return true;
		    }
		    const ret = false;
		    return ret;
		};

		module.exports.__wbindgen_closure_wrapper3467 = function(arg0, arg1, arg2) {
		    const ret = makeMutClosure(arg0, arg1, 614, __wbg_adapter_60);
		    return ret;
		};

		module.exports.__wbindgen_closure_wrapper6969 = function(arg0, arg1, arg2) {
		    const ret = makeMutClosure(arg0, arg1, 1597, __wbg_adapter_63);
		    return ret;
		};

		module.exports.__wbindgen_debug_string = function(arg0, arg1) {
		    const ret = debugString(arg1);
		    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		    const len1 = WASM_VECTOR_LEN;
		    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
		    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
		};

		module.exports.__wbindgen_error_new = function(arg0, arg1) {
		    const ret = new Error(getStringFromWasm0(arg0, arg1));
		    return ret;
		};

		module.exports.__wbindgen_in = function(arg0, arg1) {
		    const ret = arg0 in arg1;
		    return ret;
		};

		module.exports.__wbindgen_init_externref_table = function() {
		    const table = wasm.__wbindgen_export_4;
		    const offset = table.grow(4);
		    table.set(0, undefined);
		    table.set(offset + 0, undefined);
		    table.set(offset + 1, null);
		    table.set(offset + 2, true);
		    table.set(offset + 3, false);
		};

		module.exports.__wbindgen_is_bigint = function(arg0) {
		    const ret = typeof(arg0) === 'bigint';
		    return ret;
		};

		module.exports.__wbindgen_is_falsy = function(arg0) {
		    const ret = !arg0;
		    return ret;
		};

		module.exports.__wbindgen_is_function = function(arg0) {
		    const ret = typeof(arg0) === 'function';
		    return ret;
		};

		module.exports.__wbindgen_is_object = function(arg0) {
		    const val = arg0;
		    const ret = typeof(val) === 'object' && val !== null;
		    return ret;
		};

		module.exports.__wbindgen_is_string = function(arg0) {
		    const ret = typeof(arg0) === 'string';
		    return ret;
		};

		module.exports.__wbindgen_is_undefined = function(arg0) {
		    const ret = arg0 === undefined;
		    return ret;
		};

		module.exports.__wbindgen_jsval_eq = function(arg0, arg1) {
		    const ret = arg0 === arg1;
		    return ret;
		};

		module.exports.__wbindgen_jsval_loose_eq = function(arg0, arg1) {
		    const ret = arg0 == arg1;
		    return ret;
		};

		module.exports.__wbindgen_memory = function() {
		    const ret = wasm.memory;
		    return ret;
		};

		module.exports.__wbindgen_number_get = function(arg0, arg1) {
		    const obj = arg1;
		    const ret = typeof(obj) === 'number' ? obj : undefined;
		    getDataViewMemory0().setFloat64(arg0 + 8 * 1, isLikeNone(ret) ? 0 : ret, true);
		    getDataViewMemory0().setInt32(arg0 + 4 * 0, !isLikeNone(ret), true);
		};

		module.exports.__wbindgen_number_new = function(arg0) {
		    const ret = arg0;
		    return ret;
		};

		module.exports.__wbindgen_shr = function(arg0, arg1) {
		    const ret = arg0 >> arg1;
		    return ret;
		};

		module.exports.__wbindgen_string_get = function(arg0, arg1) {
		    const obj = arg1;
		    const ret = typeof(obj) === 'string' ? obj : undefined;
		    var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		    var len1 = WASM_VECTOR_LEN;
		    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
		    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
		};

		module.exports.__wbindgen_string_new = function(arg0, arg1) {
		    const ret = getStringFromWasm0(arg0, arg1);
		    return ret;
		};

		module.exports.__wbindgen_throw = function(arg0, arg1) {
		    throw new Error(getStringFromWasm0(arg0, arg1));
		};

		const path = require$$1.join(__dirname, 'js_rattler_bg.wasm');
		const bytes = require$$2.readFileSync(path);

		const wasmModule = new WebAssembly.Module(bytes);
		const wasmInstance = new WebAssembly.Instance(wasmModule, imports);
		wasm = wasmInstance.exports;
		module.exports.__wasm = wasm;

		wasm.__wbindgen_start(); 
	} (js_rattler));
	return js_rattler.exports;
}

var js_rattlerExports = requireJs_rattler();

/**
 * All platform names supported by this library.
 *
 * @public
 */
const platformNames = [
    "noarch",
    "linux-32",
    "linux-64",
    "linux-aarch64",
    "linux-armv6l",
    "linux-armv7l",
    "linux-ppc64le",
    "linux-ppc64",
    "linux-ppc",
    "linux-s390x",
    "linux-riscv32",
    "linux-riscv64",
    "osx-64",
    "osx-arm64",
    "win-32",
    "win-64",
    "win-arm64",
    "emscripten-wasm32",
    "wasi-wasm32",
    "zos-z",
];
/**
 * A type guard that identifies if an input value is a `Platform`
 *
 * @public
 */
function isPlatform(maybePlatform) {
    return (typeof maybePlatform === "string" &&
        platformNames.includes(maybePlatform));
}
/**
 * All architecture names supported by this library.
 *
 * @public
 */
const archNames = [
    "x86",
    "x86_64",
    "aarch64",
    "arm64",
    "armv6l",
    "armv7l",
    "ppc64le",
    "ppc64",
    "ppc",
    "s390x",
    "riscv32",
    "riscv64",
    "wasm32",
    "z",
];
/**
 * A type guard that identifies if an input value is an `Arch`
 *
 * @public
 */
function isArch(maybeArch) {
    return (typeof maybeArch === "string" && archNames.includes(maybeArch));
}
/**
 * Returns the architecture of a certain platform
 *
 * @param platform - The platform
 * @public
 */
function platformArch(platform) {
    switch (platform) {
        case "noarch":
            return null;
        case "linux-32":
            return "x86";
        case "linux-64":
            return "x86_64";
        case "linux-aarch64":
            return "aarch64";
        case "linux-armv6l":
            return "armv6l";
        case "linux-armv7l":
            return "armv7l";
        case "linux-ppc64le":
            return "ppc64le";
        case "linux-ppc64":
            return "ppc64";
        case "linux-ppc":
            return "ppc";
        case "linux-s390x":
            return "s390x";
        case "linux-riscv32":
            return "riscv32";
        case "linux-riscv64":
            return "riscv64";
        case "osx-64":
            return "x86_64";
        case "osx-arm64":
            return "arm64";
        case "win-32":
            return "x86";
        case "win-64":
            return "x86_64";
        case "win-arm64":
            return "arm64";
        case "emscripten-wasm32":
            return "wasm32";
        case "wasi-wasm32":
            return "wasm32";
        case "zos-z":
            return "z";
    }
}

/**
 * **Normalizes a package name to lowercase.**
 *
 * - If given a **string literal**, it is validated at compile time.
 * - If given a **runtime-validated** `PackageName`, it is accepted directly.
 * - Returns a `NormalizedPackageName` with all characters converted to lowercase.
 *
 * @example
 *
 * ```ts
 * const normalized = normalizePackageName("Valid-Package"); // "valid-package"
 * ```
 *
 * @param name - The package name to normalize.
 * @returns The normalized package name.
 * @public
 */
function normalizePackageName(name) {
    return name.toLowerCase();
}
/**
 * **Checks if a string is a valid `PackageName`.**
 *
 * - Returns `true` if `input` matches the allowed package name format.
 * - If `true`, TypeScript narrows the type to `PackageName<string>`.
 *
 * @example
 *
 * ```ts
 * if (isPackageName(userInput)) {
 *     const validName: PackageName = userInput;
 * }
 * ```
 *
 * @param input - The string to validate.
 * @returns `true` if valid, otherwise `false`.
 * @public
 */
function isPackageName(input) {
    return /^[A-Za-z0-9_.-]+$/.test(input);
}
/**
 * **Checks if a string is a valid `NormalizedPackageName`.**
 *
 * - A normalized package name must be **lowercase**.
 * - If `true`, TypeScript narrows the type to `NormalizedPackageName<string>`.
 *
 * @example
 *
 * ```ts
 * if (isNormalizedPackageName(userInput)) {
 *     const validNormalizedName: NormalizedPackageName = userInput;
 * }
 * ```
 *
 * @param input - The string to validate.
 * @returns `true` if valid, otherwise `false`.
 * @public
 */
function isNormalizedPackageName(input) {
    return /^[a-z0-9_.-]+$/.test(input);
}
/**
 * Parses a string and returns it as a `PackageName` if it is valid.
 *
 * @param input - The string to parse.
 * @returns The parsed `PackageName`.
 * @throws Will throw an error if the input is not a valid package name.
 */
function parsePackageName(input) {
    if (!isPackageName(input)) {
        throw new Error(`Invalid package name: ${input}`);
    }
    return input;
}

exports.PackageRecord = js_rattlerExports.PackageRecord;
exports.SolvedPackage = js_rattlerExports.SolvedPackage;
exports.Version = js_rattlerExports.Version;
exports.VersionSpec = js_rattlerExports.VersionSpec;
exports.VersionWithSource = js_rattlerExports.VersionWithSource;
exports.archNames = archNames;
exports.isArch = isArch;
exports.isNormalizedPackageName = isNormalizedPackageName;
exports.isPackageName = isPackageName;
exports.isPlatform = isPlatform;
exports.normalizePackageName = normalizePackageName;
exports.parsePackageName = parsePackageName;
exports.platformArch = platformArch;
exports.platformNames = platformNames;
exports.simpleSolve = js_rattlerExports.simpleSolve;
