"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  crossRegionPresignedUrlMiddleware: () => crossRegionPresignedUrlMiddleware,
  crossRegionPresignedUrlMiddlewareOptions: () => crossRegionPresignedUrlMiddlewareOptions,
  getCrossRegionPresignedUrlPlugin: () => getCrossRegionPresignedUrlPlugin
});
module.exports = __toCommonJS(index_exports);
var import_util_format_url = require("@aws-sdk/util-format-url");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_protocol_http = require("@smithy/protocol-http");
var import_signature_v4 = require("@smithy/signature-v4");
var regARN = /arn:[\w+=/,.@-]+:[\w+=/,.@-]+:([\w+=/,.@-]*)?:[0-9]+:[\w+=/,.@-]+(:[\w+=/,.@-]+)?(:[\w+=/,.@-]+)?/;
var sourceIdToCommandKeyMap = {
  SourceDBSnapshotIdentifier: "CopyDBSnapshot",
  SourceDBInstanceIdentifier: "CreateDBInstanceReadReplica",
  ReplicationSourceIdentifier: "CreateDBCluster",
  // This key is optional.
  SourceDBClusterSnapshotIdentifier: "CopyDBClusterSnapshot",
  SourceDBInstanceArn: "StartDBInstanceAutomatedBackupsReplication"
};
var version = "2014-10-31";
function crossRegionPresignedUrlMiddleware(options) {
  return (next, context) => async (args) => {
    const { input } = args;
    const region = await options.region();
    const sourceIdKey = Object.keys(sourceIdToCommandKeyMap).filter(
      (sourceKeyId) => input.hasOwnProperty(sourceKeyId)
    )[0];
    if (!sourceIdKey) return next(args);
    const command = sourceIdToCommandKeyMap[sourceIdKey];
    if (!input.PreSignedUrl && isARN(input[sourceIdKey]) && region !== getEndpointFromARN(input[sourceIdKey])) {
      const sourceRegion = getEndpointFromARN(input[sourceIdKey]);
      let resolvedEndpoint;
      if (typeof options.endpoint === "function") {
        resolvedEndpoint = await options.endpoint();
      } else {
        resolvedEndpoint = (0, import_middleware_endpoint.toEndpointV1)(context.endpointV2);
      }
      resolvedEndpoint.hostname = `rds.${sourceRegion}.amazonaws.com`;
      const request = new import_protocol_http.HttpRequest({
        ...resolvedEndpoint,
        protocol: "https",
        headers: {
          host: resolvedEndpoint.hostname
        },
        query: {
          Action: command,
          Version: version,
          KmsKeyId: input.KmsKeyId,
          DestinationRegion: region,
          [sourceIdKey]: input[sourceIdKey]
        }
      });
      const signer = new import_signature_v4.SignatureV4({
        credentials: options.credentials,
        region: sourceRegion,
        service: "rds",
        sha256: options.sha256,
        uriEscapePath: options.signingEscapePath
      });
      const presignedRequest = await signer.presign(request, {
        expiresIn: 3600
      });
      args = {
        ...args,
        input: {
          ...args.input,
          PreSignedUrl: (0, import_util_format_url.formatUrl)(presignedRequest)
        }
      };
    }
    return next(args);
  };
}
__name(crossRegionPresignedUrlMiddleware, "crossRegionPresignedUrlMiddleware");
var crossRegionPresignedUrlMiddlewareOptions = {
  step: "serialize",
  tags: ["CROSS_REGION_PRESIGNED_URL"],
  name: "crossRegionPresignedUrlMiddleware",
  override: true,
  relation: "after",
  toMiddleware: "endpointV2Middleware"
};
var getCrossRegionPresignedUrlPlugin = /* @__PURE__ */ __name((config) => ({
  applyToStack: /* @__PURE__ */ __name((clientStack) => {
    clientStack.addRelativeTo(crossRegionPresignedUrlMiddleware(config), crossRegionPresignedUrlMiddlewareOptions);
  }, "applyToStack")
}), "getCrossRegionPresignedUrlPlugin");
function isARN(id) {
  if (!id) return false;
  return regARN.test(id);
}
__name(isARN, "isARN");
function getEndpointFromARN(arn) {
  const arnArr = arn.split(":");
  if (arnArr.length < 4) {
    throw new Error(`Cannot infer endpoint from '${arn}'`);
  }
  return arnArr[3];
}
__name(getEndpointFromARN, "getEndpointFromARN");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  crossRegionPresignedUrlMiddlewareOptions,
  getCrossRegionPresignedUrlPlugin,
  crossRegionPresignedUrlMiddleware
});

