import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import {
  ActivityStreamMode,
  ActivityStreamPolicyStatus,
  ActivityStreamStatus,
  AutomationMode,
  AvailabilityZone,
  BlueGreenDeployment,
  DatabaseInsightsMode,
  DBCluster,
  DBClusterAutomatedBackup,
  DBClusterBacktrack,
  DBClusterEndpoint,
  DBClusterParameterGroup,
  DBClusterSnapshot,
  DBEngineVersion,
  DBInstance,
  DBInstanceAutomatedBackup,
  DBParameterGroup,
  DBProxy,
  DBProxyEndpoint,
  DBSecurityGroup,
  DBShardGroup,
  DBSnapshot,
  DBSubnetGroup,
  EventSubscription,
  ExportSourceType,
  ExportTask,
  GlobalCluster,
  Integration,
  OptionGroup,
  OptionSetting,
  ProcessorFeature,
  RdsCustomClusterConfiguration,
  ReplicaMode,
  ResourcePendingMaintenanceActions,
  ScalingConfiguration,
  ServerlessV2ScalingConfiguration,
  Tag,
  TenantDatabase,
  UserAuthConfig,
} from "./models_0";
import { RDSServiceException as __BaseException } from "./RDSServiceException";
export declare class InvalidOptionGroupStateFault extends __BaseException {
  readonly name: "InvalidOptionGroupStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidOptionGroupStateFault, __BaseException>
  );
}
export interface DeleteTenantDatabaseMessage {
  DBInstanceIdentifier: string | undefined;
  TenantDBName: string | undefined;
  SkipFinalSnapshot?: boolean | undefined;
  FinalDBSnapshotIdentifier?: string | undefined;
}
export interface DeleteTenantDatabaseResult {
  TenantDatabase?: TenantDatabase | undefined;
}
export declare class DBProxyTargetNotFoundFault extends __BaseException {
  readonly name: "DBProxyTargetNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBProxyTargetNotFoundFault, __BaseException>
  );
}
export interface DeregisterDBProxyTargetsRequest {
  DBProxyName: string | undefined;
  TargetGroupName?: string | undefined;
  DBInstanceIdentifiers?: string[] | undefined;
  DBClusterIdentifiers?: string[] | undefined;
}
export interface DeregisterDBProxyTargetsResponse {}
export interface DescribeAccountAttributesMessage {}
export interface Filter {
  Name: string | undefined;
  Values: string[] | undefined;
}
export interface DescribeBlueGreenDeploymentsRequest {
  BlueGreenDeploymentIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  Marker?: string | undefined;
  MaxRecords?: number | undefined;
}
export interface DescribeBlueGreenDeploymentsResponse {
  BlueGreenDeployments?: BlueGreenDeployment[] | undefined;
  Marker?: string | undefined;
}
export interface Certificate {
  CertificateIdentifier?: string | undefined;
  CertificateType?: string | undefined;
  Thumbprint?: string | undefined;
  ValidFrom?: Date | undefined;
  ValidTill?: Date | undefined;
  CertificateArn?: string | undefined;
  CustomerOverride?: boolean | undefined;
  CustomerOverrideValidTill?: Date | undefined;
}
export interface CertificateMessage {
  DefaultCertificateForNewLaunches?: string | undefined;
  Certificates?: Certificate[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeCertificatesMessage {
  CertificateIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DBClusterAutomatedBackupMessage {
  Marker?: string | undefined;
  DBClusterAutomatedBackups?: DBClusterAutomatedBackup[] | undefined;
}
export interface DescribeDBClusterAutomatedBackupsMessage {
  DbClusterResourceId?: string | undefined;
  DBClusterIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DBClusterBacktrackMessage {
  Marker?: string | undefined;
  DBClusterBacktracks?: DBClusterBacktrack[] | undefined;
}
export declare class DBClusterBacktrackNotFoundFault extends __BaseException {
  readonly name: "DBClusterBacktrackNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBClusterBacktrackNotFoundFault,
      __BaseException
    >
  );
}
export interface DescribeDBClusterBacktracksMessage {
  DBClusterIdentifier: string | undefined;
  BacktrackIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DBClusterEndpointMessage {
  Marker?: string | undefined;
  DBClusterEndpoints?: DBClusterEndpoint[] | undefined;
}
export interface DescribeDBClusterEndpointsMessage {
  DBClusterIdentifier?: string | undefined;
  DBClusterEndpointIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DBClusterParameterGroupsMessage {
  Marker?: string | undefined;
  DBClusterParameterGroups?: DBClusterParameterGroup[] | undefined;
}
export interface DescribeDBClusterParameterGroupsMessage {
  DBClusterParameterGroupName?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export declare const ApplyMethod: {
  readonly immediate: "immediate";
  readonly pending_reboot: "pending-reboot";
};
export type ApplyMethod = (typeof ApplyMethod)[keyof typeof ApplyMethod];
export interface Parameter {
  ParameterName?: string | undefined;
  ParameterValue?: string | undefined;
  Description?: string | undefined;
  Source?: string | undefined;
  ApplyType?: string | undefined;
  DataType?: string | undefined;
  AllowedValues?: string | undefined;
  IsModifiable?: boolean | undefined;
  MinimumEngineVersion?: string | undefined;
  ApplyMethod?: ApplyMethod | undefined;
  SupportedEngineModes?: string[] | undefined;
}
export interface DBClusterParameterGroupDetails {
  Parameters?: Parameter[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeDBClusterParametersMessage {
  DBClusterParameterGroupName: string | undefined;
  Source?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DBClusterMessage {
  Marker?: string | undefined;
  DBClusters?: DBCluster[] | undefined;
}
export interface DescribeDBClustersMessage {
  DBClusterIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
  IncludeShared?: boolean | undefined;
}
export interface DescribeDBClusterSnapshotAttributesMessage {
  DBClusterSnapshotIdentifier: string | undefined;
}
export interface DBClusterSnapshotAttribute {
  AttributeName?: string | undefined;
  AttributeValues?: string[] | undefined;
}
export interface DBClusterSnapshotAttributesResult {
  DBClusterSnapshotIdentifier?: string | undefined;
  DBClusterSnapshotAttributes?: DBClusterSnapshotAttribute[] | undefined;
}
export interface DescribeDBClusterSnapshotAttributesResult {
  DBClusterSnapshotAttributesResult?:
    | DBClusterSnapshotAttributesResult
    | undefined;
}
export interface DBClusterSnapshotMessage {
  Marker?: string | undefined;
  DBClusterSnapshots?: DBClusterSnapshot[] | undefined;
}
export interface DescribeDBClusterSnapshotsMessage {
  DBClusterIdentifier?: string | undefined;
  DBClusterSnapshotIdentifier?: string | undefined;
  SnapshotType?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
  IncludeShared?: boolean | undefined;
  IncludePublic?: boolean | undefined;
  DbClusterResourceId?: string | undefined;
}
export interface DBEngineVersionMessage {
  Marker?: string | undefined;
  DBEngineVersions?: DBEngineVersion[] | undefined;
}
export interface DescribeDBEngineVersionsMessage {
  Engine?: string | undefined;
  EngineVersion?: string | undefined;
  DBParameterGroupFamily?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
  DefaultOnly?: boolean | undefined;
  ListSupportedCharacterSets?: boolean | undefined;
  ListSupportedTimezones?: boolean | undefined;
  IncludeAll?: boolean | undefined;
}
export interface DBInstanceAutomatedBackupMessage {
  Marker?: string | undefined;
  DBInstanceAutomatedBackups?: DBInstanceAutomatedBackup[] | undefined;
}
export interface DescribeDBInstanceAutomatedBackupsMessage {
  DbiResourceId?: string | undefined;
  DBInstanceIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
  DBInstanceAutomatedBackupsArn?: string | undefined;
}
export interface DBInstanceMessage {
  Marker?: string | undefined;
  DBInstances?: DBInstance[] | undefined;
}
export interface DescribeDBInstancesMessage {
  DBInstanceIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export declare class DBInstanceNotReadyFault extends __BaseException {
  readonly name: "DBInstanceNotReadyFault";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<DBInstanceNotReadyFault, __BaseException>
  );
}
export interface DescribeDBLogFilesMessage {
  DBInstanceIdentifier: string | undefined;
  FilenameContains?: string | undefined;
  FileLastWritten?: number | undefined;
  FileSize?: number | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DescribeDBLogFilesDetails {
  LogFileName?: string | undefined;
  LastWritten?: number | undefined;
  Size?: number | undefined;
}
export interface DescribeDBLogFilesResponse {
  DescribeDBLogFiles?: DescribeDBLogFilesDetails[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeDBMajorEngineVersionsRequest {
  Engine?: string | undefined;
  MajorEngineVersion?: string | undefined;
  Marker?: string | undefined;
  MaxRecords?: number | undefined;
}
export declare const LifecycleSupportName: {
  readonly OPEN_SOURCE_RDS_EXTENDED_SUPPORT: "open-source-rds-extended-support";
  readonly OPEN_SOURCE_RDS_STANDARD_SUPPORT: "open-source-rds-standard-support";
};
export type LifecycleSupportName =
  (typeof LifecycleSupportName)[keyof typeof LifecycleSupportName];
export interface SupportedEngineLifecycle {
  LifecycleSupportName: LifecycleSupportName | undefined;
  LifecycleSupportStartDate: Date | undefined;
  LifecycleSupportEndDate: Date | undefined;
}
export interface DBMajorEngineVersion {
  Engine?: string | undefined;
  MajorEngineVersion?: string | undefined;
  SupportedEngineLifecycles?: SupportedEngineLifecycle[] | undefined;
}
export interface DescribeDBMajorEngineVersionsResponse {
  DBMajorEngineVersions?: DBMajorEngineVersion[] | undefined;
  Marker?: string | undefined;
}
export interface DBParameterGroupsMessage {
  Marker?: string | undefined;
  DBParameterGroups?: DBParameterGroup[] | undefined;
}
export interface DescribeDBParameterGroupsMessage {
  DBParameterGroupName?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DBParameterGroupDetails {
  Parameters?: Parameter[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeDBParametersMessage {
  DBParameterGroupName: string | undefined;
  Source?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DescribeDBProxiesRequest {
  DBProxyName?: string | undefined;
  Filters?: Filter[] | undefined;
  Marker?: string | undefined;
  MaxRecords?: number | undefined;
}
export interface DescribeDBProxiesResponse {
  DBProxies?: DBProxy[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeDBProxyEndpointsRequest {
  DBProxyName?: string | undefined;
  DBProxyEndpointName?: string | undefined;
  Filters?: Filter[] | undefined;
  Marker?: string | undefined;
  MaxRecords?: number | undefined;
}
export interface DescribeDBProxyEndpointsResponse {
  DBProxyEndpoints?: DBProxyEndpoint[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeDBProxyTargetGroupsRequest {
  DBProxyName: string | undefined;
  TargetGroupName?: string | undefined;
  Filters?: Filter[] | undefined;
  Marker?: string | undefined;
  MaxRecords?: number | undefined;
}
export interface ConnectionPoolConfigurationInfo {
  MaxConnectionsPercent?: number | undefined;
  MaxIdleConnectionsPercent?: number | undefined;
  ConnectionBorrowTimeout?: number | undefined;
  SessionPinningFilters?: string[] | undefined;
  InitQuery?: string | undefined;
}
export interface DBProxyTargetGroup {
  DBProxyName?: string | undefined;
  TargetGroupName?: string | undefined;
  TargetGroupArn?: string | undefined;
  IsDefault?: boolean | undefined;
  Status?: string | undefined;
  ConnectionPoolConfig?: ConnectionPoolConfigurationInfo | undefined;
  CreatedDate?: Date | undefined;
  UpdatedDate?: Date | undefined;
}
export interface DescribeDBProxyTargetGroupsResponse {
  TargetGroups?: DBProxyTargetGroup[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeDBProxyTargetsRequest {
  DBProxyName: string | undefined;
  TargetGroupName?: string | undefined;
  Filters?: Filter[] | undefined;
  Marker?: string | undefined;
  MaxRecords?: number | undefined;
}
export declare const TargetRole: {
  readonly READ_ONLY: "READ_ONLY";
  readonly READ_WRITE: "READ_WRITE";
  readonly UNKNOWN: "UNKNOWN";
};
export type TargetRole = (typeof TargetRole)[keyof typeof TargetRole];
export declare const TargetHealthReason: {
  readonly AUTH_FAILURE: "AUTH_FAILURE";
  readonly CONNECTION_FAILED: "CONNECTION_FAILED";
  readonly INVALID_REPLICATION_STATE: "INVALID_REPLICATION_STATE";
  readonly PENDING_PROXY_CAPACITY: "PENDING_PROXY_CAPACITY";
  readonly UNREACHABLE: "UNREACHABLE";
};
export type TargetHealthReason =
  (typeof TargetHealthReason)[keyof typeof TargetHealthReason];
export declare const TargetState: {
  readonly available: "AVAILABLE";
  readonly registering: "REGISTERING";
  readonly unavailable: "UNAVAILABLE";
};
export type TargetState = (typeof TargetState)[keyof typeof TargetState];
export interface TargetHealth {
  State?: TargetState | undefined;
  Reason?: TargetHealthReason | undefined;
  Description?: string | undefined;
}
export declare const TargetType: {
  readonly RDS_INSTANCE: "RDS_INSTANCE";
  readonly RDS_SERVERLESS_ENDPOINT: "RDS_SERVERLESS_ENDPOINT";
  readonly TRACKED_CLUSTER: "TRACKED_CLUSTER";
};
export type TargetType = (typeof TargetType)[keyof typeof TargetType];
export interface DBProxyTarget {
  TargetArn?: string | undefined;
  Endpoint?: string | undefined;
  TrackedClusterId?: string | undefined;
  RdsResourceId?: string | undefined;
  Port?: number | undefined;
  Type?: TargetType | undefined;
  Role?: TargetRole | undefined;
  TargetHealth?: TargetHealth | undefined;
}
export interface DescribeDBProxyTargetsResponse {
  Targets?: DBProxyTarget[] | undefined;
  Marker?: string | undefined;
}
export interface PerformanceInsightsMetricDimensionGroup {
  Dimensions?: string[] | undefined;
  Group?: string | undefined;
  Limit?: number | undefined;
}
export interface PerformanceInsightsMetricQuery {
  GroupBy?: PerformanceInsightsMetricDimensionGroup | undefined;
  Metric?: string | undefined;
}
export interface MetricQuery {
  PerformanceInsightsMetricQuery?: PerformanceInsightsMetricQuery | undefined;
}
export interface ScalarReferenceDetails {
  Value?: number | undefined;
}
export interface ReferenceDetails {
  ScalarReferenceDetails?: ScalarReferenceDetails | undefined;
}
export interface MetricReference {
  Name?: string | undefined;
  ReferenceDetails?: ReferenceDetails | undefined;
}
export interface Metric {
  Name?: string | undefined;
  References?: MetricReference[] | undefined;
  StatisticsDetails?: string | undefined;
  MetricQuery?: MetricQuery | undefined;
}
export interface PerformanceIssueDetails {
  StartTime?: Date | undefined;
  EndTime?: Date | undefined;
  Metrics?: Metric[] | undefined;
  Analysis?: string | undefined;
}
export interface IssueDetails {
  PerformanceIssueDetails?: PerformanceIssueDetails | undefined;
}
export interface DocLink {
  Text?: string | undefined;
  Url?: string | undefined;
}
export interface ContextAttribute {
  Key?: string | undefined;
  Value?: string | undefined;
}
export interface RecommendedActionParameter {
  Key?: string | undefined;
  Value?: string | undefined;
}
export interface RecommendedAction {
  ActionId?: string | undefined;
  Title?: string | undefined;
  Description?: string | undefined;
  Operation?: string | undefined;
  Parameters?: RecommendedActionParameter[] | undefined;
  ApplyModes?: string[] | undefined;
  Status?: string | undefined;
  IssueDetails?: IssueDetails | undefined;
  ContextAttributes?: ContextAttribute[] | undefined;
}
export interface DBRecommendation {
  RecommendationId?: string | undefined;
  TypeId?: string | undefined;
  Severity?: string | undefined;
  ResourceArn?: string | undefined;
  Status?: string | undefined;
  CreatedTime?: Date | undefined;
  UpdatedTime?: Date | undefined;
  Detection?: string | undefined;
  Recommendation?: string | undefined;
  Description?: string | undefined;
  Reason?: string | undefined;
  RecommendedActions?: RecommendedAction[] | undefined;
  Category?: string | undefined;
  Source?: string | undefined;
  TypeDetection?: string | undefined;
  TypeRecommendation?: string | undefined;
  Impact?: string | undefined;
  AdditionalInfo?: string | undefined;
  Links?: DocLink[] | undefined;
  IssueDetails?: IssueDetails | undefined;
}
export interface DBRecommendationsMessage {
  DBRecommendations?: DBRecommendation[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeDBRecommendationsMessage {
  LastUpdatedAfter?: Date | undefined;
  LastUpdatedBefore?: Date | undefined;
  Locale?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DBSecurityGroupMessage {
  Marker?: string | undefined;
  DBSecurityGroups?: DBSecurityGroup[] | undefined;
}
export interface DescribeDBSecurityGroupsMessage {
  DBSecurityGroupName?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DescribeDBShardGroupsMessage {
  DBShardGroupIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  Marker?: string | undefined;
  MaxRecords?: number | undefined;
}
export interface DescribeDBShardGroupsResponse {
  DBShardGroups?: DBShardGroup[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeDBSnapshotAttributesMessage {
  DBSnapshotIdentifier: string | undefined;
}
export interface DBSnapshotAttribute {
  AttributeName?: string | undefined;
  AttributeValues?: string[] | undefined;
}
export interface DBSnapshotAttributesResult {
  DBSnapshotIdentifier?: string | undefined;
  DBSnapshotAttributes?: DBSnapshotAttribute[] | undefined;
}
export interface DescribeDBSnapshotAttributesResult {
  DBSnapshotAttributesResult?: DBSnapshotAttributesResult | undefined;
}
export interface DBSnapshotMessage {
  Marker?: string | undefined;
  DBSnapshots?: DBSnapshot[] | undefined;
}
export interface DescribeDBSnapshotsMessage {
  DBInstanceIdentifier?: string | undefined;
  DBSnapshotIdentifier?: string | undefined;
  SnapshotType?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
  IncludeShared?: boolean | undefined;
  IncludePublic?: boolean | undefined;
  DbiResourceId?: string | undefined;
}
export interface DBSnapshotTenantDatabase {
  DBSnapshotIdentifier?: string | undefined;
  DBInstanceIdentifier?: string | undefined;
  DbiResourceId?: string | undefined;
  EngineName?: string | undefined;
  SnapshotType?: string | undefined;
  TenantDatabaseCreateTime?: Date | undefined;
  TenantDBName?: string | undefined;
  MasterUsername?: string | undefined;
  TenantDatabaseResourceId?: string | undefined;
  CharacterSetName?: string | undefined;
  DBSnapshotTenantDatabaseARN?: string | undefined;
  NcharCharacterSetName?: string | undefined;
  TagList?: Tag[] | undefined;
}
export interface DBSnapshotTenantDatabasesMessage {
  Marker?: string | undefined;
  DBSnapshotTenantDatabases?: DBSnapshotTenantDatabase[] | undefined;
}
export interface DescribeDBSnapshotTenantDatabasesMessage {
  DBInstanceIdentifier?: string | undefined;
  DBSnapshotIdentifier?: string | undefined;
  SnapshotType?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
  DbiResourceId?: string | undefined;
}
export interface DBSubnetGroupMessage {
  Marker?: string | undefined;
  DBSubnetGroups?: DBSubnetGroup[] | undefined;
}
export interface DescribeDBSubnetGroupsMessage {
  DBSubnetGroupName?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DescribeEngineDefaultClusterParametersMessage {
  DBParameterGroupFamily: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface EngineDefaults {
  DBParameterGroupFamily?: string | undefined;
  Marker?: string | undefined;
  Parameters?: Parameter[] | undefined;
}
export interface DescribeEngineDefaultClusterParametersResult {
  EngineDefaults?: EngineDefaults | undefined;
}
export interface DescribeEngineDefaultParametersMessage {
  DBParameterGroupFamily: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DescribeEngineDefaultParametersResult {
  EngineDefaults?: EngineDefaults | undefined;
}
export interface DescribeEventCategoriesMessage {
  SourceType?: string | undefined;
  Filters?: Filter[] | undefined;
}
export interface EventCategoriesMap {
  SourceType?: string | undefined;
  EventCategories?: string[] | undefined;
}
export interface EventCategoriesMessage {
  EventCategoriesMapList?: EventCategoriesMap[] | undefined;
}
export declare const SourceType: {
  readonly blue_green_deployment: "blue-green-deployment";
  readonly custom_engine_version: "custom-engine-version";
  readonly db_cluster: "db-cluster";
  readonly db_cluster_snapshot: "db-cluster-snapshot";
  readonly db_instance: "db-instance";
  readonly db_parameter_group: "db-parameter-group";
  readonly db_proxy: "db-proxy";
  readonly db_security_group: "db-security-group";
  readonly db_snapshot: "db-snapshot";
};
export type SourceType = (typeof SourceType)[keyof typeof SourceType];
export interface DescribeEventsMessage {
  SourceIdentifier?: string | undefined;
  SourceType?: SourceType | undefined;
  StartTime?: Date | undefined;
  EndTime?: Date | undefined;
  Duration?: number | undefined;
  EventCategories?: string[] | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface Event {
  SourceIdentifier?: string | undefined;
  SourceType?: SourceType | undefined;
  Message?: string | undefined;
  EventCategories?: string[] | undefined;
  Date?: Date | undefined;
  SourceArn?: string | undefined;
}
export interface EventsMessage {
  Marker?: string | undefined;
  Events?: Event[] | undefined;
}
export interface DescribeEventSubscriptionsMessage {
  SubscriptionName?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface EventSubscriptionsMessage {
  Marker?: string | undefined;
  EventSubscriptionsList?: EventSubscription[] | undefined;
}
export interface DescribeExportTasksMessage {
  ExportTaskIdentifier?: string | undefined;
  SourceArn?: string | undefined;
  Filters?: Filter[] | undefined;
  Marker?: string | undefined;
  MaxRecords?: number | undefined;
  SourceType?: ExportSourceType | undefined;
}
export interface ExportTasksMessage {
  Marker?: string | undefined;
  ExportTasks?: ExportTask[] | undefined;
}
export interface DescribeGlobalClustersMessage {
  GlobalClusterIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface GlobalClustersMessage {
  Marker?: string | undefined;
  GlobalClusters?: GlobalCluster[] | undefined;
}
export interface DescribeIntegrationsMessage {
  IntegrationIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface DescribeIntegrationsResponse {
  Marker?: string | undefined;
  Integrations?: Integration[] | undefined;
}
export interface DescribeOptionGroupOptionsMessage {
  EngineName: string | undefined;
  MajorEngineVersion?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface MinimumEngineVersionPerAllowedValue {
  AllowedValue?: string | undefined;
  MinimumEngineVersion?: string | undefined;
}
export interface OptionGroupOptionSetting {
  SettingName?: string | undefined;
  SettingDescription?: string | undefined;
  DefaultValue?: string | undefined;
  ApplyType?: string | undefined;
  AllowedValues?: string | undefined;
  IsModifiable?: boolean | undefined;
  IsRequired?: boolean | undefined;
  MinimumEngineVersionPerAllowedValue?:
    | MinimumEngineVersionPerAllowedValue[]
    | undefined;
}
export interface OptionVersion {
  Version?: string | undefined;
  IsDefault?: boolean | undefined;
}
export interface OptionGroupOption {
  Name?: string | undefined;
  Description?: string | undefined;
  EngineName?: string | undefined;
  MajorEngineVersion?: string | undefined;
  MinimumRequiredMinorEngineVersion?: string | undefined;
  PortRequired?: boolean | undefined;
  DefaultPort?: number | undefined;
  OptionsDependedOn?: string[] | undefined;
  OptionsConflictsWith?: string[] | undefined;
  Persistent?: boolean | undefined;
  Permanent?: boolean | undefined;
  RequiresAutoMinorEngineVersionUpgrade?: boolean | undefined;
  VpcOnly?: boolean | undefined;
  SupportsOptionVersionDowngrade?: boolean | undefined;
  OptionGroupOptionSettings?: OptionGroupOptionSetting[] | undefined;
  OptionGroupOptionVersions?: OptionVersion[] | undefined;
  CopyableCrossAccount?: boolean | undefined;
}
export interface OptionGroupOptionsMessage {
  OptionGroupOptions?: OptionGroupOption[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeOptionGroupsMessage {
  OptionGroupName?: string | undefined;
  Filters?: Filter[] | undefined;
  Marker?: string | undefined;
  MaxRecords?: number | undefined;
  EngineName?: string | undefined;
  MajorEngineVersion?: string | undefined;
}
export interface OptionGroups {
  OptionGroupsList?: OptionGroup[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeOrderableDBInstanceOptionsMessage {
  Engine: string | undefined;
  EngineVersion?: string | undefined;
  DBInstanceClass?: string | undefined;
  LicenseModel?: string | undefined;
  AvailabilityZoneGroup?: string | undefined;
  Vpc?: boolean | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface AvailableProcessorFeature {
  Name?: string | undefined;
  DefaultValue?: string | undefined;
  AllowedValues?: string | undefined;
}
export interface OrderableDBInstanceOption {
  Engine?: string | undefined;
  EngineVersion?: string | undefined;
  DBInstanceClass?: string | undefined;
  LicenseModel?: string | undefined;
  AvailabilityZoneGroup?: string | undefined;
  AvailabilityZones?: AvailabilityZone[] | undefined;
  MultiAZCapable?: boolean | undefined;
  ReadReplicaCapable?: boolean | undefined;
  Vpc?: boolean | undefined;
  SupportsStorageEncryption?: boolean | undefined;
  StorageType?: string | undefined;
  SupportsIops?: boolean | undefined;
  SupportsEnhancedMonitoring?: boolean | undefined;
  SupportsIAMDatabaseAuthentication?: boolean | undefined;
  SupportsPerformanceInsights?: boolean | undefined;
  MinStorageSize?: number | undefined;
  MaxStorageSize?: number | undefined;
  MinIopsPerDbInstance?: number | undefined;
  MaxIopsPerDbInstance?: number | undefined;
  MinIopsPerGib?: number | undefined;
  MaxIopsPerGib?: number | undefined;
  AvailableProcessorFeatures?: AvailableProcessorFeature[] | undefined;
  SupportedEngineModes?: string[] | undefined;
  SupportsStorageAutoscaling?: boolean | undefined;
  SupportsKerberosAuthentication?: boolean | undefined;
  OutpostCapable?: boolean | undefined;
  SupportedActivityStreamModes?: string[] | undefined;
  SupportsGlobalDatabases?: boolean | undefined;
  SupportsClusters?: boolean | undefined;
  SupportedNetworkTypes?: string[] | undefined;
  SupportsStorageThroughput?: boolean | undefined;
  MinStorageThroughputPerDbInstance?: number | undefined;
  MaxStorageThroughputPerDbInstance?: number | undefined;
  MinStorageThroughputPerIops?: number | undefined;
  MaxStorageThroughputPerIops?: number | undefined;
  SupportsDedicatedLogVolume?: boolean | undefined;
}
export interface OrderableDBInstanceOptionsMessage {
  OrderableDBInstanceOptions?: OrderableDBInstanceOption[] | undefined;
  Marker?: string | undefined;
}
export interface DescribePendingMaintenanceActionsMessage {
  ResourceIdentifier?: string | undefined;
  Filters?: Filter[] | undefined;
  Marker?: string | undefined;
  MaxRecords?: number | undefined;
}
export interface PendingMaintenanceActionsMessage {
  PendingMaintenanceActions?: ResourcePendingMaintenanceActions[] | undefined;
  Marker?: string | undefined;
}
export interface DescribeReservedDBInstancesMessage {
  ReservedDBInstanceId?: string | undefined;
  ReservedDBInstancesOfferingId?: string | undefined;
  DBInstanceClass?: string | undefined;
  Duration?: string | undefined;
  ProductDescription?: string | undefined;
  OfferingType?: string | undefined;
  MultiAZ?: boolean | undefined;
  LeaseId?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface RecurringCharge {
  RecurringChargeAmount?: number | undefined;
  RecurringChargeFrequency?: string | undefined;
}
export interface ReservedDBInstance {
  ReservedDBInstanceId?: string | undefined;
  ReservedDBInstancesOfferingId?: string | undefined;
  DBInstanceClass?: string | undefined;
  StartTime?: Date | undefined;
  Duration?: number | undefined;
  FixedPrice?: number | undefined;
  UsagePrice?: number | undefined;
  CurrencyCode?: string | undefined;
  DBInstanceCount?: number | undefined;
  ProductDescription?: string | undefined;
  OfferingType?: string | undefined;
  MultiAZ?: boolean | undefined;
  State?: string | undefined;
  RecurringCharges?: RecurringCharge[] | undefined;
  ReservedDBInstanceArn?: string | undefined;
  LeaseId?: string | undefined;
}
export interface ReservedDBInstanceMessage {
  Marker?: string | undefined;
  ReservedDBInstances?: ReservedDBInstance[] | undefined;
}
export declare class ReservedDBInstanceNotFoundFault extends __BaseException {
  readonly name: "ReservedDBInstanceNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ReservedDBInstanceNotFoundFault,
      __BaseException
    >
  );
}
export interface DescribeReservedDBInstancesOfferingsMessage {
  ReservedDBInstancesOfferingId?: string | undefined;
  DBInstanceClass?: string | undefined;
  Duration?: string | undefined;
  ProductDescription?: string | undefined;
  OfferingType?: string | undefined;
  MultiAZ?: boolean | undefined;
  Filters?: Filter[] | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
}
export interface ReservedDBInstancesOffering {
  ReservedDBInstancesOfferingId?: string | undefined;
  DBInstanceClass?: string | undefined;
  Duration?: number | undefined;
  FixedPrice?: number | undefined;
  UsagePrice?: number | undefined;
  CurrencyCode?: string | undefined;
  ProductDescription?: string | undefined;
  OfferingType?: string | undefined;
  MultiAZ?: boolean | undefined;
  RecurringCharges?: RecurringCharge[] | undefined;
}
export interface ReservedDBInstancesOfferingMessage {
  Marker?: string | undefined;
  ReservedDBInstancesOfferings?: ReservedDBInstancesOffering[] | undefined;
}
export declare class ReservedDBInstancesOfferingNotFoundFault extends __BaseException {
  readonly name: "ReservedDBInstancesOfferingNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ReservedDBInstancesOfferingNotFoundFault,
      __BaseException
    >
  );
}
export interface DescribeSourceRegionsMessage {
  RegionName?: string | undefined;
  MaxRecords?: number | undefined;
  Marker?: string | undefined;
  Filters?: Filter[] | undefined;
}
export interface SourceRegion {
  RegionName?: string | undefined;
  Endpoint?: string | undefined;
  Status?: string | undefined;
  SupportsDBInstanceAutomatedBackupsReplication?: boolean | undefined;
}
export interface SourceRegionMessage {
  Marker?: string | undefined;
  SourceRegions?: SourceRegion[] | undefined;
}
export interface DescribeTenantDatabasesMessage {
  DBInstanceIdentifier?: string | undefined;
  TenantDBName?: string | undefined;
  Filters?: Filter[] | undefined;
  Marker?: string | undefined;
  MaxRecords?: number | undefined;
}
export interface TenantDatabasesMessage {
  Marker?: string | undefined;
  TenantDatabases?: TenantDatabase[] | undefined;
}
export interface DescribeValidDBInstanceModificationsMessage {
  DBInstanceIdentifier: string | undefined;
}
export interface DoubleRange {
  From?: number | undefined;
  To?: number | undefined;
}
export interface Range {
  From?: number | undefined;
  To?: number | undefined;
  Step?: number | undefined;
}
export interface ValidStorageOptions {
  StorageType?: string | undefined;
  StorageSize?: Range[] | undefined;
  ProvisionedIops?: Range[] | undefined;
  IopsToStorageRatio?: DoubleRange[] | undefined;
  SupportsStorageAutoscaling?: boolean | undefined;
  ProvisionedStorageThroughput?: Range[] | undefined;
  StorageThroughputToIopsRatio?: DoubleRange[] | undefined;
}
export interface ValidDBInstanceModificationsMessage {
  Storage?: ValidStorageOptions[] | undefined;
  ValidProcessorFeatures?: AvailableProcessorFeature[] | undefined;
  SupportsDedicatedLogVolume?: boolean | undefined;
}
export interface DescribeValidDBInstanceModificationsResult {
  ValidDBInstanceModificationsMessage?:
    | ValidDBInstanceModificationsMessage
    | undefined;
}
export interface DisableHttpEndpointRequest {
  ResourceArn: string | undefined;
}
export interface DisableHttpEndpointResponse {
  ResourceArn?: string | undefined;
  HttpEndpointEnabled?: boolean | undefined;
}
export declare class InvalidResourceStateFault extends __BaseException {
  readonly name: "InvalidResourceStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidResourceStateFault, __BaseException>
  );
}
export declare class DBLogFileNotFoundFault extends __BaseException {
  readonly name: "DBLogFileNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBLogFileNotFoundFault, __BaseException>
  );
}
export interface DownloadDBLogFilePortionDetails {
  LogFileData?: string | undefined;
  Marker?: string | undefined;
  AdditionalDataPending?: boolean | undefined;
}
export interface DownloadDBLogFilePortionMessage {
  DBInstanceIdentifier: string | undefined;
  LogFileName: string | undefined;
  Marker?: string | undefined;
  NumberOfLines?: number | undefined;
}
export interface EnableHttpEndpointRequest {
  ResourceArn: string | undefined;
}
export interface EnableHttpEndpointResponse {
  ResourceArn?: string | undefined;
  HttpEndpointEnabled?: boolean | undefined;
}
export interface FailoverDBClusterMessage {
  DBClusterIdentifier: string | undefined;
  TargetDBInstanceIdentifier?: string | undefined;
}
export interface FailoverDBClusterResult {
  DBCluster?: DBCluster | undefined;
}
export interface FailoverGlobalClusterMessage {
  GlobalClusterIdentifier: string | undefined;
  TargetDbClusterIdentifier: string | undefined;
  AllowDataLoss?: boolean | undefined;
  Switchover?: boolean | undefined;
}
export interface FailoverGlobalClusterResult {
  GlobalCluster?: GlobalCluster | undefined;
}
export interface ListTagsForResourceMessage {
  ResourceName: string | undefined;
  Filters?: Filter[] | undefined;
}
export interface TagListMessage {
  TagList?: Tag[] | undefined;
}
export declare const AuditPolicyState: {
  readonly LOCKED_POLICY: "locked";
  readonly UNLOCKED_POLICY: "unlocked";
};
export type AuditPolicyState =
  (typeof AuditPolicyState)[keyof typeof AuditPolicyState];
export interface ModifyActivityStreamRequest {
  ResourceArn?: string | undefined;
  AuditPolicyState?: AuditPolicyState | undefined;
}
export interface ModifyActivityStreamResponse {
  KmsKeyId?: string | undefined;
  KinesisStreamName?: string | undefined;
  Status?: ActivityStreamStatus | undefined;
  Mode?: ActivityStreamMode | undefined;
  EngineNativeAuditFieldsIncluded?: boolean | undefined;
  PolicyStatus?: ActivityStreamPolicyStatus | undefined;
}
export interface ModifyCertificatesMessage {
  CertificateIdentifier?: string | undefined;
  RemoveCustomerOverride?: boolean | undefined;
}
export interface ModifyCertificatesResult {
  Certificate?: Certificate | undefined;
}
export interface DBClusterCapacityInfo {
  DBClusterIdentifier?: string | undefined;
  PendingCapacity?: number | undefined;
  CurrentCapacity?: number | undefined;
  SecondsBeforeTimeout?: number | undefined;
  TimeoutAction?: string | undefined;
}
export declare class InvalidDBClusterCapacityFault extends __BaseException {
  readonly name: "InvalidDBClusterCapacityFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDBClusterCapacityFault, __BaseException>
  );
}
export interface ModifyCurrentDBClusterCapacityMessage {
  DBClusterIdentifier: string | undefined;
  Capacity?: number | undefined;
  SecondsBeforeTimeout?: number | undefined;
  TimeoutAction?: string | undefined;
}
export declare const CustomEngineVersionStatus: {
  readonly available: "available";
  readonly inactive: "inactive";
  readonly inactive_except_restore: "inactive-except-restore";
};
export type CustomEngineVersionStatus =
  (typeof CustomEngineVersionStatus)[keyof typeof CustomEngineVersionStatus];
export interface ModifyCustomDBEngineVersionMessage {
  Engine: string | undefined;
  EngineVersion: string | undefined;
  Description?: string | undefined;
  Status?: CustomEngineVersionStatus | undefined;
}
export interface CloudwatchLogsExportConfiguration {
  EnableLogTypes?: string[] | undefined;
  DisableLogTypes?: string[] | undefined;
}
export interface ModifyDBClusterMessage {
  DBClusterIdentifier: string | undefined;
  NewDBClusterIdentifier?: string | undefined;
  ApplyImmediately?: boolean | undefined;
  BackupRetentionPeriod?: number | undefined;
  DBClusterParameterGroupName?: string | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  Port?: number | undefined;
  MasterUserPassword?: string | undefined;
  OptionGroupName?: string | undefined;
  PreferredBackupWindow?: string | undefined;
  PreferredMaintenanceWindow?: string | undefined;
  EnableIAMDatabaseAuthentication?: boolean | undefined;
  BacktrackWindow?: number | undefined;
  CloudwatchLogsExportConfiguration?:
    | CloudwatchLogsExportConfiguration
    | undefined;
  EngineVersion?: string | undefined;
  AllowMajorVersionUpgrade?: boolean | undefined;
  DBInstanceParameterGroupName?: string | undefined;
  Domain?: string | undefined;
  DomainIAMRoleName?: string | undefined;
  ScalingConfiguration?: ScalingConfiguration | undefined;
  DeletionProtection?: boolean | undefined;
  EnableHttpEndpoint?: boolean | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  EnableGlobalWriteForwarding?: boolean | undefined;
  DBClusterInstanceClass?: string | undefined;
  AllocatedStorage?: number | undefined;
  StorageType?: string | undefined;
  Iops?: number | undefined;
  AutoMinorVersionUpgrade?: boolean | undefined;
  MonitoringInterval?: number | undefined;
  MonitoringRoleArn?: string | undefined;
  DatabaseInsightsMode?: DatabaseInsightsMode | undefined;
  EnablePerformanceInsights?: boolean | undefined;
  PerformanceInsightsKMSKeyId?: string | undefined;
  PerformanceInsightsRetentionPeriod?: number | undefined;
  ServerlessV2ScalingConfiguration?:
    | ServerlessV2ScalingConfiguration
    | undefined;
  NetworkType?: string | undefined;
  ManageMasterUserPassword?: boolean | undefined;
  RotateMasterUserPassword?: boolean | undefined;
  MasterUserSecretKmsKeyId?: string | undefined;
  EngineMode?: string | undefined;
  AllowEngineModeChange?: boolean | undefined;
  EnableLocalWriteForwarding?: boolean | undefined;
  AwsBackupRecoveryPointArn?: string | undefined;
  EnableLimitlessDatabase?: boolean | undefined;
  CACertificateIdentifier?: string | undefined;
}
export interface ModifyDBClusterResult {
  DBCluster?: DBCluster | undefined;
}
export declare class StorageTypeNotAvailableFault extends __BaseException {
  readonly name: "StorageTypeNotAvailableFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<StorageTypeNotAvailableFault, __BaseException>
  );
}
export interface ModifyDBClusterEndpointMessage {
  DBClusterEndpointIdentifier: string | undefined;
  EndpointType?: string | undefined;
  StaticMembers?: string[] | undefined;
  ExcludedMembers?: string[] | undefined;
}
export interface DBClusterParameterGroupNameMessage {
  DBClusterParameterGroupName?: string | undefined;
}
export interface ModifyDBClusterParameterGroupMessage {
  DBClusterParameterGroupName: string | undefined;
  Parameters: Parameter[] | undefined;
}
export interface ModifyDBClusterSnapshotAttributeMessage {
  DBClusterSnapshotIdentifier: string | undefined;
  AttributeName: string | undefined;
  ValuesToAdd?: string[] | undefined;
  ValuesToRemove?: string[] | undefined;
}
export interface ModifyDBClusterSnapshotAttributeResult {
  DBClusterSnapshotAttributesResult?:
    | DBClusterSnapshotAttributesResult
    | undefined;
}
export declare class SharedSnapshotQuotaExceededFault extends __BaseException {
  readonly name: "SharedSnapshotQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      SharedSnapshotQuotaExceededFault,
      __BaseException
    >
  );
}
export declare class DBUpgradeDependencyFailureFault extends __BaseException {
  readonly name: "DBUpgradeDependencyFailureFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBUpgradeDependencyFailureFault,
      __BaseException
    >
  );
}
export interface ModifyDBInstanceMessage {
  DBInstanceIdentifier: string | undefined;
  AllocatedStorage?: number | undefined;
  DBInstanceClass?: string | undefined;
  DBSubnetGroupName?: string | undefined;
  DBSecurityGroups?: string[] | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  ApplyImmediately?: boolean | undefined;
  MasterUserPassword?: string | undefined;
  DBParameterGroupName?: string | undefined;
  BackupRetentionPeriod?: number | undefined;
  PreferredBackupWindow?: string | undefined;
  PreferredMaintenanceWindow?: string | undefined;
  MultiAZ?: boolean | undefined;
  EngineVersion?: string | undefined;
  AllowMajorVersionUpgrade?: boolean | undefined;
  AutoMinorVersionUpgrade?: boolean | undefined;
  LicenseModel?: string | undefined;
  Iops?: number | undefined;
  OptionGroupName?: string | undefined;
  NewDBInstanceIdentifier?: string | undefined;
  StorageType?: string | undefined;
  TdeCredentialArn?: string | undefined;
  TdeCredentialPassword?: string | undefined;
  CACertificateIdentifier?: string | undefined;
  Domain?: string | undefined;
  DomainFqdn?: string | undefined;
  DomainOu?: string | undefined;
  DomainAuthSecretArn?: string | undefined;
  DomainDnsIps?: string[] | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  MonitoringInterval?: number | undefined;
  DBPortNumber?: number | undefined;
  PubliclyAccessible?: boolean | undefined;
  MonitoringRoleArn?: string | undefined;
  DomainIAMRoleName?: string | undefined;
  DisableDomain?: boolean | undefined;
  PromotionTier?: number | undefined;
  EnableIAMDatabaseAuthentication?: boolean | undefined;
  DatabaseInsightsMode?: DatabaseInsightsMode | undefined;
  EnablePerformanceInsights?: boolean | undefined;
  PerformanceInsightsKMSKeyId?: string | undefined;
  PerformanceInsightsRetentionPeriod?: number | undefined;
  CloudwatchLogsExportConfiguration?:
    | CloudwatchLogsExportConfiguration
    | undefined;
  ProcessorFeatures?: ProcessorFeature[] | undefined;
  UseDefaultProcessorFeatures?: boolean | undefined;
  DeletionProtection?: boolean | undefined;
  MaxAllocatedStorage?: number | undefined;
  CertificateRotationRestart?: boolean | undefined;
  ReplicaMode?: ReplicaMode | undefined;
  EnableCustomerOwnedIp?: boolean | undefined;
  AwsBackupRecoveryPointArn?: string | undefined;
  AutomationMode?: AutomationMode | undefined;
  ResumeFullAutomationModeMinutes?: number | undefined;
  NetworkType?: string | undefined;
  StorageThroughput?: number | undefined;
  ManageMasterUserPassword?: boolean | undefined;
  RotateMasterUserPassword?: boolean | undefined;
  MasterUserSecretKmsKeyId?: string | undefined;
  Engine?: string | undefined;
  DedicatedLogVolume?: boolean | undefined;
  MultiTenant?: boolean | undefined;
}
export interface ModifyDBInstanceResult {
  DBInstance?: DBInstance | undefined;
}
export interface DBParameterGroupNameMessage {
  DBParameterGroupName?: string | undefined;
}
export interface ModifyDBParameterGroupMessage {
  DBParameterGroupName: string | undefined;
  Parameters: Parameter[] | undefined;
}
export interface ModifyDBProxyRequest {
  DBProxyName: string | undefined;
  NewDBProxyName?: string | undefined;
  Auth?: UserAuthConfig[] | undefined;
  RequireTLS?: boolean | undefined;
  IdleClientTimeout?: number | undefined;
  DebugLogging?: boolean | undefined;
  RoleArn?: string | undefined;
  SecurityGroups?: string[] | undefined;
}
export interface ModifyDBProxyResponse {
  DBProxy?: DBProxy | undefined;
}
export interface ModifyDBProxyEndpointRequest {
  DBProxyEndpointName: string | undefined;
  NewDBProxyEndpointName?: string | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
}
export interface ModifyDBProxyEndpointResponse {
  DBProxyEndpoint?: DBProxyEndpoint | undefined;
}
export interface ConnectionPoolConfiguration {
  MaxConnectionsPercent?: number | undefined;
  MaxIdleConnectionsPercent?: number | undefined;
  ConnectionBorrowTimeout?: number | undefined;
  SessionPinningFilters?: string[] | undefined;
  InitQuery?: string | undefined;
}
export interface ModifyDBProxyTargetGroupRequest {
  TargetGroupName: string | undefined;
  DBProxyName: string | undefined;
  ConnectionPoolConfig?: ConnectionPoolConfiguration | undefined;
  NewName?: string | undefined;
}
export interface ModifyDBProxyTargetGroupResponse {
  DBProxyTargetGroup?: DBProxyTargetGroup | undefined;
}
export interface DBRecommendationMessage {
  DBRecommendation?: DBRecommendation | undefined;
}
export interface RecommendedActionUpdate {
  ActionId: string | undefined;
  Status: string | undefined;
}
export interface ModifyDBRecommendationMessage {
  RecommendationId: string | undefined;
  Locale?: string | undefined;
  Status?: string | undefined;
  RecommendedActionUpdates?: RecommendedActionUpdate[] | undefined;
}
export interface ModifyDBShardGroupMessage {
  DBShardGroupIdentifier: string | undefined;
  MaxACU?: number | undefined;
  MinACU?: number | undefined;
  ComputeRedundancy?: number | undefined;
}
export interface ModifyDBSnapshotMessage {
  DBSnapshotIdentifier: string | undefined;
  EngineVersion?: string | undefined;
  OptionGroupName?: string | undefined;
}
export interface ModifyDBSnapshotResult {
  DBSnapshot?: DBSnapshot | undefined;
}
export interface ModifyDBSnapshotAttributeMessage {
  DBSnapshotIdentifier: string | undefined;
  AttributeName: string | undefined;
  ValuesToAdd?: string[] | undefined;
  ValuesToRemove?: string[] | undefined;
}
export interface ModifyDBSnapshotAttributeResult {
  DBSnapshotAttributesResult?: DBSnapshotAttributesResult | undefined;
}
export interface ModifyDBSubnetGroupMessage {
  DBSubnetGroupName: string | undefined;
  DBSubnetGroupDescription?: string | undefined;
  SubnetIds: string[] | undefined;
}
export interface ModifyDBSubnetGroupResult {
  DBSubnetGroup?: DBSubnetGroup | undefined;
}
export declare class SubnetAlreadyInUse extends __BaseException {
  readonly name: "SubnetAlreadyInUse";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<SubnetAlreadyInUse, __BaseException>);
}
export interface ModifyEventSubscriptionMessage {
  SubscriptionName: string | undefined;
  SnsTopicArn?: string | undefined;
  SourceType?: string | undefined;
  EventCategories?: string[] | undefined;
  Enabled?: boolean | undefined;
}
export interface ModifyEventSubscriptionResult {
  EventSubscription?: EventSubscription | undefined;
}
export interface ModifyGlobalClusterMessage {
  GlobalClusterIdentifier?: string | undefined;
  NewGlobalClusterIdentifier?: string | undefined;
  DeletionProtection?: boolean | undefined;
  EngineVersion?: string | undefined;
  AllowMajorVersionUpgrade?: boolean | undefined;
}
export interface ModifyGlobalClusterResult {
  GlobalCluster?: GlobalCluster | undefined;
}
export interface ModifyIntegrationMessage {
  IntegrationIdentifier: string | undefined;
  IntegrationName?: string | undefined;
  DataFilter?: string | undefined;
  Description?: string | undefined;
}
export interface OptionConfiguration {
  OptionName: string | undefined;
  Port?: number | undefined;
  OptionVersion?: string | undefined;
  DBSecurityGroupMemberships?: string[] | undefined;
  VpcSecurityGroupMemberships?: string[] | undefined;
  OptionSettings?: OptionSetting[] | undefined;
}
export interface ModifyOptionGroupMessage {
  OptionGroupName: string | undefined;
  OptionsToInclude?: OptionConfiguration[] | undefined;
  OptionsToRemove?: string[] | undefined;
  ApplyImmediately?: boolean | undefined;
}
export interface ModifyOptionGroupResult {
  OptionGroup?: OptionGroup | undefined;
}
export interface ModifyTenantDatabaseMessage {
  DBInstanceIdentifier: string | undefined;
  TenantDBName: string | undefined;
  MasterUserPassword?: string | undefined;
  NewTenantDBName?: string | undefined;
  ManageMasterUserPassword?: boolean | undefined;
  RotateMasterUserPassword?: boolean | undefined;
  MasterUserSecretKmsKeyId?: string | undefined;
}
export interface ModifyTenantDatabaseResult {
  TenantDatabase?: TenantDatabase | undefined;
}
export interface PromoteReadReplicaMessage {
  DBInstanceIdentifier: string | undefined;
  BackupRetentionPeriod?: number | undefined;
  PreferredBackupWindow?: string | undefined;
}
export interface PromoteReadReplicaResult {
  DBInstance?: DBInstance | undefined;
}
export interface PromoteReadReplicaDBClusterMessage {
  DBClusterIdentifier: string | undefined;
}
export interface PromoteReadReplicaDBClusterResult {
  DBCluster?: DBCluster | undefined;
}
export interface PurchaseReservedDBInstancesOfferingMessage {
  ReservedDBInstancesOfferingId: string | undefined;
  ReservedDBInstanceId?: string | undefined;
  DBInstanceCount?: number | undefined;
  Tags?: Tag[] | undefined;
}
export interface PurchaseReservedDBInstancesOfferingResult {
  ReservedDBInstance?: ReservedDBInstance | undefined;
}
export declare class ReservedDBInstanceAlreadyExistsFault extends __BaseException {
  readonly name: "ReservedDBInstanceAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ReservedDBInstanceAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class ReservedDBInstanceQuotaExceededFault extends __BaseException {
  readonly name: "ReservedDBInstanceQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ReservedDBInstanceQuotaExceededFault,
      __BaseException
    >
  );
}
export interface RebootDBClusterMessage {
  DBClusterIdentifier: string | undefined;
}
export interface RebootDBClusterResult {
  DBCluster?: DBCluster | undefined;
}
export interface RebootDBInstanceMessage {
  DBInstanceIdentifier: string | undefined;
  ForceFailover?: boolean | undefined;
}
export interface RebootDBInstanceResult {
  DBInstance?: DBInstance | undefined;
}
export interface RebootDBShardGroupMessage {
  DBShardGroupIdentifier: string | undefined;
}
export declare class DBProxyTargetAlreadyRegisteredFault extends __BaseException {
  readonly name: "DBProxyTargetAlreadyRegisteredFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBProxyTargetAlreadyRegisteredFault,
      __BaseException
    >
  );
}
export declare class InsufficientAvailableIPsInSubnetFault extends __BaseException {
  readonly name: "InsufficientAvailableIPsInSubnetFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InsufficientAvailableIPsInSubnetFault,
      __BaseException
    >
  );
}
export interface RegisterDBProxyTargetsRequest {
  DBProxyName: string | undefined;
  TargetGroupName?: string | undefined;
  DBInstanceIdentifiers?: string[] | undefined;
  DBClusterIdentifiers?: string[] | undefined;
}
export interface RegisterDBProxyTargetsResponse {
  DBProxyTargets?: DBProxyTarget[] | undefined;
}
export interface RemoveFromGlobalClusterMessage {
  GlobalClusterIdentifier?: string | undefined;
  DbClusterIdentifier?: string | undefined;
}
export interface RemoveFromGlobalClusterResult {
  GlobalCluster?: GlobalCluster | undefined;
}
export declare class DBClusterRoleNotFoundFault extends __BaseException {
  readonly name: "DBClusterRoleNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBClusterRoleNotFoundFault, __BaseException>
  );
}
export interface RemoveRoleFromDBClusterMessage {
  DBClusterIdentifier: string | undefined;
  RoleArn: string | undefined;
  FeatureName?: string | undefined;
}
export declare class DBInstanceRoleNotFoundFault extends __BaseException {
  readonly name: "DBInstanceRoleNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBInstanceRoleNotFoundFault, __BaseException>
  );
}
export interface RemoveRoleFromDBInstanceMessage {
  DBInstanceIdentifier: string | undefined;
  RoleArn: string | undefined;
  FeatureName: string | undefined;
}
export interface RemoveSourceIdentifierFromSubscriptionMessage {
  SubscriptionName: string | undefined;
  SourceIdentifier: string | undefined;
}
export interface RemoveSourceIdentifierFromSubscriptionResult {
  EventSubscription?: EventSubscription | undefined;
}
export interface RemoveTagsFromResourceMessage {
  ResourceName: string | undefined;
  TagKeys: string[] | undefined;
}
export interface ResetDBClusterParameterGroupMessage {
  DBClusterParameterGroupName: string | undefined;
  ResetAllParameters?: boolean | undefined;
  Parameters?: Parameter[] | undefined;
}
export interface ResetDBParameterGroupMessage {
  DBParameterGroupName: string | undefined;
  ResetAllParameters?: boolean | undefined;
  Parameters?: Parameter[] | undefined;
}
export declare class InvalidS3BucketFault extends __BaseException {
  readonly name: "InvalidS3BucketFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidS3BucketFault, __BaseException>
  );
}
export interface RestoreDBClusterFromS3Message {
  AvailabilityZones?: string[] | undefined;
  BackupRetentionPeriod?: number | undefined;
  CharacterSetName?: string | undefined;
  DatabaseName?: string | undefined;
  DBClusterIdentifier: string | undefined;
  DBClusterParameterGroupName?: string | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  DBSubnetGroupName?: string | undefined;
  Engine: string | undefined;
  EngineVersion?: string | undefined;
  Port?: number | undefined;
  MasterUsername: string | undefined;
  MasterUserPassword?: string | undefined;
  OptionGroupName?: string | undefined;
  PreferredBackupWindow?: string | undefined;
  PreferredMaintenanceWindow?: string | undefined;
  Tags?: Tag[] | undefined;
  StorageEncrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  EnableIAMDatabaseAuthentication?: boolean | undefined;
  SourceEngine: string | undefined;
  SourceEngineVersion: string | undefined;
  S3BucketName: string | undefined;
  S3Prefix?: string | undefined;
  S3IngestionRoleArn: string | undefined;
  BacktrackWindow?: number | undefined;
  EnableCloudwatchLogsExports?: string[] | undefined;
  DeletionProtection?: boolean | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  Domain?: string | undefined;
  DomainIAMRoleName?: string | undefined;
  ServerlessV2ScalingConfiguration?:
    | ServerlessV2ScalingConfiguration
    | undefined;
  NetworkType?: string | undefined;
  ManageMasterUserPassword?: boolean | undefined;
  MasterUserSecretKmsKeyId?: string | undefined;
  StorageType?: string | undefined;
  EngineLifecycleSupport?: string | undefined;
}
export interface RestoreDBClusterFromS3Result {
  DBCluster?: DBCluster | undefined;
}
export declare class InsufficientDBClusterCapacityFault extends __BaseException {
  readonly name: "InsufficientDBClusterCapacityFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InsufficientDBClusterCapacityFault,
      __BaseException
    >
  );
}
export declare class InvalidRestoreFault extends __BaseException {
  readonly name: "InvalidRestoreFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidRestoreFault, __BaseException>
  );
}
export interface RestoreDBClusterFromSnapshotMessage {
  AvailabilityZones?: string[] | undefined;
  DBClusterIdentifier: string | undefined;
  SnapshotIdentifier: string | undefined;
  Engine: string | undefined;
  EngineVersion?: string | undefined;
  Port?: number | undefined;
  DBSubnetGroupName?: string | undefined;
  DatabaseName?: string | undefined;
  OptionGroupName?: string | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  Tags?: Tag[] | undefined;
  KmsKeyId?: string | undefined;
  EnableIAMDatabaseAuthentication?: boolean | undefined;
  BacktrackWindow?: number | undefined;
  EnableCloudwatchLogsExports?: string[] | undefined;
  EngineMode?: string | undefined;
  ScalingConfiguration?: ScalingConfiguration | undefined;
  DBClusterParameterGroupName?: string | undefined;
  DeletionProtection?: boolean | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  Domain?: string | undefined;
  DomainIAMRoleName?: string | undefined;
  DBClusterInstanceClass?: string | undefined;
  StorageType?: string | undefined;
  Iops?: number | undefined;
  PubliclyAccessible?: boolean | undefined;
  ServerlessV2ScalingConfiguration?:
    | ServerlessV2ScalingConfiguration
    | undefined;
  NetworkType?: string | undefined;
  RdsCustomClusterConfiguration?: RdsCustomClusterConfiguration | undefined;
  MonitoringInterval?: number | undefined;
  MonitoringRoleArn?: string | undefined;
  EnablePerformanceInsights?: boolean | undefined;
  PerformanceInsightsKMSKeyId?: string | undefined;
  PerformanceInsightsRetentionPeriod?: number | undefined;
  EngineLifecycleSupport?: string | undefined;
}
export interface RestoreDBClusterFromSnapshotResult {
  DBCluster?: DBCluster | undefined;
}
export interface RestoreDBClusterToPointInTimeMessage {
  DBClusterIdentifier: string | undefined;
  RestoreType?: string | undefined;
  SourceDBClusterIdentifier?: string | undefined;
  RestoreToTime?: Date | undefined;
  UseLatestRestorableTime?: boolean | undefined;
  Port?: number | undefined;
  DBSubnetGroupName?: string | undefined;
  OptionGroupName?: string | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  Tags?: Tag[] | undefined;
  KmsKeyId?: string | undefined;
  EnableIAMDatabaseAuthentication?: boolean | undefined;
  BacktrackWindow?: number | undefined;
  EnableCloudwatchLogsExports?: string[] | undefined;
  DBClusterParameterGroupName?: string | undefined;
  DeletionProtection?: boolean | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  Domain?: string | undefined;
  DomainIAMRoleName?: string | undefined;
  ScalingConfiguration?: ScalingConfiguration | undefined;
  EngineMode?: string | undefined;
  DBClusterInstanceClass?: string | undefined;
  StorageType?: string | undefined;
  PubliclyAccessible?: boolean | undefined;
  Iops?: number | undefined;
  ServerlessV2ScalingConfiguration?:
    | ServerlessV2ScalingConfiguration
    | undefined;
  NetworkType?: string | undefined;
  SourceDbClusterResourceId?: string | undefined;
  RdsCustomClusterConfiguration?: RdsCustomClusterConfiguration | undefined;
  MonitoringInterval?: number | undefined;
  MonitoringRoleArn?: string | undefined;
  EnablePerformanceInsights?: boolean | undefined;
  PerformanceInsightsKMSKeyId?: string | undefined;
  PerformanceInsightsRetentionPeriod?: number | undefined;
  EngineLifecycleSupport?: string | undefined;
}
export interface RestoreDBClusterToPointInTimeResult {
  DBCluster?: DBCluster | undefined;
}
export interface RestoreDBInstanceFromDBSnapshotMessage {
  DBInstanceIdentifier: string | undefined;
  DBSnapshotIdentifier?: string | undefined;
  DBInstanceClass?: string | undefined;
  Port?: number | undefined;
  AvailabilityZone?: string | undefined;
  DBSubnetGroupName?: string | undefined;
  MultiAZ?: boolean | undefined;
  PubliclyAccessible?: boolean | undefined;
  AutoMinorVersionUpgrade?: boolean | undefined;
  LicenseModel?: string | undefined;
  DBName?: string | undefined;
  Engine?: string | undefined;
  Iops?: number | undefined;
  OptionGroupName?: string | undefined;
  Tags?: Tag[] | undefined;
  StorageType?: string | undefined;
  TdeCredentialArn?: string | undefined;
  TdeCredentialPassword?: string | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  Domain?: string | undefined;
  DomainFqdn?: string | undefined;
  DomainOu?: string | undefined;
  DomainAuthSecretArn?: string | undefined;
  DomainDnsIps?: string[] | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  DomainIAMRoleName?: string | undefined;
  EnableIAMDatabaseAuthentication?: boolean | undefined;
  EnableCloudwatchLogsExports?: string[] | undefined;
  ProcessorFeatures?: ProcessorFeature[] | undefined;
  UseDefaultProcessorFeatures?: boolean | undefined;
  DBParameterGroupName?: string | undefined;
  DeletionProtection?: boolean | undefined;
  EnableCustomerOwnedIp?: boolean | undefined;
  CustomIamInstanceProfile?: string | undefined;
  BackupTarget?: string | undefined;
  NetworkType?: string | undefined;
  StorageThroughput?: number | undefined;
  DBClusterSnapshotIdentifier?: string | undefined;
  AllocatedStorage?: number | undefined;
  DedicatedLogVolume?: boolean | undefined;
  CACertificateIdentifier?: string | undefined;
  EngineLifecycleSupport?: string | undefined;
  ManageMasterUserPassword?: boolean | undefined;
  MasterUserSecretKmsKeyId?: string | undefined;
}
export interface RestoreDBInstanceFromDBSnapshotResult {
  DBInstance?: DBInstance | undefined;
}
export interface RestoreDBInstanceFromS3Message {
  DBName?: string | undefined;
  DBInstanceIdentifier: string | undefined;
  AllocatedStorage?: number | undefined;
  DBInstanceClass: string | undefined;
  Engine: string | undefined;
  MasterUsername?: string | undefined;
  MasterUserPassword?: string | undefined;
  DBSecurityGroups?: string[] | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  AvailabilityZone?: string | undefined;
  DBSubnetGroupName?: string | undefined;
  PreferredMaintenanceWindow?: string | undefined;
  DBParameterGroupName?: string | undefined;
  BackupRetentionPeriod?: number | undefined;
  PreferredBackupWindow?: string | undefined;
  Port?: number | undefined;
  MultiAZ?: boolean | undefined;
  EngineVersion?: string | undefined;
  AutoMinorVersionUpgrade?: boolean | undefined;
  LicenseModel?: string | undefined;
  Iops?: number | undefined;
  OptionGroupName?: string | undefined;
  PubliclyAccessible?: boolean | undefined;
  Tags?: Tag[] | undefined;
  StorageType?: string | undefined;
  StorageEncrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  MonitoringInterval?: number | undefined;
  MonitoringRoleArn?: string | undefined;
  EnableIAMDatabaseAuthentication?: boolean | undefined;
  SourceEngine: string | undefined;
  SourceEngineVersion: string | undefined;
  S3BucketName: string | undefined;
  S3Prefix?: string | undefined;
  S3IngestionRoleArn: string | undefined;
  DatabaseInsightsMode?: DatabaseInsightsMode | undefined;
  EnablePerformanceInsights?: boolean | undefined;
  PerformanceInsightsKMSKeyId?: string | undefined;
  PerformanceInsightsRetentionPeriod?: number | undefined;
  EnableCloudwatchLogsExports?: string[] | undefined;
  ProcessorFeatures?: ProcessorFeature[] | undefined;
  UseDefaultProcessorFeatures?: boolean | undefined;
  DeletionProtection?: boolean | undefined;
  MaxAllocatedStorage?: number | undefined;
  NetworkType?: string | undefined;
  StorageThroughput?: number | undefined;
  ManageMasterUserPassword?: boolean | undefined;
  MasterUserSecretKmsKeyId?: string | undefined;
  DedicatedLogVolume?: boolean | undefined;
  CACertificateIdentifier?: string | undefined;
  EngineLifecycleSupport?: string | undefined;
}
export interface RestoreDBInstanceFromS3Result {
  DBInstance?: DBInstance | undefined;
}
export declare class PointInTimeRestoreNotEnabledFault extends __BaseException {
  readonly name: "PointInTimeRestoreNotEnabledFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PointInTimeRestoreNotEnabledFault,
      __BaseException
    >
  );
}
export interface RestoreDBInstanceToPointInTimeMessage {
  SourceDBInstanceIdentifier?: string | undefined;
  TargetDBInstanceIdentifier: string | undefined;
  RestoreTime?: Date | undefined;
  UseLatestRestorableTime?: boolean | undefined;
  DBInstanceClass?: string | undefined;
  Port?: number | undefined;
  AvailabilityZone?: string | undefined;
  DBSubnetGroupName?: string | undefined;
  MultiAZ?: boolean | undefined;
  PubliclyAccessible?: boolean | undefined;
  AutoMinorVersionUpgrade?: boolean | undefined;
  LicenseModel?: string | undefined;
  DBName?: string | undefined;
  Engine?: string | undefined;
  Iops?: number | undefined;
  OptionGroupName?: string | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  Tags?: Tag[] | undefined;
  StorageType?: string | undefined;
  TdeCredentialArn?: string | undefined;
  TdeCredentialPassword?: string | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  Domain?: string | undefined;
  DomainIAMRoleName?: string | undefined;
  DomainFqdn?: string | undefined;
  DomainOu?: string | undefined;
  DomainAuthSecretArn?: string | undefined;
  DomainDnsIps?: string[] | undefined;
  EnableIAMDatabaseAuthentication?: boolean | undefined;
  EnableCloudwatchLogsExports?: string[] | undefined;
  ProcessorFeatures?: ProcessorFeature[] | undefined;
  UseDefaultProcessorFeatures?: boolean | undefined;
  DBParameterGroupName?: string | undefined;
  DeletionProtection?: boolean | undefined;
  SourceDbiResourceId?: string | undefined;
  MaxAllocatedStorage?: number | undefined;
  SourceDBInstanceAutomatedBackupsArn?: string | undefined;
  EnableCustomerOwnedIp?: boolean | undefined;
  CustomIamInstanceProfile?: string | undefined;
  BackupTarget?: string | undefined;
  NetworkType?: string | undefined;
  StorageThroughput?: number | undefined;
  AllocatedStorage?: number | undefined;
  DedicatedLogVolume?: boolean | undefined;
  CACertificateIdentifier?: string | undefined;
  EngineLifecycleSupport?: string | undefined;
  ManageMasterUserPassword?: boolean | undefined;
  MasterUserSecretKmsKeyId?: string | undefined;
}
export interface RestoreDBInstanceToPointInTimeResult {
  DBInstance?: DBInstance | undefined;
}
export interface RevokeDBSecurityGroupIngressMessage {
  DBSecurityGroupName: string | undefined;
  CIDRIP?: string | undefined;
  EC2SecurityGroupName?: string | undefined;
  EC2SecurityGroupId?: string | undefined;
  EC2SecurityGroupOwnerId?: string | undefined;
}
export interface RevokeDBSecurityGroupIngressResult {
  DBSecurityGroup?: DBSecurityGroup | undefined;
}
export interface StartActivityStreamRequest {
  ResourceArn: string | undefined;
  Mode: ActivityStreamMode | undefined;
  KmsKeyId: string | undefined;
  ApplyImmediately?: boolean | undefined;
  EngineNativeAuditFieldsIncluded?: boolean | undefined;
}
export interface StartActivityStreamResponse {
  KmsKeyId?: string | undefined;
  KinesisStreamName?: string | undefined;
  Status?: ActivityStreamStatus | undefined;
  Mode?: ActivityStreamMode | undefined;
  ApplyImmediately?: boolean | undefined;
  EngineNativeAuditFieldsIncluded?: boolean | undefined;
}
export interface StartDBClusterMessage {
  DBClusterIdentifier: string | undefined;
}
export interface StartDBClusterResult {
  DBCluster?: DBCluster | undefined;
}
export interface StartDBInstanceMessage {
  DBInstanceIdentifier: string | undefined;
}
export interface StartDBInstanceResult {
  DBInstance?: DBInstance | undefined;
}
export interface StartDBInstanceAutomatedBackupsReplicationMessage {
  SourceDBInstanceArn: string | undefined;
  BackupRetentionPeriod?: number | undefined;
  KmsKeyId?: string | undefined;
  PreSignedUrl?: string | undefined;
}
export interface StartDBInstanceAutomatedBackupsReplicationResult {
  DBInstanceAutomatedBackup?: DBInstanceAutomatedBackup | undefined;
}
export declare class ExportTaskAlreadyExistsFault extends __BaseException {
  readonly name: "ExportTaskAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ExportTaskAlreadyExistsFault, __BaseException>
  );
}
export declare class IamRoleMissingPermissionsFault extends __BaseException {
  readonly name: "IamRoleMissingPermissionsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IamRoleMissingPermissionsFault, __BaseException>
  );
}
export declare class IamRoleNotFoundFault extends __BaseException {
  readonly name: "IamRoleNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IamRoleNotFoundFault, __BaseException>
  );
}
export declare class InvalidExportOnlyFault extends __BaseException {
  readonly name: "InvalidExportOnlyFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidExportOnlyFault, __BaseException>
  );
}
export declare class InvalidExportSourceStateFault extends __BaseException {
  readonly name: "InvalidExportSourceStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidExportSourceStateFault, __BaseException>
  );
}
export interface StartExportTaskMessage {
  ExportTaskIdentifier: string | undefined;
  SourceArn: string | undefined;
  S3BucketName: string | undefined;
  IamRoleArn: string | undefined;
  KmsKeyId: string | undefined;
  S3Prefix?: string | undefined;
  ExportOnly?: string[] | undefined;
}
export interface StopActivityStreamRequest {
  ResourceArn: string | undefined;
  ApplyImmediately?: boolean | undefined;
}
export interface StopActivityStreamResponse {
  KmsKeyId?: string | undefined;
  KinesisStreamName?: string | undefined;
  Status?: ActivityStreamStatus | undefined;
}
export interface StopDBClusterMessage {
  DBClusterIdentifier: string | undefined;
}
export interface StopDBClusterResult {
  DBCluster?: DBCluster | undefined;
}
export interface StopDBInstanceMessage {
  DBInstanceIdentifier: string | undefined;
  DBSnapshotIdentifier?: string | undefined;
}
export interface StopDBInstanceResult {
  DBInstance?: DBInstance | undefined;
}
export interface StopDBInstanceAutomatedBackupsReplicationMessage {
  SourceDBInstanceArn: string | undefined;
}
export interface StopDBInstanceAutomatedBackupsReplicationResult {
  DBInstanceAutomatedBackup?: DBInstanceAutomatedBackup | undefined;
}
export interface SwitchoverBlueGreenDeploymentRequest {
  BlueGreenDeploymentIdentifier: string | undefined;
  SwitchoverTimeout?: number | undefined;
}
export interface SwitchoverBlueGreenDeploymentResponse {
  BlueGreenDeployment?: BlueGreenDeployment | undefined;
}
export interface SwitchoverGlobalClusterMessage {
  GlobalClusterIdentifier: string | undefined;
  TargetDbClusterIdentifier: string | undefined;
}
export interface SwitchoverGlobalClusterResult {
  GlobalCluster?: GlobalCluster | undefined;
}
export interface SwitchoverReadReplicaMessage {
  DBInstanceIdentifier: string | undefined;
}
export interface SwitchoverReadReplicaResult {
  DBInstance?: DBInstance | undefined;
}
export declare const DeleteTenantDatabaseResultFilterSensitiveLog: (
  obj: DeleteTenantDatabaseResult
) => any;
export declare const TenantDatabasesMessageFilterSensitiveLog: (
  obj: TenantDatabasesMessage
) => any;
export declare const ModifyTenantDatabaseMessageFilterSensitiveLog: (
  obj: ModifyTenantDatabaseMessage
) => any;
export declare const ModifyTenantDatabaseResultFilterSensitiveLog: (
  obj: ModifyTenantDatabaseResult
) => any;
