import {
  HostHeaderInputConfig,
  HostHeaderResolvedConfig,
} from "@aws-sdk/middleware-host-header";
import {
  UserAgentInputConfig,
  UserAgentResolvedConfig,
} from "@aws-sdk/middleware-user-agent";
import {
  RegionInputConfig,
  RegionResolvedConfig,
} from "@smithy/config-resolver";
import {
  EndpointInputConfig,
  EndpointResolvedConfig,
} from "@smithy/middleware-endpoint";
import {
  RetryInputConfig,
  RetryResolvedConfig,
} from "@smithy/middleware-retry";
import { HttpHandlerUserInput as __HttpHandlerUserInput } from "@smithy/protocol-http";
import {
  Client as __Client,
  DefaultsMode as __DefaultsMode,
  SmithyConfiguration as __SmithyConfiguration,
  SmithyResolvedConfiguration as __SmithyResolvedConfiguration,
} from "@smithy/smithy-client";
import {
  AwsCredentialIdentityProvider,
  BodyLengthCalculator as __BodyLengthCalculator,
  CheckOptionalClientConfig as __CheckOptionalClientConfig,
  ChecksumConstructor as __ChecksumConstructor,
  Decoder as __Decoder,
  Encoder as __Encoder,
  HashConstructor as __HashConstructor,
  HttpHandlerOptions as __HttpHandlerOptions,
  Logger as __Logger,
  Provider as __Provider,
  Provider,
  StreamCollector as __StreamCollector,
  UrlParser as __UrlParser,
  UserAgent as __UserAgent,
} from "@smithy/types";
import {
  HttpAuthSchemeInputConfig,
  HttpAuthSchemeResolvedConfig,
} from "./auth/httpAuthSchemeProvider";
import {
  AddRoleToDBClusterCommandInput,
  AddRoleToDBClusterCommandOutput,
} from "./commands/AddRoleToDBClusterCommand";
import {
  AddRoleToDBInstanceCommandInput,
  AddRoleToDBInstanceCommandOutput,
} from "./commands/AddRoleToDBInstanceCommand";
import {
  AddSourceIdentifierToSubscriptionCommandInput,
  AddSourceIdentifierToSubscriptionCommandOutput,
} from "./commands/AddSourceIdentifierToSubscriptionCommand";
import {
  AddTagsToResourceCommandInput,
  AddTagsToResourceCommandOutput,
} from "./commands/AddTagsToResourceCommand";
import {
  ApplyPendingMaintenanceActionCommandInput,
  ApplyPendingMaintenanceActionCommandOutput,
} from "./commands/ApplyPendingMaintenanceActionCommand";
import {
  AuthorizeDBSecurityGroupIngressCommandInput,
  AuthorizeDBSecurityGroupIngressCommandOutput,
} from "./commands/AuthorizeDBSecurityGroupIngressCommand";
import {
  BacktrackDBClusterCommandInput,
  BacktrackDBClusterCommandOutput,
} from "./commands/BacktrackDBClusterCommand";
import {
  CancelExportTaskCommandInput,
  CancelExportTaskCommandOutput,
} from "./commands/CancelExportTaskCommand";
import {
  CopyDBClusterParameterGroupCommandInput,
  CopyDBClusterParameterGroupCommandOutput,
} from "./commands/CopyDBClusterParameterGroupCommand";
import {
  CopyDBClusterSnapshotCommandInput,
  CopyDBClusterSnapshotCommandOutput,
} from "./commands/CopyDBClusterSnapshotCommand";
import {
  CopyDBParameterGroupCommandInput,
  CopyDBParameterGroupCommandOutput,
} from "./commands/CopyDBParameterGroupCommand";
import {
  CopyDBSnapshotCommandInput,
  CopyDBSnapshotCommandOutput,
} from "./commands/CopyDBSnapshotCommand";
import {
  CopyOptionGroupCommandInput,
  CopyOptionGroupCommandOutput,
} from "./commands/CopyOptionGroupCommand";
import {
  CreateBlueGreenDeploymentCommandInput,
  CreateBlueGreenDeploymentCommandOutput,
} from "./commands/CreateBlueGreenDeploymentCommand";
import {
  CreateCustomDBEngineVersionCommandInput,
  CreateCustomDBEngineVersionCommandOutput,
} from "./commands/CreateCustomDBEngineVersionCommand";
import {
  CreateDBClusterCommandInput,
  CreateDBClusterCommandOutput,
} from "./commands/CreateDBClusterCommand";
import {
  CreateDBClusterEndpointCommandInput,
  CreateDBClusterEndpointCommandOutput,
} from "./commands/CreateDBClusterEndpointCommand";
import {
  CreateDBClusterParameterGroupCommandInput,
  CreateDBClusterParameterGroupCommandOutput,
} from "./commands/CreateDBClusterParameterGroupCommand";
import {
  CreateDBClusterSnapshotCommandInput,
  CreateDBClusterSnapshotCommandOutput,
} from "./commands/CreateDBClusterSnapshotCommand";
import {
  CreateDBInstanceCommandInput,
  CreateDBInstanceCommandOutput,
} from "./commands/CreateDBInstanceCommand";
import {
  CreateDBInstanceReadReplicaCommandInput,
  CreateDBInstanceReadReplicaCommandOutput,
} from "./commands/CreateDBInstanceReadReplicaCommand";
import {
  CreateDBParameterGroupCommandInput,
  CreateDBParameterGroupCommandOutput,
} from "./commands/CreateDBParameterGroupCommand";
import {
  CreateDBProxyCommandInput,
  CreateDBProxyCommandOutput,
} from "./commands/CreateDBProxyCommand";
import {
  CreateDBProxyEndpointCommandInput,
  CreateDBProxyEndpointCommandOutput,
} from "./commands/CreateDBProxyEndpointCommand";
import {
  CreateDBSecurityGroupCommandInput,
  CreateDBSecurityGroupCommandOutput,
} from "./commands/CreateDBSecurityGroupCommand";
import {
  CreateDBShardGroupCommandInput,
  CreateDBShardGroupCommandOutput,
} from "./commands/CreateDBShardGroupCommand";
import {
  CreateDBSnapshotCommandInput,
  CreateDBSnapshotCommandOutput,
} from "./commands/CreateDBSnapshotCommand";
import {
  CreateDBSubnetGroupCommandInput,
  CreateDBSubnetGroupCommandOutput,
} from "./commands/CreateDBSubnetGroupCommand";
import {
  CreateEventSubscriptionCommandInput,
  CreateEventSubscriptionCommandOutput,
} from "./commands/CreateEventSubscriptionCommand";
import {
  CreateGlobalClusterCommandInput,
  CreateGlobalClusterCommandOutput,
} from "./commands/CreateGlobalClusterCommand";
import {
  CreateIntegrationCommandInput,
  CreateIntegrationCommandOutput,
} from "./commands/CreateIntegrationCommand";
import {
  CreateOptionGroupCommandInput,
  CreateOptionGroupCommandOutput,
} from "./commands/CreateOptionGroupCommand";
import {
  CreateTenantDatabaseCommandInput,
  CreateTenantDatabaseCommandOutput,
} from "./commands/CreateTenantDatabaseCommand";
import {
  DeleteBlueGreenDeploymentCommandInput,
  DeleteBlueGreenDeploymentCommandOutput,
} from "./commands/DeleteBlueGreenDeploymentCommand";
import {
  DeleteCustomDBEngineVersionCommandInput,
  DeleteCustomDBEngineVersionCommandOutput,
} from "./commands/DeleteCustomDBEngineVersionCommand";
import {
  DeleteDBClusterAutomatedBackupCommandInput,
  DeleteDBClusterAutomatedBackupCommandOutput,
} from "./commands/DeleteDBClusterAutomatedBackupCommand";
import {
  DeleteDBClusterCommandInput,
  DeleteDBClusterCommandOutput,
} from "./commands/DeleteDBClusterCommand";
import {
  DeleteDBClusterEndpointCommandInput,
  DeleteDBClusterEndpointCommandOutput,
} from "./commands/DeleteDBClusterEndpointCommand";
import {
  DeleteDBClusterParameterGroupCommandInput,
  DeleteDBClusterParameterGroupCommandOutput,
} from "./commands/DeleteDBClusterParameterGroupCommand";
import {
  DeleteDBClusterSnapshotCommandInput,
  DeleteDBClusterSnapshotCommandOutput,
} from "./commands/DeleteDBClusterSnapshotCommand";
import {
  DeleteDBInstanceAutomatedBackupCommandInput,
  DeleteDBInstanceAutomatedBackupCommandOutput,
} from "./commands/DeleteDBInstanceAutomatedBackupCommand";
import {
  DeleteDBInstanceCommandInput,
  DeleteDBInstanceCommandOutput,
} from "./commands/DeleteDBInstanceCommand";
import {
  DeleteDBParameterGroupCommandInput,
  DeleteDBParameterGroupCommandOutput,
} from "./commands/DeleteDBParameterGroupCommand";
import {
  DeleteDBProxyCommandInput,
  DeleteDBProxyCommandOutput,
} from "./commands/DeleteDBProxyCommand";
import {
  DeleteDBProxyEndpointCommandInput,
  DeleteDBProxyEndpointCommandOutput,
} from "./commands/DeleteDBProxyEndpointCommand";
import {
  DeleteDBSecurityGroupCommandInput,
  DeleteDBSecurityGroupCommandOutput,
} from "./commands/DeleteDBSecurityGroupCommand";
import {
  DeleteDBShardGroupCommandInput,
  DeleteDBShardGroupCommandOutput,
} from "./commands/DeleteDBShardGroupCommand";
import {
  DeleteDBSnapshotCommandInput,
  DeleteDBSnapshotCommandOutput,
} from "./commands/DeleteDBSnapshotCommand";
import {
  DeleteDBSubnetGroupCommandInput,
  DeleteDBSubnetGroupCommandOutput,
} from "./commands/DeleteDBSubnetGroupCommand";
import {
  DeleteEventSubscriptionCommandInput,
  DeleteEventSubscriptionCommandOutput,
} from "./commands/DeleteEventSubscriptionCommand";
import {
  DeleteGlobalClusterCommandInput,
  DeleteGlobalClusterCommandOutput,
} from "./commands/DeleteGlobalClusterCommand";
import {
  DeleteIntegrationCommandInput,
  DeleteIntegrationCommandOutput,
} from "./commands/DeleteIntegrationCommand";
import {
  DeleteOptionGroupCommandInput,
  DeleteOptionGroupCommandOutput,
} from "./commands/DeleteOptionGroupCommand";
import {
  DeleteTenantDatabaseCommandInput,
  DeleteTenantDatabaseCommandOutput,
} from "./commands/DeleteTenantDatabaseCommand";
import {
  DeregisterDBProxyTargetsCommandInput,
  DeregisterDBProxyTargetsCommandOutput,
} from "./commands/DeregisterDBProxyTargetsCommand";
import {
  DescribeAccountAttributesCommandInput,
  DescribeAccountAttributesCommandOutput,
} from "./commands/DescribeAccountAttributesCommand";
import {
  DescribeBlueGreenDeploymentsCommandInput,
  DescribeBlueGreenDeploymentsCommandOutput,
} from "./commands/DescribeBlueGreenDeploymentsCommand";
import {
  DescribeCertificatesCommandInput,
  DescribeCertificatesCommandOutput,
} from "./commands/DescribeCertificatesCommand";
import {
  DescribeDBClusterAutomatedBackupsCommandInput,
  DescribeDBClusterAutomatedBackupsCommandOutput,
} from "./commands/DescribeDBClusterAutomatedBackupsCommand";
import {
  DescribeDBClusterBacktracksCommandInput,
  DescribeDBClusterBacktracksCommandOutput,
} from "./commands/DescribeDBClusterBacktracksCommand";
import {
  DescribeDBClusterEndpointsCommandInput,
  DescribeDBClusterEndpointsCommandOutput,
} from "./commands/DescribeDBClusterEndpointsCommand";
import {
  DescribeDBClusterParameterGroupsCommandInput,
  DescribeDBClusterParameterGroupsCommandOutput,
} from "./commands/DescribeDBClusterParameterGroupsCommand";
import {
  DescribeDBClusterParametersCommandInput,
  DescribeDBClusterParametersCommandOutput,
} from "./commands/DescribeDBClusterParametersCommand";
import {
  DescribeDBClustersCommandInput,
  DescribeDBClustersCommandOutput,
} from "./commands/DescribeDBClustersCommand";
import {
  DescribeDBClusterSnapshotAttributesCommandInput,
  DescribeDBClusterSnapshotAttributesCommandOutput,
} from "./commands/DescribeDBClusterSnapshotAttributesCommand";
import {
  DescribeDBClusterSnapshotsCommandInput,
  DescribeDBClusterSnapshotsCommandOutput,
} from "./commands/DescribeDBClusterSnapshotsCommand";
import {
  DescribeDBEngineVersionsCommandInput,
  DescribeDBEngineVersionsCommandOutput,
} from "./commands/DescribeDBEngineVersionsCommand";
import {
  DescribeDBInstanceAutomatedBackupsCommandInput,
  DescribeDBInstanceAutomatedBackupsCommandOutput,
} from "./commands/DescribeDBInstanceAutomatedBackupsCommand";
import {
  DescribeDBInstancesCommandInput,
  DescribeDBInstancesCommandOutput,
} from "./commands/DescribeDBInstancesCommand";
import {
  DescribeDBLogFilesCommandInput,
  DescribeDBLogFilesCommandOutput,
} from "./commands/DescribeDBLogFilesCommand";
import {
  DescribeDBMajorEngineVersionsCommandInput,
  DescribeDBMajorEngineVersionsCommandOutput,
} from "./commands/DescribeDBMajorEngineVersionsCommand";
import {
  DescribeDBParameterGroupsCommandInput,
  DescribeDBParameterGroupsCommandOutput,
} from "./commands/DescribeDBParameterGroupsCommand";
import {
  DescribeDBParametersCommandInput,
  DescribeDBParametersCommandOutput,
} from "./commands/DescribeDBParametersCommand";
import {
  DescribeDBProxiesCommandInput,
  DescribeDBProxiesCommandOutput,
} from "./commands/DescribeDBProxiesCommand";
import {
  DescribeDBProxyEndpointsCommandInput,
  DescribeDBProxyEndpointsCommandOutput,
} from "./commands/DescribeDBProxyEndpointsCommand";
import {
  DescribeDBProxyTargetGroupsCommandInput,
  DescribeDBProxyTargetGroupsCommandOutput,
} from "./commands/DescribeDBProxyTargetGroupsCommand";
import {
  DescribeDBProxyTargetsCommandInput,
  DescribeDBProxyTargetsCommandOutput,
} from "./commands/DescribeDBProxyTargetsCommand";
import {
  DescribeDBRecommendationsCommandInput,
  DescribeDBRecommendationsCommandOutput,
} from "./commands/DescribeDBRecommendationsCommand";
import {
  DescribeDBSecurityGroupsCommandInput,
  DescribeDBSecurityGroupsCommandOutput,
} from "./commands/DescribeDBSecurityGroupsCommand";
import {
  DescribeDBShardGroupsCommandInput,
  DescribeDBShardGroupsCommandOutput,
} from "./commands/DescribeDBShardGroupsCommand";
import {
  DescribeDBSnapshotAttributesCommandInput,
  DescribeDBSnapshotAttributesCommandOutput,
} from "./commands/DescribeDBSnapshotAttributesCommand";
import {
  DescribeDBSnapshotsCommandInput,
  DescribeDBSnapshotsCommandOutput,
} from "./commands/DescribeDBSnapshotsCommand";
import {
  DescribeDBSnapshotTenantDatabasesCommandInput,
  DescribeDBSnapshotTenantDatabasesCommandOutput,
} from "./commands/DescribeDBSnapshotTenantDatabasesCommand";
import {
  DescribeDBSubnetGroupsCommandInput,
  DescribeDBSubnetGroupsCommandOutput,
} from "./commands/DescribeDBSubnetGroupsCommand";
import {
  DescribeEngineDefaultClusterParametersCommandInput,
  DescribeEngineDefaultClusterParametersCommandOutput,
} from "./commands/DescribeEngineDefaultClusterParametersCommand";
import {
  DescribeEngineDefaultParametersCommandInput,
  DescribeEngineDefaultParametersCommandOutput,
} from "./commands/DescribeEngineDefaultParametersCommand";
import {
  DescribeEventCategoriesCommandInput,
  DescribeEventCategoriesCommandOutput,
} from "./commands/DescribeEventCategoriesCommand";
import {
  DescribeEventsCommandInput,
  DescribeEventsCommandOutput,
} from "./commands/DescribeEventsCommand";
import {
  DescribeEventSubscriptionsCommandInput,
  DescribeEventSubscriptionsCommandOutput,
} from "./commands/DescribeEventSubscriptionsCommand";
import {
  DescribeExportTasksCommandInput,
  DescribeExportTasksCommandOutput,
} from "./commands/DescribeExportTasksCommand";
import {
  DescribeGlobalClustersCommandInput,
  DescribeGlobalClustersCommandOutput,
} from "./commands/DescribeGlobalClustersCommand";
import {
  DescribeIntegrationsCommandInput,
  DescribeIntegrationsCommandOutput,
} from "./commands/DescribeIntegrationsCommand";
import {
  DescribeOptionGroupOptionsCommandInput,
  DescribeOptionGroupOptionsCommandOutput,
} from "./commands/DescribeOptionGroupOptionsCommand";
import {
  DescribeOptionGroupsCommandInput,
  DescribeOptionGroupsCommandOutput,
} from "./commands/DescribeOptionGroupsCommand";
import {
  DescribeOrderableDBInstanceOptionsCommandInput,
  DescribeOrderableDBInstanceOptionsCommandOutput,
} from "./commands/DescribeOrderableDBInstanceOptionsCommand";
import {
  DescribePendingMaintenanceActionsCommandInput,
  DescribePendingMaintenanceActionsCommandOutput,
} from "./commands/DescribePendingMaintenanceActionsCommand";
import {
  DescribeReservedDBInstancesCommandInput,
  DescribeReservedDBInstancesCommandOutput,
} from "./commands/DescribeReservedDBInstancesCommand";
import {
  DescribeReservedDBInstancesOfferingsCommandInput,
  DescribeReservedDBInstancesOfferingsCommandOutput,
} from "./commands/DescribeReservedDBInstancesOfferingsCommand";
import {
  DescribeSourceRegionsCommandInput,
  DescribeSourceRegionsCommandOutput,
} from "./commands/DescribeSourceRegionsCommand";
import {
  DescribeTenantDatabasesCommandInput,
  DescribeTenantDatabasesCommandOutput,
} from "./commands/DescribeTenantDatabasesCommand";
import {
  DescribeValidDBInstanceModificationsCommandInput,
  DescribeValidDBInstanceModificationsCommandOutput,
} from "./commands/DescribeValidDBInstanceModificationsCommand";
import {
  DisableHttpEndpointCommandInput,
  DisableHttpEndpointCommandOutput,
} from "./commands/DisableHttpEndpointCommand";
import {
  DownloadDBLogFilePortionCommandInput,
  DownloadDBLogFilePortionCommandOutput,
} from "./commands/DownloadDBLogFilePortionCommand";
import {
  EnableHttpEndpointCommandInput,
  EnableHttpEndpointCommandOutput,
} from "./commands/EnableHttpEndpointCommand";
import {
  FailoverDBClusterCommandInput,
  FailoverDBClusterCommandOutput,
} from "./commands/FailoverDBClusterCommand";
import {
  FailoverGlobalClusterCommandInput,
  FailoverGlobalClusterCommandOutput,
} from "./commands/FailoverGlobalClusterCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  ModifyActivityStreamCommandInput,
  ModifyActivityStreamCommandOutput,
} from "./commands/ModifyActivityStreamCommand";
import {
  ModifyCertificatesCommandInput,
  ModifyCertificatesCommandOutput,
} from "./commands/ModifyCertificatesCommand";
import {
  ModifyCurrentDBClusterCapacityCommandInput,
  ModifyCurrentDBClusterCapacityCommandOutput,
} from "./commands/ModifyCurrentDBClusterCapacityCommand";
import {
  ModifyCustomDBEngineVersionCommandInput,
  ModifyCustomDBEngineVersionCommandOutput,
} from "./commands/ModifyCustomDBEngineVersionCommand";
import {
  ModifyDBClusterCommandInput,
  ModifyDBClusterCommandOutput,
} from "./commands/ModifyDBClusterCommand";
import {
  ModifyDBClusterEndpointCommandInput,
  ModifyDBClusterEndpointCommandOutput,
} from "./commands/ModifyDBClusterEndpointCommand";
import {
  ModifyDBClusterParameterGroupCommandInput,
  ModifyDBClusterParameterGroupCommandOutput,
} from "./commands/ModifyDBClusterParameterGroupCommand";
import {
  ModifyDBClusterSnapshotAttributeCommandInput,
  ModifyDBClusterSnapshotAttributeCommandOutput,
} from "./commands/ModifyDBClusterSnapshotAttributeCommand";
import {
  ModifyDBInstanceCommandInput,
  ModifyDBInstanceCommandOutput,
} from "./commands/ModifyDBInstanceCommand";
import {
  ModifyDBParameterGroupCommandInput,
  ModifyDBParameterGroupCommandOutput,
} from "./commands/ModifyDBParameterGroupCommand";
import {
  ModifyDBProxyCommandInput,
  ModifyDBProxyCommandOutput,
} from "./commands/ModifyDBProxyCommand";
import {
  ModifyDBProxyEndpointCommandInput,
  ModifyDBProxyEndpointCommandOutput,
} from "./commands/ModifyDBProxyEndpointCommand";
import {
  ModifyDBProxyTargetGroupCommandInput,
  ModifyDBProxyTargetGroupCommandOutput,
} from "./commands/ModifyDBProxyTargetGroupCommand";
import {
  ModifyDBRecommendationCommandInput,
  ModifyDBRecommendationCommandOutput,
} from "./commands/ModifyDBRecommendationCommand";
import {
  ModifyDBShardGroupCommandInput,
  ModifyDBShardGroupCommandOutput,
} from "./commands/ModifyDBShardGroupCommand";
import {
  ModifyDBSnapshotAttributeCommandInput,
  ModifyDBSnapshotAttributeCommandOutput,
} from "./commands/ModifyDBSnapshotAttributeCommand";
import {
  ModifyDBSnapshotCommandInput,
  ModifyDBSnapshotCommandOutput,
} from "./commands/ModifyDBSnapshotCommand";
import {
  ModifyDBSubnetGroupCommandInput,
  ModifyDBSubnetGroupCommandOutput,
} from "./commands/ModifyDBSubnetGroupCommand";
import {
  ModifyEventSubscriptionCommandInput,
  ModifyEventSubscriptionCommandOutput,
} from "./commands/ModifyEventSubscriptionCommand";
import {
  ModifyGlobalClusterCommandInput,
  ModifyGlobalClusterCommandOutput,
} from "./commands/ModifyGlobalClusterCommand";
import {
  ModifyIntegrationCommandInput,
  ModifyIntegrationCommandOutput,
} from "./commands/ModifyIntegrationCommand";
import {
  ModifyOptionGroupCommandInput,
  ModifyOptionGroupCommandOutput,
} from "./commands/ModifyOptionGroupCommand";
import {
  ModifyTenantDatabaseCommandInput,
  ModifyTenantDatabaseCommandOutput,
} from "./commands/ModifyTenantDatabaseCommand";
import {
  PromoteReadReplicaCommandInput,
  PromoteReadReplicaCommandOutput,
} from "./commands/PromoteReadReplicaCommand";
import {
  PromoteReadReplicaDBClusterCommandInput,
  PromoteReadReplicaDBClusterCommandOutput,
} from "./commands/PromoteReadReplicaDBClusterCommand";
import {
  PurchaseReservedDBInstancesOfferingCommandInput,
  PurchaseReservedDBInstancesOfferingCommandOutput,
} from "./commands/PurchaseReservedDBInstancesOfferingCommand";
import {
  RebootDBClusterCommandInput,
  RebootDBClusterCommandOutput,
} from "./commands/RebootDBClusterCommand";
import {
  RebootDBInstanceCommandInput,
  RebootDBInstanceCommandOutput,
} from "./commands/RebootDBInstanceCommand";
import {
  RebootDBShardGroupCommandInput,
  RebootDBShardGroupCommandOutput,
} from "./commands/RebootDBShardGroupCommand";
import {
  RegisterDBProxyTargetsCommandInput,
  RegisterDBProxyTargetsCommandOutput,
} from "./commands/RegisterDBProxyTargetsCommand";
import {
  RemoveFromGlobalClusterCommandInput,
  RemoveFromGlobalClusterCommandOutput,
} from "./commands/RemoveFromGlobalClusterCommand";
import {
  RemoveRoleFromDBClusterCommandInput,
  RemoveRoleFromDBClusterCommandOutput,
} from "./commands/RemoveRoleFromDBClusterCommand";
import {
  RemoveRoleFromDBInstanceCommandInput,
  RemoveRoleFromDBInstanceCommandOutput,
} from "./commands/RemoveRoleFromDBInstanceCommand";
import {
  RemoveSourceIdentifierFromSubscriptionCommandInput,
  RemoveSourceIdentifierFromSubscriptionCommandOutput,
} from "./commands/RemoveSourceIdentifierFromSubscriptionCommand";
import {
  RemoveTagsFromResourceCommandInput,
  RemoveTagsFromResourceCommandOutput,
} from "./commands/RemoveTagsFromResourceCommand";
import {
  ResetDBClusterParameterGroupCommandInput,
  ResetDBClusterParameterGroupCommandOutput,
} from "./commands/ResetDBClusterParameterGroupCommand";
import {
  ResetDBParameterGroupCommandInput,
  ResetDBParameterGroupCommandOutput,
} from "./commands/ResetDBParameterGroupCommand";
import {
  RestoreDBClusterFromS3CommandInput,
  RestoreDBClusterFromS3CommandOutput,
} from "./commands/RestoreDBClusterFromS3Command";
import {
  RestoreDBClusterFromSnapshotCommandInput,
  RestoreDBClusterFromSnapshotCommandOutput,
} from "./commands/RestoreDBClusterFromSnapshotCommand";
import {
  RestoreDBClusterToPointInTimeCommandInput,
  RestoreDBClusterToPointInTimeCommandOutput,
} from "./commands/RestoreDBClusterToPointInTimeCommand";
import {
  RestoreDBInstanceFromDBSnapshotCommandInput,
  RestoreDBInstanceFromDBSnapshotCommandOutput,
} from "./commands/RestoreDBInstanceFromDBSnapshotCommand";
import {
  RestoreDBInstanceFromS3CommandInput,
  RestoreDBInstanceFromS3CommandOutput,
} from "./commands/RestoreDBInstanceFromS3Command";
import {
  RestoreDBInstanceToPointInTimeCommandInput,
  RestoreDBInstanceToPointInTimeCommandOutput,
} from "./commands/RestoreDBInstanceToPointInTimeCommand";
import {
  RevokeDBSecurityGroupIngressCommandInput,
  RevokeDBSecurityGroupIngressCommandOutput,
} from "./commands/RevokeDBSecurityGroupIngressCommand";
import {
  StartActivityStreamCommandInput,
  StartActivityStreamCommandOutput,
} from "./commands/StartActivityStreamCommand";
import {
  StartDBClusterCommandInput,
  StartDBClusterCommandOutput,
} from "./commands/StartDBClusterCommand";
import {
  StartDBInstanceAutomatedBackupsReplicationCommandInput,
  StartDBInstanceAutomatedBackupsReplicationCommandOutput,
} from "./commands/StartDBInstanceAutomatedBackupsReplicationCommand";
import {
  StartDBInstanceCommandInput,
  StartDBInstanceCommandOutput,
} from "./commands/StartDBInstanceCommand";
import {
  StartExportTaskCommandInput,
  StartExportTaskCommandOutput,
} from "./commands/StartExportTaskCommand";
import {
  StopActivityStreamCommandInput,
  StopActivityStreamCommandOutput,
} from "./commands/StopActivityStreamCommand";
import {
  StopDBClusterCommandInput,
  StopDBClusterCommandOutput,
} from "./commands/StopDBClusterCommand";
import {
  StopDBInstanceAutomatedBackupsReplicationCommandInput,
  StopDBInstanceAutomatedBackupsReplicationCommandOutput,
} from "./commands/StopDBInstanceAutomatedBackupsReplicationCommand";
import {
  StopDBInstanceCommandInput,
  StopDBInstanceCommandOutput,
} from "./commands/StopDBInstanceCommand";
import {
  SwitchoverBlueGreenDeploymentCommandInput,
  SwitchoverBlueGreenDeploymentCommandOutput,
} from "./commands/SwitchoverBlueGreenDeploymentCommand";
import {
  SwitchoverGlobalClusterCommandInput,
  SwitchoverGlobalClusterCommandOutput,
} from "./commands/SwitchoverGlobalClusterCommand";
import {
  SwitchoverReadReplicaCommandInput,
  SwitchoverReadReplicaCommandOutput,
} from "./commands/SwitchoverReadReplicaCommand";
import {
  ClientInputEndpointParameters,
  ClientResolvedEndpointParameters,
  EndpointParameters,
} from "./endpoint/EndpointParameters";
import { RuntimeExtension, RuntimeExtensionsConfig } from "./runtimeExtensions";
export { __Client };
export type ServiceInputTypes =
  | AddRoleToDBClusterCommandInput
  | AddRoleToDBInstanceCommandInput
  | AddSourceIdentifierToSubscriptionCommandInput
  | AddTagsToResourceCommandInput
  | ApplyPendingMaintenanceActionCommandInput
  | AuthorizeDBSecurityGroupIngressCommandInput
  | BacktrackDBClusterCommandInput
  | CancelExportTaskCommandInput
  | CopyDBClusterParameterGroupCommandInput
  | CopyDBClusterSnapshotCommandInput
  | CopyDBParameterGroupCommandInput
  | CopyDBSnapshotCommandInput
  | CopyOptionGroupCommandInput
  | CreateBlueGreenDeploymentCommandInput
  | CreateCustomDBEngineVersionCommandInput
  | CreateDBClusterCommandInput
  | CreateDBClusterEndpointCommandInput
  | CreateDBClusterParameterGroupCommandInput
  | CreateDBClusterSnapshotCommandInput
  | CreateDBInstanceCommandInput
  | CreateDBInstanceReadReplicaCommandInput
  | CreateDBParameterGroupCommandInput
  | CreateDBProxyCommandInput
  | CreateDBProxyEndpointCommandInput
  | CreateDBSecurityGroupCommandInput
  | CreateDBShardGroupCommandInput
  | CreateDBSnapshotCommandInput
  | CreateDBSubnetGroupCommandInput
  | CreateEventSubscriptionCommandInput
  | CreateGlobalClusterCommandInput
  | CreateIntegrationCommandInput
  | CreateOptionGroupCommandInput
  | CreateTenantDatabaseCommandInput
  | DeleteBlueGreenDeploymentCommandInput
  | DeleteCustomDBEngineVersionCommandInput
  | DeleteDBClusterAutomatedBackupCommandInput
  | DeleteDBClusterCommandInput
  | DeleteDBClusterEndpointCommandInput
  | DeleteDBClusterParameterGroupCommandInput
  | DeleteDBClusterSnapshotCommandInput
  | DeleteDBInstanceAutomatedBackupCommandInput
  | DeleteDBInstanceCommandInput
  | DeleteDBParameterGroupCommandInput
  | DeleteDBProxyCommandInput
  | DeleteDBProxyEndpointCommandInput
  | DeleteDBSecurityGroupCommandInput
  | DeleteDBShardGroupCommandInput
  | DeleteDBSnapshotCommandInput
  | DeleteDBSubnetGroupCommandInput
  | DeleteEventSubscriptionCommandInput
  | DeleteGlobalClusterCommandInput
  | DeleteIntegrationCommandInput
  | DeleteOptionGroupCommandInput
  | DeleteTenantDatabaseCommandInput
  | DeregisterDBProxyTargetsCommandInput
  | DescribeAccountAttributesCommandInput
  | DescribeBlueGreenDeploymentsCommandInput
  | DescribeCertificatesCommandInput
  | DescribeDBClusterAutomatedBackupsCommandInput
  | DescribeDBClusterBacktracksCommandInput
  | DescribeDBClusterEndpointsCommandInput
  | DescribeDBClusterParameterGroupsCommandInput
  | DescribeDBClusterParametersCommandInput
  | DescribeDBClusterSnapshotAttributesCommandInput
  | DescribeDBClusterSnapshotsCommandInput
  | DescribeDBClustersCommandInput
  | DescribeDBEngineVersionsCommandInput
  | DescribeDBInstanceAutomatedBackupsCommandInput
  | DescribeDBInstancesCommandInput
  | DescribeDBLogFilesCommandInput
  | DescribeDBMajorEngineVersionsCommandInput
  | DescribeDBParameterGroupsCommandInput
  | DescribeDBParametersCommandInput
  | DescribeDBProxiesCommandInput
  | DescribeDBProxyEndpointsCommandInput
  | DescribeDBProxyTargetGroupsCommandInput
  | DescribeDBProxyTargetsCommandInput
  | DescribeDBRecommendationsCommandInput
  | DescribeDBSecurityGroupsCommandInput
  | DescribeDBShardGroupsCommandInput
  | DescribeDBSnapshotAttributesCommandInput
  | DescribeDBSnapshotTenantDatabasesCommandInput
  | DescribeDBSnapshotsCommandInput
  | DescribeDBSubnetGroupsCommandInput
  | DescribeEngineDefaultClusterParametersCommandInput
  | DescribeEngineDefaultParametersCommandInput
  | DescribeEventCategoriesCommandInput
  | DescribeEventSubscriptionsCommandInput
  | DescribeEventsCommandInput
  | DescribeExportTasksCommandInput
  | DescribeGlobalClustersCommandInput
  | DescribeIntegrationsCommandInput
  | DescribeOptionGroupOptionsCommandInput
  | DescribeOptionGroupsCommandInput
  | DescribeOrderableDBInstanceOptionsCommandInput
  | DescribePendingMaintenanceActionsCommandInput
  | DescribeReservedDBInstancesCommandInput
  | DescribeReservedDBInstancesOfferingsCommandInput
  | DescribeSourceRegionsCommandInput
  | DescribeTenantDatabasesCommandInput
  | DescribeValidDBInstanceModificationsCommandInput
  | DisableHttpEndpointCommandInput
  | DownloadDBLogFilePortionCommandInput
  | EnableHttpEndpointCommandInput
  | FailoverDBClusterCommandInput
  | FailoverGlobalClusterCommandInput
  | ListTagsForResourceCommandInput
  | ModifyActivityStreamCommandInput
  | ModifyCertificatesCommandInput
  | ModifyCurrentDBClusterCapacityCommandInput
  | ModifyCustomDBEngineVersionCommandInput
  | ModifyDBClusterCommandInput
  | ModifyDBClusterEndpointCommandInput
  | ModifyDBClusterParameterGroupCommandInput
  | ModifyDBClusterSnapshotAttributeCommandInput
  | ModifyDBInstanceCommandInput
  | ModifyDBParameterGroupCommandInput
  | ModifyDBProxyCommandInput
  | ModifyDBProxyEndpointCommandInput
  | ModifyDBProxyTargetGroupCommandInput
  | ModifyDBRecommendationCommandInput
  | ModifyDBShardGroupCommandInput
  | ModifyDBSnapshotAttributeCommandInput
  | ModifyDBSnapshotCommandInput
  | ModifyDBSubnetGroupCommandInput
  | ModifyEventSubscriptionCommandInput
  | ModifyGlobalClusterCommandInput
  | ModifyIntegrationCommandInput
  | ModifyOptionGroupCommandInput
  | ModifyTenantDatabaseCommandInput
  | PromoteReadReplicaCommandInput
  | PromoteReadReplicaDBClusterCommandInput
  | PurchaseReservedDBInstancesOfferingCommandInput
  | RebootDBClusterCommandInput
  | RebootDBInstanceCommandInput
  | RebootDBShardGroupCommandInput
  | RegisterDBProxyTargetsCommandInput
  | RemoveFromGlobalClusterCommandInput
  | RemoveRoleFromDBClusterCommandInput
  | RemoveRoleFromDBInstanceCommandInput
  | RemoveSourceIdentifierFromSubscriptionCommandInput
  | RemoveTagsFromResourceCommandInput
  | ResetDBClusterParameterGroupCommandInput
  | ResetDBParameterGroupCommandInput
  | RestoreDBClusterFromS3CommandInput
  | RestoreDBClusterFromSnapshotCommandInput
  | RestoreDBClusterToPointInTimeCommandInput
  | RestoreDBInstanceFromDBSnapshotCommandInput
  | RestoreDBInstanceFromS3CommandInput
  | RestoreDBInstanceToPointInTimeCommandInput
  | RevokeDBSecurityGroupIngressCommandInput
  | StartActivityStreamCommandInput
  | StartDBClusterCommandInput
  | StartDBInstanceAutomatedBackupsReplicationCommandInput
  | StartDBInstanceCommandInput
  | StartExportTaskCommandInput
  | StopActivityStreamCommandInput
  | StopDBClusterCommandInput
  | StopDBInstanceAutomatedBackupsReplicationCommandInput
  | StopDBInstanceCommandInput
  | SwitchoverBlueGreenDeploymentCommandInput
  | SwitchoverGlobalClusterCommandInput
  | SwitchoverReadReplicaCommandInput;
export type ServiceOutputTypes =
  | AddRoleToDBClusterCommandOutput
  | AddRoleToDBInstanceCommandOutput
  | AddSourceIdentifierToSubscriptionCommandOutput
  | AddTagsToResourceCommandOutput
  | ApplyPendingMaintenanceActionCommandOutput
  | AuthorizeDBSecurityGroupIngressCommandOutput
  | BacktrackDBClusterCommandOutput
  | CancelExportTaskCommandOutput
  | CopyDBClusterParameterGroupCommandOutput
  | CopyDBClusterSnapshotCommandOutput
  | CopyDBParameterGroupCommandOutput
  | CopyDBSnapshotCommandOutput
  | CopyOptionGroupCommandOutput
  | CreateBlueGreenDeploymentCommandOutput
  | CreateCustomDBEngineVersionCommandOutput
  | CreateDBClusterCommandOutput
  | CreateDBClusterEndpointCommandOutput
  | CreateDBClusterParameterGroupCommandOutput
  | CreateDBClusterSnapshotCommandOutput
  | CreateDBInstanceCommandOutput
  | CreateDBInstanceReadReplicaCommandOutput
  | CreateDBParameterGroupCommandOutput
  | CreateDBProxyCommandOutput
  | CreateDBProxyEndpointCommandOutput
  | CreateDBSecurityGroupCommandOutput
  | CreateDBShardGroupCommandOutput
  | CreateDBSnapshotCommandOutput
  | CreateDBSubnetGroupCommandOutput
  | CreateEventSubscriptionCommandOutput
  | CreateGlobalClusterCommandOutput
  | CreateIntegrationCommandOutput
  | CreateOptionGroupCommandOutput
  | CreateTenantDatabaseCommandOutput
  | DeleteBlueGreenDeploymentCommandOutput
  | DeleteCustomDBEngineVersionCommandOutput
  | DeleteDBClusterAutomatedBackupCommandOutput
  | DeleteDBClusterCommandOutput
  | DeleteDBClusterEndpointCommandOutput
  | DeleteDBClusterParameterGroupCommandOutput
  | DeleteDBClusterSnapshotCommandOutput
  | DeleteDBInstanceAutomatedBackupCommandOutput
  | DeleteDBInstanceCommandOutput
  | DeleteDBParameterGroupCommandOutput
  | DeleteDBProxyCommandOutput
  | DeleteDBProxyEndpointCommandOutput
  | DeleteDBSecurityGroupCommandOutput
  | DeleteDBShardGroupCommandOutput
  | DeleteDBSnapshotCommandOutput
  | DeleteDBSubnetGroupCommandOutput
  | DeleteEventSubscriptionCommandOutput
  | DeleteGlobalClusterCommandOutput
  | DeleteIntegrationCommandOutput
  | DeleteOptionGroupCommandOutput
  | DeleteTenantDatabaseCommandOutput
  | DeregisterDBProxyTargetsCommandOutput
  | DescribeAccountAttributesCommandOutput
  | DescribeBlueGreenDeploymentsCommandOutput
  | DescribeCertificatesCommandOutput
  | DescribeDBClusterAutomatedBackupsCommandOutput
  | DescribeDBClusterBacktracksCommandOutput
  | DescribeDBClusterEndpointsCommandOutput
  | DescribeDBClusterParameterGroupsCommandOutput
  | DescribeDBClusterParametersCommandOutput
  | DescribeDBClusterSnapshotAttributesCommandOutput
  | DescribeDBClusterSnapshotsCommandOutput
  | DescribeDBClustersCommandOutput
  | DescribeDBEngineVersionsCommandOutput
  | DescribeDBInstanceAutomatedBackupsCommandOutput
  | DescribeDBInstancesCommandOutput
  | DescribeDBLogFilesCommandOutput
  | DescribeDBMajorEngineVersionsCommandOutput
  | DescribeDBParameterGroupsCommandOutput
  | DescribeDBParametersCommandOutput
  | DescribeDBProxiesCommandOutput
  | DescribeDBProxyEndpointsCommandOutput
  | DescribeDBProxyTargetGroupsCommandOutput
  | DescribeDBProxyTargetsCommandOutput
  | DescribeDBRecommendationsCommandOutput
  | DescribeDBSecurityGroupsCommandOutput
  | DescribeDBShardGroupsCommandOutput
  | DescribeDBSnapshotAttributesCommandOutput
  | DescribeDBSnapshotTenantDatabasesCommandOutput
  | DescribeDBSnapshotsCommandOutput
  | DescribeDBSubnetGroupsCommandOutput
  | DescribeEngineDefaultClusterParametersCommandOutput
  | DescribeEngineDefaultParametersCommandOutput
  | DescribeEventCategoriesCommandOutput
  | DescribeEventSubscriptionsCommandOutput
  | DescribeEventsCommandOutput
  | DescribeExportTasksCommandOutput
  | DescribeGlobalClustersCommandOutput
  | DescribeIntegrationsCommandOutput
  | DescribeOptionGroupOptionsCommandOutput
  | DescribeOptionGroupsCommandOutput
  | DescribeOrderableDBInstanceOptionsCommandOutput
  | DescribePendingMaintenanceActionsCommandOutput
  | DescribeReservedDBInstancesCommandOutput
  | DescribeReservedDBInstancesOfferingsCommandOutput
  | DescribeSourceRegionsCommandOutput
  | DescribeTenantDatabasesCommandOutput
  | DescribeValidDBInstanceModificationsCommandOutput
  | DisableHttpEndpointCommandOutput
  | DownloadDBLogFilePortionCommandOutput
  | EnableHttpEndpointCommandOutput
  | FailoverDBClusterCommandOutput
  | FailoverGlobalClusterCommandOutput
  | ListTagsForResourceCommandOutput
  | ModifyActivityStreamCommandOutput
  | ModifyCertificatesCommandOutput
  | ModifyCurrentDBClusterCapacityCommandOutput
  | ModifyCustomDBEngineVersionCommandOutput
  | ModifyDBClusterCommandOutput
  | ModifyDBClusterEndpointCommandOutput
  | ModifyDBClusterParameterGroupCommandOutput
  | ModifyDBClusterSnapshotAttributeCommandOutput
  | ModifyDBInstanceCommandOutput
  | ModifyDBParameterGroupCommandOutput
  | ModifyDBProxyCommandOutput
  | ModifyDBProxyEndpointCommandOutput
  | ModifyDBProxyTargetGroupCommandOutput
  | ModifyDBRecommendationCommandOutput
  | ModifyDBShardGroupCommandOutput
  | ModifyDBSnapshotAttributeCommandOutput
  | ModifyDBSnapshotCommandOutput
  | ModifyDBSubnetGroupCommandOutput
  | ModifyEventSubscriptionCommandOutput
  | ModifyGlobalClusterCommandOutput
  | ModifyIntegrationCommandOutput
  | ModifyOptionGroupCommandOutput
  | ModifyTenantDatabaseCommandOutput
  | PromoteReadReplicaCommandOutput
  | PromoteReadReplicaDBClusterCommandOutput
  | PurchaseReservedDBInstancesOfferingCommandOutput
  | RebootDBClusterCommandOutput
  | RebootDBInstanceCommandOutput
  | RebootDBShardGroupCommandOutput
  | RegisterDBProxyTargetsCommandOutput
  | RemoveFromGlobalClusterCommandOutput
  | RemoveRoleFromDBClusterCommandOutput
  | RemoveRoleFromDBInstanceCommandOutput
  | RemoveSourceIdentifierFromSubscriptionCommandOutput
  | RemoveTagsFromResourceCommandOutput
  | ResetDBClusterParameterGroupCommandOutput
  | ResetDBParameterGroupCommandOutput
  | RestoreDBClusterFromS3CommandOutput
  | RestoreDBClusterFromSnapshotCommandOutput
  | RestoreDBClusterToPointInTimeCommandOutput
  | RestoreDBInstanceFromDBSnapshotCommandOutput
  | RestoreDBInstanceFromS3CommandOutput
  | RestoreDBInstanceToPointInTimeCommandOutput
  | RevokeDBSecurityGroupIngressCommandOutput
  | StartActivityStreamCommandOutput
  | StartDBClusterCommandOutput
  | StartDBInstanceAutomatedBackupsReplicationCommandOutput
  | StartDBInstanceCommandOutput
  | StartExportTaskCommandOutput
  | StopActivityStreamCommandOutput
  | StopDBClusterCommandOutput
  | StopDBInstanceAutomatedBackupsReplicationCommandOutput
  | StopDBInstanceCommandOutput
  | SwitchoverBlueGreenDeploymentCommandOutput
  | SwitchoverGlobalClusterCommandOutput
  | SwitchoverReadReplicaCommandOutput;
export interface ClientDefaults
  extends Partial<__SmithyConfiguration<__HttpHandlerOptions>> {
  requestHandler?: __HttpHandlerUserInput;
  sha256?: __ChecksumConstructor | __HashConstructor;
  urlParser?: __UrlParser;
  bodyLengthChecker?: __BodyLengthCalculator;
  streamCollector?: __StreamCollector;
  base64Decoder?: __Decoder;
  base64Encoder?: __Encoder;
  utf8Decoder?: __Decoder;
  utf8Encoder?: __Encoder;
  runtime?: string;
  disableHostPrefix?: boolean;
  serviceId?: string;
  useDualstackEndpoint?: boolean | __Provider<boolean>;
  useFipsEndpoint?: boolean | __Provider<boolean>;
  region?: string | __Provider<string>;
  profile?: string;
  defaultUserAgentProvider?: Provider<__UserAgent>;
  credentialDefaultProvider?: (input: any) => AwsCredentialIdentityProvider;
  maxAttempts?: number | __Provider<number>;
  retryMode?: string | __Provider<string>;
  logger?: __Logger;
  extensions?: RuntimeExtension[];
  defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
export type RDSClientConfigType = Partial<
  __SmithyConfiguration<__HttpHandlerOptions>
> &
  ClientDefaults &
  UserAgentInputConfig &
  RetryInputConfig &
  RegionInputConfig &
  HostHeaderInputConfig &
  EndpointInputConfig<EndpointParameters> &
  HttpAuthSchemeInputConfig &
  ClientInputEndpointParameters;
export interface RDSClientConfig extends RDSClientConfigType {}
export type RDSClientResolvedConfigType =
  __SmithyResolvedConfiguration<__HttpHandlerOptions> &
    Required<ClientDefaults> &
    RuntimeExtensionsConfig &
    UserAgentResolvedConfig &
    RetryResolvedConfig &
    RegionResolvedConfig &
    HostHeaderResolvedConfig &
    EndpointResolvedConfig<EndpointParameters> &
    HttpAuthSchemeResolvedConfig &
    ClientResolvedEndpointParameters;
export interface RDSClientResolvedConfig extends RDSClientResolvedConfigType {}
export declare class RDSClient extends __Client<
  __HttpHandlerOptions,
  ServiceInputTypes,
  ServiceOutputTypes,
  RDSClientResolvedConfig
> {
  readonly config: RDSClientResolvedConfig;
  constructor(...[configuration]: __CheckOptionalClientConfig<RDSClientConfig>);
  destroy(): void;
}
