import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { RemoveRoleFromDBClusterMessage } from "../models/models_1";
import { RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../RDSClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link RemoveRoleFromDBClusterCommand}.
 */
export interface RemoveRoleFromDBClusterCommandInput extends RemoveRoleFromDBClusterMessage {
}
/**
 * @public
 *
 * The output of {@link RemoveRoleFromDBClusterCommand}.
 */
export interface RemoveRoleFromDBClusterCommandOutput extends __MetadataBearer {
}
declare const RemoveRoleFromDBClusterCommand_base: {
    new (input: RemoveRoleFromDBClusterCommandInput): import("@smithy/smithy-client").CommandImpl<RemoveRoleFromDBClusterCommandInput, RemoveRoleFromDBClusterCommandOutput, RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: RemoveRoleFromDBClusterCommandInput): import("@smithy/smithy-client").CommandImpl<RemoveRoleFromDBClusterCommandInput, RemoveRoleFromDBClusterCommandOutput, RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Removes the asssociation of an Amazon Web Services Identity and Access Management (IAM) role from a
 *             DB cluster.</p>
 *          <p>For more information on Amazon Aurora DB clusters, see
 *             <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
 *                 What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p>
 *          <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
 *                 cluster deployments</a> in the <i>Amazon RDS User
 *             Guide.</i>
 *          </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { RDSClient, RemoveRoleFromDBClusterCommand } from "@aws-sdk/client-rds"; // ES Modules import
 * // const { RDSClient, RemoveRoleFromDBClusterCommand } = require("@aws-sdk/client-rds"); // CommonJS import
 * const client = new RDSClient(config);
 * const input = { // RemoveRoleFromDBClusterMessage
 *   DBClusterIdentifier: "STRING_VALUE", // required
 *   RoleArn: "STRING_VALUE", // required
 *   FeatureName: "STRING_VALUE",
 * };
 * const command = new RemoveRoleFromDBClusterCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param RemoveRoleFromDBClusterCommandInput - {@link RemoveRoleFromDBClusterCommandInput}
 * @returns {@link RemoveRoleFromDBClusterCommandOutput}
 * @see {@link RemoveRoleFromDBClusterCommandInput} for command's `input` shape.
 * @see {@link RemoveRoleFromDBClusterCommandOutput} for command's `response` shape.
 * @see {@link RDSClientResolvedConfig | config} for RDSClient's `config` shape.
 *
 * @throws {@link DBClusterNotFoundFault} (client fault)
 *  <p>
 *             <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</p>
 *
 * @throws {@link DBClusterRoleNotFoundFault} (client fault)
 *  <p>The specified IAM role Amazon Resource Name (ARN) isn't associated with the specified DB cluster.</p>
 *
 * @throws {@link InvalidDBClusterStateFault} (client fault)
 *  <p>The requested operation can't be performed while the cluster is in this state.</p>
 *
 * @throws {@link RDSServiceException}
 * <p>Base exception class for all service exceptions from RDS service.</p>
 *
 *
 * @example To disassociate an Identity and Access Management (IAM) role from a DB cluster
 * ```javascript
 * // The following example removes a role from a DB cluster.
 * const input = {
 *   DBClusterIdentifier: "mydbcluster",
 *   RoleArn: "arn:aws:iam::123456789012:role/RDSLoadFromS3"
 * };
 * const command = new RemoveRoleFromDBClusterCommand(input);
 * const response = await client.send(command);
 * /* response is
 * { /* metadata only *\/ }
 * *\/
 * ```
 *
 * @public
 */
export declare class RemoveRoleFromDBClusterCommand extends RemoveRoleFromDBClusterCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: RemoveRoleFromDBClusterMessage;
            output: {};
        };
        sdk: {
            input: RemoveRoleFromDBClusterCommandInput;
            output: RemoveRoleFromDBClusterCommandOutput;
        };
    };
}
