import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { ModifyOptionGroupMessage, ModifyOptionGroupResult } from "../models/models_1";
import { RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../RDSClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ModifyOptionGroupCommand}.
 */
export interface ModifyOptionGroupCommandInput extends ModifyOptionGroupMessage {
}
/**
 * @public
 *
 * The output of {@link ModifyOptionGroupCommand}.
 */
export interface ModifyOptionGroupCommandOutput extends ModifyOptionGroupResult, __MetadataBearer {
}
declare const ModifyOptionGroupCommand_base: {
    new (input: ModifyOptionGroupCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyOptionGroupCommandInput, ModifyOptionGroupCommandOutput, RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: ModifyOptionGroupCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyOptionGroupCommandInput, ModifyOptionGroupCommandOutput, RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Modifies an existing option group.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { RDSClient, ModifyOptionGroupCommand } from "@aws-sdk/client-rds"; // ES Modules import
 * // const { RDSClient, ModifyOptionGroupCommand } = require("@aws-sdk/client-rds"); // CommonJS import
 * const client = new RDSClient(config);
 * const input = { // ModifyOptionGroupMessage
 *   OptionGroupName: "STRING_VALUE", // required
 *   OptionsToInclude: [ // OptionConfigurationList
 *     { // OptionConfiguration
 *       OptionName: "STRING_VALUE", // required
 *       Port: Number("int"),
 *       OptionVersion: "STRING_VALUE",
 *       DBSecurityGroupMemberships: [ // DBSecurityGroupNameList
 *         "STRING_VALUE",
 *       ],
 *       VpcSecurityGroupMemberships: [ // VpcSecurityGroupIdList
 *         "STRING_VALUE",
 *       ],
 *       OptionSettings: [ // OptionSettingsList
 *         { // OptionSetting
 *           Name: "STRING_VALUE",
 *           Value: "STRING_VALUE",
 *           DefaultValue: "STRING_VALUE",
 *           Description: "STRING_VALUE",
 *           ApplyType: "STRING_VALUE",
 *           DataType: "STRING_VALUE",
 *           AllowedValues: "STRING_VALUE",
 *           IsModifiable: true || false,
 *           IsCollection: true || false,
 *         },
 *       ],
 *     },
 *   ],
 *   OptionsToRemove: [ // OptionNamesList
 *     "STRING_VALUE",
 *   ],
 *   ApplyImmediately: true || false,
 * };
 * const command = new ModifyOptionGroupCommand(input);
 * const response = await client.send(command);
 * // { // ModifyOptionGroupResult
 * //   OptionGroup: { // OptionGroup
 * //     OptionGroupName: "STRING_VALUE",
 * //     OptionGroupDescription: "STRING_VALUE",
 * //     EngineName: "STRING_VALUE",
 * //     MajorEngineVersion: "STRING_VALUE",
 * //     Options: [ // OptionsList
 * //       { // Option
 * //         OptionName: "STRING_VALUE",
 * //         OptionDescription: "STRING_VALUE",
 * //         Persistent: true || false,
 * //         Permanent: true || false,
 * //         Port: Number("int"),
 * //         OptionVersion: "STRING_VALUE",
 * //         OptionSettings: [ // OptionSettingConfigurationList
 * //           { // OptionSetting
 * //             Name: "STRING_VALUE",
 * //             Value: "STRING_VALUE",
 * //             DefaultValue: "STRING_VALUE",
 * //             Description: "STRING_VALUE",
 * //             ApplyType: "STRING_VALUE",
 * //             DataType: "STRING_VALUE",
 * //             AllowedValues: "STRING_VALUE",
 * //             IsModifiable: true || false,
 * //             IsCollection: true || false,
 * //           },
 * //         ],
 * //         DBSecurityGroupMemberships: [ // DBSecurityGroupMembershipList
 * //           { // DBSecurityGroupMembership
 * //             DBSecurityGroupName: "STRING_VALUE",
 * //             Status: "STRING_VALUE",
 * //           },
 * //         ],
 * //         VpcSecurityGroupMemberships: [ // VpcSecurityGroupMembershipList
 * //           { // VpcSecurityGroupMembership
 * //             VpcSecurityGroupId: "STRING_VALUE",
 * //             Status: "STRING_VALUE",
 * //           },
 * //         ],
 * //       },
 * //     ],
 * //     AllowsVpcAndNonVpcInstanceMemberships: true || false,
 * //     VpcId: "STRING_VALUE",
 * //     OptionGroupArn: "STRING_VALUE",
 * //     SourceOptionGroup: "STRING_VALUE",
 * //     SourceAccountId: "STRING_VALUE",
 * //     CopyTimestamp: new Date("TIMESTAMP"),
 * //   },
 * // };
 *
 * ```
 *
 * @param ModifyOptionGroupCommandInput - {@link ModifyOptionGroupCommandInput}
 * @returns {@link ModifyOptionGroupCommandOutput}
 * @see {@link ModifyOptionGroupCommandInput} for command's `input` shape.
 * @see {@link ModifyOptionGroupCommandOutput} for command's `response` shape.
 * @see {@link RDSClientResolvedConfig | config} for RDSClient's `config` shape.
 *
 * @throws {@link InvalidOptionGroupStateFault} (client fault)
 *  <p>The option group isn't in the <i>available</i> state.</p>
 *
 * @throws {@link OptionGroupNotFoundFault} (client fault)
 *  <p>The specified option group could not be found.</p>
 *
 * @throws {@link RDSServiceException}
 * <p>Base exception class for all service exceptions from RDS service.</p>
 *
 *
 * @example To modify an option group
 * ```javascript
 * // The following example adds an option to an option group.
 * const input = {
 *   ApplyImmediately: true,
 *   OptionGroupName: "myawsuser-og02",
 *   OptionsToInclude: [
 *     {
 *       DBSecurityGroupMemberships: [
 *         "default"
 *       ],
 *       OptionName: "MEMCACHED"
 *     }
 *   ]
 * };
 * const command = new ModifyOptionGroupCommand(input);
 * const response = await client.send(command);
 * /* response is
 * {
 *   OptionGroup:   { /* empty *\/ }
 * }
 * *\/
 * ```
 *
 * @public
 */
export declare class ModifyOptionGroupCommand extends ModifyOptionGroupCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ModifyOptionGroupMessage;
            output: ModifyOptionGroupResult;
        };
        sdk: {
            input: ModifyOptionGroupCommandInput;
            output: ModifyOptionGroupCommandOutput;
        };
    };
}
