import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { DescribeGlobalClustersMessage, GlobalClustersMessage } from "../models/models_1";
import { RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../RDSClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DescribeGlobalClustersCommand}.
 */
export interface DescribeGlobalClustersCommandInput extends DescribeGlobalClustersMessage {
}
/**
 * @public
 *
 * The output of {@link DescribeGlobalClustersCommand}.
 */
export interface DescribeGlobalClustersCommandOutput extends GlobalClustersMessage, __MetadataBearer {
}
declare const DescribeGlobalClustersCommand_base: {
    new (input: DescribeGlobalClustersCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeGlobalClustersCommandInput, DescribeGlobalClustersCommandOutput, RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribeGlobalClustersCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribeGlobalClustersCommandInput, DescribeGlobalClustersCommandOutput, RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Returns information about Aurora global database clusters. This API supports pagination.</p>
 *          <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the
 *         <i>Amazon Aurora User Guide</i>.</p>
 *          <note>
 *             <p>This action only applies to Aurora DB clusters.</p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { RDSClient, DescribeGlobalClustersCommand } from "@aws-sdk/client-rds"; // ES Modules import
 * // const { RDSClient, DescribeGlobalClustersCommand } = require("@aws-sdk/client-rds"); // CommonJS import
 * const client = new RDSClient(config);
 * const input = { // DescribeGlobalClustersMessage
 *   GlobalClusterIdentifier: "STRING_VALUE",
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE", // required
 *       Values: [ // FilterValueList // required
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   MaxRecords: Number("int"),
 *   Marker: "STRING_VALUE",
 * };
 * const command = new DescribeGlobalClustersCommand(input);
 * const response = await client.send(command);
 * // { // GlobalClustersMessage
 * //   Marker: "STRING_VALUE",
 * //   GlobalClusters: [ // GlobalClusterList
 * //     { // GlobalCluster
 * //       GlobalClusterIdentifier: "STRING_VALUE",
 * //       GlobalClusterResourceId: "STRING_VALUE",
 * //       GlobalClusterArn: "STRING_VALUE",
 * //       Status: "STRING_VALUE",
 * //       Engine: "STRING_VALUE",
 * //       EngineVersion: "STRING_VALUE",
 * //       EngineLifecycleSupport: "STRING_VALUE",
 * //       DatabaseName: "STRING_VALUE",
 * //       StorageEncrypted: true || false,
 * //       DeletionProtection: true || false,
 * //       GlobalClusterMembers: [ // GlobalClusterMemberList
 * //         { // GlobalClusterMember
 * //           DBClusterArn: "STRING_VALUE",
 * //           Readers: [ // ReadersArnList
 * //             "STRING_VALUE",
 * //           ],
 * //           IsWriter: true || false,
 * //           GlobalWriteForwardingStatus: "enabled" || "disabled" || "enabling" || "disabling" || "unknown",
 * //           SynchronizationStatus: "connected" || "pending-resync",
 * //         },
 * //       ],
 * //       Endpoint: "STRING_VALUE",
 * //       FailoverState: { // FailoverState
 * //         Status: "pending" || "failing-over" || "cancelling",
 * //         FromDbClusterArn: "STRING_VALUE",
 * //         ToDbClusterArn: "STRING_VALUE",
 * //         IsDataLossAllowed: true || false,
 * //       },
 * //       TagList: [ // TagList
 * //         { // Tag
 * //           Key: "STRING_VALUE",
 * //           Value: "STRING_VALUE",
 * //         },
 * //       ],
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param DescribeGlobalClustersCommandInput - {@link DescribeGlobalClustersCommandInput}
 * @returns {@link DescribeGlobalClustersCommandOutput}
 * @see {@link DescribeGlobalClustersCommandInput} for command's `input` shape.
 * @see {@link DescribeGlobalClustersCommandOutput} for command's `response` shape.
 * @see {@link RDSClientResolvedConfig | config} for RDSClient's `config` shape.
 *
 * @throws {@link GlobalClusterNotFoundFault} (client fault)
 *  <p>The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.</p>
 *
 * @throws {@link RDSServiceException}
 * <p>Base exception class for all service exceptions from RDS service.</p>
 *
 *
 * @example To describe global DB clusters
 * ```javascript
 * // The following example lists Aurora global DB clusters in the current AWS Region.
 * const input = { /* empty *\/ };
 * const command = new DescribeGlobalClustersCommand(input);
 * const response = await client.send(command);
 * /* response is
 * {
 *   GlobalClusters: [
 *     {
 *       DeletionProtection: false,
 *       Engine: "aurora-mysql",
 *       EngineVersion: "5.7.mysql_aurora.2.07.2",
 *       GlobalClusterArn: "arn:aws:rds::123456789012:global-cluster:myglobalcluster",
 *       GlobalClusterIdentifier: "myglobalcluster",
 *       GlobalClusterMembers:       [],
 *       GlobalClusterResourceId: "cluster-f5982077e3b5aabb",
 *       Status: "available",
 *       StorageEncrypted: false
 *     }
 *   ]
 * }
 * *\/
 * ```
 *
 * @public
 */
export declare class DescribeGlobalClustersCommand extends DescribeGlobalClustersCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DescribeGlobalClustersMessage;
            output: GlobalClustersMessage;
        };
        sdk: {
            input: DescribeGlobalClustersCommandInput;
            output: DescribeGlobalClustersCommandOutput;
        };
    };
}
