import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { DBRecommendationsMessage, DescribeDBRecommendationsMessage } from "../models/models_1";
import { RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../RDSClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DescribeDBRecommendationsCommand}.
 */
export interface DescribeDBRecommendationsCommandInput extends DescribeDBRecommendationsMessage {
}
/**
 * @public
 *
 * The output of {@link DescribeDBRecommendationsCommand}.
 */
export interface DescribeDBRecommendationsCommandOutput extends DBRecommendationsMessage, __MetadataBearer {
}
declare const DescribeDBRecommendationsCommand_base: {
    new (input: DescribeDBRecommendationsCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeDBRecommendationsCommandInput, DescribeDBRecommendationsCommandOutput, RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribeDBRecommendationsCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribeDBRecommendationsCommandInput, DescribeDBRecommendationsCommandOutput, RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the recommendations to resolve the issues for your DB instances, DB clusters, and DB parameter groups.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { RDSClient, DescribeDBRecommendationsCommand } from "@aws-sdk/client-rds"; // ES Modules import
 * // const { RDSClient, DescribeDBRecommendationsCommand } = require("@aws-sdk/client-rds"); // CommonJS import
 * const client = new RDSClient(config);
 * const input = { // DescribeDBRecommendationsMessage
 *   LastUpdatedAfter: new Date("TIMESTAMP"),
 *   LastUpdatedBefore: new Date("TIMESTAMP"),
 *   Locale: "STRING_VALUE",
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE", // required
 *       Values: [ // FilterValueList // required
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   MaxRecords: Number("int"),
 *   Marker: "STRING_VALUE",
 * };
 * const command = new DescribeDBRecommendationsCommand(input);
 * const response = await client.send(command);
 * // { // DBRecommendationsMessage
 * //   DBRecommendations: [ // DBRecommendationList
 * //     { // DBRecommendation
 * //       RecommendationId: "STRING_VALUE",
 * //       TypeId: "STRING_VALUE",
 * //       Severity: "STRING_VALUE",
 * //       ResourceArn: "STRING_VALUE",
 * //       Status: "STRING_VALUE",
 * //       CreatedTime: new Date("TIMESTAMP"),
 * //       UpdatedTime: new Date("TIMESTAMP"),
 * //       Detection: "STRING_VALUE",
 * //       Recommendation: "STRING_VALUE",
 * //       Description: "STRING_VALUE",
 * //       Reason: "STRING_VALUE",
 * //       RecommendedActions: [ // RecommendedActionList
 * //         { // RecommendedAction
 * //           ActionId: "STRING_VALUE",
 * //           Title: "STRING_VALUE",
 * //           Description: "STRING_VALUE",
 * //           Operation: "STRING_VALUE",
 * //           Parameters: [ // RecommendedActionParameterList
 * //             { // RecommendedActionParameter
 * //               Key: "STRING_VALUE",
 * //               Value: "STRING_VALUE",
 * //             },
 * //           ],
 * //           ApplyModes: [ // StringList
 * //             "STRING_VALUE",
 * //           ],
 * //           Status: "STRING_VALUE",
 * //           IssueDetails: { // IssueDetails
 * //             PerformanceIssueDetails: { // PerformanceIssueDetails
 * //               StartTime: new Date("TIMESTAMP"),
 * //               EndTime: new Date("TIMESTAMP"),
 * //               Metrics: [ // MetricList
 * //                 { // Metric
 * //                   Name: "STRING_VALUE",
 * //                   References: [ // MetricReferenceList
 * //                     { // MetricReference
 * //                       Name: "STRING_VALUE",
 * //                       ReferenceDetails: { // ReferenceDetails
 * //                         ScalarReferenceDetails: { // ScalarReferenceDetails
 * //                           Value: Number("double"),
 * //                         },
 * //                       },
 * //                     },
 * //                   ],
 * //                   StatisticsDetails: "STRING_VALUE",
 * //                   MetricQuery: { // MetricQuery
 * //                     PerformanceInsightsMetricQuery: { // PerformanceInsightsMetricQuery
 * //                       GroupBy: { // PerformanceInsightsMetricDimensionGroup
 * //                         Dimensions: [
 * //                           "STRING_VALUE",
 * //                         ],
 * //                         Group: "STRING_VALUE",
 * //                         Limit: Number("int"),
 * //                       },
 * //                       Metric: "STRING_VALUE",
 * //                     },
 * //                   },
 * //                 },
 * //               ],
 * //               Analysis: "STRING_VALUE",
 * //             },
 * //           },
 * //           ContextAttributes: [ // ContextAttributeList
 * //             { // ContextAttribute
 * //               Key: "STRING_VALUE",
 * //               Value: "STRING_VALUE",
 * //             },
 * //           ],
 * //         },
 * //       ],
 * //       Category: "STRING_VALUE",
 * //       Source: "STRING_VALUE",
 * //       TypeDetection: "STRING_VALUE",
 * //       TypeRecommendation: "STRING_VALUE",
 * //       Impact: "STRING_VALUE",
 * //       AdditionalInfo: "STRING_VALUE",
 * //       Links: [ // DocLinkList
 * //         { // DocLink
 * //           Text: "STRING_VALUE",
 * //           Url: "STRING_VALUE",
 * //         },
 * //       ],
 * //       IssueDetails: {
 * //         PerformanceIssueDetails: {
 * //           StartTime: new Date("TIMESTAMP"),
 * //           EndTime: new Date("TIMESTAMP"),
 * //           Metrics: [
 * //             {
 * //               Name: "STRING_VALUE",
 * //               References: [
 * //                 {
 * //                   Name: "STRING_VALUE",
 * //                   ReferenceDetails: {
 * //                     ScalarReferenceDetails: {
 * //                       Value: Number("double"),
 * //                     },
 * //                   },
 * //                 },
 * //               ],
 * //               StatisticsDetails: "STRING_VALUE",
 * //               MetricQuery: {
 * //                 PerformanceInsightsMetricQuery: {
 * //                   GroupBy: {
 * //                     Dimensions: "<StringList>",
 * //                     Group: "STRING_VALUE",
 * //                     Limit: Number("int"),
 * //                   },
 * //                   Metric: "STRING_VALUE",
 * //                 },
 * //               },
 * //             },
 * //           ],
 * //           Analysis: "STRING_VALUE",
 * //         },
 * //       },
 * //     },
 * //   ],
 * //   Marker: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DescribeDBRecommendationsCommandInput - {@link DescribeDBRecommendationsCommandInput}
 * @returns {@link DescribeDBRecommendationsCommandOutput}
 * @see {@link DescribeDBRecommendationsCommandInput} for command's `input` shape.
 * @see {@link DescribeDBRecommendationsCommandOutput} for command's `response` shape.
 * @see {@link RDSClientResolvedConfig | config} for RDSClient's `config` shape.
 *
 * @throws {@link RDSServiceException}
 * <p>Base exception class for all service exceptions from RDS service.</p>
 *
 *
 * @public
 */
export declare class DescribeDBRecommendationsCommand extends DescribeDBRecommendationsCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DescribeDBRecommendationsMessage;
            output: DBRecommendationsMessage;
        };
        sdk: {
            input: DescribeDBRecommendationsCommandInput;
            output: DescribeDBRecommendationsCommandOutput;
        };
    };
}
