import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { RDSServiceException as __BaseException } from "./RDSServiceException";
export const ActivityStreamMode = {
    async: "async",
    sync: "sync",
};
export const ActivityStreamPolicyStatus = {
    locked: "locked",
    locking_policy: "locking-policy",
    unlocked: "unlocked",
    unlocking_policy: "unlocking-policy",
};
export const ActivityStreamStatus = {
    started: "started",
    starting: "starting",
    stopped: "stopped",
    stopping: "stopping",
};
export class DBClusterNotFoundFault extends __BaseException {
    name = "DBClusterNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterNotFoundFault.prototype);
    }
}
export class DBClusterRoleAlreadyExistsFault extends __BaseException {
    name = "DBClusterRoleAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterRoleAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterRoleAlreadyExistsFault.prototype);
    }
}
export class DBClusterRoleQuotaExceededFault extends __BaseException {
    name = "DBClusterRoleQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterRoleQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterRoleQuotaExceededFault.prototype);
    }
}
export class InvalidDBClusterStateFault extends __BaseException {
    name = "InvalidDBClusterStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBClusterStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBClusterStateFault.prototype);
    }
}
export class DBInstanceNotFoundFault extends __BaseException {
    name = "DBInstanceNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBInstanceNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBInstanceNotFoundFault.prototype);
    }
}
export class DBInstanceRoleAlreadyExistsFault extends __BaseException {
    name = "DBInstanceRoleAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBInstanceRoleAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBInstanceRoleAlreadyExistsFault.prototype);
    }
}
export class DBInstanceRoleQuotaExceededFault extends __BaseException {
    name = "DBInstanceRoleQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBInstanceRoleQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBInstanceRoleQuotaExceededFault.prototype);
    }
}
export class InvalidDBInstanceStateFault extends __BaseException {
    name = "InvalidDBInstanceStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBInstanceStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBInstanceStateFault.prototype);
    }
}
export class SourceNotFoundFault extends __BaseException {
    name = "SourceNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SourceNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SourceNotFoundFault.prototype);
    }
}
export class SubscriptionNotFoundFault extends __BaseException {
    name = "SubscriptionNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SubscriptionNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SubscriptionNotFoundFault.prototype);
    }
}
export class BlueGreenDeploymentNotFoundFault extends __BaseException {
    name = "BlueGreenDeploymentNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BlueGreenDeploymentNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BlueGreenDeploymentNotFoundFault.prototype);
    }
}
export class DBProxyNotFoundFault extends __BaseException {
    name = "DBProxyNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBProxyNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBProxyNotFoundFault.prototype);
    }
}
export class DBProxyTargetGroupNotFoundFault extends __BaseException {
    name = "DBProxyTargetGroupNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBProxyTargetGroupNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBProxyTargetGroupNotFoundFault.prototype);
    }
}
export class DBSnapshotNotFoundFault extends __BaseException {
    name = "DBSnapshotNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSnapshotNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSnapshotNotFoundFault.prototype);
    }
}
export class DBSnapshotTenantDatabaseNotFoundFault extends __BaseException {
    name = "DBSnapshotTenantDatabaseNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSnapshotTenantDatabaseNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSnapshotTenantDatabaseNotFoundFault.prototype);
    }
}
export class IntegrationNotFoundFault extends __BaseException {
    name = "IntegrationNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IntegrationNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IntegrationNotFoundFault.prototype);
    }
}
export class TenantDatabaseNotFoundFault extends __BaseException {
    name = "TenantDatabaseNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TenantDatabaseNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TenantDatabaseNotFoundFault.prototype);
    }
}
export class ResourceNotFoundFault extends __BaseException {
    name = "ResourceNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ResourceNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceNotFoundFault.prototype);
    }
}
export class AuthorizationAlreadyExistsFault extends __BaseException {
    name = "AuthorizationAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "AuthorizationAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, AuthorizationAlreadyExistsFault.prototype);
    }
}
export class AuthorizationQuotaExceededFault extends __BaseException {
    name = "AuthorizationQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "AuthorizationQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, AuthorizationQuotaExceededFault.prototype);
    }
}
export class DBSecurityGroupNotFoundFault extends __BaseException {
    name = "DBSecurityGroupNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSecurityGroupNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSecurityGroupNotFoundFault.prototype);
    }
}
export class InvalidDBSecurityGroupStateFault extends __BaseException {
    name = "InvalidDBSecurityGroupStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBSecurityGroupStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBSecurityGroupStateFault.prototype);
    }
}
export const ExportSourceType = {
    CLUSTER: "CLUSTER",
    SNAPSHOT: "SNAPSHOT",
};
export class ExportTaskNotFoundFault extends __BaseException {
    name = "ExportTaskNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ExportTaskNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ExportTaskNotFoundFault.prototype);
    }
}
export class InvalidExportTaskStateFault extends __BaseException {
    name = "InvalidExportTaskStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidExportTaskStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidExportTaskStateFault.prototype);
    }
}
export class DBParameterGroupAlreadyExistsFault extends __BaseException {
    name = "DBParameterGroupAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBParameterGroupAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBParameterGroupAlreadyExistsFault.prototype);
    }
}
export class DBParameterGroupNotFoundFault extends __BaseException {
    name = "DBParameterGroupNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBParameterGroupNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBParameterGroupNotFoundFault.prototype);
    }
}
export class DBParameterGroupQuotaExceededFault extends __BaseException {
    name = "DBParameterGroupQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBParameterGroupQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBParameterGroupQuotaExceededFault.prototype);
    }
}
export class DBClusterSnapshotAlreadyExistsFault extends __BaseException {
    name = "DBClusterSnapshotAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterSnapshotAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterSnapshotAlreadyExistsFault.prototype);
    }
}
export class DBClusterSnapshotNotFoundFault extends __BaseException {
    name = "DBClusterSnapshotNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterSnapshotNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterSnapshotNotFoundFault.prototype);
    }
}
export class InvalidDBClusterSnapshotStateFault extends __BaseException {
    name = "InvalidDBClusterSnapshotStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBClusterSnapshotStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBClusterSnapshotStateFault.prototype);
    }
}
export class KMSKeyNotAccessibleFault extends __BaseException {
    name = "KMSKeyNotAccessibleFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "KMSKeyNotAccessibleFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, KMSKeyNotAccessibleFault.prototype);
    }
}
export class SnapshotQuotaExceededFault extends __BaseException {
    name = "SnapshotQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SnapshotQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SnapshotQuotaExceededFault.prototype);
    }
}
export class CustomAvailabilityZoneNotFoundFault extends __BaseException {
    name = "CustomAvailabilityZoneNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CustomAvailabilityZoneNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CustomAvailabilityZoneNotFoundFault.prototype);
    }
}
export class DBSnapshotAlreadyExistsFault extends __BaseException {
    name = "DBSnapshotAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSnapshotAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSnapshotAlreadyExistsFault.prototype);
    }
}
export class InvalidDBSnapshotStateFault extends __BaseException {
    name = "InvalidDBSnapshotStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBSnapshotStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBSnapshotStateFault.prototype);
    }
}
export class OptionGroupAlreadyExistsFault extends __BaseException {
    name = "OptionGroupAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "OptionGroupAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OptionGroupAlreadyExistsFault.prototype);
    }
}
export class OptionGroupNotFoundFault extends __BaseException {
    name = "OptionGroupNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "OptionGroupNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OptionGroupNotFoundFault.prototype);
    }
}
export class OptionGroupQuotaExceededFault extends __BaseException {
    name = "OptionGroupQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "OptionGroupQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OptionGroupQuotaExceededFault.prototype);
    }
}
export class BlueGreenDeploymentAlreadyExistsFault extends __BaseException {
    name = "BlueGreenDeploymentAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BlueGreenDeploymentAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BlueGreenDeploymentAlreadyExistsFault.prototype);
    }
}
export class DBClusterParameterGroupNotFoundFault extends __BaseException {
    name = "DBClusterParameterGroupNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterParameterGroupNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterParameterGroupNotFoundFault.prototype);
    }
}
export class DBClusterQuotaExceededFault extends __BaseException {
    name = "DBClusterQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterQuotaExceededFault.prototype);
    }
}
export class InstanceQuotaExceededFault extends __BaseException {
    name = "InstanceQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InstanceQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InstanceQuotaExceededFault.prototype);
    }
}
export class SourceClusterNotSupportedFault extends __BaseException {
    name = "SourceClusterNotSupportedFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SourceClusterNotSupportedFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SourceClusterNotSupportedFault.prototype);
    }
}
export class SourceDatabaseNotSupportedFault extends __BaseException {
    name = "SourceDatabaseNotSupportedFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SourceDatabaseNotSupportedFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SourceDatabaseNotSupportedFault.prototype);
    }
}
export class CreateCustomDBEngineVersionFault extends __BaseException {
    name = "CreateCustomDBEngineVersionFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CreateCustomDBEngineVersionFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CreateCustomDBEngineVersionFault.prototype);
    }
}
export class CustomDBEngineVersionAlreadyExistsFault extends __BaseException {
    name = "CustomDBEngineVersionAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CustomDBEngineVersionAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CustomDBEngineVersionAlreadyExistsFault.prototype);
    }
}
export class CustomDBEngineVersionQuotaExceededFault extends __BaseException {
    name = "CustomDBEngineVersionQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CustomDBEngineVersionQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CustomDBEngineVersionQuotaExceededFault.prototype);
    }
}
export class Ec2ImagePropertiesNotSupportedFault extends __BaseException {
    name = "Ec2ImagePropertiesNotSupportedFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "Ec2ImagePropertiesNotSupportedFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, Ec2ImagePropertiesNotSupportedFault.prototype);
    }
}
export const ClusterScalabilityType = {
    LIMITLESS: "limitless",
    STANDARD: "standard",
};
export const DatabaseInsightsMode = {
    ADVANCED: "advanced",
    STANDARD: "standard",
};
export const ReplicaMode = {
    MOUNTED: "mounted",
    OPEN_READ_ONLY: "open-read-only",
};
export const WriteForwardingStatus = {
    DISABLED: "disabled",
    DISABLING: "disabling",
    ENABLED: "enabled",
    ENABLING: "enabling",
    UNKNOWN: "unknown",
};
export const LimitlessDatabaseStatus = {
    ACTIVE: "active",
    DISABLED: "disabled",
    DISABLING: "disabling",
    ENABLED: "enabled",
    ENABLING: "enabling",
    ERROR: "error",
    MODIFYING_MAX_CAPACITY: "modifying-max-capacity",
    NOT_IN_USE: "not-in-use",
};
export const LocalWriteForwardingStatus = {
    DISABLED: "disabled",
    DISABLING: "disabling",
    ENABLED: "enabled",
    ENABLING: "enabling",
    REQUESTED: "requested",
};
export class DBClusterAlreadyExistsFault extends __BaseException {
    name = "DBClusterAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterAlreadyExistsFault.prototype);
    }
}
export class DBSubnetGroupDoesNotCoverEnoughAZs extends __BaseException {
    name = "DBSubnetGroupDoesNotCoverEnoughAZs";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSubnetGroupDoesNotCoverEnoughAZs",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSubnetGroupDoesNotCoverEnoughAZs.prototype);
    }
}
export class DBSubnetGroupNotFoundFault extends __BaseException {
    name = "DBSubnetGroupNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSubnetGroupNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSubnetGroupNotFoundFault.prototype);
    }
}
export class DomainNotFoundFault extends __BaseException {
    name = "DomainNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DomainNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DomainNotFoundFault.prototype);
    }
}
export class GlobalClusterNotFoundFault extends __BaseException {
    name = "GlobalClusterNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "GlobalClusterNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, GlobalClusterNotFoundFault.prototype);
    }
}
export class InsufficientDBInstanceCapacityFault extends __BaseException {
    name = "InsufficientDBInstanceCapacityFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InsufficientDBInstanceCapacityFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InsufficientDBInstanceCapacityFault.prototype);
    }
}
export class InsufficientStorageClusterCapacityFault extends __BaseException {
    name = "InsufficientStorageClusterCapacityFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InsufficientStorageClusterCapacityFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InsufficientStorageClusterCapacityFault.prototype);
    }
}
export class InvalidDBSubnetGroupFault extends __BaseException {
    name = "InvalidDBSubnetGroupFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBSubnetGroupFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBSubnetGroupFault.prototype);
    }
}
export class InvalidDBSubnetGroupStateFault extends __BaseException {
    name = "InvalidDBSubnetGroupStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBSubnetGroupStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBSubnetGroupStateFault.prototype);
    }
}
export class InvalidGlobalClusterStateFault extends __BaseException {
    name = "InvalidGlobalClusterStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidGlobalClusterStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidGlobalClusterStateFault.prototype);
    }
}
export class InvalidSubnet extends __BaseException {
    name = "InvalidSubnet";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidSubnet",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidSubnet.prototype);
    }
}
export class InvalidVPCNetworkStateFault extends __BaseException {
    name = "InvalidVPCNetworkStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidVPCNetworkStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidVPCNetworkStateFault.prototype);
    }
}
export class StorageQuotaExceededFault extends __BaseException {
    name = "StorageQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "StorageQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StorageQuotaExceededFault.prototype);
    }
}
export class DBClusterEndpointAlreadyExistsFault extends __BaseException {
    name = "DBClusterEndpointAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterEndpointAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterEndpointAlreadyExistsFault.prototype);
    }
}
export class DBClusterEndpointQuotaExceededFault extends __BaseException {
    name = "DBClusterEndpointQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterEndpointQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterEndpointQuotaExceededFault.prototype);
    }
}
export class AuthorizationNotFoundFault extends __BaseException {
    name = "AuthorizationNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "AuthorizationNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, AuthorizationNotFoundFault.prototype);
    }
}
export class BackupPolicyNotFoundFault extends __BaseException {
    name = "BackupPolicyNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BackupPolicyNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BackupPolicyNotFoundFault.prototype);
    }
}
export class CertificateNotFoundFault extends __BaseException {
    name = "CertificateNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CertificateNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CertificateNotFoundFault.prototype);
    }
}
export const AutomationMode = {
    ALL_PAUSED: "all-paused",
    FULL: "full",
};
export class DBInstanceAlreadyExistsFault extends __BaseException {
    name = "DBInstanceAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBInstanceAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBInstanceAlreadyExistsFault.prototype);
    }
}
export class NetworkTypeNotSupported extends __BaseException {
    name = "NetworkTypeNotSupported";
    $fault = "client";
    constructor(opts) {
        super({
            name: "NetworkTypeNotSupported",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NetworkTypeNotSupported.prototype);
    }
}
export class ProvisionedIopsNotAvailableInAZFault extends __BaseException {
    name = "ProvisionedIopsNotAvailableInAZFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ProvisionedIopsNotAvailableInAZFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ProvisionedIopsNotAvailableInAZFault.prototype);
    }
}
export class StorageTypeNotSupportedFault extends __BaseException {
    name = "StorageTypeNotSupportedFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "StorageTypeNotSupportedFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StorageTypeNotSupportedFault.prototype);
    }
}
export class TenantDatabaseQuotaExceededFault extends __BaseException {
    name = "TenantDatabaseQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TenantDatabaseQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TenantDatabaseQuotaExceededFault.prototype);
    }
}
export class DBSubnetGroupNotAllowedFault extends __BaseException {
    name = "DBSubnetGroupNotAllowedFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSubnetGroupNotAllowedFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSubnetGroupNotAllowedFault.prototype);
    }
}
export const AuthScheme = {
    SECRETS: "SECRETS",
};
export const ClientPasswordAuthType = {
    MYSQL_CACHING_SHA2_PASSWORD: "MYSQL_CACHING_SHA2_PASSWORD",
    MYSQL_NATIVE_PASSWORD: "MYSQL_NATIVE_PASSWORD",
    POSTGRES_MD5: "POSTGRES_MD5",
    POSTGRES_SCRAM_SHA_256: "POSTGRES_SCRAM_SHA_256",
    SQL_SERVER_AUTHENTICATION: "SQL_SERVER_AUTHENTICATION",
};
export const IAMAuthMode = {
    DISABLED: "DISABLED",
    ENABLED: "ENABLED",
    REQUIRED: "REQUIRED",
};
export const EngineFamily = {
    MYSQL: "MYSQL",
    POSTGRESQL: "POSTGRESQL",
    SQLSERVER: "SQLSERVER",
};
export const DBProxyStatus = {
    AVAILABLE: "available",
    CREATING: "creating",
    DELETING: "deleting",
    INCOMPATIBLE_NETWORK: "incompatible-network",
    INSUFFICIENT_RESOURCE_LIMITS: "insufficient-resource-limits",
    MODIFYING: "modifying",
    REACTIVATING: "reactivating",
    SUSPENDED: "suspended",
    SUSPENDING: "suspending",
};
export class DBProxyAlreadyExistsFault extends __BaseException {
    name = "DBProxyAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBProxyAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBProxyAlreadyExistsFault.prototype);
    }
}
export class DBProxyQuotaExceededFault extends __BaseException {
    name = "DBProxyQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBProxyQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBProxyQuotaExceededFault.prototype);
    }
}
export const DBProxyEndpointTargetRole = {
    READ_ONLY: "READ_ONLY",
    READ_WRITE: "READ_WRITE",
};
export const DBProxyEndpointStatus = {
    AVAILABLE: "available",
    CREATING: "creating",
    DELETING: "deleting",
    INCOMPATIBLE_NETWORK: "incompatible-network",
    INSUFFICIENT_RESOURCE_LIMITS: "insufficient-resource-limits",
    MODIFYING: "modifying",
};
export class DBProxyEndpointAlreadyExistsFault extends __BaseException {
    name = "DBProxyEndpointAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBProxyEndpointAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBProxyEndpointAlreadyExistsFault.prototype);
    }
}
export class DBProxyEndpointQuotaExceededFault extends __BaseException {
    name = "DBProxyEndpointQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBProxyEndpointQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBProxyEndpointQuotaExceededFault.prototype);
    }
}
export class InvalidDBProxyStateFault extends __BaseException {
    name = "InvalidDBProxyStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBProxyStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBProxyStateFault.prototype);
    }
}
export class DBSecurityGroupAlreadyExistsFault extends __BaseException {
    name = "DBSecurityGroupAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSecurityGroupAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSecurityGroupAlreadyExistsFault.prototype);
    }
}
export class DBSecurityGroupNotSupportedFault extends __BaseException {
    name = "DBSecurityGroupNotSupportedFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSecurityGroupNotSupportedFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSecurityGroupNotSupportedFault.prototype);
    }
}
export class DBSecurityGroupQuotaExceededFault extends __BaseException {
    name = "DBSecurityGroupQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSecurityGroupQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSecurityGroupQuotaExceededFault.prototype);
    }
}
export class DBShardGroupAlreadyExistsFault extends __BaseException {
    name = "DBShardGroupAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBShardGroupAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBShardGroupAlreadyExistsFault.prototype);
    }
}
export class MaxDBShardGroupLimitReached extends __BaseException {
    name = "MaxDBShardGroupLimitReached";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MaxDBShardGroupLimitReached",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MaxDBShardGroupLimitReached.prototype);
    }
}
export class UnsupportedDBEngineVersionFault extends __BaseException {
    name = "UnsupportedDBEngineVersionFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "UnsupportedDBEngineVersionFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, UnsupportedDBEngineVersionFault.prototype);
    }
}
export class DBSubnetGroupAlreadyExistsFault extends __BaseException {
    name = "DBSubnetGroupAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSubnetGroupAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSubnetGroupAlreadyExistsFault.prototype);
    }
}
export class DBSubnetGroupQuotaExceededFault extends __BaseException {
    name = "DBSubnetGroupQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSubnetGroupQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSubnetGroupQuotaExceededFault.prototype);
    }
}
export class DBSubnetQuotaExceededFault extends __BaseException {
    name = "DBSubnetQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBSubnetQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBSubnetQuotaExceededFault.prototype);
    }
}
export class EventSubscriptionQuotaExceededFault extends __BaseException {
    name = "EventSubscriptionQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "EventSubscriptionQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, EventSubscriptionQuotaExceededFault.prototype);
    }
}
export class SNSInvalidTopicFault extends __BaseException {
    name = "SNSInvalidTopicFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SNSInvalidTopicFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SNSInvalidTopicFault.prototype);
    }
}
export class SNSNoAuthorizationFault extends __BaseException {
    name = "SNSNoAuthorizationFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SNSNoAuthorizationFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SNSNoAuthorizationFault.prototype);
    }
}
export class SNSTopicArnNotFoundFault extends __BaseException {
    name = "SNSTopicArnNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SNSTopicArnNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SNSTopicArnNotFoundFault.prototype);
    }
}
export class SubscriptionAlreadyExistFault extends __BaseException {
    name = "SubscriptionAlreadyExistFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SubscriptionAlreadyExistFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SubscriptionAlreadyExistFault.prototype);
    }
}
export class SubscriptionCategoryNotFoundFault extends __BaseException {
    name = "SubscriptionCategoryNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SubscriptionCategoryNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SubscriptionCategoryNotFoundFault.prototype);
    }
}
export const FailoverStatus = {
    CANCELLING: "cancelling",
    FAILING_OVER: "failing-over",
    PENDING: "pending",
};
export const GlobalClusterMemberSynchronizationStatus = {
    CONNECTED: "connected",
    PENDING_RESYNC: "pending-resync",
};
export class GlobalClusterAlreadyExistsFault extends __BaseException {
    name = "GlobalClusterAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "GlobalClusterAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, GlobalClusterAlreadyExistsFault.prototype);
    }
}
export class GlobalClusterQuotaExceededFault extends __BaseException {
    name = "GlobalClusterQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "GlobalClusterQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, GlobalClusterQuotaExceededFault.prototype);
    }
}
export const IntegrationStatus = {
    ACTIVE: "active",
    CREATING: "creating",
    DELETING: "deleting",
    FAILED: "failed",
    MODIFYING: "modifying",
    NEEDS_ATTENTION: "needs_attention",
    SYNCING: "syncing",
};
export class IntegrationAlreadyExistsFault extends __BaseException {
    name = "IntegrationAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IntegrationAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IntegrationAlreadyExistsFault.prototype);
    }
}
export class IntegrationConflictOperationFault extends __BaseException {
    name = "IntegrationConflictOperationFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IntegrationConflictOperationFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IntegrationConflictOperationFault.prototype);
    }
}
export class IntegrationQuotaExceededFault extends __BaseException {
    name = "IntegrationQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IntegrationQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IntegrationQuotaExceededFault.prototype);
    }
}
export class TenantDatabaseAlreadyExistsFault extends __BaseException {
    name = "TenantDatabaseAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TenantDatabaseAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TenantDatabaseAlreadyExistsFault.prototype);
    }
}
export class InvalidBlueGreenDeploymentStateFault extends __BaseException {
    name = "InvalidBlueGreenDeploymentStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidBlueGreenDeploymentStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidBlueGreenDeploymentStateFault.prototype);
    }
}
export class CustomDBEngineVersionNotFoundFault extends __BaseException {
    name = "CustomDBEngineVersionNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CustomDBEngineVersionNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CustomDBEngineVersionNotFoundFault.prototype);
    }
}
export class InvalidCustomDBEngineVersionStateFault extends __BaseException {
    name = "InvalidCustomDBEngineVersionStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidCustomDBEngineVersionStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidCustomDBEngineVersionStateFault.prototype);
    }
}
export class DBClusterAutomatedBackupQuotaExceededFault extends __BaseException {
    name = "DBClusterAutomatedBackupQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterAutomatedBackupQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterAutomatedBackupQuotaExceededFault.prototype);
    }
}
export class DBClusterAutomatedBackupNotFoundFault extends __BaseException {
    name = "DBClusterAutomatedBackupNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterAutomatedBackupNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterAutomatedBackupNotFoundFault.prototype);
    }
}
export class InvalidDBClusterAutomatedBackupStateFault extends __BaseException {
    name = "InvalidDBClusterAutomatedBackupStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBClusterAutomatedBackupStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBClusterAutomatedBackupStateFault.prototype);
    }
}
export class DBClusterEndpointNotFoundFault extends __BaseException {
    name = "DBClusterEndpointNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterEndpointNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterEndpointNotFoundFault.prototype);
    }
}
export class InvalidDBClusterEndpointStateFault extends __BaseException {
    name = "InvalidDBClusterEndpointStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBClusterEndpointStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBClusterEndpointStateFault.prototype);
    }
}
export class InvalidDBParameterGroupStateFault extends __BaseException {
    name = "InvalidDBParameterGroupStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBParameterGroupStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBParameterGroupStateFault.prototype);
    }
}
export class DBInstanceAutomatedBackupQuotaExceededFault extends __BaseException {
    name = "DBInstanceAutomatedBackupQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBInstanceAutomatedBackupQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBInstanceAutomatedBackupQuotaExceededFault.prototype);
    }
}
export class DBInstanceAutomatedBackupNotFoundFault extends __BaseException {
    name = "DBInstanceAutomatedBackupNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBInstanceAutomatedBackupNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBInstanceAutomatedBackupNotFoundFault.prototype);
    }
}
export class InvalidDBInstanceAutomatedBackupStateFault extends __BaseException {
    name = "InvalidDBInstanceAutomatedBackupStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBInstanceAutomatedBackupStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBInstanceAutomatedBackupStateFault.prototype);
    }
}
export class DBProxyEndpointNotFoundFault extends __BaseException {
    name = "DBProxyEndpointNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBProxyEndpointNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBProxyEndpointNotFoundFault.prototype);
    }
}
export class InvalidDBProxyEndpointStateFault extends __BaseException {
    name = "InvalidDBProxyEndpointStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBProxyEndpointStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBProxyEndpointStateFault.prototype);
    }
}
export class DBShardGroupNotFoundFault extends __BaseException {
    name = "DBShardGroupNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBShardGroupNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBShardGroupNotFoundFault.prototype);
    }
}
export class InvalidDBShardGroupStateFault extends __BaseException {
    name = "InvalidDBShardGroupStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBShardGroupStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBShardGroupStateFault.prototype);
    }
}
export class InvalidDBSubnetStateFault extends __BaseException {
    name = "InvalidDBSubnetStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBSubnetStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBSubnetStateFault.prototype);
    }
}
export class InvalidEventSubscriptionStateFault extends __BaseException {
    name = "InvalidEventSubscriptionStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidEventSubscriptionStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidEventSubscriptionStateFault.prototype);
    }
}
export class InvalidIntegrationStateFault extends __BaseException {
    name = "InvalidIntegrationStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidIntegrationStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidIntegrationStateFault.prototype);
    }
}
export const CreateTenantDatabaseMessageFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MasterUserPassword && { MasterUserPassword: SENSITIVE_STRING }),
});
export const TenantDatabasePendingModifiedValuesFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MasterUserPassword && { MasterUserPassword: SENSITIVE_STRING }),
});
export const TenantDatabaseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PendingModifiedValues && {
        PendingModifiedValues: TenantDatabasePendingModifiedValuesFilterSensitiveLog(obj.PendingModifiedValues),
    }),
});
export const CreateTenantDatabaseResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TenantDatabase && { TenantDatabase: TenantDatabaseFilterSensitiveLog(obj.TenantDatabase) }),
});
