import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteDBSubnetGroupCommand, se_DeleteDBSubnetGroupCommand } from "../protocols/Aws_query";
export { $Command };
export class DeleteDBSubnetGroupCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonRDSv19", "DeleteDBSubnetGroup", {})
    .n("RDSClient", "DeleteDBSubnetGroupCommand")
    .f(void 0, void 0)
    .ser(se_DeleteDBSubnetGroupCommand)
    .de(de_DeleteDBSubnetGroupCommand)
    .build() {
}
