import {
  AwsSdkSigV4AuthInputConfig,
  AwsSdkSigV4AuthResolvedConfig,
  AwsSdkSigV4PreviouslyResolved,
} from "@aws-sdk/core";
import {
  HandlerExecutionContext,
  HttpAuthScheme,
  HttpAuthSchemeParameters,
  HttpAuthSchemeParametersProvider,
  HttpAuthSchemeProvider,
  Provider,
} from "@smithy/types";
import { EKSClientResolvedConfig } from "../EKSClient";
export interface EKSHttpAuthSchemeParameters extends HttpAuthSchemeParameters {
  region?: string;
}
export interface EKSHttpAuthSchemeParametersProvider
  extends HttpAuthSchemeParametersProvider<
    EKSClientResolvedConfig,
    HandlerExecutionContext,
    EKSHttpAuthSchemeParameters,
    object
  > {}
export declare const defaultEKSHttpAuthSchemeParametersProvider: (
  config: EKSClientResolvedConfig,
  context: HandlerExecutionContext,
  input: object
) => Promise<EKSHttpAuthSchemeParameters>;
export interface EKSHttpAuthSchemeProvider
  extends HttpAuthSchemeProvider<EKSHttpAuthSchemeParameters> {}
export declare const defaultEKSHttpAuthSchemeProvider: EKSHttpAuthSchemeProvider;
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
  authSchemePreference?: string[] | Provider<string[]>;
  httpAuthSchemes?: HttpAuthScheme[];
  httpAuthSchemeProvider?: EKSHttpAuthSchemeProvider;
}
export interface HttpAuthSchemeResolvedConfig
  extends AwsSdkSigV4AuthResolvedConfig {
  readonly authSchemePreference: Provider<string[]>;
  readonly httpAuthSchemes: HttpAuthScheme[];
  readonly httpAuthSchemeProvider: EKSHttpAuthSchemeProvider;
}
export declare const resolveHttpAuthSchemeConfig: <T>(
  config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved
) => T & HttpAuthSchemeResolvedConfig;
