import {
  HostHeaderInputConfig,
  HostHeaderResolvedConfig,
} from "@aws-sdk/middleware-host-header";
import {
  UserAgentInputConfig,
  UserAgentResolvedConfig,
} from "@aws-sdk/middleware-user-agent";
import {
  RegionInputConfig,
  RegionResolvedConfig,
} from "@smithy/config-resolver";
import {
  EndpointInputConfig,
  EndpointResolvedConfig,
} from "@smithy/middleware-endpoint";
import {
  RetryInputConfig,
  RetryResolvedConfig,
} from "@smithy/middleware-retry";
import { HttpHandlerUserInput as __HttpHandlerUserInput } from "@smithy/protocol-http";
import {
  Client as __Client,
  DefaultsMode as __DefaultsMode,
  SmithyConfiguration as __SmithyConfiguration,
  SmithyResolvedConfiguration as __SmithyResolvedConfiguration,
} from "@smithy/smithy-client";
import {
  AwsCredentialIdentityProvider,
  BodyLengthCalculator as __BodyLengthCalculator,
  CheckOptionalClientConfig as __CheckOptionalClientConfig,
  ChecksumConstructor as __ChecksumConstructor,
  Decoder as __Decoder,
  Encoder as __Encoder,
  HashConstructor as __HashConstructor,
  HttpHandlerOptions as __HttpHandlerOptions,
  Logger as __Logger,
  Provider as __Provider,
  Provider,
  StreamCollector as __StreamCollector,
  UrlParser as __UrlParser,
  UserAgent as __UserAgent,
} from "@smithy/types";
import {
  HttpAuthSchemeInputConfig,
  HttpAuthSchemeResolvedConfig,
} from "./auth/httpAuthSchemeProvider";
import {
  AssociateAccessPolicyCommandInput,
  AssociateAccessPolicyCommandOutput,
} from "./commands/AssociateAccessPolicyCommand";
import {
  AssociateEncryptionConfigCommandInput,
  AssociateEncryptionConfigCommandOutput,
} from "./commands/AssociateEncryptionConfigCommand";
import {
  AssociateIdentityProviderConfigCommandInput,
  AssociateIdentityProviderConfigCommandOutput,
} from "./commands/AssociateIdentityProviderConfigCommand";
import {
  CreateAccessEntryCommandInput,
  CreateAccessEntryCommandOutput,
} from "./commands/CreateAccessEntryCommand";
import {
  CreateAddonCommandInput,
  CreateAddonCommandOutput,
} from "./commands/CreateAddonCommand";
import {
  CreateClusterCommandInput,
  CreateClusterCommandOutput,
} from "./commands/CreateClusterCommand";
import {
  CreateEksAnywhereSubscriptionCommandInput,
  CreateEksAnywhereSubscriptionCommandOutput,
} from "./commands/CreateEksAnywhereSubscriptionCommand";
import {
  CreateFargateProfileCommandInput,
  CreateFargateProfileCommandOutput,
} from "./commands/CreateFargateProfileCommand";
import {
  CreateNodegroupCommandInput,
  CreateNodegroupCommandOutput,
} from "./commands/CreateNodegroupCommand";
import {
  CreatePodIdentityAssociationCommandInput,
  CreatePodIdentityAssociationCommandOutput,
} from "./commands/CreatePodIdentityAssociationCommand";
import {
  DeleteAccessEntryCommandInput,
  DeleteAccessEntryCommandOutput,
} from "./commands/DeleteAccessEntryCommand";
import {
  DeleteAddonCommandInput,
  DeleteAddonCommandOutput,
} from "./commands/DeleteAddonCommand";
import {
  DeleteClusterCommandInput,
  DeleteClusterCommandOutput,
} from "./commands/DeleteClusterCommand";
import {
  DeleteEksAnywhereSubscriptionCommandInput,
  DeleteEksAnywhereSubscriptionCommandOutput,
} from "./commands/DeleteEksAnywhereSubscriptionCommand";
import {
  DeleteFargateProfileCommandInput,
  DeleteFargateProfileCommandOutput,
} from "./commands/DeleteFargateProfileCommand";
import {
  DeleteNodegroupCommandInput,
  DeleteNodegroupCommandOutput,
} from "./commands/DeleteNodegroupCommand";
import {
  DeletePodIdentityAssociationCommandInput,
  DeletePodIdentityAssociationCommandOutput,
} from "./commands/DeletePodIdentityAssociationCommand";
import {
  DeregisterClusterCommandInput,
  DeregisterClusterCommandOutput,
} from "./commands/DeregisterClusterCommand";
import {
  DescribeAccessEntryCommandInput,
  DescribeAccessEntryCommandOutput,
} from "./commands/DescribeAccessEntryCommand";
import {
  DescribeAddonCommandInput,
  DescribeAddonCommandOutput,
} from "./commands/DescribeAddonCommand";
import {
  DescribeAddonConfigurationCommandInput,
  DescribeAddonConfigurationCommandOutput,
} from "./commands/DescribeAddonConfigurationCommand";
import {
  DescribeAddonVersionsCommandInput,
  DescribeAddonVersionsCommandOutput,
} from "./commands/DescribeAddonVersionsCommand";
import {
  DescribeClusterCommandInput,
  DescribeClusterCommandOutput,
} from "./commands/DescribeClusterCommand";
import {
  DescribeClusterVersionsCommandInput,
  DescribeClusterVersionsCommandOutput,
} from "./commands/DescribeClusterVersionsCommand";
import {
  DescribeEksAnywhereSubscriptionCommandInput,
  DescribeEksAnywhereSubscriptionCommandOutput,
} from "./commands/DescribeEksAnywhereSubscriptionCommand";
import {
  DescribeFargateProfileCommandInput,
  DescribeFargateProfileCommandOutput,
} from "./commands/DescribeFargateProfileCommand";
import {
  DescribeIdentityProviderConfigCommandInput,
  DescribeIdentityProviderConfigCommandOutput,
} from "./commands/DescribeIdentityProviderConfigCommand";
import {
  DescribeInsightCommandInput,
  DescribeInsightCommandOutput,
} from "./commands/DescribeInsightCommand";
import {
  DescribeNodegroupCommandInput,
  DescribeNodegroupCommandOutput,
} from "./commands/DescribeNodegroupCommand";
import {
  DescribePodIdentityAssociationCommandInput,
  DescribePodIdentityAssociationCommandOutput,
} from "./commands/DescribePodIdentityAssociationCommand";
import {
  DescribeUpdateCommandInput,
  DescribeUpdateCommandOutput,
} from "./commands/DescribeUpdateCommand";
import {
  DisassociateAccessPolicyCommandInput,
  DisassociateAccessPolicyCommandOutput,
} from "./commands/DisassociateAccessPolicyCommand";
import {
  DisassociateIdentityProviderConfigCommandInput,
  DisassociateIdentityProviderConfigCommandOutput,
} from "./commands/DisassociateIdentityProviderConfigCommand";
import {
  ListAccessEntriesCommandInput,
  ListAccessEntriesCommandOutput,
} from "./commands/ListAccessEntriesCommand";
import {
  ListAccessPoliciesCommandInput,
  ListAccessPoliciesCommandOutput,
} from "./commands/ListAccessPoliciesCommand";
import {
  ListAddonsCommandInput,
  ListAddonsCommandOutput,
} from "./commands/ListAddonsCommand";
import {
  ListAssociatedAccessPoliciesCommandInput,
  ListAssociatedAccessPoliciesCommandOutput,
} from "./commands/ListAssociatedAccessPoliciesCommand";
import {
  ListClustersCommandInput,
  ListClustersCommandOutput,
} from "./commands/ListClustersCommand";
import {
  ListEksAnywhereSubscriptionsCommandInput,
  ListEksAnywhereSubscriptionsCommandOutput,
} from "./commands/ListEksAnywhereSubscriptionsCommand";
import {
  ListFargateProfilesCommandInput,
  ListFargateProfilesCommandOutput,
} from "./commands/ListFargateProfilesCommand";
import {
  ListIdentityProviderConfigsCommandInput,
  ListIdentityProviderConfigsCommandOutput,
} from "./commands/ListIdentityProviderConfigsCommand";
import {
  ListInsightsCommandInput,
  ListInsightsCommandOutput,
} from "./commands/ListInsightsCommand";
import {
  ListNodegroupsCommandInput,
  ListNodegroupsCommandOutput,
} from "./commands/ListNodegroupsCommand";
import {
  ListPodIdentityAssociationsCommandInput,
  ListPodIdentityAssociationsCommandOutput,
} from "./commands/ListPodIdentityAssociationsCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  ListUpdatesCommandInput,
  ListUpdatesCommandOutput,
} from "./commands/ListUpdatesCommand";
import {
  RegisterClusterCommandInput,
  RegisterClusterCommandOutput,
} from "./commands/RegisterClusterCommand";
import {
  TagResourceCommandInput,
  TagResourceCommandOutput,
} from "./commands/TagResourceCommand";
import {
  UntagResourceCommandInput,
  UntagResourceCommandOutput,
} from "./commands/UntagResourceCommand";
import {
  UpdateAccessEntryCommandInput,
  UpdateAccessEntryCommandOutput,
} from "./commands/UpdateAccessEntryCommand";
import {
  UpdateAddonCommandInput,
  UpdateAddonCommandOutput,
} from "./commands/UpdateAddonCommand";
import {
  UpdateClusterConfigCommandInput,
  UpdateClusterConfigCommandOutput,
} from "./commands/UpdateClusterConfigCommand";
import {
  UpdateClusterVersionCommandInput,
  UpdateClusterVersionCommandOutput,
} from "./commands/UpdateClusterVersionCommand";
import {
  UpdateEksAnywhereSubscriptionCommandInput,
  UpdateEksAnywhereSubscriptionCommandOutput,
} from "./commands/UpdateEksAnywhereSubscriptionCommand";
import {
  UpdateNodegroupConfigCommandInput,
  UpdateNodegroupConfigCommandOutput,
} from "./commands/UpdateNodegroupConfigCommand";
import {
  UpdateNodegroupVersionCommandInput,
  UpdateNodegroupVersionCommandOutput,
} from "./commands/UpdateNodegroupVersionCommand";
import {
  UpdatePodIdentityAssociationCommandInput,
  UpdatePodIdentityAssociationCommandOutput,
} from "./commands/UpdatePodIdentityAssociationCommand";
import {
  ClientInputEndpointParameters,
  ClientResolvedEndpointParameters,
  EndpointParameters,
} from "./endpoint/EndpointParameters";
import { RuntimeExtension, RuntimeExtensionsConfig } from "./runtimeExtensions";
export { __Client };
export type ServiceInputTypes =
  | AssociateAccessPolicyCommandInput
  | AssociateEncryptionConfigCommandInput
  | AssociateIdentityProviderConfigCommandInput
  | CreateAccessEntryCommandInput
  | CreateAddonCommandInput
  | CreateClusterCommandInput
  | CreateEksAnywhereSubscriptionCommandInput
  | CreateFargateProfileCommandInput
  | CreateNodegroupCommandInput
  | CreatePodIdentityAssociationCommandInput
  | DeleteAccessEntryCommandInput
  | DeleteAddonCommandInput
  | DeleteClusterCommandInput
  | DeleteEksAnywhereSubscriptionCommandInput
  | DeleteFargateProfileCommandInput
  | DeleteNodegroupCommandInput
  | DeletePodIdentityAssociationCommandInput
  | DeregisterClusterCommandInput
  | DescribeAccessEntryCommandInput
  | DescribeAddonCommandInput
  | DescribeAddonConfigurationCommandInput
  | DescribeAddonVersionsCommandInput
  | DescribeClusterCommandInput
  | DescribeClusterVersionsCommandInput
  | DescribeEksAnywhereSubscriptionCommandInput
  | DescribeFargateProfileCommandInput
  | DescribeIdentityProviderConfigCommandInput
  | DescribeInsightCommandInput
  | DescribeNodegroupCommandInput
  | DescribePodIdentityAssociationCommandInput
  | DescribeUpdateCommandInput
  | DisassociateAccessPolicyCommandInput
  | DisassociateIdentityProviderConfigCommandInput
  | ListAccessEntriesCommandInput
  | ListAccessPoliciesCommandInput
  | ListAddonsCommandInput
  | ListAssociatedAccessPoliciesCommandInput
  | ListClustersCommandInput
  | ListEksAnywhereSubscriptionsCommandInput
  | ListFargateProfilesCommandInput
  | ListIdentityProviderConfigsCommandInput
  | ListInsightsCommandInput
  | ListNodegroupsCommandInput
  | ListPodIdentityAssociationsCommandInput
  | ListTagsForResourceCommandInput
  | ListUpdatesCommandInput
  | RegisterClusterCommandInput
  | TagResourceCommandInput
  | UntagResourceCommandInput
  | UpdateAccessEntryCommandInput
  | UpdateAddonCommandInput
  | UpdateClusterConfigCommandInput
  | UpdateClusterVersionCommandInput
  | UpdateEksAnywhereSubscriptionCommandInput
  | UpdateNodegroupConfigCommandInput
  | UpdateNodegroupVersionCommandInput
  | UpdatePodIdentityAssociationCommandInput;
export type ServiceOutputTypes =
  | AssociateAccessPolicyCommandOutput
  | AssociateEncryptionConfigCommandOutput
  | AssociateIdentityProviderConfigCommandOutput
  | CreateAccessEntryCommandOutput
  | CreateAddonCommandOutput
  | CreateClusterCommandOutput
  | CreateEksAnywhereSubscriptionCommandOutput
  | CreateFargateProfileCommandOutput
  | CreateNodegroupCommandOutput
  | CreatePodIdentityAssociationCommandOutput
  | DeleteAccessEntryCommandOutput
  | DeleteAddonCommandOutput
  | DeleteClusterCommandOutput
  | DeleteEksAnywhereSubscriptionCommandOutput
  | DeleteFargateProfileCommandOutput
  | DeleteNodegroupCommandOutput
  | DeletePodIdentityAssociationCommandOutput
  | DeregisterClusterCommandOutput
  | DescribeAccessEntryCommandOutput
  | DescribeAddonCommandOutput
  | DescribeAddonConfigurationCommandOutput
  | DescribeAddonVersionsCommandOutput
  | DescribeClusterCommandOutput
  | DescribeClusterVersionsCommandOutput
  | DescribeEksAnywhereSubscriptionCommandOutput
  | DescribeFargateProfileCommandOutput
  | DescribeIdentityProviderConfigCommandOutput
  | DescribeInsightCommandOutput
  | DescribeNodegroupCommandOutput
  | DescribePodIdentityAssociationCommandOutput
  | DescribeUpdateCommandOutput
  | DisassociateAccessPolicyCommandOutput
  | DisassociateIdentityProviderConfigCommandOutput
  | ListAccessEntriesCommandOutput
  | ListAccessPoliciesCommandOutput
  | ListAddonsCommandOutput
  | ListAssociatedAccessPoliciesCommandOutput
  | ListClustersCommandOutput
  | ListEksAnywhereSubscriptionsCommandOutput
  | ListFargateProfilesCommandOutput
  | ListIdentityProviderConfigsCommandOutput
  | ListInsightsCommandOutput
  | ListNodegroupsCommandOutput
  | ListPodIdentityAssociationsCommandOutput
  | ListTagsForResourceCommandOutput
  | ListUpdatesCommandOutput
  | RegisterClusterCommandOutput
  | TagResourceCommandOutput
  | UntagResourceCommandOutput
  | UpdateAccessEntryCommandOutput
  | UpdateAddonCommandOutput
  | UpdateClusterConfigCommandOutput
  | UpdateClusterVersionCommandOutput
  | UpdateEksAnywhereSubscriptionCommandOutput
  | UpdateNodegroupConfigCommandOutput
  | UpdateNodegroupVersionCommandOutput
  | UpdatePodIdentityAssociationCommandOutput;
export interface ClientDefaults
  extends Partial<__SmithyConfiguration<__HttpHandlerOptions>> {
  requestHandler?: __HttpHandlerUserInput;
  sha256?: __ChecksumConstructor | __HashConstructor;
  urlParser?: __UrlParser;
  bodyLengthChecker?: __BodyLengthCalculator;
  streamCollector?: __StreamCollector;
  base64Decoder?: __Decoder;
  base64Encoder?: __Encoder;
  utf8Decoder?: __Decoder;
  utf8Encoder?: __Encoder;
  runtime?: string;
  disableHostPrefix?: boolean;
  serviceId?: string;
  useDualstackEndpoint?: boolean | __Provider<boolean>;
  useFipsEndpoint?: boolean | __Provider<boolean>;
  region?: string | __Provider<string>;
  profile?: string;
  defaultUserAgentProvider?: Provider<__UserAgent>;
  credentialDefaultProvider?: (input: any) => AwsCredentialIdentityProvider;
  maxAttempts?: number | __Provider<number>;
  retryMode?: string | __Provider<string>;
  logger?: __Logger;
  extensions?: RuntimeExtension[];
  defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
export type EKSClientConfigType = Partial<
  __SmithyConfiguration<__HttpHandlerOptions>
> &
  ClientDefaults &
  UserAgentInputConfig &
  RetryInputConfig &
  RegionInputConfig &
  HostHeaderInputConfig &
  EndpointInputConfig<EndpointParameters> &
  HttpAuthSchemeInputConfig &
  ClientInputEndpointParameters;
export interface EKSClientConfig extends EKSClientConfigType {}
export type EKSClientResolvedConfigType =
  __SmithyResolvedConfiguration<__HttpHandlerOptions> &
    Required<ClientDefaults> &
    RuntimeExtensionsConfig &
    UserAgentResolvedConfig &
    RetryResolvedConfig &
    RegionResolvedConfig &
    HostHeaderResolvedConfig &
    EndpointResolvedConfig<EndpointParameters> &
    HttpAuthSchemeResolvedConfig &
    ClientResolvedEndpointParameters;
export interface EKSClientResolvedConfig extends EKSClientResolvedConfigType {}
export declare class EKSClient extends __Client<
  __HttpHandlerOptions,
  ServiceInputTypes,
  ServiceOutputTypes,
  EKSClientResolvedConfig
> {
  readonly config: EKSClientResolvedConfig;
  constructor(...[configuration]: __CheckOptionalClientConfig<EKSClientConfig>);
  destroy(): void;
}
