import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EKSClient";
import { ListAssociatedAccessPoliciesRequest, ListAssociatedAccessPoliciesResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ListAssociatedAccessPoliciesCommand}.
 */
export interface ListAssociatedAccessPoliciesCommandInput extends ListAssociatedAccessPoliciesRequest {
}
/**
 * @public
 *
 * The output of {@link ListAssociatedAccessPoliciesCommand}.
 */
export interface ListAssociatedAccessPoliciesCommandOutput extends ListAssociatedAccessPoliciesResponse, __MetadataBearer {
}
declare const ListAssociatedAccessPoliciesCommand_base: {
    new (input: ListAssociatedAccessPoliciesCommandInput): import("@smithy/smithy-client").CommandImpl<ListAssociatedAccessPoliciesCommandInput, ListAssociatedAccessPoliciesCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: ListAssociatedAccessPoliciesCommandInput): import("@smithy/smithy-client").CommandImpl<ListAssociatedAccessPoliciesCommandInput, ListAssociatedAccessPoliciesCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Lists the access policies associated with an access entry.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EKSClient, ListAssociatedAccessPoliciesCommand } from "@aws-sdk/client-eks"; // ES Modules import
 * // const { EKSClient, ListAssociatedAccessPoliciesCommand } = require("@aws-sdk/client-eks"); // CommonJS import
 * const client = new EKSClient(config);
 * const input = { // ListAssociatedAccessPoliciesRequest
 *   clusterName: "STRING_VALUE", // required
 *   principalArn: "STRING_VALUE", // required
 *   maxResults: Number("int"),
 *   nextToken: "STRING_VALUE",
 * };
 * const command = new ListAssociatedAccessPoliciesCommand(input);
 * const response = await client.send(command);
 * // { // ListAssociatedAccessPoliciesResponse
 * //   clusterName: "STRING_VALUE",
 * //   principalArn: "STRING_VALUE",
 * //   nextToken: "STRING_VALUE",
 * //   associatedAccessPolicies: [ // AssociatedAccessPoliciesList
 * //     { // AssociatedAccessPolicy
 * //       policyArn: "STRING_VALUE",
 * //       accessScope: { // AccessScope
 * //         type: "cluster" || "namespace",
 * //         namespaces: [ // StringList
 * //           "STRING_VALUE",
 * //         ],
 * //       },
 * //       associatedAt: new Date("TIMESTAMP"),
 * //       modifiedAt: new Date("TIMESTAMP"),
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param ListAssociatedAccessPoliciesCommandInput - {@link ListAssociatedAccessPoliciesCommandInput}
 * @returns {@link ListAssociatedAccessPoliciesCommandOutput}
 * @see {@link ListAssociatedAccessPoliciesCommandInput} for command's `input` shape.
 * @see {@link ListAssociatedAccessPoliciesCommandOutput} for command's `response` shape.
 * @see {@link EKSClientResolvedConfig | config} for EKSClient's `config` shape.
 *
 * @throws {@link InvalidRequestException} (client fault)
 *  <p>The request is invalid given the state of the cluster. Check the state of the cluster
 *             and the associated operations.</p>
 *
 * @throws {@link ResourceNotFoundException} (client fault)
 *  <p>The specified resource could not be found. You can view your available clusters with
 *                 <code>ListClusters</code>. You can view your available managed node groups with
 *                 <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Amazon Web Services Region
 *             specific.</p>
 *
 * @throws {@link ServerException} (server fault)
 *  <p>These errors are usually caused by a server-side issue.</p>
 *
 * @throws {@link EKSServiceException}
 * <p>Base exception class for all service exceptions from EKS service.</p>
 *
 *
 * @public
 */
export declare class ListAssociatedAccessPoliciesCommand extends ListAssociatedAccessPoliciesCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ListAssociatedAccessPoliciesRequest;
            output: ListAssociatedAccessPoliciesResponse;
        };
        sdk: {
            input: ListAssociatedAccessPoliciesCommandInput;
            output: ListAssociatedAccessPoliciesCommandOutput;
        };
    };
}
