import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EKSClient";
import { DescribeAccessEntryRequest, DescribeAccessEntryResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DescribeAccessEntryCommand}.
 */
export interface DescribeAccessEntryCommandInput extends DescribeAccessEntryRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeAccessEntryCommand}.
 */
export interface DescribeAccessEntryCommandOutput extends DescribeAccessEntryResponse, __MetadataBearer {
}
declare const DescribeAccessEntryCommand_base: {
    new (input: DescribeAccessEntryCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeAccessEntryCommandInput, DescribeAccessEntryCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DescribeAccessEntryCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeAccessEntryCommandInput, DescribeAccessEntryCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes an access entry.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EKSClient, DescribeAccessEntryCommand } from "@aws-sdk/client-eks"; // ES Modules import
 * // const { EKSClient, DescribeAccessEntryCommand } = require("@aws-sdk/client-eks"); // CommonJS import
 * const client = new EKSClient(config);
 * const input = { // DescribeAccessEntryRequest
 *   clusterName: "STRING_VALUE", // required
 *   principalArn: "STRING_VALUE", // required
 * };
 * const command = new DescribeAccessEntryCommand(input);
 * const response = await client.send(command);
 * // { // DescribeAccessEntryResponse
 * //   accessEntry: { // AccessEntry
 * //     clusterName: "STRING_VALUE",
 * //     principalArn: "STRING_VALUE",
 * //     kubernetesGroups: [ // StringList
 * //       "STRING_VALUE",
 * //     ],
 * //     accessEntryArn: "STRING_VALUE",
 * //     createdAt: new Date("TIMESTAMP"),
 * //     modifiedAt: new Date("TIMESTAMP"),
 * //     tags: { // TagMap
 * //       "<keys>": "STRING_VALUE",
 * //     },
 * //     username: "STRING_VALUE",
 * //     type: "STRING_VALUE",
 * //   },
 * // };
 *
 * ```
 *
 * @param DescribeAccessEntryCommandInput - {@link DescribeAccessEntryCommandInput}
 * @returns {@link DescribeAccessEntryCommandOutput}
 * @see {@link DescribeAccessEntryCommandInput} for command's `input` shape.
 * @see {@link DescribeAccessEntryCommandOutput} for command's `response` shape.
 * @see {@link EKSClientResolvedConfig | config} for EKSClient's `config` shape.
 *
 * @throws {@link InvalidRequestException} (client fault)
 *  <p>The request is invalid given the state of the cluster. Check the state of the cluster
 *             and the associated operations.</p>
 *
 * @throws {@link ResourceNotFoundException} (client fault)
 *  <p>The specified resource could not be found. You can view your available clusters with
 *                 <code>ListClusters</code>. You can view your available managed node groups with
 *                 <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Amazon Web Services Region
 *             specific.</p>
 *
 * @throws {@link ServerException} (server fault)
 *  <p>These errors are usually caused by a server-side issue.</p>
 *
 * @throws {@link EKSServiceException}
 * <p>Base exception class for all service exceptions from EKS service.</p>
 *
 *
 * @public
 */
export declare class DescribeAccessEntryCommand extends DescribeAccessEntryCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DescribeAccessEntryRequest;
            output: DescribeAccessEntryResponse;
        };
        sdk: {
            input: DescribeAccessEntryCommandInput;
            output: DescribeAccessEntryCommandOutput;
        };
    };
}
