import { checkExceptions, createWaiter, WaiterState } from "@smithy/util-waiter";
import { DescribeNodegroupCommand } from "../commands/DescribeNodegroupCommand";
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeNodegroupCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.nodegroup.status;
            };
            if (returnComparator() === "DELETE_FAILED") {
                return { state: WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "ResourceNotFoundException") {
            return { state: WaiterState.SUCCESS, reason };
        }
    }
    return { state: WaiterState.RETRY, reason };
};
export const waitForNodegroupDeleted = async (params, input) => {
    const serviceDefaults = { minDelay: 30, maxDelay: 120 };
    return createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
export const waitUntilNodegroupDeleted = async (params, input) => {
    const serviceDefaults = { minDelay: 30, maxDelay: 120 };
    const result = await createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return checkExceptions(result);
};
