import { checkExceptions, createWaiter, WaiterState } from "@smithy/util-waiter";
import { DescribeFargateProfileCommand, } from "../commands/DescribeFargateProfileCommand";
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeFargateProfileCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.fargateProfile.status;
            };
            if (returnComparator() === "DELETE_FAILED") {
                return { state: WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "ResourceNotFoundException") {
            return { state: WaiterState.SUCCESS, reason };
        }
    }
    return { state: WaiterState.RETRY, reason };
};
export const waitForFargateProfileDeleted = async (params, input) => {
    const serviceDefaults = { minDelay: 30, maxDelay: 120 };
    return createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
export const waitUntilFargateProfileDeleted = async (params, input) => {
    const serviceDefaults = { minDelay: 30, maxDelay: 120 };
    const result = await createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return checkExceptions(result);
};
