import { checkExceptions, createWaiter, WaiterState } from "@smithy/util-waiter";
import { DescribeFargateProfileCommand, } from "../commands/DescribeFargateProfileCommand";
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeFargateProfileCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.fargateProfile.status;
            };
            if (returnComparator() === "CREATE_FAILED") {
                return { state: WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                return result.fargateProfile.status;
            };
            if (returnComparator() === "ACTIVE") {
                return { state: WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: WaiterState.RETRY, reason };
};
export const waitForFargateProfileActive = async (params, input) => {
    const serviceDefaults = { minDelay: 10, maxDelay: 120 };
    return createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
export const waitUntilFargateProfileActive = async (params, input) => {
    const serviceDefaults = { minDelay: 10, maxDelay: 120 };
    const result = await createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return checkExceptions(result);
};
