import { checkExceptions, createWaiter, WaiterState } from "@smithy/util-waiter";
import { DescribeClusterCommand } from "../commands/DescribeClusterCommand";
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeClusterCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.cluster.status;
            };
            if (returnComparator() === "ACTIVE") {
                return { state: WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                return result.cluster.status;
            };
            if (returnComparator() === "CREATING") {
                return { state: WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                return result.cluster.status;
            };
            if (returnComparator() === "PENDING") {
                return { state: WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "ResourceNotFoundException") {
            return { state: WaiterState.SUCCESS, reason };
        }
    }
    return { state: WaiterState.RETRY, reason };
};
export const waitForClusterDeleted = async (params, input) => {
    const serviceDefaults = { minDelay: 30, maxDelay: 120 };
    return createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
export const waitUntilClusterDeleted = async (params, input) => {
    const serviceDefaults = { minDelay: 30, maxDelay: 120 };
    const result = await createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return checkExceptions(result);
};
