import { loadRestJsonErrorCode, parseJsonBody as parseBody, parseJsonErrorBody as parseErrorBody } from "@aws-sdk/core";
import { requestBuilder as rb } from "@smithy/core";
import { _json, collectBody, decorateServiceException as __decorateServiceException, expectBoolean as __expectBoolean, expectInt32 as __expectInt32, expectNonNull as __expectNonNull, expectNumber as __expectNumber, expectObject as __expectObject, expectString as __expectString, map, parseEpochTimestamp as __parseEpochTimestamp, take, withBaseException, } from "@smithy/smithy-client";
import { v4 as generateIdempotencyToken } from "uuid";
import { EKSServiceException as __BaseException } from "../models/EKSServiceException";
import { AccessDeniedException, BadRequestException, ClientException, InvalidParameterException, InvalidRequestException, InvalidStateException, NotFoundException, ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException, ResourcePropagationDelayException, ServerException, ServiceUnavailableException, ThrottlingException, UnsupportedAvailabilityZoneException, } from "../models/models_0";
export const se_AssociateAccessPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/access-entries/{principalArn}/access-policies");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("principalArn", () => input.principalArn, "{principalArn}", false);
    let body;
    body = JSON.stringify(take(input, {
        accessScope: (_) => _json(_),
        policyArn: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_AssociateEncryptionConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/encryption-config/associate");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        encryptionConfig: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_AssociateIdentityProviderConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/identity-provider-configs/associate");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        oidc: (_) => _json(_),
        tags: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateAccessEntryCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/access-entries");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        kubernetesGroups: (_) => _json(_),
        principalArn: [],
        tags: (_) => _json(_),
        type: [],
        username: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateAddonCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/addons");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    let body;
    body = JSON.stringify(take(input, {
        addonName: [],
        addonVersion: [],
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        configurationValues: [],
        podIdentityAssociations: (_) => _json(_),
        resolveConflicts: [],
        serviceAccountRoleArn: [],
        tags: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateClusterCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters");
    let body;
    body = JSON.stringify(take(input, {
        accessConfig: (_) => _json(_),
        bootstrapSelfManagedAddons: [],
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        computeConfig: (_) => _json(_),
        encryptionConfig: (_) => _json(_),
        kubernetesNetworkConfig: (_) => _json(_),
        logging: (_) => _json(_),
        name: [],
        outpostConfig: (_) => _json(_),
        remoteNetworkConfig: (_) => _json(_),
        resourcesVpcConfig: (_) => _json(_),
        roleArn: [],
        storageConfig: (_) => _json(_),
        tags: (_) => _json(_),
        upgradePolicy: (_) => _json(_),
        version: [],
        zonalShiftConfig: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateEksAnywhereSubscriptionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/eks-anywhere-subscriptions");
    let body;
    body = JSON.stringify(take(input, {
        autoRenew: [],
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        licenseQuantity: [],
        licenseType: [],
        name: [],
        tags: (_) => _json(_),
        term: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateFargateProfileCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/fargate-profiles");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        fargateProfileName: [],
        podExecutionRoleArn: [],
        selectors: (_) => _json(_),
        subnets: (_) => _json(_),
        tags: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateNodegroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/node-groups");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    let body;
    body = JSON.stringify(take(input, {
        amiType: [],
        capacityType: [],
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        diskSize: [],
        instanceTypes: (_) => _json(_),
        labels: (_) => _json(_),
        launchTemplate: (_) => _json(_),
        nodeRepairConfig: (_) => _json(_),
        nodeRole: [],
        nodegroupName: [],
        releaseVersion: [],
        remoteAccess: (_) => _json(_),
        scalingConfig: (_) => _json(_),
        subnets: (_) => _json(_),
        tags: (_) => _json(_),
        taints: (_) => _json(_),
        updateConfig: (_) => _json(_),
        version: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreatePodIdentityAssociationCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/pod-identity-associations");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        disableSessionTags: [],
        namespace: [],
        roleArn: [],
        serviceAccount: [],
        tags: (_) => _json(_),
        targetRoleArn: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_DeleteAccessEntryCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/access-entries/{principalArn}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("principalArn", () => input.principalArn, "{principalArn}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteAddonCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/addons/{addonName}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("addonName", () => input.addonName, "{addonName}", false);
    const query = map({
        [_p]: [() => input.preserve !== void 0, () => input[_p].toString()],
    });
    let body;
    b.m("DELETE").h(headers).q(query).b(body);
    return b.build();
};
export const se_DeleteClusterCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{name}");
    b.p("name", () => input.name, "{name}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteEksAnywhereSubscriptionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/eks-anywhere-subscriptions/{id}");
    b.p("id", () => input.id, "{id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteFargateProfileCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/fargate-profiles/{fargateProfileName}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("fargateProfileName", () => input.fargateProfileName, "{fargateProfileName}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteNodegroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/node-groups/{nodegroupName}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("nodegroupName", () => input.nodegroupName, "{nodegroupName}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeletePodIdentityAssociationCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/pod-identity-associations/{associationId}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("associationId", () => input.associationId, "{associationId}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeregisterClusterCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/cluster-registrations/{name}");
    b.p("name", () => input.name, "{name}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DescribeAccessEntryCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/access-entries/{principalArn}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("principalArn", () => input.principalArn, "{principalArn}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_DescribeAddonCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/addons/{addonName}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("addonName", () => input.addonName, "{addonName}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_DescribeAddonConfigurationCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/addons/configuration-schemas");
    const query = map({
        [_aN]: [, __expectNonNull(input[_aN], `addonName`)],
        [_aV]: [, __expectNonNull(input[_aV], `addonVersion`)],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_DescribeAddonVersionsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/addons/supported-versions");
    const query = map({
        [_kV]: [, input[_kV]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_aN]: [, input[_aN]],
        [_t]: [() => input.types !== void 0, () => input[_t] || []],
        [_pu]: [() => input.publishers !== void 0, () => input[_pu] || []],
        [_o]: [() => input.owners !== void 0, () => input[_o] || []],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_DescribeClusterCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{name}");
    b.p("name", () => input.name, "{name}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_DescribeClusterVersionsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/cluster-versions");
    const query = map({
        [_cT]: [, input[_cT]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_dO]: [() => input.defaultOnly !== void 0, () => input[_dO].toString()],
        [_iA]: [() => input.includeAll !== void 0, () => input[_iA].toString()],
        [_cV]: [() => input.clusterVersions !== void 0, () => input[_cV] || []],
        [_s]: [, input[_s]],
        [_vS]: [, input[_vS]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_DescribeEksAnywhereSubscriptionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/eks-anywhere-subscriptions/{id}");
    b.p("id", () => input.id, "{id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_DescribeFargateProfileCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/fargate-profiles/{fargateProfileName}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("fargateProfileName", () => input.fargateProfileName, "{fargateProfileName}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_DescribeIdentityProviderConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/identity-provider-configs/describe");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    let body;
    body = JSON.stringify(take(input, {
        identityProviderConfig: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_DescribeInsightCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/insights/{id}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("id", () => input.id, "{id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_DescribeNodegroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/node-groups/{nodegroupName}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("nodegroupName", () => input.nodegroupName, "{nodegroupName}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_DescribePodIdentityAssociationCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/pod-identity-associations/{associationId}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("associationId", () => input.associationId, "{associationId}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_DescribeUpdateCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{name}/updates/{updateId}");
    b.p("name", () => input.name, "{name}", false);
    b.p("updateId", () => input.updateId, "{updateId}", false);
    const query = map({
        [_nN]: [, input[_nN]],
        [_aN]: [, input[_aN]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_DisassociateAccessPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/access-entries/{principalArn}/access-policies/{policyArn}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("principalArn", () => input.principalArn, "{principalArn}", false);
    b.p("policyArn", () => input.policyArn, "{policyArn}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DisassociateIdentityProviderConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/identity-provider-configs/disassociate");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        identityProviderConfig: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_ListAccessEntriesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/access-entries");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    const query = map({
        [_aPA]: [, input[_aPA]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListAccessPoliciesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/access-policies");
    const query = map({
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListAddonsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/addons");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    const query = map({
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListAssociatedAccessPoliciesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/access-entries/{principalArn}/access-policies");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("principalArn", () => input.principalArn, "{principalArn}", false);
    const query = map({
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListClustersCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters");
    const query = map({
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_i]: [() => input.include !== void 0, () => input[_i] || []],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListEksAnywhereSubscriptionsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/eks-anywhere-subscriptions");
    const query = map({
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
        [_iS]: [() => input.includeStatus !== void 0, () => input[_iS] || []],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListFargateProfilesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/fargate-profiles");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    const query = map({
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListIdentityProviderConfigsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/identity-provider-configs");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    const query = map({
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListInsightsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/insights");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    let body;
    body = JSON.stringify(take(input, {
        filter: (_) => _json(_),
        maxResults: [],
        nextToken: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_ListNodegroupsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/node-groups");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    const query = map({
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListPodIdentityAssociationsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{clusterName}/pod-identity-associations");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    const query = map({
        [_n]: [, input[_n]],
        [_sA]: [, input[_sA]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
        [_nT]: [, input[_nT]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListTagsForResourceCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/tags/{resourceArn}");
    b.p("resourceArn", () => input.resourceArn, "{resourceArn}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_ListUpdatesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/clusters/{name}/updates");
    b.p("name", () => input.name, "{name}", false);
    const query = map({
        [_nN]: [, input[_nN]],
        [_aN]: [, input[_aN]],
        [_nT]: [, input[_nT]],
        [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_RegisterClusterCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/cluster-registrations");
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        connectorConfig: (_) => _json(_),
        name: [],
        tags: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_TagResourceCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/tags/{resourceArn}");
    b.p("resourceArn", () => input.resourceArn, "{resourceArn}", false);
    let body;
    body = JSON.stringify(take(input, {
        tags: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_UntagResourceCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/tags/{resourceArn}");
    b.p("resourceArn", () => input.resourceArn, "{resourceArn}", false);
    const query = map({
        [_tK]: [__expectNonNull(input.tagKeys, `tagKeys`) != null, () => input[_tK] || []],
    });
    let body;
    b.m("DELETE").h(headers).q(query).b(body);
    return b.build();
};
export const se_UpdateAccessEntryCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/access-entries/{principalArn}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("principalArn", () => input.principalArn, "{principalArn}", false);
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        kubernetesGroups: (_) => _json(_),
        username: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_UpdateAddonCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/addons/{addonName}/update");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("addonName", () => input.addonName, "{addonName}", false);
    let body;
    body = JSON.stringify(take(input, {
        addonVersion: [],
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        configurationValues: [],
        podIdentityAssociations: (_) => _json(_),
        resolveConflicts: [],
        serviceAccountRoleArn: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_UpdateClusterConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{name}/update-config");
    b.p("name", () => input.name, "{name}", false);
    let body;
    body = JSON.stringify(take(input, {
        accessConfig: (_) => _json(_),
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        computeConfig: (_) => _json(_),
        kubernetesNetworkConfig: (_) => _json(_),
        logging: (_) => _json(_),
        remoteNetworkConfig: (_) => _json(_),
        resourcesVpcConfig: (_) => _json(_),
        storageConfig: (_) => _json(_),
        upgradePolicy: (_) => _json(_),
        zonalShiftConfig: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_UpdateClusterVersionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{name}/updates");
    b.p("name", () => input.name, "{name}", false);
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        force: [],
        version: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_UpdateEksAnywhereSubscriptionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/eks-anywhere-subscriptions/{id}");
    b.p("id", () => input.id, "{id}", false);
    let body;
    body = JSON.stringify(take(input, {
        autoRenew: [],
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_UpdateNodegroupConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/node-groups/{nodegroupName}/update-config");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("nodegroupName", () => input.nodegroupName, "{nodegroupName}", false);
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        labels: (_) => _json(_),
        nodeRepairConfig: (_) => _json(_),
        scalingConfig: (_) => _json(_),
        taints: (_) => _json(_),
        updateConfig: (_) => _json(_),
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_UpdateNodegroupVersionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/node-groups/{nodegroupName}/update-version");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("nodegroupName", () => input.nodegroupName, "{nodegroupName}", false);
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        force: [],
        launchTemplate: (_) => _json(_),
        releaseVersion: [],
        version: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_UpdatePodIdentityAssociationCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/json",
    };
    b.bp("/clusters/{clusterName}/pod-identity-associations/{associationId}");
    b.p("clusterName", () => input.clusterName, "{clusterName}", false);
    b.p("associationId", () => input.associationId, "{associationId}", false);
    let body;
    body = JSON.stringify(take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        disableSessionTags: [],
        roleArn: [],
        targetRoleArn: [],
    }));
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const de_AssociateAccessPolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        associatedAccessPolicy: (_) => de_AssociatedAccessPolicy(_, context),
        clusterName: __expectString,
        principalArn: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_AssociateEncryptionConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        update: (_) => de_Update(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_AssociateIdentityProviderConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        tags: _json,
        update: (_) => de_Update(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_CreateAccessEntryCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        accessEntry: (_) => de_AccessEntry(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_CreateAddonCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        addon: (_) => de_Addon(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_CreateClusterCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        cluster: (_) => de_Cluster(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_CreateEksAnywhereSubscriptionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        subscription: (_) => de_EksAnywhereSubscription(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_CreateFargateProfileCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        fargateProfile: (_) => de_FargateProfile(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_CreateNodegroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        nodegroup: (_) => de_Nodegroup(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_CreatePodIdentityAssociationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        association: (_) => de_PodIdentityAssociation(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DeleteAccessEntryCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteAddonCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        addon: (_) => de_Addon(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DeleteClusterCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        cluster: (_) => de_Cluster(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DeleteEksAnywhereSubscriptionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        subscription: (_) => de_EksAnywhereSubscription(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DeleteFargateProfileCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        fargateProfile: (_) => de_FargateProfile(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DeleteNodegroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        nodegroup: (_) => de_Nodegroup(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DeletePodIdentityAssociationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        association: (_) => de_PodIdentityAssociation(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DeregisterClusterCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        cluster: (_) => de_Cluster(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeAccessEntryCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        accessEntry: (_) => de_AccessEntry(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeAddonCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        addon: (_) => de_Addon(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeAddonConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        addonName: __expectString,
        addonVersion: __expectString,
        configurationSchema: __expectString,
        podIdentityConfiguration: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeAddonVersionsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        addons: _json,
        nextToken: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeClusterCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        cluster: (_) => de_Cluster(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeClusterVersionsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        clusterVersions: (_) => de_ClusterVersionList(_, context),
        nextToken: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeEksAnywhereSubscriptionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        subscription: (_) => de_EksAnywhereSubscription(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeFargateProfileCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        fargateProfile: (_) => de_FargateProfile(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeIdentityProviderConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        identityProviderConfig: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeInsightCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        insight: (_) => de_Insight(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeNodegroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        nodegroup: (_) => de_Nodegroup(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribePodIdentityAssociationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        association: (_) => de_PodIdentityAssociation(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DescribeUpdateCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        update: (_) => de_Update(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_DisassociateAccessPolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DisassociateIdentityProviderConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        update: (_) => de_Update(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListAccessEntriesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        accessEntries: _json,
        nextToken: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListAccessPoliciesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        accessPolicies: _json,
        nextToken: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListAddonsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        addons: _json,
        nextToken: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListAssociatedAccessPoliciesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        associatedAccessPolicies: (_) => de_AssociatedAccessPoliciesList(_, context),
        clusterName: __expectString,
        nextToken: __expectString,
        principalArn: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListClustersCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        clusters: _json,
        nextToken: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListEksAnywhereSubscriptionsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        nextToken: __expectString,
        subscriptions: (_) => de_EksAnywhereSubscriptionList(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListFargateProfilesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        fargateProfileNames: _json,
        nextToken: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListIdentityProviderConfigsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        identityProviderConfigs: _json,
        nextToken: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListInsightsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        insights: (_) => de_InsightSummaries(_, context),
        nextToken: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListNodegroupsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        nextToken: __expectString,
        nodegroups: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListPodIdentityAssociationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        associations: _json,
        nextToken: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        tags: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_ListUpdatesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        nextToken: __expectString,
        updateIds: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_RegisterClusterCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        cluster: (_) => de_Cluster(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_TagResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_UntagResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_UpdateAccessEntryCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        accessEntry: (_) => de_AccessEntry(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_UpdateAddonCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        update: (_) => de_Update(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_UpdateClusterConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        update: (_) => de_Update(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_UpdateClusterVersionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        update: (_) => de_Update(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_UpdateEksAnywhereSubscriptionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        subscription: (_) => de_EksAnywhereSubscription(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_UpdateNodegroupConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        update: (_) => de_Update(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_UpdateNodegroupVersionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        update: (_) => de_Update(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
export const de_UpdatePodIdentityAssociationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        association: (_) => de_PodIdentityAssociation(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.eks#InvalidParameterException":
            throw await de_InvalidParameterExceptionRes(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.eks#InvalidRequestException":
            throw await de_InvalidRequestExceptionRes(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.eks#ResourceNotFoundException":
            throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
        case "ServerException":
        case "com.amazonaws.eks#ServerException":
            throw await de_ServerExceptionRes(parsedOutput, context);
        case "ClientException":
        case "com.amazonaws.eks#ClientException":
            throw await de_ClientExceptionRes(parsedOutput, context);
        case "ResourceInUseException":
        case "com.amazonaws.eks#ResourceInUseException":
            throw await de_ResourceInUseExceptionRes(parsedOutput, context);
        case "ThrottlingException":
        case "com.amazonaws.eks#ThrottlingException":
            throw await de_ThrottlingExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.eks#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.eks#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "UnsupportedAvailabilityZoneException":
        case "com.amazonaws.eks#UnsupportedAvailabilityZoneException":
            throw await de_UnsupportedAvailabilityZoneExceptionRes(parsedOutput, context);
        case "AccessDeniedException":
        case "com.amazonaws.eks#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.eks#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.eks#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourcePropagationDelayException":
        case "com.amazonaws.eks#ResourcePropagationDelayException":
            throw await de_ResourcePropagationDelayExceptionRes(parsedOutput, context);
        case "InvalidStateException":
        case "com.amazonaws.eks#InvalidStateException":
            throw await de_InvalidStateExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const throwDefaultError = withBaseException(__BaseException);
const de_AccessDeniedExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new AccessDeniedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_BadRequestExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new BadRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ClientExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        addonName: __expectString,
        clusterName: __expectString,
        message: __expectString,
        nodegroupName: __expectString,
        subscriptionId: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_InvalidParameterExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        addonName: __expectString,
        clusterName: __expectString,
        fargateProfileName: __expectString,
        message: __expectString,
        nodegroupName: __expectString,
        subscriptionId: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new InvalidParameterException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_InvalidRequestExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        addonName: __expectString,
        clusterName: __expectString,
        message: __expectString,
        nodegroupName: __expectString,
        subscriptionId: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new InvalidRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_InvalidStateExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        clusterName: __expectString,
        message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new InvalidStateException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_NotFoundExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new NotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ResourceInUseExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        addonName: __expectString,
        clusterName: __expectString,
        message: __expectString,
        nodegroupName: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ResourceInUseException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ResourceLimitExceededExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        clusterName: __expectString,
        message: __expectString,
        nodegroupName: __expectString,
        subscriptionId: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ResourceLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ResourceNotFoundExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        addonName: __expectString,
        clusterName: __expectString,
        fargateProfileName: __expectString,
        message: __expectString,
        nodegroupName: __expectString,
        subscriptionId: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ResourceNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ResourcePropagationDelayExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ResourcePropagationDelayException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ServerExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        addonName: __expectString,
        clusterName: __expectString,
        message: __expectString,
        nodegroupName: __expectString,
        subscriptionId: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ServerException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ServiceUnavailableExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ServiceUnavailableException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ThrottlingExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        clusterName: __expectString,
        message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ThrottlingException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_UnsupportedAvailabilityZoneExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        clusterName: __expectString,
        message: __expectString,
        nodegroupName: __expectString,
        validZones: _json,
    });
    Object.assign(contents, doc);
    const exception = new UnsupportedAvailabilityZoneException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_AccessEntry = (output, context) => {
    return take(output, {
        accessEntryArn: __expectString,
        clusterName: __expectString,
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        kubernetesGroups: _json,
        modifiedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        principalArn: __expectString,
        tags: _json,
        type: __expectString,
        username: __expectString,
    });
};
const de_Addon = (output, context) => {
    return take(output, {
        addonArn: __expectString,
        addonName: __expectString,
        addonVersion: __expectString,
        clusterName: __expectString,
        configurationValues: __expectString,
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        health: _json,
        marketplaceInformation: _json,
        modifiedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        owner: __expectString,
        podIdentityAssociations: _json,
        publisher: __expectString,
        serviceAccountRoleArn: __expectString,
        status: __expectString,
        tags: _json,
    });
};
const de_AssociatedAccessPoliciesList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AssociatedAccessPolicy(entry, context);
    });
    return retVal;
};
const de_AssociatedAccessPolicy = (output, context) => {
    return take(output, {
        accessScope: _json,
        associatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        modifiedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        policyArn: __expectString,
    });
};
const de_ClientStat = (output, context) => {
    return take(output, {
        lastRequestTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        numberOfRequestsLast30Days: __expectInt32,
        userAgent: __expectString,
    });
};
const de_ClientStats = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ClientStat(entry, context);
    });
    return retVal;
};
const de_Cluster = (output, context) => {
    return take(output, {
        accessConfig: _json,
        arn: __expectString,
        certificateAuthority: _json,
        clientRequestToken: __expectString,
        computeConfig: _json,
        connectorConfig: (_) => de_ConnectorConfigResponse(_, context),
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        encryptionConfig: _json,
        endpoint: __expectString,
        health: _json,
        id: __expectString,
        identity: _json,
        kubernetesNetworkConfig: _json,
        logging: _json,
        name: __expectString,
        outpostConfig: _json,
        platformVersion: __expectString,
        remoteNetworkConfig: _json,
        resourcesVpcConfig: _json,
        roleArn: __expectString,
        status: __expectString,
        storageConfig: _json,
        tags: _json,
        upgradePolicy: _json,
        version: __expectString,
        zonalShiftConfig: _json,
    });
};
const de_ClusterVersionInformation = (output, context) => {
    return take(output, {
        clusterType: __expectString,
        clusterVersion: __expectString,
        defaultPlatformVersion: __expectString,
        defaultVersion: __expectBoolean,
        endOfExtendedSupportDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        endOfStandardSupportDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        kubernetesPatchVersion: __expectString,
        releaseDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        status: __expectString,
        versionStatus: __expectString,
    });
};
const de_ClusterVersionList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ClusterVersionInformation(entry, context);
    });
    return retVal;
};
const de_ConnectorConfigResponse = (output, context) => {
    return take(output, {
        activationCode: __expectString,
        activationExpiry: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        activationId: __expectString,
        provider: __expectString,
        roleArn: __expectString,
    });
};
const de_DeprecationDetail = (output, context) => {
    return take(output, {
        clientStats: (_) => de_ClientStats(_, context),
        replacedWith: __expectString,
        startServingReplacementVersion: __expectString,
        stopServingVersion: __expectString,
        usage: __expectString,
    });
};
const de_DeprecationDetails = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DeprecationDetail(entry, context);
    });
    return retVal;
};
const de_EksAnywhereSubscription = (output, context) => {
    return take(output, {
        arn: __expectString,
        autoRenew: __expectBoolean,
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        effectiveDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        expirationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        id: __expectString,
        licenseArns: _json,
        licenseQuantity: __expectInt32,
        licenseType: __expectString,
        licenses: _json,
        status: __expectString,
        tags: _json,
        term: _json,
    });
};
const de_EksAnywhereSubscriptionList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_EksAnywhereSubscription(entry, context);
    });
    return retVal;
};
const de_FargateProfile = (output, context) => {
    return take(output, {
        clusterName: __expectString,
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        fargateProfileArn: __expectString,
        fargateProfileName: __expectString,
        health: _json,
        podExecutionRoleArn: __expectString,
        selectors: _json,
        status: __expectString,
        subnets: _json,
        tags: _json,
    });
};
const de_Insight = (output, context) => {
    return take(output, {
        additionalInfo: _json,
        category: __expectString,
        categorySpecificSummary: (_) => de_InsightCategorySpecificSummary(_, context),
        description: __expectString,
        id: __expectString,
        insightStatus: _json,
        kubernetesVersion: __expectString,
        lastRefreshTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lastTransitionTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        name: __expectString,
        recommendation: __expectString,
        resources: _json,
    });
};
const de_InsightCategorySpecificSummary = (output, context) => {
    return take(output, {
        addonCompatibilityDetails: _json,
        deprecationDetails: (_) => de_DeprecationDetails(_, context),
    });
};
const de_InsightSummaries = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_InsightSummary(entry, context);
    });
    return retVal;
};
const de_InsightSummary = (output, context) => {
    return take(output, {
        category: __expectString,
        description: __expectString,
        id: __expectString,
        insightStatus: _json,
        kubernetesVersion: __expectString,
        lastRefreshTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lastTransitionTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        name: __expectString,
    });
};
const de_Nodegroup = (output, context) => {
    return take(output, {
        amiType: __expectString,
        capacityType: __expectString,
        clusterName: __expectString,
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        diskSize: __expectInt32,
        health: _json,
        instanceTypes: _json,
        labels: _json,
        launchTemplate: _json,
        modifiedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        nodeRepairConfig: _json,
        nodeRole: __expectString,
        nodegroupArn: __expectString,
        nodegroupName: __expectString,
        releaseVersion: __expectString,
        remoteAccess: _json,
        resources: _json,
        scalingConfig: _json,
        status: __expectString,
        subnets: _json,
        tags: _json,
        taints: _json,
        updateConfig: _json,
        version: __expectString,
    });
};
const de_PodIdentityAssociation = (output, context) => {
    return take(output, {
        associationArn: __expectString,
        associationId: __expectString,
        clusterName: __expectString,
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        disableSessionTags: __expectBoolean,
        externalId: __expectString,
        modifiedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        namespace: __expectString,
        ownerArn: __expectString,
        roleArn: __expectString,
        serviceAccount: __expectString,
        tags: _json,
        targetRoleArn: __expectString,
    });
};
const de_Update = (output, context) => {
    return take(output, {
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        errors: _json,
        id: __expectString,
        params: _json,
        status: __expectString,
        type: __expectString,
    });
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const _aN = "addonName";
const _aPA = "associatedPolicyArn";
const _aV = "addonVersion";
const _cT = "clusterType";
const _cV = "clusterVersions";
const _dO = "defaultOnly";
const _i = "include";
const _iA = "includeAll";
const _iS = "includeStatus";
const _kV = "kubernetesVersion";
const _mR = "maxResults";
const _n = "namespace";
const _nN = "nodegroupName";
const _nT = "nextToken";
const _o = "owners";
const _p = "preserve";
const _pu = "publishers";
const _s = "status";
const _sA = "serviceAccount";
const _t = "types";
const _tK = "tagKeys";
const _vS = "versionStatus";
