import { EKSServiceException as __BaseException } from "./EKSServiceException";
export const AuthenticationMode = {
    API: "API",
    API_AND_CONFIG_MAP: "API_AND_CONFIG_MAP",
    CONFIG_MAP: "CONFIG_MAP",
};
export class AccessDeniedException extends __BaseException {
    name = "AccessDeniedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "AccessDeniedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, AccessDeniedException.prototype);
    }
}
export const AccessScopeType = {
    cluster: "cluster",
    namespace: "namespace",
};
export const AddonIssueCode = {
    ACCESS_DENIED: "AccessDenied",
    ADDON_PERMISSION_FAILURE: "AddonPermissionFailure",
    ADDON_SUBSCRIPTION_NEEDED: "AddonSubscriptionNeeded",
    ADMISSION_REQUEST_DENIED: "AdmissionRequestDenied",
    CLUSTER_UNREACHABLE: "ClusterUnreachable",
    CONFIGURATION_CONFLICT: "ConfigurationConflict",
    INSUFFICIENT_NUMBER_OF_REPLICAS: "InsufficientNumberOfReplicas",
    INTERNAL_FAILURE: "InternalFailure",
    K8S_RESOURCE_NOT_FOUND: "K8sResourceNotFound",
    UNSUPPORTED_ADDON_MODIFICATION: "UnsupportedAddonModification",
};
export const AddonStatus = {
    ACTIVE: "ACTIVE",
    CREATE_FAILED: "CREATE_FAILED",
    CREATING: "CREATING",
    DEGRADED: "DEGRADED",
    DELETE_FAILED: "DELETE_FAILED",
    DELETING: "DELETING",
    UPDATE_FAILED: "UPDATE_FAILED",
    UPDATING: "UPDATING",
};
export const AMITypes = {
    AL2023_ARM_64_NVIDIA: "AL2023_ARM_64_NVIDIA",
    AL2023_ARM_64_STANDARD: "AL2023_ARM_64_STANDARD",
    AL2023_x86_64_NEURON: "AL2023_x86_64_NEURON",
    AL2023_x86_64_NVIDIA: "AL2023_x86_64_NVIDIA",
    AL2023_x86_64_STANDARD: "AL2023_x86_64_STANDARD",
    AL2_ARM_64: "AL2_ARM_64",
    AL2_x86_64: "AL2_x86_64",
    AL2_x86_64_GPU: "AL2_x86_64_GPU",
    BOTTLEROCKET_ARM_64: "BOTTLEROCKET_ARM_64",
    BOTTLEROCKET_ARM_64_FIPS: "BOTTLEROCKET_ARM_64_FIPS",
    BOTTLEROCKET_ARM_64_NVIDIA: "BOTTLEROCKET_ARM_64_NVIDIA",
    BOTTLEROCKET_x86_64: "BOTTLEROCKET_x86_64",
    BOTTLEROCKET_x86_64_FIPS: "BOTTLEROCKET_x86_64_FIPS",
    BOTTLEROCKET_x86_64_NVIDIA: "BOTTLEROCKET_x86_64_NVIDIA",
    CUSTOM: "CUSTOM",
    WINDOWS_CORE_2019_x86_64: "WINDOWS_CORE_2019_x86_64",
    WINDOWS_CORE_2022_x86_64: "WINDOWS_CORE_2022_x86_64",
    WINDOWS_FULL_2019_x86_64: "WINDOWS_FULL_2019_x86_64",
    WINDOWS_FULL_2022_x86_64: "WINDOWS_FULL_2022_x86_64",
};
export class InvalidParameterException extends __BaseException {
    name = "InvalidParameterException";
    $fault = "client";
    clusterName;
    nodegroupName;
    fargateProfileName;
    addonName;
    subscriptionId;
    constructor(opts) {
        super({
            name: "InvalidParameterException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidParameterException.prototype);
        this.clusterName = opts.clusterName;
        this.nodegroupName = opts.nodegroupName;
        this.fargateProfileName = opts.fargateProfileName;
        this.addonName = opts.addonName;
        this.subscriptionId = opts.subscriptionId;
    }
}
export class InvalidRequestException extends __BaseException {
    name = "InvalidRequestException";
    $fault = "client";
    clusterName;
    nodegroupName;
    addonName;
    subscriptionId;
    constructor(opts) {
        super({
            name: "InvalidRequestException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidRequestException.prototype);
        this.clusterName = opts.clusterName;
        this.nodegroupName = opts.nodegroupName;
        this.addonName = opts.addonName;
        this.subscriptionId = opts.subscriptionId;
    }
}
export class ResourceNotFoundException extends __BaseException {
    name = "ResourceNotFoundException";
    $fault = "client";
    clusterName;
    nodegroupName;
    fargateProfileName;
    addonName;
    subscriptionId;
    constructor(opts) {
        super({
            name: "ResourceNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceNotFoundException.prototype);
        this.clusterName = opts.clusterName;
        this.nodegroupName = opts.nodegroupName;
        this.fargateProfileName = opts.fargateProfileName;
        this.addonName = opts.addonName;
        this.subscriptionId = opts.subscriptionId;
    }
}
export class ServerException extends __BaseException {
    name = "ServerException";
    $fault = "server";
    clusterName;
    nodegroupName;
    addonName;
    subscriptionId;
    constructor(opts) {
        super({
            name: "ServerException",
            $fault: "server",
            ...opts,
        });
        Object.setPrototypeOf(this, ServerException.prototype);
        this.clusterName = opts.clusterName;
        this.nodegroupName = opts.nodegroupName;
        this.addonName = opts.addonName;
        this.subscriptionId = opts.subscriptionId;
    }
}
export const ErrorCode = {
    ACCESS_DENIED: "AccessDenied",
    ADMISSION_REQUEST_DENIED: "AdmissionRequestDenied",
    CLUSTER_UNREACHABLE: "ClusterUnreachable",
    CONFIGURATION_CONFLICT: "ConfigurationConflict",
    ENI_LIMIT_REACHED: "EniLimitReached",
    INSUFFICIENT_FREE_ADDRESSES: "InsufficientFreeAddresses",
    INSUFFICIENT_NUMBER_OF_REPLICAS: "InsufficientNumberOfReplicas",
    IP_NOT_AVAILABLE: "IpNotAvailable",
    K8S_RESOURCE_NOT_FOUND: "K8sResourceNotFound",
    NODE_CREATION_FAILURE: "NodeCreationFailure",
    OPERATION_NOT_PERMITTED: "OperationNotPermitted",
    POD_EVICTION_FAILURE: "PodEvictionFailure",
    SECURITY_GROUP_NOT_FOUND: "SecurityGroupNotFound",
    SUBNET_NOT_FOUND: "SubnetNotFound",
    UNKNOWN: "Unknown",
    UNSUPPORTED_ADDON_MODIFICATION: "UnsupportedAddonModification",
    VPC_ID_NOT_FOUND: "VpcIdNotFound",
};
export const UpdateParamType = {
    ADDON_VERSION: "AddonVersion",
    AUTHENTICATION_MODE: "AuthenticationMode",
    CLUSTER_LOGGING: "ClusterLogging",
    COMPUTE_CONFIG: "ComputeConfig",
    CONFIGURATION_VALUES: "ConfigurationValues",
    DESIRED_SIZE: "DesiredSize",
    ENCRYPTION_CONFIG: "EncryptionConfig",
    ENDPOINT_PRIVATE_ACCESS: "EndpointPrivateAccess",
    ENDPOINT_PUBLIC_ACCESS: "EndpointPublicAccess",
    IDENTITY_PROVIDER_CONFIG: "IdentityProviderConfig",
    KUBERNETES_NETWORK_CONFIG: "KubernetesNetworkConfig",
    LABELS_TO_ADD: "LabelsToAdd",
    LABELS_TO_REMOVE: "LabelsToRemove",
    LAUNCH_TEMPLATE_NAME: "LaunchTemplateName",
    LAUNCH_TEMPLATE_VERSION: "LaunchTemplateVersion",
    MAX_SIZE: "MaxSize",
    MAX_UNAVAILABLE: "MaxUnavailable",
    MAX_UNAVAILABLE_PERCENTAGE: "MaxUnavailablePercentage",
    MIN_SIZE: "MinSize",
    NODE_REPAIR_ENABLED: "NodeRepairEnabled",
    PLATFORM_VERSION: "PlatformVersion",
    POD_IDENTITY_ASSOCIATIONS: "PodIdentityAssociations",
    PUBLIC_ACCESS_CIDRS: "PublicAccessCidrs",
    RELEASE_VERSION: "ReleaseVersion",
    REMOTE_NETWORK_CONFIG: "RemoteNetworkConfig",
    RESOLVE_CONFLICTS: "ResolveConflicts",
    SECURITY_GROUPS: "SecurityGroups",
    SERVICE_ACCOUNT_ROLE_ARN: "ServiceAccountRoleArn",
    STORAGE_CONFIG: "StorageConfig",
    SUBNETS: "Subnets",
    TAINTS_TO_ADD: "TaintsToAdd",
    TAINTS_TO_REMOVE: "TaintsToRemove",
    UPDATE_STRATEGY: "UpdateStrategy",
    UPGRADE_POLICY: "UpgradePolicy",
    VERSION: "Version",
    ZONAL_SHIFT_CONFIG: "ZonalShiftConfig",
};
export const UpdateStatus = {
    CANCELLED: "Cancelled",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    SUCCESSFUL: "Successful",
};
export const UpdateType = {
    ACCESS_CONFIG_UPDATE: "AccessConfigUpdate",
    ADDON_UPDATE: "AddonUpdate",
    ASSOCIATE_ENCRYPTION_CONFIG: "AssociateEncryptionConfig",
    ASSOCIATE_IDENTITY_PROVIDER_CONFIG: "AssociateIdentityProviderConfig",
    AUTO_MODE_UPDATE: "AutoModeUpdate",
    CONFIG_UPDATE: "ConfigUpdate",
    DISASSOCIATE_IDENTITY_PROVIDER_CONFIG: "DisassociateIdentityProviderConfig",
    ENDPOINT_ACCESS_UPDATE: "EndpointAccessUpdate",
    LOGGING_UPDATE: "LoggingUpdate",
    REMOTE_NETWORK_CONFIG_UPDATE: "RemoteNetworkConfigUpdate",
    UPGRADE_POLICY_UPDATE: "UpgradePolicyUpdate",
    VERSION_UPDATE: "VersionUpdate",
    VPC_CONFIG_UPDATE: "VpcConfigUpdate",
    ZONAL_SHIFT_CONFIG_UPDATE: "ZonalShiftConfigUpdate",
};
export class ClientException extends __BaseException {
    name = "ClientException";
    $fault = "client";
    clusterName;
    nodegroupName;
    addonName;
    subscriptionId;
    constructor(opts) {
        super({
            name: "ClientException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ClientException.prototype);
        this.clusterName = opts.clusterName;
        this.nodegroupName = opts.nodegroupName;
        this.addonName = opts.addonName;
        this.subscriptionId = opts.subscriptionId;
    }
}
export class ResourceInUseException extends __BaseException {
    name = "ResourceInUseException";
    $fault = "client";
    clusterName;
    nodegroupName;
    addonName;
    constructor(opts) {
        super({
            name: "ResourceInUseException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceInUseException.prototype);
        this.clusterName = opts.clusterName;
        this.nodegroupName = opts.nodegroupName;
        this.addonName = opts.addonName;
    }
}
export class ThrottlingException extends __BaseException {
    name = "ThrottlingException";
    $fault = "client";
    clusterName;
    constructor(opts) {
        super({
            name: "ThrottlingException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ThrottlingException.prototype);
        this.clusterName = opts.clusterName;
    }
}
export class ResourceLimitExceededException extends __BaseException {
    name = "ResourceLimitExceededException";
    $fault = "client";
    clusterName;
    nodegroupName;
    subscriptionId;
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.clusterName = opts.clusterName;
        this.nodegroupName = opts.nodegroupName;
        this.subscriptionId = opts.subscriptionId;
    }
}
export const ResolveConflicts = {
    NONE: "NONE",
    OVERWRITE: "OVERWRITE",
    PRESERVE: "PRESERVE",
};
export const IpFamily = {
    IPV4: "ipv4",
    IPV6: "ipv6",
};
export const LogType = {
    API: "api",
    AUDIT: "audit",
    AUTHENTICATOR: "authenticator",
    CONTROLLER_MANAGER: "controllerManager",
    SCHEDULER: "scheduler",
};
export const SupportType = {
    EXTENDED: "EXTENDED",
    STANDARD: "STANDARD",
};
export const ClusterIssueCode = {
    ACCESS_DENIED: "AccessDenied",
    CLUSTER_UNREACHABLE: "ClusterUnreachable",
    CONFIGURATION_CONFLICT: "ConfigurationConflict",
    EC2_SECURITY_GROUP_NOT_FOUND: "Ec2SecurityGroupNotFound",
    EC2_SERVICE_NOT_SUBSCRIBED: "Ec2ServiceNotSubscribed",
    EC2_SUBNET_NOT_FOUND: "Ec2SubnetNotFound",
    IAM_ROLE_NOT_FOUND: "IamRoleNotFound",
    INSUFFICIENT_FREE_ADDRESSES: "InsufficientFreeAddresses",
    INTERNAL_FAILURE: "InternalFailure",
    KMS_GRANT_REVOKED: "KmsGrantRevoked",
    KMS_KEY_DISABLED: "KmsKeyDisabled",
    KMS_KEY_MARKED_FOR_DELETION: "KmsKeyMarkedForDeletion",
    KMS_KEY_NOT_FOUND: "KmsKeyNotFound",
    OTHER: "Other",
    RESOURCE_LIMIT_EXCEEDED: "ResourceLimitExceeded",
    RESOURCE_NOT_FOUND: "ResourceNotFound",
    STS_REGIONAL_ENDPOINT_DISABLED: "StsRegionalEndpointDisabled",
    UNSUPPORTED_VERSION: "UnsupportedVersion",
    VPC_NOT_FOUND: "VpcNotFound",
};
export const ClusterStatus = {
    ACTIVE: "ACTIVE",
    CREATING: "CREATING",
    DELETING: "DELETING",
    FAILED: "FAILED",
    PENDING: "PENDING",
    UPDATING: "UPDATING",
};
export class ServiceUnavailableException extends __BaseException {
    name = "ServiceUnavailableException";
    $fault = "server";
    constructor(opts) {
        super({
            name: "ServiceUnavailableException",
            $fault: "server",
            ...opts,
        });
        Object.setPrototypeOf(this, ServiceUnavailableException.prototype);
    }
}
export class UnsupportedAvailabilityZoneException extends __BaseException {
    name = "UnsupportedAvailabilityZoneException";
    $fault = "client";
    clusterName;
    nodegroupName;
    validZones;
    constructor(opts) {
        super({
            name: "UnsupportedAvailabilityZoneException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, UnsupportedAvailabilityZoneException.prototype);
        this.clusterName = opts.clusterName;
        this.nodegroupName = opts.nodegroupName;
        this.validZones = opts.validZones;
    }
}
export const EksAnywhereSubscriptionLicenseType = {
    Cluster: "Cluster",
};
export const EksAnywhereSubscriptionTermUnit = {
    MONTHS: "MONTHS",
};
export const FargateProfileIssueCode = {
    ACCESS_DENIED: "AccessDenied",
    CLUSTER_UNREACHABLE: "ClusterUnreachable",
    INTERNAL_FAILURE: "InternalFailure",
    POD_EXECUTION_ROLE_ALREADY_IN_USE: "PodExecutionRoleAlreadyInUse",
};
export const FargateProfileStatus = {
    ACTIVE: "ACTIVE",
    CREATE_FAILED: "CREATE_FAILED",
    CREATING: "CREATING",
    DELETE_FAILED: "DELETE_FAILED",
    DELETING: "DELETING",
};
export const CapacityTypes = {
    CAPACITY_BLOCK: "CAPACITY_BLOCK",
    ON_DEMAND: "ON_DEMAND",
    SPOT: "SPOT",
};
export const TaintEffect = {
    NO_EXECUTE: "NO_EXECUTE",
    NO_SCHEDULE: "NO_SCHEDULE",
    PREFER_NO_SCHEDULE: "PREFER_NO_SCHEDULE",
};
export const NodegroupUpdateStrategies = {
    DEFAULT: "DEFAULT",
    MINIMAL: "MINIMAL",
};
export const NodegroupIssueCode = {
    ACCESS_DENIED: "AccessDenied",
    AMI_ID_NOT_FOUND: "AmiIdNotFound",
    ASG_INSTANCE_LAUNCH_FAILURES: "AsgInstanceLaunchFailures",
    AUTO_SCALING_GROUP_INSTANCE_REFRESH_ACTIVE: "AutoScalingGroupInstanceRefreshActive",
    AUTO_SCALING_GROUP_INVALID_CONFIGURATION: "AutoScalingGroupInvalidConfiguration",
    AUTO_SCALING_GROUP_NOT_FOUND: "AutoScalingGroupNotFound",
    AUTO_SCALING_GROUP_OPT_IN_REQUIRED: "AutoScalingGroupOptInRequired",
    AUTO_SCALING_GROUP_RATE_LIMIT_EXCEEDED: "AutoScalingGroupRateLimitExceeded",
    CLUSTER_UNREACHABLE: "ClusterUnreachable",
    EC2_INSTANCE_TYPE_DOES_NOT_EXIST: "Ec2InstanceTypeDoesNotExist",
    EC2_LAUNCH_TEMPLATE_DELETION_FAILURE: "Ec2LaunchTemplateDeletionFailure",
    EC2_LAUNCH_TEMPLATE_INVALID_CONFIGURATION: "Ec2LaunchTemplateInvalidConfiguration",
    EC2_LAUNCH_TEMPLATE_MAX_LIMIT_EXCEEDED: "Ec2LaunchTemplateMaxLimitExceeded",
    EC2_LAUNCH_TEMPLATE_NOT_FOUND: "Ec2LaunchTemplateNotFound",
    EC2_LAUNCH_TEMPLATE_VERSION_MAX_LIMIT_EXCEEDED: "Ec2LaunchTemplateVersionMaxLimitExceeded",
    EC2_LAUNCH_TEMPLATE_VERSION_MISMATCH: "Ec2LaunchTemplateVersionMismatch",
    EC2_SECURITY_GROUP_DELETION_FAILURE: "Ec2SecurityGroupDeletionFailure",
    EC2_SECURITY_GROUP_NOT_FOUND: "Ec2SecurityGroupNotFound",
    EC2_SUBNET_INVALID_CONFIGURATION: "Ec2SubnetInvalidConfiguration",
    EC2_SUBNET_LIST_TOO_LONG: "Ec2SubnetListTooLong",
    EC2_SUBNET_MISSING_IPV6_ASSIGNMENT: "Ec2SubnetMissingIpv6Assignment",
    EC2_SUBNET_NOT_FOUND: "Ec2SubnetNotFound",
    IAM_INSTANCE_PROFILE_NOT_FOUND: "IamInstanceProfileNotFound",
    IAM_LIMIT_EXCEEDED: "IamLimitExceeded",
    IAM_NODE_ROLE_NOT_FOUND: "IamNodeRoleNotFound",
    IAM_THROTTLING: "IamThrottling",
    INSTANCE_LIMIT_EXCEEDED: "InstanceLimitExceeded",
    INSUFFICIENT_FREE_ADDRESSES: "InsufficientFreeAddresses",
    INTERNAL_FAILURE: "InternalFailure",
    KUBERNETES_LABEL_INVALID: "KubernetesLabelInvalid",
    LIMIT_EXCEEDED: "LimitExceeded",
    NODE_CREATION_FAILURE: "NodeCreationFailure",
    NODE_TERMINATION_FAILURE: "NodeTerminationFailure",
    POD_EVICTION_FAILURE: "PodEvictionFailure",
    SOURCE_EC2_LAUNCH_TEMPLATE_NOT_FOUND: "SourceEc2LaunchTemplateNotFound",
    UNKNOWN: "Unknown",
};
export const NodegroupStatus = {
    ACTIVE: "ACTIVE",
    CREATE_FAILED: "CREATE_FAILED",
    CREATING: "CREATING",
    DEGRADED: "DEGRADED",
    DELETE_FAILED: "DELETE_FAILED",
    DELETING: "DELETING",
    UPDATING: "UPDATING",
};
export const ClusterVersionStatus = {
    extended_support: "extended-support",
    standard_support: "standard-support",
    unsupported: "unsupported",
};
export const VersionStatus = {
    EXTENDED_SUPPORT: "EXTENDED_SUPPORT",
    STANDARD_SUPPORT: "STANDARD_SUPPORT",
    UNSUPPORTED: "UNSUPPORTED",
};
export const ConfigStatus = {
    ACTIVE: "ACTIVE",
    CREATING: "CREATING",
    DELETING: "DELETING",
};
export const Category = {
    MISCONFIGURATION: "MISCONFIGURATION",
    UPGRADE_READINESS: "UPGRADE_READINESS",
};
export const InsightStatusValue = {
    ERROR: "ERROR",
    PASSING: "PASSING",
    UNKNOWN: "UNKNOWN",
    WARNING: "WARNING",
};
export const EksAnywhereSubscriptionStatus = {
    ACTIVE: "ACTIVE",
    CREATING: "CREATING",
    DELETING: "DELETING",
    EXPIRED: "EXPIRED",
    EXPIRING: "EXPIRING",
    UPDATING: "UPDATING",
};
export class BadRequestException extends __BaseException {
    name = "BadRequestException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BadRequestException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BadRequestException.prototype);
    }
}
export class NotFoundException extends __BaseException {
    name = "NotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "NotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NotFoundException.prototype);
    }
}
export const ConnectorConfigProvider = {
    AKS: "AKS",
    ANTHOS: "ANTHOS",
    EC2: "EC2",
    EKS_ANYWHERE: "EKS_ANYWHERE",
    GKE: "GKE",
    OPENSHIFT: "OPENSHIFT",
    OTHER: "OTHER",
    RANCHER: "RANCHER",
    TANZU: "TANZU",
};
export class ResourcePropagationDelayException extends __BaseException {
    name = "ResourcePropagationDelayException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ResourcePropagationDelayException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourcePropagationDelayException.prototype);
    }
}
export class InvalidStateException extends __BaseException {
    name = "InvalidStateException";
    $fault = "client";
    clusterName;
    constructor(opts) {
        super({
            name: "InvalidStateException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidStateException.prototype);
        this.clusterName = opts.clusterName;
    }
}
