import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListAccessEntriesCommand, se_ListAccessEntriesCommand } from "../protocols/Aws_restJson1";
export { $Command };
export class ListAccessEntriesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AWSWesleyFrontend", "ListAccessEntries", {})
    .n("EKSClient", "ListAccessEntriesCommand")
    .f(void 0, void 0)
    .ser(se_ListAccessEntriesCommand)
    .de(de_ListAccessEntriesCommand)
    .build() {
}
