import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeClusterVersionsCommand, se_DescribeClusterVersionsCommand } from "../protocols/Aws_restJson1";
export { $Command };
export class DescribeClusterVersionsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AWSWesleyFrontend", "DescribeClusterVersions", {})
    .n("EKSClient", "DescribeClusterVersionsCommand")
    .f(void 0, void 0)
    .ser(se_DescribeClusterVersionsCommand)
    .de(de_DescribeClusterVersionsCommand)
    .build() {
}
