import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteNodegroupCommand, se_DeleteNodegroupCommand } from "../protocols/Aws_restJson1";
export { $Command };
export class DeleteNodegroupCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AWSWesleyFrontend", "DeleteNodegroup", {})
    .n("EKSClient", "DeleteNodegroupCommand")
    .f(void 0, void 0)
    .ser(se_DeleteNodegroupCommand)
    .de(de_DeleteNodegroupCommand)
    .build() {
}
