import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { ECRServiceException as __BaseException } from "./ECRServiceException";
export interface BatchCheckLayerAvailabilityRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  layerDigests: string[] | undefined;
}
export declare const LayerFailureCode: {
  readonly InvalidLayerDigest: "InvalidLayerDigest";
  readonly MissingLayerDigest: "MissingLayerDigest";
};
export type LayerFailureCode =
  (typeof LayerFailureCode)[keyof typeof LayerFailureCode];
export interface LayerFailure {
  layerDigest?: string | undefined;
  failureCode?: LayerFailureCode | undefined;
  failureReason?: string | undefined;
}
export declare const LayerAvailability: {
  readonly AVAILABLE: "AVAILABLE";
  readonly UNAVAILABLE: "UNAVAILABLE";
};
export type LayerAvailability =
  (typeof LayerAvailability)[keyof typeof LayerAvailability];
export interface Layer {
  layerDigest?: string | undefined;
  layerAvailability?: LayerAvailability | undefined;
  layerSize?: number | undefined;
  mediaType?: string | undefined;
}
export interface BatchCheckLayerAvailabilityResponse {
  layers?: Layer[] | undefined;
  failures?: LayerFailure[] | undefined;
}
export declare class InvalidParameterException extends __BaseException {
  readonly name: "InvalidParameterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidParameterException, __BaseException>
  );
}
export declare class RepositoryNotFoundException extends __BaseException {
  readonly name: "RepositoryNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RepositoryNotFoundException, __BaseException>
  );
}
export declare class ServerException extends __BaseException {
  readonly name: "ServerException";
  readonly $fault: "server";
  constructor(opts: __ExceptionOptionType<ServerException, __BaseException>);
}
export interface ImageIdentifier {
  imageDigest?: string | undefined;
  imageTag?: string | undefined;
}
export interface BatchDeleteImageRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  imageIds: ImageIdentifier[] | undefined;
}
export declare const ImageFailureCode: {
  readonly ImageNotFound: "ImageNotFound";
  readonly ImageReferencedByManifestList: "ImageReferencedByManifestList";
  readonly ImageTagDoesNotMatchDigest: "ImageTagDoesNotMatchDigest";
  readonly InvalidImageDigest: "InvalidImageDigest";
  readonly InvalidImageTag: "InvalidImageTag";
  readonly KmsError: "KmsError";
  readonly MissingDigestAndTag: "MissingDigestAndTag";
  readonly UpstreamAccessDenied: "UpstreamAccessDenied";
  readonly UpstreamTooManyRequests: "UpstreamTooManyRequests";
  readonly UpstreamUnavailable: "UpstreamUnavailable";
};
export type ImageFailureCode =
  (typeof ImageFailureCode)[keyof typeof ImageFailureCode];
export interface ImageFailure {
  imageId?: ImageIdentifier | undefined;
  failureCode?: ImageFailureCode | undefined;
  failureReason?: string | undefined;
}
export interface BatchDeleteImageResponse {
  imageIds?: ImageIdentifier[] | undefined;
  failures?: ImageFailure[] | undefined;
}
export interface BatchGetImageRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  imageIds: ImageIdentifier[] | undefined;
  acceptedMediaTypes?: string[] | undefined;
}
export interface Image {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  imageId?: ImageIdentifier | undefined;
  imageManifest?: string | undefined;
  imageManifestMediaType?: string | undefined;
}
export interface BatchGetImageResponse {
  images?: Image[] | undefined;
  failures?: ImageFailure[] | undefined;
}
export declare class LimitExceededException extends __BaseException {
  readonly name: "LimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LimitExceededException, __BaseException>
  );
}
export declare class UnableToGetUpstreamImageException extends __BaseException {
  readonly name: "UnableToGetUpstreamImageException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      UnableToGetUpstreamImageException,
      __BaseException
    >
  );
}
export interface BatchGetRepositoryScanningConfigurationRequest {
  repositoryNames: string[] | undefined;
}
export declare const ScanningConfigurationFailureCode: {
  readonly REPOSITORY_NOT_FOUND: "REPOSITORY_NOT_FOUND";
};
export type ScanningConfigurationFailureCode =
  (typeof ScanningConfigurationFailureCode)[keyof typeof ScanningConfigurationFailureCode];
export interface RepositoryScanningConfigurationFailure {
  repositoryName?: string | undefined;
  failureCode?: ScanningConfigurationFailureCode | undefined;
  failureReason?: string | undefined;
}
export declare const ScanningRepositoryFilterType: {
  readonly WILDCARD: "WILDCARD";
};
export type ScanningRepositoryFilterType =
  (typeof ScanningRepositoryFilterType)[keyof typeof ScanningRepositoryFilterType];
export interface ScanningRepositoryFilter {
  filter: string | undefined;
  filterType: ScanningRepositoryFilterType | undefined;
}
export declare const ScanFrequency: {
  readonly CONTINUOUS_SCAN: "CONTINUOUS_SCAN";
  readonly MANUAL: "MANUAL";
  readonly SCAN_ON_PUSH: "SCAN_ON_PUSH";
};
export type ScanFrequency = (typeof ScanFrequency)[keyof typeof ScanFrequency];
export interface RepositoryScanningConfiguration {
  repositoryArn?: string | undefined;
  repositoryName?: string | undefined;
  scanOnPush?: boolean | undefined;
  scanFrequency?: ScanFrequency | undefined;
  appliedScanFilters?: ScanningRepositoryFilter[] | undefined;
}
export interface BatchGetRepositoryScanningConfigurationResponse {
  scanningConfigurations?: RepositoryScanningConfiguration[] | undefined;
  failures?: RepositoryScanningConfigurationFailure[] | undefined;
}
export declare class ValidationException extends __BaseException {
  readonly name: "ValidationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ValidationException, __BaseException>
  );
}
export interface CompleteLayerUploadRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  uploadId: string | undefined;
  layerDigests: string[] | undefined;
}
export interface CompleteLayerUploadResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  uploadId?: string | undefined;
  layerDigest?: string | undefined;
}
export declare class EmptyUploadException extends __BaseException {
  readonly name: "EmptyUploadException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<EmptyUploadException, __BaseException>
  );
}
export declare class InvalidLayerException extends __BaseException {
  readonly name: "InvalidLayerException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidLayerException, __BaseException>
  );
}
export declare class KmsException extends __BaseException {
  readonly name: "KmsException";
  readonly $fault: "client";
  kmsError?: string | undefined;
  constructor(opts: __ExceptionOptionType<KmsException, __BaseException>);
}
export declare class LayerAlreadyExistsException extends __BaseException {
  readonly name: "LayerAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LayerAlreadyExistsException, __BaseException>
  );
}
export declare class LayerPartTooSmallException extends __BaseException {
  readonly name: "LayerPartTooSmallException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LayerPartTooSmallException, __BaseException>
  );
}
export declare class UploadNotFoundException extends __BaseException {
  readonly name: "UploadNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UploadNotFoundException, __BaseException>
  );
}
export declare const UpstreamRegistry: {
  readonly AzureContainerRegistry: "azure-container-registry";
  readonly DockerHub: "docker-hub";
  readonly Ecr: "ecr";
  readonly EcrPublic: "ecr-public";
  readonly GitHubContainerRegistry: "github-container-registry";
  readonly GitLabContainerRegistry: "gitlab-container-registry";
  readonly K8s: "k8s";
  readonly Quay: "quay";
};
export type UpstreamRegistry =
  (typeof UpstreamRegistry)[keyof typeof UpstreamRegistry];
export interface CreatePullThroughCacheRuleRequest {
  ecrRepositoryPrefix: string | undefined;
  upstreamRegistryUrl: string | undefined;
  registryId?: string | undefined;
  upstreamRegistry?: UpstreamRegistry | undefined;
  credentialArn?: string | undefined;
  customRoleArn?: string | undefined;
  upstreamRepositoryPrefix?: string | undefined;
}
export interface CreatePullThroughCacheRuleResponse {
  ecrRepositoryPrefix?: string | undefined;
  upstreamRegistryUrl?: string | undefined;
  createdAt?: Date | undefined;
  registryId?: string | undefined;
  upstreamRegistry?: UpstreamRegistry | undefined;
  credentialArn?: string | undefined;
  customRoleArn?: string | undefined;
  upstreamRepositoryPrefix?: string | undefined;
}
export declare class PullThroughCacheRuleAlreadyExistsException extends __BaseException {
  readonly name: "PullThroughCacheRuleAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PullThroughCacheRuleAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class SecretNotFoundException extends __BaseException {
  readonly name: "SecretNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<SecretNotFoundException, __BaseException>
  );
}
export declare class UnableToAccessSecretException extends __BaseException {
  readonly name: "UnableToAccessSecretException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnableToAccessSecretException, __BaseException>
  );
}
export declare class UnableToDecryptSecretValueException extends __BaseException {
  readonly name: "UnableToDecryptSecretValueException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      UnableToDecryptSecretValueException,
      __BaseException
    >
  );
}
export declare class UnsupportedUpstreamRegistryException extends __BaseException {
  readonly name: "UnsupportedUpstreamRegistryException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      UnsupportedUpstreamRegistryException,
      __BaseException
    >
  );
}
export declare const EncryptionType: {
  readonly AES256: "AES256";
  readonly KMS: "KMS";
  readonly KMS_DSSE: "KMS_DSSE";
};
export type EncryptionType =
  (typeof EncryptionType)[keyof typeof EncryptionType];
export interface EncryptionConfiguration {
  encryptionType: EncryptionType | undefined;
  kmsKey?: string | undefined;
}
export interface ImageScanningConfiguration {
  scanOnPush?: boolean | undefined;
}
export declare const ImageTagMutability: {
  readonly IMMUTABLE: "IMMUTABLE";
  readonly MUTABLE: "MUTABLE";
};
export type ImageTagMutability =
  (typeof ImageTagMutability)[keyof typeof ImageTagMutability];
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateRepositoryRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  tags?: Tag[] | undefined;
  imageTagMutability?: ImageTagMutability | undefined;
  imageScanningConfiguration?: ImageScanningConfiguration | undefined;
  encryptionConfiguration?: EncryptionConfiguration | undefined;
}
export interface Repository {
  repositoryArn?: string | undefined;
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  repositoryUri?: string | undefined;
  createdAt?: Date | undefined;
  imageTagMutability?: ImageTagMutability | undefined;
  imageScanningConfiguration?: ImageScanningConfiguration | undefined;
  encryptionConfiguration?: EncryptionConfiguration | undefined;
}
export interface CreateRepositoryResponse {
  repository?: Repository | undefined;
}
export declare class InvalidTagParameterException extends __BaseException {
  readonly name: "InvalidTagParameterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTagParameterException, __BaseException>
  );
}
export declare class RepositoryAlreadyExistsException extends __BaseException {
  readonly name: "RepositoryAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class TooManyTagsException extends __BaseException {
  readonly name: "TooManyTagsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TooManyTagsException, __BaseException>
  );
}
export declare const RCTAppliedFor: {
  readonly PULL_THROUGH_CACHE: "PULL_THROUGH_CACHE";
  readonly REPLICATION: "REPLICATION";
};
export type RCTAppliedFor = (typeof RCTAppliedFor)[keyof typeof RCTAppliedFor];
export interface EncryptionConfigurationForRepositoryCreationTemplate {
  encryptionType: EncryptionType | undefined;
  kmsKey?: string | undefined;
}
export interface CreateRepositoryCreationTemplateRequest {
  prefix: string | undefined;
  description?: string | undefined;
  encryptionConfiguration?:
    | EncryptionConfigurationForRepositoryCreationTemplate
    | undefined;
  resourceTags?: Tag[] | undefined;
  imageTagMutability?: ImageTagMutability | undefined;
  repositoryPolicy?: string | undefined;
  lifecyclePolicy?: string | undefined;
  appliedFor: RCTAppliedFor[] | undefined;
  customRoleArn?: string | undefined;
}
export interface RepositoryCreationTemplate {
  prefix?: string | undefined;
  description?: string | undefined;
  encryptionConfiguration?:
    | EncryptionConfigurationForRepositoryCreationTemplate
    | undefined;
  resourceTags?: Tag[] | undefined;
  imageTagMutability?: ImageTagMutability | undefined;
  repositoryPolicy?: string | undefined;
  lifecyclePolicy?: string | undefined;
  appliedFor?: RCTAppliedFor[] | undefined;
  customRoleArn?: string | undefined;
  createdAt?: Date | undefined;
  updatedAt?: Date | undefined;
}
export interface CreateRepositoryCreationTemplateResponse {
  registryId?: string | undefined;
  repositoryCreationTemplate?: RepositoryCreationTemplate | undefined;
}
export declare class TemplateAlreadyExistsException extends __BaseException {
  readonly name: "TemplateAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TemplateAlreadyExistsException, __BaseException>
  );
}
export interface DeleteLifecyclePolicyRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
}
export interface DeleteLifecyclePolicyResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  lifecyclePolicyText?: string | undefined;
  lastEvaluatedAt?: Date | undefined;
}
export declare class LifecyclePolicyNotFoundException extends __BaseException {
  readonly name: "LifecyclePolicyNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      LifecyclePolicyNotFoundException,
      __BaseException
    >
  );
}
export interface DeletePullThroughCacheRuleRequest {
  ecrRepositoryPrefix: string | undefined;
  registryId?: string | undefined;
}
export interface DeletePullThroughCacheRuleResponse {
  ecrRepositoryPrefix?: string | undefined;
  upstreamRegistryUrl?: string | undefined;
  createdAt?: Date | undefined;
  registryId?: string | undefined;
  credentialArn?: string | undefined;
  customRoleArn?: string | undefined;
  upstreamRepositoryPrefix?: string | undefined;
}
export declare class PullThroughCacheRuleNotFoundException extends __BaseException {
  readonly name: "PullThroughCacheRuleNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PullThroughCacheRuleNotFoundException,
      __BaseException
    >
  );
}
export interface DeleteRegistryPolicyRequest {}
export interface DeleteRegistryPolicyResponse {
  registryId?: string | undefined;
  policyText?: string | undefined;
}
export declare class RegistryPolicyNotFoundException extends __BaseException {
  readonly name: "RegistryPolicyNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RegistryPolicyNotFoundException,
      __BaseException
    >
  );
}
export interface DeleteRepositoryRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  force?: boolean | undefined;
}
export interface DeleteRepositoryResponse {
  repository?: Repository | undefined;
}
export declare class RepositoryNotEmptyException extends __BaseException {
  readonly name: "RepositoryNotEmptyException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RepositoryNotEmptyException, __BaseException>
  );
}
export interface DeleteRepositoryCreationTemplateRequest {
  prefix: string | undefined;
}
export interface DeleteRepositoryCreationTemplateResponse {
  registryId?: string | undefined;
  repositoryCreationTemplate?: RepositoryCreationTemplate | undefined;
}
export declare class TemplateNotFoundException extends __BaseException {
  readonly name: "TemplateNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TemplateNotFoundException, __BaseException>
  );
}
export interface DeleteRepositoryPolicyRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
}
export interface DeleteRepositoryPolicyResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  policyText?: string | undefined;
}
export declare class RepositoryPolicyNotFoundException extends __BaseException {
  readonly name: "RepositoryPolicyNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryPolicyNotFoundException,
      __BaseException
    >
  );
}
export interface DescribeImageReplicationStatusRequest {
  repositoryName: string | undefined;
  imageId: ImageIdentifier | undefined;
  registryId?: string | undefined;
}
export declare const ReplicationStatus: {
  readonly COMPLETE: "COMPLETE";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
};
export type ReplicationStatus =
  (typeof ReplicationStatus)[keyof typeof ReplicationStatus];
export interface ImageReplicationStatus {
  region?: string | undefined;
  registryId?: string | undefined;
  status?: ReplicationStatus | undefined;
  failureCode?: string | undefined;
}
export interface DescribeImageReplicationStatusResponse {
  repositoryName?: string | undefined;
  imageId?: ImageIdentifier | undefined;
  replicationStatuses?: ImageReplicationStatus[] | undefined;
}
export declare class ImageNotFoundException extends __BaseException {
  readonly name: "ImageNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ImageNotFoundException, __BaseException>
  );
}
export declare const TagStatus: {
  readonly ANY: "ANY";
  readonly TAGGED: "TAGGED";
  readonly UNTAGGED: "UNTAGGED";
};
export type TagStatus = (typeof TagStatus)[keyof typeof TagStatus];
export interface DescribeImagesFilter {
  tagStatus?: TagStatus | undefined;
}
export interface DescribeImagesRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  imageIds?: ImageIdentifier[] | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
  filter?: DescribeImagesFilter | undefined;
}
export declare const FindingSeverity: {
  readonly CRITICAL: "CRITICAL";
  readonly HIGH: "HIGH";
  readonly INFORMATIONAL: "INFORMATIONAL";
  readonly LOW: "LOW";
  readonly MEDIUM: "MEDIUM";
  readonly UNDEFINED: "UNDEFINED";
};
export type FindingSeverity =
  (typeof FindingSeverity)[keyof typeof FindingSeverity];
export interface ImageScanFindingsSummary {
  imageScanCompletedAt?: Date | undefined;
  vulnerabilitySourceUpdatedAt?: Date | undefined;
  findingSeverityCounts?: Partial<Record<FindingSeverity, number>> | undefined;
}
export declare const ScanStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly COMPLETE: "COMPLETE";
  readonly FAILED: "FAILED";
  readonly FINDINGS_UNAVAILABLE: "FINDINGS_UNAVAILABLE";
  readonly IN_PROGRESS: "IN_PROGRESS";
  readonly LIMIT_EXCEEDED: "LIMIT_EXCEEDED";
  readonly PENDING: "PENDING";
  readonly SCAN_ELIGIBILITY_EXPIRED: "SCAN_ELIGIBILITY_EXPIRED";
  readonly UNSUPPORTED_IMAGE: "UNSUPPORTED_IMAGE";
};
export type ScanStatus = (typeof ScanStatus)[keyof typeof ScanStatus];
export interface ImageScanStatus {
  status?: ScanStatus | undefined;
  description?: string | undefined;
}
export interface ImageDetail {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  imageDigest?: string | undefined;
  imageTags?: string[] | undefined;
  imageSizeInBytes?: number | undefined;
  imagePushedAt?: Date | undefined;
  imageScanStatus?: ImageScanStatus | undefined;
  imageScanFindingsSummary?: ImageScanFindingsSummary | undefined;
  imageManifestMediaType?: string | undefined;
  artifactMediaType?: string | undefined;
  lastRecordedPullTime?: Date | undefined;
}
export interface DescribeImagesResponse {
  imageDetails?: ImageDetail[] | undefined;
  nextToken?: string | undefined;
}
export interface DescribeImageScanFindingsRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  imageId: ImageIdentifier | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface CvssScore {
  baseScore?: number | undefined;
  scoringVector?: string | undefined;
  source?: string | undefined;
  version?: string | undefined;
}
export interface VulnerablePackage {
  arch?: string | undefined;
  epoch?: number | undefined;
  filePath?: string | undefined;
  name?: string | undefined;
  packageManager?: string | undefined;
  release?: string | undefined;
  sourceLayerHash?: string | undefined;
  version?: string | undefined;
  fixedInVersion?: string | undefined;
}
export interface PackageVulnerabilityDetails {
  cvss?: CvssScore[] | undefined;
  referenceUrls?: string[] | undefined;
  relatedVulnerabilities?: string[] | undefined;
  source?: string | undefined;
  sourceUrl?: string | undefined;
  vendorCreatedAt?: Date | undefined;
  vendorSeverity?: string | undefined;
  vendorUpdatedAt?: Date | undefined;
  vulnerabilityId?: string | undefined;
  vulnerablePackages?: VulnerablePackage[] | undefined;
}
export interface Recommendation {
  url?: string | undefined;
  text?: string | undefined;
}
export interface Remediation {
  recommendation?: Recommendation | undefined;
}
export interface AwsEcrContainerImageDetails {
  architecture?: string | undefined;
  author?: string | undefined;
  imageHash?: string | undefined;
  imageTags?: string[] | undefined;
  platform?: string | undefined;
  pushedAt?: Date | undefined;
  lastInUseAt?: Date | undefined;
  inUseCount?: number | undefined;
  registry?: string | undefined;
  repositoryName?: string | undefined;
}
export interface ResourceDetails {
  awsEcrContainerImage?: AwsEcrContainerImageDetails | undefined;
}
export interface Resource {
  details?: ResourceDetails | undefined;
  id?: string | undefined;
  tags?: Record<string, string> | undefined;
  type?: string | undefined;
}
export interface CvssScoreAdjustment {
  metric?: string | undefined;
  reason?: string | undefined;
}
export interface CvssScoreDetails {
  adjustments?: CvssScoreAdjustment[] | undefined;
  score?: number | undefined;
  scoreSource?: string | undefined;
  scoringVector?: string | undefined;
  version?: string | undefined;
}
export interface ScoreDetails {
  cvss?: CvssScoreDetails | undefined;
}
export interface EnhancedImageScanFinding {
  awsAccountId?: string | undefined;
  description?: string | undefined;
  findingArn?: string | undefined;
  firstObservedAt?: Date | undefined;
  lastObservedAt?: Date | undefined;
  packageVulnerabilityDetails?: PackageVulnerabilityDetails | undefined;
  remediation?: Remediation | undefined;
  resources?: Resource[] | undefined;
  score?: number | undefined;
  scoreDetails?: ScoreDetails | undefined;
  severity?: string | undefined;
  status?: string | undefined;
  title?: string | undefined;
  type?: string | undefined;
  updatedAt?: Date | undefined;
  fixAvailable?: string | undefined;
  exploitAvailable?: string | undefined;
}
export interface Attribute {
  key: string | undefined;
  value?: string | undefined;
}
export interface ImageScanFinding {
  name?: string | undefined;
  description?: string | undefined;
  uri?: string | undefined;
  severity?: FindingSeverity | undefined;
  attributes?: Attribute[] | undefined;
}
export interface ImageScanFindings {
  imageScanCompletedAt?: Date | undefined;
  vulnerabilitySourceUpdatedAt?: Date | undefined;
  findingSeverityCounts?: Partial<Record<FindingSeverity, number>> | undefined;
  findings?: ImageScanFinding[] | undefined;
  enhancedFindings?: EnhancedImageScanFinding[] | undefined;
}
export interface DescribeImageScanFindingsResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  imageId?: ImageIdentifier | undefined;
  imageScanStatus?: ImageScanStatus | undefined;
  imageScanFindings?: ImageScanFindings | undefined;
  nextToken?: string | undefined;
}
export declare class ScanNotFoundException extends __BaseException {
  readonly name: "ScanNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ScanNotFoundException, __BaseException>
  );
}
export interface DescribePullThroughCacheRulesRequest {
  registryId?: string | undefined;
  ecrRepositoryPrefixes?: string[] | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface PullThroughCacheRule {
  ecrRepositoryPrefix?: string | undefined;
  upstreamRegistryUrl?: string | undefined;
  createdAt?: Date | undefined;
  registryId?: string | undefined;
  credentialArn?: string | undefined;
  customRoleArn?: string | undefined;
  upstreamRepositoryPrefix?: string | undefined;
  upstreamRegistry?: UpstreamRegistry | undefined;
  updatedAt?: Date | undefined;
}
export interface DescribePullThroughCacheRulesResponse {
  pullThroughCacheRules?: PullThroughCacheRule[] | undefined;
  nextToken?: string | undefined;
}
export interface DescribeRegistryRequest {}
export interface ReplicationDestination {
  region: string | undefined;
  registryId: string | undefined;
}
export declare const RepositoryFilterType: {
  readonly PREFIX_MATCH: "PREFIX_MATCH";
};
export type RepositoryFilterType =
  (typeof RepositoryFilterType)[keyof typeof RepositoryFilterType];
export interface RepositoryFilter {
  filter: string | undefined;
  filterType: RepositoryFilterType | undefined;
}
export interface ReplicationRule {
  destinations: ReplicationDestination[] | undefined;
  repositoryFilters?: RepositoryFilter[] | undefined;
}
export interface ReplicationConfiguration {
  rules: ReplicationRule[] | undefined;
}
export interface DescribeRegistryResponse {
  registryId?: string | undefined;
  replicationConfiguration?: ReplicationConfiguration | undefined;
}
export interface DescribeRepositoriesRequest {
  registryId?: string | undefined;
  repositoryNames?: string[] | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface DescribeRepositoriesResponse {
  repositories?: Repository[] | undefined;
  nextToken?: string | undefined;
}
export interface DescribeRepositoryCreationTemplatesRequest {
  prefixes?: string[] | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface DescribeRepositoryCreationTemplatesResponse {
  registryId?: string | undefined;
  repositoryCreationTemplates?: RepositoryCreationTemplate[] | undefined;
  nextToken?: string | undefined;
}
export interface GetAccountSettingRequest {
  name: string | undefined;
}
export interface GetAccountSettingResponse {
  name?: string | undefined;
  value?: string | undefined;
}
export interface GetAuthorizationTokenRequest {
  registryIds?: string[] | undefined;
}
export interface AuthorizationData {
  authorizationToken?: string | undefined;
  expiresAt?: Date | undefined;
  proxyEndpoint?: string | undefined;
}
export interface GetAuthorizationTokenResponse {
  authorizationData?: AuthorizationData[] | undefined;
}
export interface GetDownloadUrlForLayerRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  layerDigest: string | undefined;
}
export interface GetDownloadUrlForLayerResponse {
  downloadUrl?: string | undefined;
  layerDigest?: string | undefined;
}
export declare class LayerInaccessibleException extends __BaseException {
  readonly name: "LayerInaccessibleException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LayerInaccessibleException, __BaseException>
  );
}
export declare class LayersNotFoundException extends __BaseException {
  readonly name: "LayersNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LayersNotFoundException, __BaseException>
  );
}
export declare class UnableToGetUpstreamLayerException extends __BaseException {
  readonly name: "UnableToGetUpstreamLayerException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      UnableToGetUpstreamLayerException,
      __BaseException
    >
  );
}
export interface GetLifecyclePolicyRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
}
export interface GetLifecyclePolicyResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  lifecyclePolicyText?: string | undefined;
  lastEvaluatedAt?: Date | undefined;
}
export interface LifecyclePolicyPreviewFilter {
  tagStatus?: TagStatus | undefined;
}
export interface GetLifecyclePolicyPreviewRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  imageIds?: ImageIdentifier[] | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
  filter?: LifecyclePolicyPreviewFilter | undefined;
}
export declare const ImageActionType: {
  readonly EXPIRE: "EXPIRE";
};
export type ImageActionType =
  (typeof ImageActionType)[keyof typeof ImageActionType];
export interface LifecyclePolicyRuleAction {
  type?: ImageActionType | undefined;
}
export interface LifecyclePolicyPreviewResult {
  imageTags?: string[] | undefined;
  imageDigest?: string | undefined;
  imagePushedAt?: Date | undefined;
  action?: LifecyclePolicyRuleAction | undefined;
  appliedRulePriority?: number | undefined;
}
export declare const LifecyclePolicyPreviewStatus: {
  readonly COMPLETE: "COMPLETE";
  readonly EXPIRED: "EXPIRED";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
};
export type LifecyclePolicyPreviewStatus =
  (typeof LifecyclePolicyPreviewStatus)[keyof typeof LifecyclePolicyPreviewStatus];
export interface LifecyclePolicyPreviewSummary {
  expiringImageTotalCount?: number | undefined;
}
export interface GetLifecyclePolicyPreviewResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  lifecyclePolicyText?: string | undefined;
  status?: LifecyclePolicyPreviewStatus | undefined;
  nextToken?: string | undefined;
  previewResults?: LifecyclePolicyPreviewResult[] | undefined;
  summary?: LifecyclePolicyPreviewSummary | undefined;
}
export declare class LifecyclePolicyPreviewNotFoundException extends __BaseException {
  readonly name: "LifecyclePolicyPreviewNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      LifecyclePolicyPreviewNotFoundException,
      __BaseException
    >
  );
}
export interface GetRegistryPolicyRequest {}
export interface GetRegistryPolicyResponse {
  registryId?: string | undefined;
  policyText?: string | undefined;
}
export interface GetRegistryScanningConfigurationRequest {}
export interface RegistryScanningRule {
  scanFrequency: ScanFrequency | undefined;
  repositoryFilters: ScanningRepositoryFilter[] | undefined;
}
export declare const ScanType: {
  readonly BASIC: "BASIC";
  readonly ENHANCED: "ENHANCED";
};
export type ScanType = (typeof ScanType)[keyof typeof ScanType];
export interface RegistryScanningConfiguration {
  scanType?: ScanType | undefined;
  rules?: RegistryScanningRule[] | undefined;
}
export interface GetRegistryScanningConfigurationResponse {
  registryId?: string | undefined;
  scanningConfiguration?: RegistryScanningConfiguration | undefined;
}
export interface GetRepositoryPolicyRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
}
export interface GetRepositoryPolicyResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  policyText?: string | undefined;
}
export interface InitiateLayerUploadRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
}
export interface InitiateLayerUploadResponse {
  uploadId?: string | undefined;
  partSize?: number | undefined;
}
export interface ListImagesFilter {
  tagStatus?: TagStatus | undefined;
}
export interface ListImagesRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
  filter?: ListImagesFilter | undefined;
}
export interface ListImagesResponse {
  imageIds?: ImageIdentifier[] | undefined;
  nextToken?: string | undefined;
}
export interface ListTagsForResourceRequest {
  resourceArn: string | undefined;
}
export interface ListTagsForResourceResponse {
  tags?: Tag[] | undefined;
}
export interface PutAccountSettingRequest {
  name: string | undefined;
  value: string | undefined;
}
export interface PutAccountSettingResponse {
  name?: string | undefined;
  value?: string | undefined;
}
export declare class ImageAlreadyExistsException extends __BaseException {
  readonly name: "ImageAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ImageAlreadyExistsException, __BaseException>
  );
}
export declare class ImageDigestDoesNotMatchException extends __BaseException {
  readonly name: "ImageDigestDoesNotMatchException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ImageDigestDoesNotMatchException,
      __BaseException
    >
  );
}
export declare class ImageTagAlreadyExistsException extends __BaseException {
  readonly name: "ImageTagAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ImageTagAlreadyExistsException, __BaseException>
  );
}
export interface PutImageRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  imageManifest: string | undefined;
  imageManifestMediaType?: string | undefined;
  imageTag?: string | undefined;
  imageDigest?: string | undefined;
}
export interface PutImageResponse {
  image?: Image | undefined;
}
export declare class ReferencedImagesNotFoundException extends __BaseException {
  readonly name: "ReferencedImagesNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ReferencedImagesNotFoundException,
      __BaseException
    >
  );
}
export interface PutImageScanningConfigurationRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  imageScanningConfiguration: ImageScanningConfiguration | undefined;
}
export interface PutImageScanningConfigurationResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  imageScanningConfiguration?: ImageScanningConfiguration | undefined;
}
export interface PutImageTagMutabilityRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  imageTagMutability: ImageTagMutability | undefined;
}
export interface PutImageTagMutabilityResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  imageTagMutability?: ImageTagMutability | undefined;
}
export interface PutLifecyclePolicyRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  lifecyclePolicyText: string | undefined;
}
export interface PutLifecyclePolicyResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  lifecyclePolicyText?: string | undefined;
}
export interface PutRegistryPolicyRequest {
  policyText: string | undefined;
}
export interface PutRegistryPolicyResponse {
  registryId?: string | undefined;
  policyText?: string | undefined;
}
export interface PutRegistryScanningConfigurationRequest {
  scanType?: ScanType | undefined;
  rules?: RegistryScanningRule[] | undefined;
}
export interface PutRegistryScanningConfigurationResponse {
  registryScanningConfiguration?: RegistryScanningConfiguration | undefined;
}
export interface PutReplicationConfigurationRequest {
  replicationConfiguration: ReplicationConfiguration | undefined;
}
export interface PutReplicationConfigurationResponse {
  replicationConfiguration?: ReplicationConfiguration | undefined;
}
export interface SetRepositoryPolicyRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  policyText: string | undefined;
  force?: boolean | undefined;
}
export interface SetRepositoryPolicyResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  policyText?: string | undefined;
}
export interface StartImageScanRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  imageId: ImageIdentifier | undefined;
}
export interface StartImageScanResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  imageId?: ImageIdentifier | undefined;
  imageScanStatus?: ImageScanStatus | undefined;
}
export declare class UnsupportedImageTypeException extends __BaseException {
  readonly name: "UnsupportedImageTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnsupportedImageTypeException, __BaseException>
  );
}
export declare class LifecyclePolicyPreviewInProgressException extends __BaseException {
  readonly name: "LifecyclePolicyPreviewInProgressException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      LifecyclePolicyPreviewInProgressException,
      __BaseException
    >
  );
}
export interface StartLifecyclePolicyPreviewRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  lifecyclePolicyText?: string | undefined;
}
export interface StartLifecyclePolicyPreviewResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  lifecyclePolicyText?: string | undefined;
  status?: LifecyclePolicyPreviewStatus | undefined;
}
export interface TagResourceRequest {
  resourceArn: string | undefined;
  tags: Tag[] | undefined;
}
export interface TagResourceResponse {}
export interface UntagResourceRequest {
  resourceArn: string | undefined;
  tagKeys: string[] | undefined;
}
export interface UntagResourceResponse {}
export interface UpdatePullThroughCacheRuleRequest {
  registryId?: string | undefined;
  ecrRepositoryPrefix: string | undefined;
  credentialArn?: string | undefined;
  customRoleArn?: string | undefined;
}
export interface UpdatePullThroughCacheRuleResponse {
  ecrRepositoryPrefix?: string | undefined;
  registryId?: string | undefined;
  updatedAt?: Date | undefined;
  credentialArn?: string | undefined;
  customRoleArn?: string | undefined;
  upstreamRepositoryPrefix?: string | undefined;
}
export interface UpdateRepositoryCreationTemplateRequest {
  prefix: string | undefined;
  description?: string | undefined;
  encryptionConfiguration?:
    | EncryptionConfigurationForRepositoryCreationTemplate
    | undefined;
  resourceTags?: Tag[] | undefined;
  imageTagMutability?: ImageTagMutability | undefined;
  repositoryPolicy?: string | undefined;
  lifecyclePolicy?: string | undefined;
  appliedFor?: RCTAppliedFor[] | undefined;
  customRoleArn?: string | undefined;
}
export interface UpdateRepositoryCreationTemplateResponse {
  registryId?: string | undefined;
  repositoryCreationTemplate?: RepositoryCreationTemplate | undefined;
}
export declare class InvalidLayerPartException extends __BaseException {
  readonly name: "InvalidLayerPartException";
  readonly $fault: "client";
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  uploadId?: string | undefined;
  lastValidByteReceived?: number | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidLayerPartException, __BaseException>
  );
}
export interface UploadLayerPartRequest {
  registryId?: string | undefined;
  repositoryName: string | undefined;
  uploadId: string | undefined;
  partFirstByte: number | undefined;
  partLastByte: number | undefined;
  layerPartBlob: Uint8Array | undefined;
}
export interface UploadLayerPartResponse {
  registryId?: string | undefined;
  repositoryName?: string | undefined;
  uploadId?: string | undefined;
  lastByteReceived?: number | undefined;
}
export interface ValidatePullThroughCacheRuleRequest {
  ecrRepositoryPrefix: string | undefined;
  registryId?: string | undefined;
}
export interface ValidatePullThroughCacheRuleResponse {
  ecrRepositoryPrefix?: string | undefined;
  registryId?: string | undefined;
  upstreamRegistryUrl?: string | undefined;
  credentialArn?: string | undefined;
  customRoleArn?: string | undefined;
  upstreamRepositoryPrefix?: string | undefined;
  isValid?: boolean | undefined;
  failure?: string | undefined;
}
