import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ECRClient";
import { PutRegistryScanningConfigurationRequest, PutRegistryScanningConfigurationResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link PutRegistryScanningConfigurationCommand}.
 */
export interface PutRegistryScanningConfigurationCommandInput extends PutRegistryScanningConfigurationRequest {
}
/**
 * @public
 *
 * The output of {@link PutRegistryScanningConfigurationCommand}.
 */
export interface PutRegistryScanningConfigurationCommandOutput extends PutRegistryScanningConfigurationResponse, __MetadataBearer {
}
declare const PutRegistryScanningConfigurationCommand_base: {
    new (input: PutRegistryScanningConfigurationCommandInput): import("@smithy/smithy-client").CommandImpl<PutRegistryScanningConfigurationCommandInput, PutRegistryScanningConfigurationCommandOutput, ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [PutRegistryScanningConfigurationCommandInput]): import("@smithy/smithy-client").CommandImpl<PutRegistryScanningConfigurationCommandInput, PutRegistryScanningConfigurationCommandOutput, ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Creates or updates the scanning configuration for your private registry.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ECRClient, PutRegistryScanningConfigurationCommand } from "@aws-sdk/client-ecr"; // ES Modules import
 * // const { ECRClient, PutRegistryScanningConfigurationCommand } = require("@aws-sdk/client-ecr"); // CommonJS import
 * const client = new ECRClient(config);
 * const input = { // PutRegistryScanningConfigurationRequest
 *   scanType: "BASIC" || "ENHANCED",
 *   rules: [ // RegistryScanningRuleList
 *     { // RegistryScanningRule
 *       scanFrequency: "SCAN_ON_PUSH" || "CONTINUOUS_SCAN" || "MANUAL", // required
 *       repositoryFilters: [ // ScanningRepositoryFilterList // required
 *         { // ScanningRepositoryFilter
 *           filter: "STRING_VALUE", // required
 *           filterType: "WILDCARD", // required
 *         },
 *       ],
 *     },
 *   ],
 * };
 * const command = new PutRegistryScanningConfigurationCommand(input);
 * const response = await client.send(command);
 * // { // PutRegistryScanningConfigurationResponse
 * //   registryScanningConfiguration: { // RegistryScanningConfiguration
 * //     scanType: "BASIC" || "ENHANCED",
 * //     rules: [ // RegistryScanningRuleList
 * //       { // RegistryScanningRule
 * //         scanFrequency: "SCAN_ON_PUSH" || "CONTINUOUS_SCAN" || "MANUAL", // required
 * //         repositoryFilters: [ // ScanningRepositoryFilterList // required
 * //           { // ScanningRepositoryFilter
 * //             filter: "STRING_VALUE", // required
 * //             filterType: "WILDCARD", // required
 * //           },
 * //         ],
 * //       },
 * //     ],
 * //   },
 * // };
 *
 * ```
 *
 * @param PutRegistryScanningConfigurationCommandInput - {@link PutRegistryScanningConfigurationCommandInput}
 * @returns {@link PutRegistryScanningConfigurationCommandOutput}
 * @see {@link PutRegistryScanningConfigurationCommandInput} for command's `input` shape.
 * @see {@link PutRegistryScanningConfigurationCommandOutput} for command's `response` shape.
 * @see {@link ECRClientResolvedConfig | config} for ECRClient's `config` shape.
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>The specified parameter is invalid. Review the available parameters for the API
 *             request.</p>
 *
 * @throws {@link ServerException} (server fault)
 *  <p>These errors are usually caused by a server-side issue.</p>
 *
 * @throws {@link ValidationException} (client fault)
 *  <p>There was an exception validating this request.</p>
 *
 * @throws {@link ECRServiceException}
 * <p>Base exception class for all service exceptions from ECR service.</p>
 *
 *
 * @public
 */
export declare class PutRegistryScanningConfigurationCommand extends PutRegistryScanningConfigurationCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: PutRegistryScanningConfigurationRequest;
            output: PutRegistryScanningConfigurationResponse;
        };
        sdk: {
            input: PutRegistryScanningConfigurationCommandInput;
            output: PutRegistryScanningConfigurationCommandOutput;
        };
    };
}
