import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ECRClient";
import { PutRegistryPolicyRequest, PutRegistryPolicyResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link PutRegistryPolicyCommand}.
 */
export interface PutRegistryPolicyCommandInput extends PutRegistryPolicyRequest {
}
/**
 * @public
 *
 * The output of {@link PutRegistryPolicyCommand}.
 */
export interface PutRegistryPolicyCommandOutput extends PutRegistryPolicyResponse, __MetadataBearer {
}
declare const PutRegistryPolicyCommand_base: {
    new (input: PutRegistryPolicyCommandInput): import("@smithy/smithy-client").CommandImpl<PutRegistryPolicyCommandInput, PutRegistryPolicyCommandOutput, ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: PutRegistryPolicyCommandInput): import("@smithy/smithy-client").CommandImpl<PutRegistryPolicyCommandInput, PutRegistryPolicyCommandOutput, ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Creates or updates the permissions policy for your registry.</p>
 *          <p>A registry policy is used to specify permissions for another Amazon Web Services account and is used
 *             when configuring cross-account replication. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ECRClient, PutRegistryPolicyCommand } from "@aws-sdk/client-ecr"; // ES Modules import
 * // const { ECRClient, PutRegistryPolicyCommand } = require("@aws-sdk/client-ecr"); // CommonJS import
 * const client = new ECRClient(config);
 * const input = { // PutRegistryPolicyRequest
 *   policyText: "STRING_VALUE", // required
 * };
 * const command = new PutRegistryPolicyCommand(input);
 * const response = await client.send(command);
 * // { // PutRegistryPolicyResponse
 * //   registryId: "STRING_VALUE",
 * //   policyText: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param PutRegistryPolicyCommandInput - {@link PutRegistryPolicyCommandInput}
 * @returns {@link PutRegistryPolicyCommandOutput}
 * @see {@link PutRegistryPolicyCommandInput} for command's `input` shape.
 * @see {@link PutRegistryPolicyCommandOutput} for command's `response` shape.
 * @see {@link ECRClientResolvedConfig | config} for ECRClient's `config` shape.
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>The specified parameter is invalid. Review the available parameters for the API
 *             request.</p>
 *
 * @throws {@link ServerException} (server fault)
 *  <p>These errors are usually caused by a server-side issue.</p>
 *
 * @throws {@link ValidationException} (client fault)
 *  <p>There was an exception validating this request.</p>
 *
 * @throws {@link ECRServiceException}
 * <p>Base exception class for all service exceptions from ECR service.</p>
 *
 *
 * @public
 */
export declare class PutRegistryPolicyCommand extends PutRegistryPolicyCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: PutRegistryPolicyRequest;
            output: PutRegistryPolicyResponse;
        };
        sdk: {
            input: PutRegistryPolicyCommandInput;
            output: PutRegistryPolicyCommandOutput;
        };
    };
}
