import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ECRClient";
import { GetLifecyclePolicyPreviewRequest, GetLifecyclePolicyPreviewResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link GetLifecyclePolicyPreviewCommand}.
 */
export interface GetLifecyclePolicyPreviewCommandInput extends GetLifecyclePolicyPreviewRequest {
}
/**
 * @public
 *
 * The output of {@link GetLifecyclePolicyPreviewCommand}.
 */
export interface GetLifecyclePolicyPreviewCommandOutput extends GetLifecyclePolicyPreviewResponse, __MetadataBearer {
}
declare const GetLifecyclePolicyPreviewCommand_base: {
    new (input: GetLifecyclePolicyPreviewCommandInput): import("@smithy/smithy-client").CommandImpl<GetLifecyclePolicyPreviewCommandInput, GetLifecyclePolicyPreviewCommandOutput, ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: GetLifecyclePolicyPreviewCommandInput): import("@smithy/smithy-client").CommandImpl<GetLifecyclePolicyPreviewCommandInput, GetLifecyclePolicyPreviewCommandOutput, ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Retrieves the results of the lifecycle policy preview request for the specified
 *             repository.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ECRClient, GetLifecyclePolicyPreviewCommand } from "@aws-sdk/client-ecr"; // ES Modules import
 * // const { ECRClient, GetLifecyclePolicyPreviewCommand } = require("@aws-sdk/client-ecr"); // CommonJS import
 * const client = new ECRClient(config);
 * const input = { // GetLifecyclePolicyPreviewRequest
 *   registryId: "STRING_VALUE",
 *   repositoryName: "STRING_VALUE", // required
 *   imageIds: [ // ImageIdentifierList
 *     { // ImageIdentifier
 *       imageDigest: "STRING_VALUE",
 *       imageTag: "STRING_VALUE",
 *     },
 *   ],
 *   nextToken: "STRING_VALUE",
 *   maxResults: Number("int"),
 *   filter: { // LifecyclePolicyPreviewFilter
 *     tagStatus: "TAGGED" || "UNTAGGED" || "ANY",
 *   },
 * };
 * const command = new GetLifecyclePolicyPreviewCommand(input);
 * const response = await client.send(command);
 * // { // GetLifecyclePolicyPreviewResponse
 * //   registryId: "STRING_VALUE",
 * //   repositoryName: "STRING_VALUE",
 * //   lifecyclePolicyText: "STRING_VALUE",
 * //   status: "IN_PROGRESS" || "COMPLETE" || "EXPIRED" || "FAILED",
 * //   nextToken: "STRING_VALUE",
 * //   previewResults: [ // LifecyclePolicyPreviewResultList
 * //     { // LifecyclePolicyPreviewResult
 * //       imageTags: [ // ImageTagList
 * //         "STRING_VALUE",
 * //       ],
 * //       imageDigest: "STRING_VALUE",
 * //       imagePushedAt: new Date("TIMESTAMP"),
 * //       action: { // LifecyclePolicyRuleAction
 * //         type: "EXPIRE",
 * //       },
 * //       appliedRulePriority: Number("int"),
 * //     },
 * //   ],
 * //   summary: { // LifecyclePolicyPreviewSummary
 * //     expiringImageTotalCount: Number("int"),
 * //   },
 * // };
 *
 * ```
 *
 * @param GetLifecyclePolicyPreviewCommandInput - {@link GetLifecyclePolicyPreviewCommandInput}
 * @returns {@link GetLifecyclePolicyPreviewCommandOutput}
 * @see {@link GetLifecyclePolicyPreviewCommandInput} for command's `input` shape.
 * @see {@link GetLifecyclePolicyPreviewCommandOutput} for command's `response` shape.
 * @see {@link ECRClientResolvedConfig | config} for ECRClient's `config` shape.
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>The specified parameter is invalid. Review the available parameters for the API
 *             request.</p>
 *
 * @throws {@link LifecyclePolicyPreviewNotFoundException} (client fault)
 *  <p>There is no dry run for this repository.</p>
 *
 * @throws {@link RepositoryNotFoundException} (client fault)
 *  <p>The specified repository could not be found. Check the spelling of the specified
 *             repository and ensure that you are performing operations on the correct registry.</p>
 *
 * @throws {@link ServerException} (server fault)
 *  <p>These errors are usually caused by a server-side issue.</p>
 *
 * @throws {@link ValidationException} (client fault)
 *  <p>There was an exception validating this request.</p>
 *
 * @throws {@link ECRServiceException}
 * <p>Base exception class for all service exceptions from ECR service.</p>
 *
 *
 * @public
 */
export declare class GetLifecyclePolicyPreviewCommand extends GetLifecyclePolicyPreviewCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: GetLifecyclePolicyPreviewRequest;
            output: GetLifecyclePolicyPreviewResponse;
        };
        sdk: {
            input: GetLifecyclePolicyPreviewCommandInput;
            output: GetLifecyclePolicyPreviewCommandOutput;
        };
    };
}
