import { HostHeaderInputConfig, HostHeaderResolvedConfig } from "@aws-sdk/middleware-host-header";
import { UserAgentInputConfig, UserAgentResolvedConfig } from "@aws-sdk/middleware-user-agent";
import { RegionInputConfig, RegionResolvedConfig } from "@smithy/config-resolver";
import { EndpointInputConfig, EndpointResolvedConfig } from "@smithy/middleware-endpoint";
import { RetryInputConfig, RetryResolvedConfig } from "@smithy/middleware-retry";
import { HttpHandlerUserInput as __HttpHandlerUserInput } from "@smithy/protocol-http";
import { Client as __Client, DefaultsMode as __DefaultsMode, SmithyConfiguration as __SmithyConfiguration, SmithyResolvedConfiguration as __SmithyResolvedConfiguration } from "@smithy/smithy-client";
import { AwsCredentialIdentityProvider, BodyLengthCalculator as __BodyLengthCalculator, CheckOptionalClientConfig as __CheckOptionalClientConfig, ChecksumConstructor as __ChecksumConstructor, Decoder as __Decoder, Encoder as __Encoder, HashConstructor as __HashConstructor, HttpHandlerOptions as __HttpHandlerOptions, Logger as __Logger, Provider as __Provider, Provider, StreamCollector as __StreamCollector, UrlParser as __UrlParser, UserAgent as __UserAgent } from "@smithy/types";
import { HttpAuthSchemeInputConfig, HttpAuthSchemeResolvedConfig } from "./auth/httpAuthSchemeProvider";
import { BatchCheckLayerAvailabilityCommandInput, BatchCheckLayerAvailabilityCommandOutput } from "./commands/BatchCheckLayerAvailabilityCommand";
import { BatchDeleteImageCommandInput, BatchDeleteImageCommandOutput } from "./commands/BatchDeleteImageCommand";
import { BatchGetImageCommandInput, BatchGetImageCommandOutput } from "./commands/BatchGetImageCommand";
import { BatchGetRepositoryScanningConfigurationCommandInput, BatchGetRepositoryScanningConfigurationCommandOutput } from "./commands/BatchGetRepositoryScanningConfigurationCommand";
import { CompleteLayerUploadCommandInput, CompleteLayerUploadCommandOutput } from "./commands/CompleteLayerUploadCommand";
import { CreatePullThroughCacheRuleCommandInput, CreatePullThroughCacheRuleCommandOutput } from "./commands/CreatePullThroughCacheRuleCommand";
import { CreateRepositoryCommandInput, CreateRepositoryCommandOutput } from "./commands/CreateRepositoryCommand";
import { CreateRepositoryCreationTemplateCommandInput, CreateRepositoryCreationTemplateCommandOutput } from "./commands/CreateRepositoryCreationTemplateCommand";
import { DeleteLifecyclePolicyCommandInput, DeleteLifecyclePolicyCommandOutput } from "./commands/DeleteLifecyclePolicyCommand";
import { DeletePullThroughCacheRuleCommandInput, DeletePullThroughCacheRuleCommandOutput } from "./commands/DeletePullThroughCacheRuleCommand";
import { DeleteRegistryPolicyCommandInput, DeleteRegistryPolicyCommandOutput } from "./commands/DeleteRegistryPolicyCommand";
import { DeleteRepositoryCommandInput, DeleteRepositoryCommandOutput } from "./commands/DeleteRepositoryCommand";
import { DeleteRepositoryCreationTemplateCommandInput, DeleteRepositoryCreationTemplateCommandOutput } from "./commands/DeleteRepositoryCreationTemplateCommand";
import { DeleteRepositoryPolicyCommandInput, DeleteRepositoryPolicyCommandOutput } from "./commands/DeleteRepositoryPolicyCommand";
import { DescribeImageReplicationStatusCommandInput, DescribeImageReplicationStatusCommandOutput } from "./commands/DescribeImageReplicationStatusCommand";
import { DescribeImageScanFindingsCommandInput, DescribeImageScanFindingsCommandOutput } from "./commands/DescribeImageScanFindingsCommand";
import { DescribeImagesCommandInput, DescribeImagesCommandOutput } from "./commands/DescribeImagesCommand";
import { DescribePullThroughCacheRulesCommandInput, DescribePullThroughCacheRulesCommandOutput } from "./commands/DescribePullThroughCacheRulesCommand";
import { DescribeRegistryCommandInput, DescribeRegistryCommandOutput } from "./commands/DescribeRegistryCommand";
import { DescribeRepositoriesCommandInput, DescribeRepositoriesCommandOutput } from "./commands/DescribeRepositoriesCommand";
import { DescribeRepositoryCreationTemplatesCommandInput, DescribeRepositoryCreationTemplatesCommandOutput } from "./commands/DescribeRepositoryCreationTemplatesCommand";
import { GetAccountSettingCommandInput, GetAccountSettingCommandOutput } from "./commands/GetAccountSettingCommand";
import { GetAuthorizationTokenCommandInput, GetAuthorizationTokenCommandOutput } from "./commands/GetAuthorizationTokenCommand";
import { GetDownloadUrlForLayerCommandInput, GetDownloadUrlForLayerCommandOutput } from "./commands/GetDownloadUrlForLayerCommand";
import { GetLifecyclePolicyCommandInput, GetLifecyclePolicyCommandOutput } from "./commands/GetLifecyclePolicyCommand";
import { GetLifecyclePolicyPreviewCommandInput, GetLifecyclePolicyPreviewCommandOutput } from "./commands/GetLifecyclePolicyPreviewCommand";
import { GetRegistryPolicyCommandInput, GetRegistryPolicyCommandOutput } from "./commands/GetRegistryPolicyCommand";
import { GetRegistryScanningConfigurationCommandInput, GetRegistryScanningConfigurationCommandOutput } from "./commands/GetRegistryScanningConfigurationCommand";
import { GetRepositoryPolicyCommandInput, GetRepositoryPolicyCommandOutput } from "./commands/GetRepositoryPolicyCommand";
import { InitiateLayerUploadCommandInput, InitiateLayerUploadCommandOutput } from "./commands/InitiateLayerUploadCommand";
import { ListImagesCommandInput, ListImagesCommandOutput } from "./commands/ListImagesCommand";
import { ListTagsForResourceCommandInput, ListTagsForResourceCommandOutput } from "./commands/ListTagsForResourceCommand";
import { PutAccountSettingCommandInput, PutAccountSettingCommandOutput } from "./commands/PutAccountSettingCommand";
import { PutImageCommandInput, PutImageCommandOutput } from "./commands/PutImageCommand";
import { PutImageScanningConfigurationCommandInput, PutImageScanningConfigurationCommandOutput } from "./commands/PutImageScanningConfigurationCommand";
import { PutImageTagMutabilityCommandInput, PutImageTagMutabilityCommandOutput } from "./commands/PutImageTagMutabilityCommand";
import { PutLifecyclePolicyCommandInput, PutLifecyclePolicyCommandOutput } from "./commands/PutLifecyclePolicyCommand";
import { PutRegistryPolicyCommandInput, PutRegistryPolicyCommandOutput } from "./commands/PutRegistryPolicyCommand";
import { PutRegistryScanningConfigurationCommandInput, PutRegistryScanningConfigurationCommandOutput } from "./commands/PutRegistryScanningConfigurationCommand";
import { PutReplicationConfigurationCommandInput, PutReplicationConfigurationCommandOutput } from "./commands/PutReplicationConfigurationCommand";
import { SetRepositoryPolicyCommandInput, SetRepositoryPolicyCommandOutput } from "./commands/SetRepositoryPolicyCommand";
import { StartImageScanCommandInput, StartImageScanCommandOutput } from "./commands/StartImageScanCommand";
import { StartLifecyclePolicyPreviewCommandInput, StartLifecyclePolicyPreviewCommandOutput } from "./commands/StartLifecyclePolicyPreviewCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { UpdatePullThroughCacheRuleCommandInput, UpdatePullThroughCacheRuleCommandOutput } from "./commands/UpdatePullThroughCacheRuleCommand";
import { UpdateRepositoryCreationTemplateCommandInput, UpdateRepositoryCreationTemplateCommandOutput } from "./commands/UpdateRepositoryCreationTemplateCommand";
import { UploadLayerPartCommandInput, UploadLayerPartCommandOutput } from "./commands/UploadLayerPartCommand";
import { ValidatePullThroughCacheRuleCommandInput, ValidatePullThroughCacheRuleCommandOutput } from "./commands/ValidatePullThroughCacheRuleCommand";
import { ClientInputEndpointParameters, ClientResolvedEndpointParameters, EndpointParameters } from "./endpoint/EndpointParameters";
import { RuntimeExtension, RuntimeExtensionsConfig } from "./runtimeExtensions";
export { __Client };
/**
 * @public
 */
export type ServiceInputTypes = BatchCheckLayerAvailabilityCommandInput | BatchDeleteImageCommandInput | BatchGetImageCommandInput | BatchGetRepositoryScanningConfigurationCommandInput | CompleteLayerUploadCommandInput | CreatePullThroughCacheRuleCommandInput | CreateRepositoryCommandInput | CreateRepositoryCreationTemplateCommandInput | DeleteLifecyclePolicyCommandInput | DeletePullThroughCacheRuleCommandInput | DeleteRegistryPolicyCommandInput | DeleteRepositoryCommandInput | DeleteRepositoryCreationTemplateCommandInput | DeleteRepositoryPolicyCommandInput | DescribeImageReplicationStatusCommandInput | DescribeImageScanFindingsCommandInput | DescribeImagesCommandInput | DescribePullThroughCacheRulesCommandInput | DescribeRegistryCommandInput | DescribeRepositoriesCommandInput | DescribeRepositoryCreationTemplatesCommandInput | GetAccountSettingCommandInput | GetAuthorizationTokenCommandInput | GetDownloadUrlForLayerCommandInput | GetLifecyclePolicyCommandInput | GetLifecyclePolicyPreviewCommandInput | GetRegistryPolicyCommandInput | GetRegistryScanningConfigurationCommandInput | GetRepositoryPolicyCommandInput | InitiateLayerUploadCommandInput | ListImagesCommandInput | ListTagsForResourceCommandInput | PutAccountSettingCommandInput | PutImageCommandInput | PutImageScanningConfigurationCommandInput | PutImageTagMutabilityCommandInput | PutLifecyclePolicyCommandInput | PutRegistryPolicyCommandInput | PutRegistryScanningConfigurationCommandInput | PutReplicationConfigurationCommandInput | SetRepositoryPolicyCommandInput | StartImageScanCommandInput | StartLifecyclePolicyPreviewCommandInput | TagResourceCommandInput | UntagResourceCommandInput | UpdatePullThroughCacheRuleCommandInput | UpdateRepositoryCreationTemplateCommandInput | UploadLayerPartCommandInput | ValidatePullThroughCacheRuleCommandInput;
/**
 * @public
 */
export type ServiceOutputTypes = BatchCheckLayerAvailabilityCommandOutput | BatchDeleteImageCommandOutput | BatchGetImageCommandOutput | BatchGetRepositoryScanningConfigurationCommandOutput | CompleteLayerUploadCommandOutput | CreatePullThroughCacheRuleCommandOutput | CreateRepositoryCommandOutput | CreateRepositoryCreationTemplateCommandOutput | DeleteLifecyclePolicyCommandOutput | DeletePullThroughCacheRuleCommandOutput | DeleteRegistryPolicyCommandOutput | DeleteRepositoryCommandOutput | DeleteRepositoryCreationTemplateCommandOutput | DeleteRepositoryPolicyCommandOutput | DescribeImageReplicationStatusCommandOutput | DescribeImageScanFindingsCommandOutput | DescribeImagesCommandOutput | DescribePullThroughCacheRulesCommandOutput | DescribeRegistryCommandOutput | DescribeRepositoriesCommandOutput | DescribeRepositoryCreationTemplatesCommandOutput | GetAccountSettingCommandOutput | GetAuthorizationTokenCommandOutput | GetDownloadUrlForLayerCommandOutput | GetLifecyclePolicyCommandOutput | GetLifecyclePolicyPreviewCommandOutput | GetRegistryPolicyCommandOutput | GetRegistryScanningConfigurationCommandOutput | GetRepositoryPolicyCommandOutput | InitiateLayerUploadCommandOutput | ListImagesCommandOutput | ListTagsForResourceCommandOutput | PutAccountSettingCommandOutput | PutImageCommandOutput | PutImageScanningConfigurationCommandOutput | PutImageTagMutabilityCommandOutput | PutLifecyclePolicyCommandOutput | PutRegistryPolicyCommandOutput | PutRegistryScanningConfigurationCommandOutput | PutReplicationConfigurationCommandOutput | SetRepositoryPolicyCommandOutput | StartImageScanCommandOutput | StartLifecyclePolicyPreviewCommandOutput | TagResourceCommandOutput | UntagResourceCommandOutput | UpdatePullThroughCacheRuleCommandOutput | UpdateRepositoryCreationTemplateCommandOutput | UploadLayerPartCommandOutput | ValidatePullThroughCacheRuleCommandOutput;
/**
 * @public
 */
export interface ClientDefaults extends Partial<__SmithyConfiguration<__HttpHandlerOptions>> {
    /**
     * The HTTP handler to use or its constructor options. Fetch in browser and Https in Nodejs.
     */
    requestHandler?: __HttpHandlerUserInput;
    /**
     * A constructor for a class implementing the {@link @smithy/types#ChecksumConstructor} interface
     * that computes the SHA-256 HMAC or checksum of a string or binary buffer.
     * @internal
     */
    sha256?: __ChecksumConstructor | __HashConstructor;
    /**
     * The function that will be used to convert strings into HTTP endpoints.
     * @internal
     */
    urlParser?: __UrlParser;
    /**
     * A function that can calculate the length of a request body.
     * @internal
     */
    bodyLengthChecker?: __BodyLengthCalculator;
    /**
     * A function that converts a stream into an array of bytes.
     * @internal
     */
    streamCollector?: __StreamCollector;
    /**
     * The function that will be used to convert a base64-encoded string to a byte array.
     * @internal
     */
    base64Decoder?: __Decoder;
    /**
     * The function that will be used to convert binary data to a base64-encoded string.
     * @internal
     */
    base64Encoder?: __Encoder;
    /**
     * The function that will be used to convert a UTF8-encoded string to a byte array.
     * @internal
     */
    utf8Decoder?: __Decoder;
    /**
     * The function that will be used to convert binary data to a UTF-8 encoded string.
     * @internal
     */
    utf8Encoder?: __Encoder;
    /**
     * The runtime environment.
     * @internal
     */
    runtime?: string;
    /**
     * Disable dynamically changing the endpoint of the client based on the hostPrefix
     * trait of an operation.
     */
    disableHostPrefix?: boolean;
    /**
     * Unique service identifier.
     * @internal
     */
    serviceId?: string;
    /**
     * Enables IPv6/IPv4 dualstack endpoint.
     */
    useDualstackEndpoint?: boolean | __Provider<boolean>;
    /**
     * Enables FIPS compatible endpoints.
     */
    useFipsEndpoint?: boolean | __Provider<boolean>;
    /**
     * The AWS region to which this client will send requests
     */
    region?: string | __Provider<string>;
    /**
     * Setting a client profile is similar to setting a value for the
     * AWS_PROFILE environment variable. Setting a profile on a client
     * in code only affects the single client instance, unlike AWS_PROFILE.
     *
     * When set, and only for environments where an AWS configuration
     * file exists, fields configurable by this file will be retrieved
     * from the specified profile within that file.
     * Conflicting code configuration and environment variables will
     * still have higher priority.
     *
     * For client credential resolution that involves checking the AWS
     * configuration file, the client's profile (this value) will be
     * used unless a different profile is set in the credential
     * provider options.
     *
     */
    profile?: string;
    /**
     * The provider populating default tracking information to be sent with `user-agent`, `x-amz-user-agent` header
     * @internal
     */
    defaultUserAgentProvider?: Provider<__UserAgent>;
    /**
     * Default credentials provider; Not available in browser runtime.
     * @deprecated
     * @internal
     */
    credentialDefaultProvider?: (input: any) => AwsCredentialIdentityProvider;
    /**
     * Value for how many times a request will be made at most in case of retry.
     */
    maxAttempts?: number | __Provider<number>;
    /**
     * Specifies which retry algorithm to use.
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/v3/latest/Package/-smithy-util-retry/Enum/RETRY_MODES/
     *
     */
    retryMode?: string | __Provider<string>;
    /**
     * Optional logger for logging debug/info/warn/error.
     */
    logger?: __Logger;
    /**
     * Optional extensions
     */
    extensions?: RuntimeExtension[];
    /**
     * The {@link @smithy/smithy-client#DefaultsMode} that will be used to determine how certain default configuration options are resolved in the SDK.
     */
    defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
/**
 * @public
 */
export type ECRClientConfigType = Partial<__SmithyConfiguration<__HttpHandlerOptions>> & ClientDefaults & UserAgentInputConfig & RetryInputConfig & RegionInputConfig & HostHeaderInputConfig & EndpointInputConfig<EndpointParameters> & HttpAuthSchemeInputConfig & ClientInputEndpointParameters;
/**
 * @public
 *
 *  The configuration interface of ECRClient class constructor that set the region, credentials and other options.
 */
export interface ECRClientConfig extends ECRClientConfigType {
}
/**
 * @public
 */
export type ECRClientResolvedConfigType = __SmithyResolvedConfiguration<__HttpHandlerOptions> & Required<ClientDefaults> & RuntimeExtensionsConfig & UserAgentResolvedConfig & RetryResolvedConfig & RegionResolvedConfig & HostHeaderResolvedConfig & EndpointResolvedConfig<EndpointParameters> & HttpAuthSchemeResolvedConfig & ClientResolvedEndpointParameters;
/**
 * @public
 *
 *  The resolved configuration interface of ECRClient class. This is resolved and normalized from the {@link ECRClientConfig | constructor configuration interface}.
 */
export interface ECRClientResolvedConfig extends ECRClientResolvedConfigType {
}
/**
 * <fullname>Amazon Elastic Container Registry</fullname>
 *          <p>Amazon Elastic Container Registry (Amazon ECR) is a managed container image registry service. Customers can use the
 *             familiar Docker CLI, or their preferred client, to push, pull, and manage images. Amazon ECR
 *             provides a secure, scalable, and reliable registry for your Docker or Open Container
 *             Initiative (OCI) images. Amazon ECR supports private repositories with resource-based
 *             permissions using IAM so that specific users or Amazon EC2 instances can access
 *             repositories and images.</p>
 *          <p>Amazon ECR has service endpoints in each supported Region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/ecr.html">Amazon ECR endpoints</a> in the
 *                 <i>Amazon Web Services General Reference</i>.</p>
 * @public
 */
export declare class ECRClient extends __Client<__HttpHandlerOptions, ServiceInputTypes, ServiceOutputTypes, ECRClientResolvedConfig> {
    /**
     * The resolved configuration of ECRClient class. This is resolved and normalized from the {@link ECRClientConfig | constructor configuration interface}.
     */
    readonly config: ECRClientResolvedConfig;
    constructor(...[configuration]: __CheckOptionalClientConfig<ECRClientConfig>);
    /**
     * Destroy underlying resources, like sockets. It's usually not necessary to do this.
     * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
     * Otherwise, sockets might stay open for quite a long time before the server terminates them.
     */
    destroy(): void;
}
