import { checkExceptions, createWaiter, WaiterState } from "@smithy/util-waiter";
import { DescribeImageScanFindingsCommand, } from "../commands/DescribeImageScanFindingsCommand";
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeImageScanFindingsCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.imageScanStatus.status;
            };
            if (returnComparator() === "COMPLETE") {
                return { state: WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                return result.imageScanStatus.status;
            };
            if (returnComparator() === "FAILED") {
                return { state: WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: WaiterState.RETRY, reason };
};
export const waitForImageScanComplete = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    return createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
export const waitUntilImageScanComplete = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    const result = await createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return checkExceptions(result);
};
