import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_PutImageCommand, se_PutImageCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class PutImageCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2ContainerRegistry_V20150921", "PutImage", {})
    .n("ECRClient", "PutImageCommand")
    .f(void 0, void 0)
    .ser(se_PutImageCommand)
    .de(de_PutImageCommand)
    .build() {
}
