import { createAggregatedClient } from "@smithy/smithy-client";
import { BatchCheckLayerAvailabilityCommand, } from "./commands/BatchCheckLayerAvailabilityCommand";
import { BatchDeleteImageCommand, } from "./commands/BatchDeleteImageCommand";
import { BatchGetImageCommand, } from "./commands/BatchGetImageCommand";
import { BatchGetRepositoryScanningConfigurationCommand, } from "./commands/BatchGetRepositoryScanningConfigurationCommand";
import { CompleteLayerUploadCommand, } from "./commands/CompleteLayerUploadCommand";
import { CreatePullThroughCacheRuleCommand, } from "./commands/CreatePullThroughCacheRuleCommand";
import { CreateRepositoryCommand, } from "./commands/CreateRepositoryCommand";
import { CreateRepositoryCreationTemplateCommand, } from "./commands/CreateRepositoryCreationTemplateCommand";
import { DeleteLifecyclePolicyCommand, } from "./commands/DeleteLifecyclePolicyCommand";
import { DeletePullThroughCacheRuleCommand, } from "./commands/DeletePullThroughCacheRuleCommand";
import { DeleteRegistryPolicyCommand, } from "./commands/DeleteRegistryPolicyCommand";
import { DeleteRepositoryCommand, } from "./commands/DeleteRepositoryCommand";
import { DeleteRepositoryCreationTemplateCommand, } from "./commands/DeleteRepositoryCreationTemplateCommand";
import { DeleteRepositoryPolicyCommand, } from "./commands/DeleteRepositoryPolicyCommand";
import { DescribeImageReplicationStatusCommand, } from "./commands/DescribeImageReplicationStatusCommand";
import { DescribeImageScanFindingsCommand, } from "./commands/DescribeImageScanFindingsCommand";
import { DescribeImagesCommand, } from "./commands/DescribeImagesCommand";
import { DescribePullThroughCacheRulesCommand, } from "./commands/DescribePullThroughCacheRulesCommand";
import { DescribeRegistryCommand, } from "./commands/DescribeRegistryCommand";
import { DescribeRepositoriesCommand, } from "./commands/DescribeRepositoriesCommand";
import { DescribeRepositoryCreationTemplatesCommand, } from "./commands/DescribeRepositoryCreationTemplatesCommand";
import { GetAccountSettingCommand, } from "./commands/GetAccountSettingCommand";
import { GetAuthorizationTokenCommand, } from "./commands/GetAuthorizationTokenCommand";
import { GetDownloadUrlForLayerCommand, } from "./commands/GetDownloadUrlForLayerCommand";
import { GetLifecyclePolicyCommand, } from "./commands/GetLifecyclePolicyCommand";
import { GetLifecyclePolicyPreviewCommand, } from "./commands/GetLifecyclePolicyPreviewCommand";
import { GetRegistryPolicyCommand, } from "./commands/GetRegistryPolicyCommand";
import { GetRegistryScanningConfigurationCommand, } from "./commands/GetRegistryScanningConfigurationCommand";
import { GetRepositoryPolicyCommand, } from "./commands/GetRepositoryPolicyCommand";
import { InitiateLayerUploadCommand, } from "./commands/InitiateLayerUploadCommand";
import { ListImagesCommand } from "./commands/ListImagesCommand";
import { ListTagsForResourceCommand, } from "./commands/ListTagsForResourceCommand";
import { PutAccountSettingCommand, } from "./commands/PutAccountSettingCommand";
import { PutImageCommand } from "./commands/PutImageCommand";
import { PutImageScanningConfigurationCommand, } from "./commands/PutImageScanningConfigurationCommand";
import { PutImageTagMutabilityCommand, } from "./commands/PutImageTagMutabilityCommand";
import { PutLifecyclePolicyCommand, } from "./commands/PutLifecyclePolicyCommand";
import { PutRegistryPolicyCommand, } from "./commands/PutRegistryPolicyCommand";
import { PutRegistryScanningConfigurationCommand, } from "./commands/PutRegistryScanningConfigurationCommand";
import { PutReplicationConfigurationCommand, } from "./commands/PutReplicationConfigurationCommand";
import { SetRepositoryPolicyCommand, } from "./commands/SetRepositoryPolicyCommand";
import { StartImageScanCommand, } from "./commands/StartImageScanCommand";
import { StartLifecyclePolicyPreviewCommand, } from "./commands/StartLifecyclePolicyPreviewCommand";
import { TagResourceCommand } from "./commands/TagResourceCommand";
import { UntagResourceCommand, } from "./commands/UntagResourceCommand";
import { UpdatePullThroughCacheRuleCommand, } from "./commands/UpdatePullThroughCacheRuleCommand";
import { UpdateRepositoryCreationTemplateCommand, } from "./commands/UpdateRepositoryCreationTemplateCommand";
import { UploadLayerPartCommand, } from "./commands/UploadLayerPartCommand";
import { ValidatePullThroughCacheRuleCommand, } from "./commands/ValidatePullThroughCacheRuleCommand";
import { ECRClient } from "./ECRClient";
const commands = {
    BatchCheckLayerAvailabilityCommand,
    BatchDeleteImageCommand,
    BatchGetImageCommand,
    BatchGetRepositoryScanningConfigurationCommand,
    CompleteLayerUploadCommand,
    CreatePullThroughCacheRuleCommand,
    CreateRepositoryCommand,
    CreateRepositoryCreationTemplateCommand,
    DeleteLifecyclePolicyCommand,
    DeletePullThroughCacheRuleCommand,
    DeleteRegistryPolicyCommand,
    DeleteRepositoryCommand,
    DeleteRepositoryCreationTemplateCommand,
    DeleteRepositoryPolicyCommand,
    DescribeImageReplicationStatusCommand,
    DescribeImagesCommand,
    DescribeImageScanFindingsCommand,
    DescribePullThroughCacheRulesCommand,
    DescribeRegistryCommand,
    DescribeRepositoriesCommand,
    DescribeRepositoryCreationTemplatesCommand,
    GetAccountSettingCommand,
    GetAuthorizationTokenCommand,
    GetDownloadUrlForLayerCommand,
    GetLifecyclePolicyCommand,
    GetLifecyclePolicyPreviewCommand,
    GetRegistryPolicyCommand,
    GetRegistryScanningConfigurationCommand,
    GetRepositoryPolicyCommand,
    InitiateLayerUploadCommand,
    ListImagesCommand,
    ListTagsForResourceCommand,
    PutAccountSettingCommand,
    PutImageCommand,
    PutImageScanningConfigurationCommand,
    PutImageTagMutabilityCommand,
    PutLifecyclePolicyCommand,
    PutRegistryPolicyCommand,
    PutRegistryScanningConfigurationCommand,
    PutReplicationConfigurationCommand,
    SetRepositoryPolicyCommand,
    StartImageScanCommand,
    StartLifecyclePolicyPreviewCommand,
    TagResourceCommand,
    UntagResourceCommand,
    UpdatePullThroughCacheRuleCommand,
    UpdateRepositoryCreationTemplateCommand,
    UploadLayerPartCommand,
    ValidatePullThroughCacheRuleCommand,
};
export class ECR extends ECRClient {
}
createAggregatedClient(commands, ECR);
