import {
  AccessScopePath,
  AccessScopePathRequest,
  AddPrefixListEntry,
  ApplianceModeSupportValue,
  AttachmentStatus,
  CurrencyCodeValues,
  DeviceTrustProviderType,
  DnsSupportValue,
  DynamicRoutingValue,
  Ipv4PrefixSpecification,
  Ipv6SupportValue,
  NatGatewayAddress,
  PortRange,
  Protocol,
  ReservedInstancesListing,
  ResourceType,
  RouteTableAssociationState,
  SecurityGroupReferencingSupportValue,
  Tag,
  TagSpecification,
  TransitGatewayAttachmentResourceType,
  TransitGatewayAttachmentState,
  TransitGatewayPeeringAttachment,
  TransitGatewayVpcAttachment,
  TrustProviderType,
  UserTrustProviderType,
  VerifiedAccessInstance,
  VerifiedAccessSseSpecificationResponse,
  VerifiedAccessTrustProvider,
  VolumeAttachment,
} from "./models_0";
import {
  _InstanceType,
  ConnectionTrackingSpecification,
  ConnectionTrackingSpecificationRequest,
  CreditSpecification,
  ElasticGpuSpecificationResponse,
  HostnameType,
  InstanceBandwidthWeighting,
  InstanceRequirements,
  Ipv4PrefixSpecificationRequest,
  Ipv6PrefixSpecificationRequest,
  LaunchTemplateBlockDeviceMapping,
  LaunchTemplateCapacityReservationSpecificationResponse,
  LaunchTemplateCpuOptions,
  LaunchTemplateElasticInferenceAcceleratorResponse,
  LaunchTemplateEnaSrdUdpSpecification,
  LaunchTemplateEnclaveOptions,
  LaunchTemplateHibernationOptions,
  LaunchTemplateIamInstanceProfileSpecification,
  LaunchTemplateInstanceMaintenanceOptions,
  LaunchTemplateInstanceMarketOptions,
  LaunchTemplateInstanceMetadataOptions,
  LaunchTemplateLicenseConfiguration,
  LaunchTemplatesMonitoring,
  MacModificationTask,
  MacSystemIntegrityProtectionSettingStatus,
  OperatorRequest,
  OperatorResponse,
  PrivateIpAddressSpecification,
  ShutdownBehavior,
  SnapshotLocationEnum,
  Subnet,
  Tenancy,
  ValidationWarning,
  VolumeType,
  Vpc,
} from "./models_1";
export interface LaunchTemplateEnaSrdSpecification {
  EnaSrdEnabled?: boolean | undefined;
  EnaSrdUdpSpecification?: LaunchTemplateEnaSrdUdpSpecification | undefined;
}
export interface Ipv4PrefixSpecificationResponse {
  Ipv4Prefix?: string | undefined;
}
export interface InstanceIpv6Address {
  Ipv6Address?: string | undefined;
  IsPrimaryIpv6?: boolean | undefined;
}
export interface Ipv6PrefixSpecificationResponse {
  Ipv6Prefix?: string | undefined;
}
export interface LaunchTemplateInstanceNetworkInterfaceSpecification {
  AssociateCarrierIpAddress?: boolean | undefined;
  AssociatePublicIpAddress?: boolean | undefined;
  DeleteOnTermination?: boolean | undefined;
  Description?: string | undefined;
  DeviceIndex?: number | undefined;
  Groups?: string[] | undefined;
  InterfaceType?: string | undefined;
  Ipv6AddressCount?: number | undefined;
  Ipv6Addresses?: InstanceIpv6Address[] | undefined;
  NetworkInterfaceId?: string | undefined;
  PrivateIpAddress?: string | undefined;
  PrivateIpAddresses?: PrivateIpAddressSpecification[] | undefined;
  SecondaryPrivateIpAddressCount?: number | undefined;
  SubnetId?: string | undefined;
  NetworkCardIndex?: number | undefined;
  Ipv4Prefixes?: Ipv4PrefixSpecificationResponse[] | undefined;
  Ipv4PrefixCount?: number | undefined;
  Ipv6Prefixes?: Ipv6PrefixSpecificationResponse[] | undefined;
  Ipv6PrefixCount?: number | undefined;
  PrimaryIpv6?: boolean | undefined;
  EnaSrdSpecification?: LaunchTemplateEnaSrdSpecification | undefined;
  ConnectionTrackingSpecification?: ConnectionTrackingSpecification | undefined;
  EnaQueueCount?: number | undefined;
}
export interface LaunchTemplateNetworkPerformanceOptions {
  BandwidthWeighting?: InstanceBandwidthWeighting | undefined;
}
export interface LaunchTemplatePlacement {
  AvailabilityZone?: string | undefined;
  Affinity?: string | undefined;
  GroupName?: string | undefined;
  HostId?: string | undefined;
  Tenancy?: Tenancy | undefined;
  SpreadDomain?: string | undefined;
  HostResourceGroupArn?: string | undefined;
  PartitionNumber?: number | undefined;
  GroupId?: string | undefined;
}
export interface LaunchTemplatePrivateDnsNameOptions {
  HostnameType?: HostnameType | undefined;
  EnableResourceNameDnsARecord?: boolean | undefined;
  EnableResourceNameDnsAAAARecord?: boolean | undefined;
}
export interface LaunchTemplateTagSpecification {
  ResourceType?: ResourceType | undefined;
  Tags?: Tag[] | undefined;
}
export interface ResponseLaunchTemplateData {
  KernelId?: string | undefined;
  EbsOptimized?: boolean | undefined;
  IamInstanceProfile?:
    | LaunchTemplateIamInstanceProfileSpecification
    | undefined;
  BlockDeviceMappings?: LaunchTemplateBlockDeviceMapping[] | undefined;
  NetworkInterfaces?:
    | LaunchTemplateInstanceNetworkInterfaceSpecification[]
    | undefined;
  ImageId?: string | undefined;
  InstanceType?: _InstanceType | undefined;
  KeyName?: string | undefined;
  Monitoring?: LaunchTemplatesMonitoring | undefined;
  Placement?: LaunchTemplatePlacement | undefined;
  RamDiskId?: string | undefined;
  DisableApiTermination?: boolean | undefined;
  InstanceInitiatedShutdownBehavior?: ShutdownBehavior | undefined;
  UserData?: string | undefined;
  TagSpecifications?: LaunchTemplateTagSpecification[] | undefined;
  ElasticGpuSpecifications?: ElasticGpuSpecificationResponse[] | undefined;
  ElasticInferenceAccelerators?:
    | LaunchTemplateElasticInferenceAcceleratorResponse[]
    | undefined;
  SecurityGroupIds?: string[] | undefined;
  SecurityGroups?: string[] | undefined;
  InstanceMarketOptions?: LaunchTemplateInstanceMarketOptions | undefined;
  CreditSpecification?: CreditSpecification | undefined;
  CpuOptions?: LaunchTemplateCpuOptions | undefined;
  CapacityReservationSpecification?:
    | LaunchTemplateCapacityReservationSpecificationResponse
    | undefined;
  LicenseSpecifications?: LaunchTemplateLicenseConfiguration[] | undefined;
  HibernationOptions?: LaunchTemplateHibernationOptions | undefined;
  MetadataOptions?: LaunchTemplateInstanceMetadataOptions | undefined;
  EnclaveOptions?: LaunchTemplateEnclaveOptions | undefined;
  InstanceRequirements?: InstanceRequirements | undefined;
  PrivateDnsNameOptions?: LaunchTemplatePrivateDnsNameOptions | undefined;
  MaintenanceOptions?: LaunchTemplateInstanceMaintenanceOptions | undefined;
  DisableApiStop?: boolean | undefined;
  Operator?: OperatorResponse | undefined;
  NetworkPerformanceOptions?:
    | LaunchTemplateNetworkPerformanceOptions
    | undefined;
}
export interface LaunchTemplateVersion {
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
  VersionNumber?: number | undefined;
  VersionDescription?: string | undefined;
  CreateTime?: Date | undefined;
  CreatedBy?: string | undefined;
  DefaultVersion?: boolean | undefined;
  LaunchTemplateData?: ResponseLaunchTemplateData | undefined;
  Operator?: OperatorResponse | undefined;
}
export interface CreateLaunchTemplateVersionResult {
  LaunchTemplateVersion?: LaunchTemplateVersion | undefined;
  Warning?: ValidationWarning | undefined;
}
export interface CreateLocalGatewayRouteRequest {
  DestinationCidrBlock?: string | undefined;
  LocalGatewayRouteTableId: string | undefined;
  LocalGatewayVirtualInterfaceGroupId?: string | undefined;
  DryRun?: boolean | undefined;
  NetworkInterfaceId?: string | undefined;
  DestinationPrefixListId?: string | undefined;
}
export declare const LocalGatewayRouteState: {
  readonly active: "active";
  readonly blackhole: "blackhole";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type LocalGatewayRouteState =
  (typeof LocalGatewayRouteState)[keyof typeof LocalGatewayRouteState];
export declare const LocalGatewayRouteType: {
  readonly propagated: "propagated";
  readonly static: "static";
};
export type LocalGatewayRouteType =
  (typeof LocalGatewayRouteType)[keyof typeof LocalGatewayRouteType];
export interface LocalGatewayRoute {
  DestinationCidrBlock?: string | undefined;
  LocalGatewayVirtualInterfaceGroupId?: string | undefined;
  Type?: LocalGatewayRouteType | undefined;
  State?: LocalGatewayRouteState | undefined;
  LocalGatewayRouteTableId?: string | undefined;
  LocalGatewayRouteTableArn?: string | undefined;
  OwnerId?: string | undefined;
  SubnetId?: string | undefined;
  CoipPoolId?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  DestinationPrefixListId?: string | undefined;
}
export interface CreateLocalGatewayRouteResult {
  Route?: LocalGatewayRoute | undefined;
}
export declare const LocalGatewayRouteTableMode: {
  readonly coip: "coip";
  readonly direct_vpc_routing: "direct-vpc-routing";
};
export type LocalGatewayRouteTableMode =
  (typeof LocalGatewayRouteTableMode)[keyof typeof LocalGatewayRouteTableMode];
export interface CreateLocalGatewayRouteTableRequest {
  LocalGatewayId: string | undefined;
  Mode?: LocalGatewayRouteTableMode | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface StateReason {
  Code?: string | undefined;
  Message?: string | undefined;
}
export interface LocalGatewayRouteTable {
  LocalGatewayRouteTableId?: string | undefined;
  LocalGatewayRouteTableArn?: string | undefined;
  LocalGatewayId?: string | undefined;
  OutpostArn?: string | undefined;
  OwnerId?: string | undefined;
  State?: string | undefined;
  Tags?: Tag[] | undefined;
  Mode?: LocalGatewayRouteTableMode | undefined;
  StateReason?: StateReason | undefined;
}
export interface CreateLocalGatewayRouteTableResult {
  LocalGatewayRouteTable?: LocalGatewayRouteTable | undefined;
}
export interface CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
  LocalGatewayRouteTableId: string | undefined;
  LocalGatewayVirtualInterfaceGroupId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface LocalGatewayRouteTableVirtualInterfaceGroupAssociation {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociationId?: string | undefined;
  LocalGatewayVirtualInterfaceGroupId?: string | undefined;
  LocalGatewayId?: string | undefined;
  LocalGatewayRouteTableId?: string | undefined;
  LocalGatewayRouteTableArn?: string | undefined;
  OwnerId?: string | undefined;
  State?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation?:
    | LocalGatewayRouteTableVirtualInterfaceGroupAssociation
    | undefined;
}
export interface CreateLocalGatewayRouteTableVpcAssociationRequest {
  LocalGatewayRouteTableId: string | undefined;
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface LocalGatewayRouteTableVpcAssociation {
  LocalGatewayRouteTableVpcAssociationId?: string | undefined;
  LocalGatewayRouteTableId?: string | undefined;
  LocalGatewayRouteTableArn?: string | undefined;
  LocalGatewayId?: string | undefined;
  VpcId?: string | undefined;
  OwnerId?: string | undefined;
  State?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateLocalGatewayRouteTableVpcAssociationResult {
  LocalGatewayRouteTableVpcAssociation?:
    | LocalGatewayRouteTableVpcAssociation
    | undefined;
}
export interface CreateLocalGatewayVirtualInterfaceRequest {
  LocalGatewayVirtualInterfaceGroupId: string | undefined;
  OutpostLagId: string | undefined;
  Vlan: number | undefined;
  LocalAddress: string | undefined;
  PeerAddress: string | undefined;
  PeerBgpAsn?: number | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  PeerBgpAsnExtended?: number | undefined;
}
export declare const LocalGatewayVirtualInterfaceConfigurationState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type LocalGatewayVirtualInterfaceConfigurationState =
  (typeof LocalGatewayVirtualInterfaceConfigurationState)[keyof typeof LocalGatewayVirtualInterfaceConfigurationState];
export interface LocalGatewayVirtualInterface {
  LocalGatewayVirtualInterfaceId?: string | undefined;
  LocalGatewayId?: string | undefined;
  LocalGatewayVirtualInterfaceGroupId?: string | undefined;
  LocalGatewayVirtualInterfaceArn?: string | undefined;
  OutpostLagId?: string | undefined;
  Vlan?: number | undefined;
  LocalAddress?: string | undefined;
  PeerAddress?: string | undefined;
  LocalBgpAsn?: number | undefined;
  PeerBgpAsn?: number | undefined;
  PeerBgpAsnExtended?: number | undefined;
  OwnerId?: string | undefined;
  Tags?: Tag[] | undefined;
  ConfigurationState?:
    | LocalGatewayVirtualInterfaceConfigurationState
    | undefined;
}
export interface CreateLocalGatewayVirtualInterfaceResult {
  LocalGatewayVirtualInterface?: LocalGatewayVirtualInterface | undefined;
}
export interface CreateLocalGatewayVirtualInterfaceGroupRequest {
  LocalGatewayId: string | undefined;
  LocalBgpAsn?: number | undefined;
  LocalBgpAsnExtended?: number | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export declare const LocalGatewayVirtualInterfaceGroupConfigurationState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly incomplete: "incomplete";
  readonly pending: "pending";
};
export type LocalGatewayVirtualInterfaceGroupConfigurationState =
  (typeof LocalGatewayVirtualInterfaceGroupConfigurationState)[keyof typeof LocalGatewayVirtualInterfaceGroupConfigurationState];
export interface LocalGatewayVirtualInterfaceGroup {
  LocalGatewayVirtualInterfaceGroupId?: string | undefined;
  LocalGatewayVirtualInterfaceIds?: string[] | undefined;
  LocalGatewayId?: string | undefined;
  OwnerId?: string | undefined;
  LocalBgpAsn?: number | undefined;
  LocalBgpAsnExtended?: number | undefined;
  LocalGatewayVirtualInterfaceGroupArn?: string | undefined;
  Tags?: Tag[] | undefined;
  ConfigurationState?:
    | LocalGatewayVirtualInterfaceGroupConfigurationState
    | undefined;
}
export interface CreateLocalGatewayVirtualInterfaceGroupResult {
  LocalGatewayVirtualInterfaceGroup?:
    | LocalGatewayVirtualInterfaceGroup
    | undefined;
}
export interface MacSystemIntegrityProtectionConfigurationRequest {
  AppleInternal?: MacSystemIntegrityProtectionSettingStatus | undefined;
  BaseSystem?: MacSystemIntegrityProtectionSettingStatus | undefined;
  DebuggingRestrictions?: MacSystemIntegrityProtectionSettingStatus | undefined;
  DTraceRestrictions?: MacSystemIntegrityProtectionSettingStatus | undefined;
  FilesystemProtections?: MacSystemIntegrityProtectionSettingStatus | undefined;
  KextSigning?: MacSystemIntegrityProtectionSettingStatus | undefined;
  NvramProtections?: MacSystemIntegrityProtectionSettingStatus | undefined;
}
export interface CreateMacSystemIntegrityProtectionModificationTaskRequest {
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  InstanceId: string | undefined;
  MacCredentials?: string | undefined;
  MacSystemIntegrityProtectionConfiguration?:
    | MacSystemIntegrityProtectionConfigurationRequest
    | undefined;
  MacSystemIntegrityProtectionStatus:
    | MacSystemIntegrityProtectionSettingStatus
    | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export interface CreateMacSystemIntegrityProtectionModificationTaskResult {
  MacModificationTask?: MacModificationTask | undefined;
}
export interface CreateManagedPrefixListRequest {
  DryRun?: boolean | undefined;
  PrefixListName: string | undefined;
  Entries?: AddPrefixListEntry[] | undefined;
  MaxEntries: number | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  AddressFamily: string | undefined;
  ClientToken?: string | undefined;
}
export declare const PrefixListState: {
  readonly create_complete: "create-complete";
  readonly create_failed: "create-failed";
  readonly create_in_progress: "create-in-progress";
  readonly delete_complete: "delete-complete";
  readonly delete_failed: "delete-failed";
  readonly delete_in_progress: "delete-in-progress";
  readonly modify_complete: "modify-complete";
  readonly modify_failed: "modify-failed";
  readonly modify_in_progress: "modify-in-progress";
  readonly restore_complete: "restore-complete";
  readonly restore_failed: "restore-failed";
  readonly restore_in_progress: "restore-in-progress";
};
export type PrefixListState =
  (typeof PrefixListState)[keyof typeof PrefixListState];
export interface ManagedPrefixList {
  PrefixListId?: string | undefined;
  AddressFamily?: string | undefined;
  State?: PrefixListState | undefined;
  StateMessage?: string | undefined;
  PrefixListArn?: string | undefined;
  PrefixListName?: string | undefined;
  MaxEntries?: number | undefined;
  Version?: number | undefined;
  Tags?: Tag[] | undefined;
  OwnerId?: string | undefined;
}
export interface CreateManagedPrefixListResult {
  PrefixList?: ManagedPrefixList | undefined;
}
export declare const ConnectivityType: {
  readonly PRIVATE: "private";
  readonly PUBLIC: "public";
};
export type ConnectivityType =
  (typeof ConnectivityType)[keyof typeof ConnectivityType];
export interface CreateNatGatewayRequest {
  AllocationId?: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  SubnetId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ConnectivityType?: ConnectivityType | undefined;
  PrivateIpAddress?: string | undefined;
  SecondaryAllocationIds?: string[] | undefined;
  SecondaryPrivateIpAddresses?: string[] | undefined;
  SecondaryPrivateIpAddressCount?: number | undefined;
}
export interface ProvisionedBandwidth {
  ProvisionTime?: Date | undefined;
  Provisioned?: string | undefined;
  RequestTime?: Date | undefined;
  Requested?: string | undefined;
  Status?: string | undefined;
}
export declare const NatGatewayState: {
  readonly AVAILABLE: "available";
  readonly DELETED: "deleted";
  readonly DELETING: "deleting";
  readonly FAILED: "failed";
  readonly PENDING: "pending";
};
export type NatGatewayState =
  (typeof NatGatewayState)[keyof typeof NatGatewayState];
export interface NatGateway {
  CreateTime?: Date | undefined;
  DeleteTime?: Date | undefined;
  FailureCode?: string | undefined;
  FailureMessage?: string | undefined;
  NatGatewayAddresses?: NatGatewayAddress[] | undefined;
  NatGatewayId?: string | undefined;
  ProvisionedBandwidth?: ProvisionedBandwidth | undefined;
  State?: NatGatewayState | undefined;
  SubnetId?: string | undefined;
  VpcId?: string | undefined;
  Tags?: Tag[] | undefined;
  ConnectivityType?: ConnectivityType | undefined;
}
export interface CreateNatGatewayResult {
  ClientToken?: string | undefined;
  NatGateway?: NatGateway | undefined;
}
export interface CreateNetworkAclRequest {
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  VpcId: string | undefined;
}
export interface NetworkAclAssociation {
  NetworkAclAssociationId?: string | undefined;
  NetworkAclId?: string | undefined;
  SubnetId?: string | undefined;
}
export interface IcmpTypeCode {
  Code?: number | undefined;
  Type?: number | undefined;
}
export declare const RuleAction: {
  readonly allow: "allow";
  readonly deny: "deny";
};
export type RuleAction = (typeof RuleAction)[keyof typeof RuleAction];
export interface NetworkAclEntry {
  CidrBlock?: string | undefined;
  Egress?: boolean | undefined;
  IcmpTypeCode?: IcmpTypeCode | undefined;
  Ipv6CidrBlock?: string | undefined;
  PortRange?: PortRange | undefined;
  Protocol?: string | undefined;
  RuleAction?: RuleAction | undefined;
  RuleNumber?: number | undefined;
}
export interface NetworkAcl {
  Associations?: NetworkAclAssociation[] | undefined;
  Entries?: NetworkAclEntry[] | undefined;
  IsDefault?: boolean | undefined;
  NetworkAclId?: string | undefined;
  Tags?: Tag[] | undefined;
  VpcId?: string | undefined;
  OwnerId?: string | undefined;
}
export interface CreateNetworkAclResult {
  NetworkAcl?: NetworkAcl | undefined;
  ClientToken?: string | undefined;
}
export interface CreateNetworkAclEntryRequest {
  DryRun?: boolean | undefined;
  NetworkAclId: string | undefined;
  RuleNumber: number | undefined;
  Protocol: string | undefined;
  RuleAction: RuleAction | undefined;
  Egress: boolean | undefined;
  CidrBlock?: string | undefined;
  Ipv6CidrBlock?: string | undefined;
  IcmpTypeCode?: IcmpTypeCode | undefined;
  PortRange?: PortRange | undefined;
}
export interface CreateNetworkInsightsAccessScopeRequest {
  MatchPaths?: AccessScopePathRequest[] | undefined;
  ExcludePaths?: AccessScopePathRequest[] | undefined;
  ClientToken?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface NetworkInsightsAccessScope {
  NetworkInsightsAccessScopeId?: string | undefined;
  NetworkInsightsAccessScopeArn?: string | undefined;
  CreatedDate?: Date | undefined;
  UpdatedDate?: Date | undefined;
  Tags?: Tag[] | undefined;
}
export interface NetworkInsightsAccessScopeContent {
  NetworkInsightsAccessScopeId?: string | undefined;
  MatchPaths?: AccessScopePath[] | undefined;
  ExcludePaths?: AccessScopePath[] | undefined;
}
export interface CreateNetworkInsightsAccessScopeResult {
  NetworkInsightsAccessScope?: NetworkInsightsAccessScope | undefined;
  NetworkInsightsAccessScopeContent?:
    | NetworkInsightsAccessScopeContent
    | undefined;
}
export interface RequestFilterPortRange {
  FromPort?: number | undefined;
  ToPort?: number | undefined;
}
export interface PathRequestFilter {
  SourceAddress?: string | undefined;
  SourcePortRange?: RequestFilterPortRange | undefined;
  DestinationAddress?: string | undefined;
  DestinationPortRange?: RequestFilterPortRange | undefined;
}
export interface CreateNetworkInsightsPathRequest {
  SourceIp?: string | undefined;
  DestinationIp?: string | undefined;
  Source: string | undefined;
  Destination?: string | undefined;
  Protocol: Protocol | undefined;
  DestinationPort?: number | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  FilterAtSource?: PathRequestFilter | undefined;
  FilterAtDestination?: PathRequestFilter | undefined;
}
export interface FilterPortRange {
  FromPort?: number | undefined;
  ToPort?: number | undefined;
}
export interface PathFilter {
  SourceAddress?: string | undefined;
  SourcePortRange?: FilterPortRange | undefined;
  DestinationAddress?: string | undefined;
  DestinationPortRange?: FilterPortRange | undefined;
}
export interface NetworkInsightsPath {
  NetworkInsightsPathId?: string | undefined;
  NetworkInsightsPathArn?: string | undefined;
  CreatedDate?: Date | undefined;
  Source?: string | undefined;
  Destination?: string | undefined;
  SourceArn?: string | undefined;
  DestinationArn?: string | undefined;
  SourceIp?: string | undefined;
  DestinationIp?: string | undefined;
  Protocol?: Protocol | undefined;
  DestinationPort?: number | undefined;
  Tags?: Tag[] | undefined;
  FilterAtSource?: PathFilter | undefined;
  FilterAtDestination?: PathFilter | undefined;
}
export interface CreateNetworkInsightsPathResult {
  NetworkInsightsPath?: NetworkInsightsPath | undefined;
}
export declare const NetworkInterfaceCreationType: {
  readonly branch: "branch";
  readonly efa: "efa";
  readonly efa_only: "efa-only";
  readonly trunk: "trunk";
};
export type NetworkInterfaceCreationType =
  (typeof NetworkInterfaceCreationType)[keyof typeof NetworkInterfaceCreationType];
export interface CreateNetworkInterfaceRequest {
  Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[] | undefined;
  Ipv4PrefixCount?: number | undefined;
  Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[] | undefined;
  Ipv6PrefixCount?: number | undefined;
  InterfaceType?: NetworkInterfaceCreationType | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
  EnablePrimaryIpv6?: boolean | undefined;
  ConnectionTrackingSpecification?:
    | ConnectionTrackingSpecificationRequest
    | undefined;
  Operator?: OperatorRequest | undefined;
  SubnetId: string | undefined;
  Description?: string | undefined;
  PrivateIpAddress?: string | undefined;
  Groups?: string[] | undefined;
  PrivateIpAddresses?: PrivateIpAddressSpecification[] | undefined;
  SecondaryPrivateIpAddressCount?: number | undefined;
  Ipv6Addresses?: InstanceIpv6Address[] | undefined;
  Ipv6AddressCount?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface NetworkInterfaceAssociation {
  AllocationId?: string | undefined;
  AssociationId?: string | undefined;
  IpOwnerId?: string | undefined;
  PublicDnsName?: string | undefined;
  PublicIp?: string | undefined;
  CustomerOwnedIp?: string | undefined;
  CarrierIp?: string | undefined;
}
export interface AttachmentEnaSrdUdpSpecification {
  EnaSrdUdpEnabled?: boolean | undefined;
}
export interface AttachmentEnaSrdSpecification {
  EnaSrdEnabled?: boolean | undefined;
  EnaSrdUdpSpecification?: AttachmentEnaSrdUdpSpecification | undefined;
}
export interface NetworkInterfaceAttachment {
  AttachTime?: Date | undefined;
  AttachmentId?: string | undefined;
  DeleteOnTermination?: boolean | undefined;
  DeviceIndex?: number | undefined;
  NetworkCardIndex?: number | undefined;
  InstanceId?: string | undefined;
  InstanceOwnerId?: string | undefined;
  Status?: AttachmentStatus | undefined;
  EnaSrdSpecification?: AttachmentEnaSrdSpecification | undefined;
  EnaQueueCount?: number | undefined;
}
export interface ConnectionTrackingConfiguration {
  TcpEstablishedTimeout?: number | undefined;
  UdpStreamTimeout?: number | undefined;
  UdpTimeout?: number | undefined;
}
export interface GroupIdentifier {
  GroupId?: string | undefined;
  GroupName?: string | undefined;
}
export declare const NetworkInterfaceType: {
  readonly api_gateway_managed: "api_gateway_managed";
  readonly aws_codestar_connections_managed: "aws_codestar_connections_managed";
  readonly branch: "branch";
  readonly efa: "efa";
  readonly efa_only: "efa-only";
  readonly gateway_load_balancer: "gateway_load_balancer";
  readonly gateway_load_balancer_endpoint: "gateway_load_balancer_endpoint";
  readonly global_accelerator_managed: "global_accelerator_managed";
  readonly interface: "interface";
  readonly iot_rules_managed: "iot_rules_managed";
  readonly lambda: "lambda";
  readonly load_balancer: "load_balancer";
  readonly natGateway: "natGateway";
  readonly network_load_balancer: "network_load_balancer";
  readonly quicksight: "quicksight";
  readonly transit_gateway: "transit_gateway";
  readonly trunk: "trunk";
  readonly vpc_endpoint: "vpc_endpoint";
};
export type NetworkInterfaceType =
  (typeof NetworkInterfaceType)[keyof typeof NetworkInterfaceType];
export interface NetworkInterfaceIpv6Address {
  Ipv6Address?: string | undefined;
  PublicIpv6DnsName?: string | undefined;
  IsPrimaryIpv6?: boolean | undefined;
}
export interface Ipv6PrefixSpecification {
  Ipv6Prefix?: string | undefined;
}
export interface NetworkInterfacePrivateIpAddress {
  Association?: NetworkInterfaceAssociation | undefined;
  Primary?: boolean | undefined;
  PrivateDnsName?: string | undefined;
  PrivateIpAddress?: string | undefined;
}
export interface PublicIpDnsNameOptions {
  DnsHostnameType?: string | undefined;
  PublicIpv4DnsName?: string | undefined;
  PublicIpv6DnsName?: string | undefined;
  PublicDualStackDnsName?: string | undefined;
}
export declare const NetworkInterfaceStatus: {
  readonly associated: "associated";
  readonly attaching: "attaching";
  readonly available: "available";
  readonly detaching: "detaching";
  readonly in_use: "in-use";
};
export type NetworkInterfaceStatus =
  (typeof NetworkInterfaceStatus)[keyof typeof NetworkInterfaceStatus];
export interface NetworkInterface {
  Association?: NetworkInterfaceAssociation | undefined;
  Attachment?: NetworkInterfaceAttachment | undefined;
  AvailabilityZone?: string | undefined;
  ConnectionTrackingConfiguration?: ConnectionTrackingConfiguration | undefined;
  Description?: string | undefined;
  Groups?: GroupIdentifier[] | undefined;
  InterfaceType?: NetworkInterfaceType | undefined;
  Ipv6Addresses?: NetworkInterfaceIpv6Address[] | undefined;
  MacAddress?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  OutpostArn?: string | undefined;
  OwnerId?: string | undefined;
  PrivateDnsName?: string | undefined;
  PublicDnsName?: string | undefined;
  PublicIpDnsNameOptions?: PublicIpDnsNameOptions | undefined;
  PrivateIpAddress?: string | undefined;
  PrivateIpAddresses?: NetworkInterfacePrivateIpAddress[] | undefined;
  Ipv4Prefixes?: Ipv4PrefixSpecification[] | undefined;
  Ipv6Prefixes?: Ipv6PrefixSpecification[] | undefined;
  RequesterId?: string | undefined;
  RequesterManaged?: boolean | undefined;
  SourceDestCheck?: boolean | undefined;
  Status?: NetworkInterfaceStatus | undefined;
  SubnetId?: string | undefined;
  TagSet?: Tag[] | undefined;
  VpcId?: string | undefined;
  DenyAllIgwTraffic?: boolean | undefined;
  Ipv6Native?: boolean | undefined;
  Ipv6Address?: string | undefined;
  Operator?: OperatorResponse | undefined;
  AssociatedSubnets?: string[] | undefined;
}
export interface CreateNetworkInterfaceResult {
  NetworkInterface?: NetworkInterface | undefined;
  ClientToken?: string | undefined;
}
export declare const InterfacePermissionType: {
  readonly EIP_ASSOCIATE: "EIP-ASSOCIATE";
  readonly INSTANCE_ATTACH: "INSTANCE-ATTACH";
};
export type InterfacePermissionType =
  (typeof InterfacePermissionType)[keyof typeof InterfacePermissionType];
export interface CreateNetworkInterfacePermissionRequest {
  NetworkInterfaceId: string | undefined;
  AwsAccountId?: string | undefined;
  AwsService?: string | undefined;
  Permission: InterfacePermissionType | undefined;
  DryRun?: boolean | undefined;
}
export declare const NetworkInterfacePermissionStateCode: {
  readonly granted: "granted";
  readonly pending: "pending";
  readonly revoked: "revoked";
  readonly revoking: "revoking";
};
export type NetworkInterfacePermissionStateCode =
  (typeof NetworkInterfacePermissionStateCode)[keyof typeof NetworkInterfacePermissionStateCode];
export interface NetworkInterfacePermissionState {
  State?: NetworkInterfacePermissionStateCode | undefined;
  StatusMessage?: string | undefined;
}
export interface NetworkInterfacePermission {
  NetworkInterfacePermissionId?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  AwsAccountId?: string | undefined;
  AwsService?: string | undefined;
  Permission?: InterfacePermissionType | undefined;
  PermissionState?: NetworkInterfacePermissionState | undefined;
}
export interface CreateNetworkInterfacePermissionResult {
  InterfacePermission?: NetworkInterfacePermission | undefined;
}
export declare const SpreadLevel: {
  readonly host: "host";
  readonly rack: "rack";
};
export type SpreadLevel = (typeof SpreadLevel)[keyof typeof SpreadLevel];
export declare const PlacementStrategy: {
  readonly cluster: "cluster";
  readonly partition: "partition";
  readonly spread: "spread";
};
export type PlacementStrategy =
  (typeof PlacementStrategy)[keyof typeof PlacementStrategy];
export interface CreatePlacementGroupRequest {
  PartitionCount?: number | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  SpreadLevel?: SpreadLevel | undefined;
  DryRun?: boolean | undefined;
  GroupName?: string | undefined;
  Strategy?: PlacementStrategy | undefined;
}
export declare const PlacementGroupState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type PlacementGroupState =
  (typeof PlacementGroupState)[keyof typeof PlacementGroupState];
export interface PlacementGroup {
  GroupName?: string | undefined;
  State?: PlacementGroupState | undefined;
  Strategy?: PlacementStrategy | undefined;
  PartitionCount?: number | undefined;
  GroupId?: string | undefined;
  Tags?: Tag[] | undefined;
  GroupArn?: string | undefined;
  SpreadLevel?: SpreadLevel | undefined;
}
export interface CreatePlacementGroupResult {
  PlacementGroup?: PlacementGroup | undefined;
}
export interface CreatePublicIpv4PoolRequest {
  DryRun?: boolean | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  NetworkBorderGroup?: string | undefined;
}
export interface CreatePublicIpv4PoolResult {
  PoolId?: string | undefined;
}
export interface CreateReplaceRootVolumeTaskRequest {
  InstanceId: string | undefined;
  SnapshotId?: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ImageId?: string | undefined;
  DeleteReplacedRootVolume?: boolean | undefined;
  VolumeInitializationRate?: number | undefined;
}
export declare const ReplaceRootVolumeTaskState: {
  readonly failed: "failed";
  readonly failed_detached: "failed-detached";
  readonly failing: "failing";
  readonly in_progress: "in-progress";
  readonly pending: "pending";
  readonly succeeded: "succeeded";
};
export type ReplaceRootVolumeTaskState =
  (typeof ReplaceRootVolumeTaskState)[keyof typeof ReplaceRootVolumeTaskState];
export interface ReplaceRootVolumeTask {
  ReplaceRootVolumeTaskId?: string | undefined;
  InstanceId?: string | undefined;
  TaskState?: ReplaceRootVolumeTaskState | undefined;
  StartTime?: string | undefined;
  CompleteTime?: string | undefined;
  Tags?: Tag[] | undefined;
  ImageId?: string | undefined;
  SnapshotId?: string | undefined;
  DeleteReplacedRootVolume?: boolean | undefined;
}
export interface CreateReplaceRootVolumeTaskResult {
  ReplaceRootVolumeTask?: ReplaceRootVolumeTask | undefined;
}
export interface PriceScheduleSpecification {
  Term?: number | undefined;
  Price?: number | undefined;
  CurrencyCode?: CurrencyCodeValues | undefined;
}
export interface CreateReservedInstancesListingRequest {
  ReservedInstancesId: string | undefined;
  InstanceCount: number | undefined;
  PriceSchedules: PriceScheduleSpecification[] | undefined;
  ClientToken: string | undefined;
}
export interface CreateReservedInstancesListingResult {
  ReservedInstancesListings?: ReservedInstancesListing[] | undefined;
}
export interface CreateRestoreImageTaskRequest {
  Bucket: string | undefined;
  ObjectKey: string | undefined;
  Name?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface CreateRestoreImageTaskResult {
  ImageId?: string | undefined;
}
export interface CreateRouteRequest {
  DestinationPrefixListId?: string | undefined;
  VpcEndpointId?: string | undefined;
  TransitGatewayId?: string | undefined;
  LocalGatewayId?: string | undefined;
  CarrierGatewayId?: string | undefined;
  CoreNetworkArn?: string | undefined;
  OdbNetworkArn?: string | undefined;
  DryRun?: boolean | undefined;
  RouteTableId: string | undefined;
  DestinationCidrBlock?: string | undefined;
  GatewayId?: string | undefined;
  DestinationIpv6CidrBlock?: string | undefined;
  EgressOnlyInternetGatewayId?: string | undefined;
  InstanceId?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  VpcPeeringConnectionId?: string | undefined;
  NatGatewayId?: string | undefined;
}
export interface CreateRouteResult {
  Return?: boolean | undefined;
}
export declare const RouteServerPersistRoutesAction: {
  readonly DISABLE: "disable";
  readonly ENABLE: "enable";
  readonly RESET: "reset";
};
export type RouteServerPersistRoutesAction =
  (typeof RouteServerPersistRoutesAction)[keyof typeof RouteServerPersistRoutesAction];
export interface CreateRouteServerRequest {
  AmazonSideAsn: number | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  PersistRoutes?: RouteServerPersistRoutesAction | undefined;
  PersistRoutesDuration?: number | undefined;
  SnsNotificationsEnabled?: boolean | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export declare const RouteServerPersistRoutesState: {
  readonly DISABLED: "disabled";
  readonly DISABLING: "disabling";
  readonly ENABLED: "enabled";
  readonly ENABLING: "enabling";
  readonly MODIFYING: "modifying";
  readonly RESETTING: "resetting";
};
export type RouteServerPersistRoutesState =
  (typeof RouteServerPersistRoutesState)[keyof typeof RouteServerPersistRoutesState];
export declare const RouteServerState: {
  readonly AVAILABLE: "available";
  readonly DELETED: "deleted";
  readonly DELETING: "deleting";
  readonly MODIFYING: "modifying";
  readonly PENDING: "pending";
};
export type RouteServerState =
  (typeof RouteServerState)[keyof typeof RouteServerState];
export interface RouteServer {
  RouteServerId?: string | undefined;
  AmazonSideAsn?: number | undefined;
  State?: RouteServerState | undefined;
  Tags?: Tag[] | undefined;
  PersistRoutesState?: RouteServerPersistRoutesState | undefined;
  PersistRoutesDuration?: number | undefined;
  SnsNotificationsEnabled?: boolean | undefined;
  SnsTopicArn?: string | undefined;
}
export interface CreateRouteServerResult {
  RouteServer?: RouteServer | undefined;
}
export interface CreateRouteServerEndpointRequest {
  RouteServerId: string | undefined;
  SubnetId: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export declare const RouteServerEndpointState: {
  readonly AVAILABLE: "available";
  readonly DELETED: "deleted";
  readonly DELETE_FAILED: "delete-failed";
  readonly DELETING: "deleting";
  readonly FAILED: "failed";
  readonly FAILING: "failing";
  readonly PENDING: "pending";
};
export type RouteServerEndpointState =
  (typeof RouteServerEndpointState)[keyof typeof RouteServerEndpointState];
export interface RouteServerEndpoint {
  RouteServerId?: string | undefined;
  RouteServerEndpointId?: string | undefined;
  VpcId?: string | undefined;
  SubnetId?: string | undefined;
  EniId?: string | undefined;
  EniAddress?: string | undefined;
  State?: RouteServerEndpointState | undefined;
  FailureReason?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateRouteServerEndpointResult {
  RouteServerEndpoint?: RouteServerEndpoint | undefined;
}
export declare const RouteServerPeerLivenessMode: {
  readonly BFD: "bfd";
  readonly BGP_KEEPALIVE: "bgp-keepalive";
};
export type RouteServerPeerLivenessMode =
  (typeof RouteServerPeerLivenessMode)[keyof typeof RouteServerPeerLivenessMode];
export interface RouteServerBgpOptionsRequest {
  PeerAsn: number | undefined;
  PeerLivenessDetection?: RouteServerPeerLivenessMode | undefined;
}
export interface CreateRouteServerPeerRequest {
  RouteServerEndpointId: string | undefined;
  PeerAddress: string | undefined;
  BgpOptions: RouteServerBgpOptionsRequest | undefined;
  DryRun?: boolean | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export declare const RouteServerBfdState: {
  readonly DOWN: "down";
  readonly UP: "up";
};
export type RouteServerBfdState =
  (typeof RouteServerBfdState)[keyof typeof RouteServerBfdState];
export interface RouteServerBfdStatus {
  Status?: RouteServerBfdState | undefined;
}
export interface RouteServerBgpOptions {
  PeerAsn?: number | undefined;
  PeerLivenessDetection?: RouteServerPeerLivenessMode | undefined;
}
export declare const RouteServerBgpState: {
  readonly DOWN: "down";
  readonly UP: "up";
};
export type RouteServerBgpState =
  (typeof RouteServerBgpState)[keyof typeof RouteServerBgpState];
export interface RouteServerBgpStatus {
  Status?: RouteServerBgpState | undefined;
}
export declare const RouteServerPeerState: {
  readonly AVAILABLE: "available";
  readonly DELETED: "deleted";
  readonly DELETING: "deleting";
  readonly FAILED: "failed";
  readonly FAILING: "failing";
  readonly PENDING: "pending";
};
export type RouteServerPeerState =
  (typeof RouteServerPeerState)[keyof typeof RouteServerPeerState];
export interface RouteServerPeer {
  RouteServerPeerId?: string | undefined;
  RouteServerEndpointId?: string | undefined;
  RouteServerId?: string | undefined;
  VpcId?: string | undefined;
  SubnetId?: string | undefined;
  State?: RouteServerPeerState | undefined;
  FailureReason?: string | undefined;
  EndpointEniId?: string | undefined;
  EndpointEniAddress?: string | undefined;
  PeerAddress?: string | undefined;
  BgpOptions?: RouteServerBgpOptions | undefined;
  BgpStatus?: RouteServerBgpStatus | undefined;
  BfdStatus?: RouteServerBfdStatus | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateRouteServerPeerResult {
  RouteServerPeer?: RouteServerPeer | undefined;
}
export interface CreateRouteTableRequest {
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  VpcId: string | undefined;
}
export interface RouteTableAssociation {
  Main?: boolean | undefined;
  RouteTableAssociationId?: string | undefined;
  RouteTableId?: string | undefined;
  SubnetId?: string | undefined;
  GatewayId?: string | undefined;
  AssociationState?: RouteTableAssociationState | undefined;
}
export interface PropagatingVgw {
  GatewayId?: string | undefined;
}
export declare const RouteOrigin: {
  readonly CreateRoute: "CreateRoute";
  readonly CreateRouteTable: "CreateRouteTable";
  readonly EnableVgwRoutePropagation: "EnableVgwRoutePropagation";
};
export type RouteOrigin = (typeof RouteOrigin)[keyof typeof RouteOrigin];
export declare const RouteState: {
  readonly active: "active";
  readonly blackhole: "blackhole";
};
export type RouteState = (typeof RouteState)[keyof typeof RouteState];
export interface Route {
  DestinationCidrBlock?: string | undefined;
  DestinationIpv6CidrBlock?: string | undefined;
  DestinationPrefixListId?: string | undefined;
  EgressOnlyInternetGatewayId?: string | undefined;
  GatewayId?: string | undefined;
  InstanceId?: string | undefined;
  InstanceOwnerId?: string | undefined;
  NatGatewayId?: string | undefined;
  TransitGatewayId?: string | undefined;
  LocalGatewayId?: string | undefined;
  CarrierGatewayId?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  Origin?: RouteOrigin | undefined;
  State?: RouteState | undefined;
  VpcPeeringConnectionId?: string | undefined;
  CoreNetworkArn?: string | undefined;
  OdbNetworkArn?: string | undefined;
}
export interface RouteTable {
  Associations?: RouteTableAssociation[] | undefined;
  PropagatingVgws?: PropagatingVgw[] | undefined;
  RouteTableId?: string | undefined;
  Routes?: Route[] | undefined;
  Tags?: Tag[] | undefined;
  VpcId?: string | undefined;
  OwnerId?: string | undefined;
}
export interface CreateRouteTableResult {
  RouteTable?: RouteTable | undefined;
  ClientToken?: string | undefined;
}
export interface CreateSecurityGroupRequest {
  Description: string | undefined;
  GroupName: string | undefined;
  VpcId?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface CreateSecurityGroupResult {
  GroupId?: string | undefined;
  Tags?: Tag[] | undefined;
  SecurityGroupArn?: string | undefined;
}
export interface CreateSnapshotRequest {
  Description?: string | undefined;
  OutpostArn?: string | undefined;
  VolumeId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  Location?: SnapshotLocationEnum | undefined;
  DryRun?: boolean | undefined;
}
export declare const SSEType: {
  readonly none: "none";
  readonly sse_ebs: "sse-ebs";
  readonly sse_kms: "sse-kms";
};
export type SSEType = (typeof SSEType)[keyof typeof SSEType];
export declare const SnapshotState: {
  readonly completed: "completed";
  readonly error: "error";
  readonly pending: "pending";
  readonly recoverable: "recoverable";
  readonly recovering: "recovering";
};
export type SnapshotState = (typeof SnapshotState)[keyof typeof SnapshotState];
export declare const StorageTier: {
  readonly archive: "archive";
  readonly standard: "standard";
};
export type StorageTier = (typeof StorageTier)[keyof typeof StorageTier];
export declare const TransferType: {
  readonly standard: "standard";
  readonly time_based: "time-based";
};
export type TransferType = (typeof TransferType)[keyof typeof TransferType];
export interface Snapshot {
  OwnerAlias?: string | undefined;
  OutpostArn?: string | undefined;
  Tags?: Tag[] | undefined;
  StorageTier?: StorageTier | undefined;
  RestoreExpiryTime?: Date | undefined;
  SseType?: SSEType | undefined;
  AvailabilityZone?: string | undefined;
  TransferType?: TransferType | undefined;
  CompletionDurationMinutes?: number | undefined;
  CompletionTime?: Date | undefined;
  FullSnapshotSizeInBytes?: number | undefined;
  SnapshotId?: string | undefined;
  VolumeId?: string | undefined;
  State?: SnapshotState | undefined;
  StateMessage?: string | undefined;
  StartTime?: Date | undefined;
  Progress?: string | undefined;
  OwnerId?: string | undefined;
  Description?: string | undefined;
  VolumeSize?: number | undefined;
  Encrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  DataEncryptionKeyId?: string | undefined;
}
export declare const CopyTagsFromSource: {
  readonly volume: "volume";
};
export type CopyTagsFromSource =
  (typeof CopyTagsFromSource)[keyof typeof CopyTagsFromSource];
export interface InstanceSpecification {
  InstanceId: string | undefined;
  ExcludeBootVolume?: boolean | undefined;
  ExcludeDataVolumeIds?: string[] | undefined;
}
export interface CreateSnapshotsRequest {
  Description?: string | undefined;
  InstanceSpecification: InstanceSpecification | undefined;
  OutpostArn?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  CopyTagsFromSource?: CopyTagsFromSource | undefined;
  Location?: SnapshotLocationEnum | undefined;
}
export interface SnapshotInfo {
  Description?: string | undefined;
  Tags?: Tag[] | undefined;
  Encrypted?: boolean | undefined;
  VolumeId?: string | undefined;
  State?: SnapshotState | undefined;
  VolumeSize?: number | undefined;
  StartTime?: Date | undefined;
  Progress?: string | undefined;
  OwnerId?: string | undefined;
  SnapshotId?: string | undefined;
  OutpostArn?: string | undefined;
  SseType?: SSEType | undefined;
  AvailabilityZone?: string | undefined;
}
export interface CreateSnapshotsResult {
  Snapshots?: SnapshotInfo[] | undefined;
}
export interface CreateSpotDatafeedSubscriptionRequest {
  DryRun?: boolean | undefined;
  Bucket: string | undefined;
  Prefix?: string | undefined;
}
export interface SpotInstanceStateFault {
  Code?: string | undefined;
  Message?: string | undefined;
}
export declare const DatafeedSubscriptionState: {
  readonly Active: "Active";
  readonly Inactive: "Inactive";
};
export type DatafeedSubscriptionState =
  (typeof DatafeedSubscriptionState)[keyof typeof DatafeedSubscriptionState];
export interface SpotDatafeedSubscription {
  Bucket?: string | undefined;
  Fault?: SpotInstanceStateFault | undefined;
  OwnerId?: string | undefined;
  Prefix?: string | undefined;
  State?: DatafeedSubscriptionState | undefined;
}
export interface CreateSpotDatafeedSubscriptionResult {
  SpotDatafeedSubscription?: SpotDatafeedSubscription | undefined;
}
export interface S3ObjectTag {
  Key?: string | undefined;
  Value?: string | undefined;
}
export interface CreateStoreImageTaskRequest {
  ImageId: string | undefined;
  Bucket: string | undefined;
  S3ObjectTags?: S3ObjectTag[] | undefined;
  DryRun?: boolean | undefined;
}
export interface CreateStoreImageTaskResult {
  ObjectKey?: string | undefined;
}
export interface CreateSubnetRequest {
  TagSpecifications?: TagSpecification[] | undefined;
  AvailabilityZone?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  CidrBlock?: string | undefined;
  Ipv6CidrBlock?: string | undefined;
  OutpostArn?: string | undefined;
  VpcId: string | undefined;
  Ipv6Native?: boolean | undefined;
  Ipv4IpamPoolId?: string | undefined;
  Ipv4NetmaskLength?: number | undefined;
  Ipv6IpamPoolId?: string | undefined;
  Ipv6NetmaskLength?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface CreateSubnetResult {
  Subnet?: Subnet | undefined;
}
export declare const SubnetCidrReservationType: {
  readonly explicit: "explicit";
  readonly prefix: "prefix";
};
export type SubnetCidrReservationType =
  (typeof SubnetCidrReservationType)[keyof typeof SubnetCidrReservationType];
export interface CreateSubnetCidrReservationRequest {
  SubnetId: string | undefined;
  Cidr: string | undefined;
  ReservationType: SubnetCidrReservationType | undefined;
  Description?: string | undefined;
  DryRun?: boolean | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export interface SubnetCidrReservation {
  SubnetCidrReservationId?: string | undefined;
  SubnetId?: string | undefined;
  Cidr?: string | undefined;
  ReservationType?: SubnetCidrReservationType | undefined;
  OwnerId?: string | undefined;
  Description?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateSubnetCidrReservationResult {
  SubnetCidrReservation?: SubnetCidrReservation | undefined;
}
export interface CreateTagsRequest {
  DryRun?: boolean | undefined;
  Resources: string[] | undefined;
  Tags: Tag[] | undefined;
}
export interface CreateTrafficMirrorFilterRequest {
  Description?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
}
export interface TrafficMirrorPortRange {
  FromPort?: number | undefined;
  ToPort?: number | undefined;
}
export declare const TrafficMirrorRuleAction: {
  readonly accept: "accept";
  readonly reject: "reject";
};
export type TrafficMirrorRuleAction =
  (typeof TrafficMirrorRuleAction)[keyof typeof TrafficMirrorRuleAction];
export declare const TrafficDirection: {
  readonly egress: "egress";
  readonly ingress: "ingress";
};
export type TrafficDirection =
  (typeof TrafficDirection)[keyof typeof TrafficDirection];
export interface TrafficMirrorFilterRule {
  TrafficMirrorFilterRuleId?: string | undefined;
  TrafficMirrorFilterId?: string | undefined;
  TrafficDirection?: TrafficDirection | undefined;
  RuleNumber?: number | undefined;
  RuleAction?: TrafficMirrorRuleAction | undefined;
  Protocol?: number | undefined;
  DestinationPortRange?: TrafficMirrorPortRange | undefined;
  SourcePortRange?: TrafficMirrorPortRange | undefined;
  DestinationCidrBlock?: string | undefined;
  SourceCidrBlock?: string | undefined;
  Description?: string | undefined;
  Tags?: Tag[] | undefined;
}
export declare const TrafficMirrorNetworkService: {
  readonly amazon_dns: "amazon-dns";
};
export type TrafficMirrorNetworkService =
  (typeof TrafficMirrorNetworkService)[keyof typeof TrafficMirrorNetworkService];
export interface TrafficMirrorFilter {
  TrafficMirrorFilterId?: string | undefined;
  IngressFilterRules?: TrafficMirrorFilterRule[] | undefined;
  EgressFilterRules?: TrafficMirrorFilterRule[] | undefined;
  NetworkServices?: TrafficMirrorNetworkService[] | undefined;
  Description?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateTrafficMirrorFilterResult {
  TrafficMirrorFilter?: TrafficMirrorFilter | undefined;
  ClientToken?: string | undefined;
}
export interface TrafficMirrorPortRangeRequest {
  FromPort?: number | undefined;
  ToPort?: number | undefined;
}
export interface CreateTrafficMirrorFilterRuleRequest {
  TrafficMirrorFilterId: string | undefined;
  TrafficDirection: TrafficDirection | undefined;
  RuleNumber: number | undefined;
  RuleAction: TrafficMirrorRuleAction | undefined;
  DestinationPortRange?: TrafficMirrorPortRangeRequest | undefined;
  SourcePortRange?: TrafficMirrorPortRangeRequest | undefined;
  Protocol?: number | undefined;
  DestinationCidrBlock: string | undefined;
  SourceCidrBlock: string | undefined;
  Description?: string | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export interface CreateTrafficMirrorFilterRuleResult {
  TrafficMirrorFilterRule?: TrafficMirrorFilterRule | undefined;
  ClientToken?: string | undefined;
}
export interface CreateTrafficMirrorSessionRequest {
  NetworkInterfaceId: string | undefined;
  TrafficMirrorTargetId: string | undefined;
  TrafficMirrorFilterId: string | undefined;
  PacketLength?: number | undefined;
  SessionNumber: number | undefined;
  VirtualNetworkId?: number | undefined;
  Description?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
}
export interface TrafficMirrorSession {
  TrafficMirrorSessionId?: string | undefined;
  TrafficMirrorTargetId?: string | undefined;
  TrafficMirrorFilterId?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  OwnerId?: string | undefined;
  PacketLength?: number | undefined;
  SessionNumber?: number | undefined;
  VirtualNetworkId?: number | undefined;
  Description?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateTrafficMirrorSessionResult {
  TrafficMirrorSession?: TrafficMirrorSession | undefined;
  ClientToken?: string | undefined;
}
export interface CreateTrafficMirrorTargetRequest {
  NetworkInterfaceId?: string | undefined;
  NetworkLoadBalancerArn?: string | undefined;
  Description?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  GatewayLoadBalancerEndpointId?: string | undefined;
}
export declare const TrafficMirrorTargetType: {
  readonly gateway_load_balancer_endpoint: "gateway-load-balancer-endpoint";
  readonly network_interface: "network-interface";
  readonly network_load_balancer: "network-load-balancer";
};
export type TrafficMirrorTargetType =
  (typeof TrafficMirrorTargetType)[keyof typeof TrafficMirrorTargetType];
export interface TrafficMirrorTarget {
  TrafficMirrorTargetId?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  NetworkLoadBalancerArn?: string | undefined;
  Type?: TrafficMirrorTargetType | undefined;
  Description?: string | undefined;
  OwnerId?: string | undefined;
  Tags?: Tag[] | undefined;
  GatewayLoadBalancerEndpointId?: string | undefined;
}
export interface CreateTrafficMirrorTargetResult {
  TrafficMirrorTarget?: TrafficMirrorTarget | undefined;
  ClientToken?: string | undefined;
}
export declare const AutoAcceptSharedAttachmentsValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type AutoAcceptSharedAttachmentsValue =
  (typeof AutoAcceptSharedAttachmentsValue)[keyof typeof AutoAcceptSharedAttachmentsValue];
export declare const DefaultRouteTableAssociationValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type DefaultRouteTableAssociationValue =
  (typeof DefaultRouteTableAssociationValue)[keyof typeof DefaultRouteTableAssociationValue];
export declare const DefaultRouteTablePropagationValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type DefaultRouteTablePropagationValue =
  (typeof DefaultRouteTablePropagationValue)[keyof typeof DefaultRouteTablePropagationValue];
export declare const MulticastSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type MulticastSupportValue =
  (typeof MulticastSupportValue)[keyof typeof MulticastSupportValue];
export declare const VpnEcmpSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type VpnEcmpSupportValue =
  (typeof VpnEcmpSupportValue)[keyof typeof VpnEcmpSupportValue];
export interface TransitGatewayRequestOptions {
  AmazonSideAsn?: number | undefined;
  AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue | undefined;
  DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue | undefined;
  DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue | undefined;
  VpnEcmpSupport?: VpnEcmpSupportValue | undefined;
  DnsSupport?: DnsSupportValue | undefined;
  SecurityGroupReferencingSupport?:
    | SecurityGroupReferencingSupportValue
    | undefined;
  MulticastSupport?: MulticastSupportValue | undefined;
  TransitGatewayCidrBlocks?: string[] | undefined;
}
export interface CreateTransitGatewayRequest {
  Description?: string | undefined;
  Options?: TransitGatewayRequestOptions | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface TransitGatewayOptions {
  AmazonSideAsn?: number | undefined;
  TransitGatewayCidrBlocks?: string[] | undefined;
  AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue | undefined;
  DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue | undefined;
  AssociationDefaultRouteTableId?: string | undefined;
  DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue | undefined;
  PropagationDefaultRouteTableId?: string | undefined;
  VpnEcmpSupport?: VpnEcmpSupportValue | undefined;
  DnsSupport?: DnsSupportValue | undefined;
  SecurityGroupReferencingSupport?:
    | SecurityGroupReferencingSupportValue
    | undefined;
  MulticastSupport?: MulticastSupportValue | undefined;
}
export declare const TransitGatewayState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly modifying: "modifying";
  readonly pending: "pending";
};
export type TransitGatewayState =
  (typeof TransitGatewayState)[keyof typeof TransitGatewayState];
export interface TransitGateway {
  TransitGatewayId?: string | undefined;
  TransitGatewayArn?: string | undefined;
  State?: TransitGatewayState | undefined;
  OwnerId?: string | undefined;
  Description?: string | undefined;
  CreationTime?: Date | undefined;
  Options?: TransitGatewayOptions | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateTransitGatewayResult {
  TransitGateway?: TransitGateway | undefined;
}
export declare const ProtocolValue: {
  readonly gre: "gre";
};
export type ProtocolValue = (typeof ProtocolValue)[keyof typeof ProtocolValue];
export interface CreateTransitGatewayConnectRequestOptions {
  Protocol: ProtocolValue | undefined;
}
export interface CreateTransitGatewayConnectRequest {
  TransportTransitGatewayAttachmentId: string | undefined;
  Options: CreateTransitGatewayConnectRequestOptions | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface TransitGatewayConnectOptions {
  Protocol?: ProtocolValue | undefined;
}
export interface TransitGatewayConnect {
  TransitGatewayAttachmentId?: string | undefined;
  TransportTransitGatewayAttachmentId?: string | undefined;
  TransitGatewayId?: string | undefined;
  State?: TransitGatewayAttachmentState | undefined;
  CreationTime?: Date | undefined;
  Options?: TransitGatewayConnectOptions | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateTransitGatewayConnectResult {
  TransitGatewayConnect?: TransitGatewayConnect | undefined;
}
export interface TransitGatewayConnectRequestBgpOptions {
  PeerAsn?: number | undefined;
}
export interface CreateTransitGatewayConnectPeerRequest {
  TransitGatewayAttachmentId: string | undefined;
  TransitGatewayAddress?: string | undefined;
  PeerAddress: string | undefined;
  BgpOptions?: TransitGatewayConnectRequestBgpOptions | undefined;
  InsideCidrBlocks: string[] | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export declare const BgpStatus: {
  readonly down: "down";
  readonly up: "up";
};
export type BgpStatus = (typeof BgpStatus)[keyof typeof BgpStatus];
export interface TransitGatewayAttachmentBgpConfiguration {
  TransitGatewayAsn?: number | undefined;
  PeerAsn?: number | undefined;
  TransitGatewayAddress?: string | undefined;
  PeerAddress?: string | undefined;
  BgpStatus?: BgpStatus | undefined;
}
export interface TransitGatewayConnectPeerConfiguration {
  TransitGatewayAddress?: string | undefined;
  PeerAddress?: string | undefined;
  InsideCidrBlocks?: string[] | undefined;
  Protocol?: ProtocolValue | undefined;
  BgpConfigurations?: TransitGatewayAttachmentBgpConfiguration[] | undefined;
}
export declare const TransitGatewayConnectPeerState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type TransitGatewayConnectPeerState =
  (typeof TransitGatewayConnectPeerState)[keyof typeof TransitGatewayConnectPeerState];
export interface TransitGatewayConnectPeer {
  TransitGatewayAttachmentId?: string | undefined;
  TransitGatewayConnectPeerId?: string | undefined;
  State?: TransitGatewayConnectPeerState | undefined;
  CreationTime?: Date | undefined;
  ConnectPeerConfiguration?: TransitGatewayConnectPeerConfiguration | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateTransitGatewayConnectPeerResult {
  TransitGatewayConnectPeer?: TransitGatewayConnectPeer | undefined;
}
export declare const AutoAcceptSharedAssociationsValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type AutoAcceptSharedAssociationsValue =
  (typeof AutoAcceptSharedAssociationsValue)[keyof typeof AutoAcceptSharedAssociationsValue];
export declare const Igmpv2SupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type Igmpv2SupportValue =
  (typeof Igmpv2SupportValue)[keyof typeof Igmpv2SupportValue];
export declare const StaticSourcesSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type StaticSourcesSupportValue =
  (typeof StaticSourcesSupportValue)[keyof typeof StaticSourcesSupportValue];
export interface CreateTransitGatewayMulticastDomainRequestOptions {
  Igmpv2Support?: Igmpv2SupportValue | undefined;
  StaticSourcesSupport?: StaticSourcesSupportValue | undefined;
  AutoAcceptSharedAssociations?: AutoAcceptSharedAssociationsValue | undefined;
}
export interface CreateTransitGatewayMulticastDomainRequest {
  TransitGatewayId: string | undefined;
  Options?: CreateTransitGatewayMulticastDomainRequestOptions | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface TransitGatewayMulticastDomainOptions {
  Igmpv2Support?: Igmpv2SupportValue | undefined;
  StaticSourcesSupport?: StaticSourcesSupportValue | undefined;
  AutoAcceptSharedAssociations?: AutoAcceptSharedAssociationsValue | undefined;
}
export declare const TransitGatewayMulticastDomainState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type TransitGatewayMulticastDomainState =
  (typeof TransitGatewayMulticastDomainState)[keyof typeof TransitGatewayMulticastDomainState];
export interface TransitGatewayMulticastDomain {
  TransitGatewayMulticastDomainId?: string | undefined;
  TransitGatewayId?: string | undefined;
  TransitGatewayMulticastDomainArn?: string | undefined;
  OwnerId?: string | undefined;
  Options?: TransitGatewayMulticastDomainOptions | undefined;
  State?: TransitGatewayMulticastDomainState | undefined;
  CreationTime?: Date | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateTransitGatewayMulticastDomainResult {
  TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain | undefined;
}
export interface CreateTransitGatewayPeeringAttachmentRequestOptions {
  DynamicRouting?: DynamicRoutingValue | undefined;
}
export interface CreateTransitGatewayPeeringAttachmentRequest {
  TransitGatewayId: string | undefined;
  PeerTransitGatewayId: string | undefined;
  PeerAccountId: string | undefined;
  PeerRegion: string | undefined;
  Options?: CreateTransitGatewayPeeringAttachmentRequestOptions | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface CreateTransitGatewayPeeringAttachmentResult {
  TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment | undefined;
}
export interface CreateTransitGatewayPolicyTableRequest {
  TransitGatewayId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export declare const TransitGatewayPolicyTableState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type TransitGatewayPolicyTableState =
  (typeof TransitGatewayPolicyTableState)[keyof typeof TransitGatewayPolicyTableState];
export interface TransitGatewayPolicyTable {
  TransitGatewayPolicyTableId?: string | undefined;
  TransitGatewayId?: string | undefined;
  State?: TransitGatewayPolicyTableState | undefined;
  CreationTime?: Date | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateTransitGatewayPolicyTableResult {
  TransitGatewayPolicyTable?: TransitGatewayPolicyTable | undefined;
}
export interface CreateTransitGatewayPrefixListReferenceRequest {
  TransitGatewayRouteTableId: string | undefined;
  PrefixListId: string | undefined;
  TransitGatewayAttachmentId?: string | undefined;
  Blackhole?: boolean | undefined;
  DryRun?: boolean | undefined;
}
export declare const TransitGatewayPrefixListReferenceState: {
  readonly available: "available";
  readonly deleting: "deleting";
  readonly modifying: "modifying";
  readonly pending: "pending";
};
export type TransitGatewayPrefixListReferenceState =
  (typeof TransitGatewayPrefixListReferenceState)[keyof typeof TransitGatewayPrefixListReferenceState];
export interface TransitGatewayPrefixListAttachment {
  TransitGatewayAttachmentId?: string | undefined;
  ResourceType?: TransitGatewayAttachmentResourceType | undefined;
  ResourceId?: string | undefined;
}
export interface TransitGatewayPrefixListReference {
  TransitGatewayRouteTableId?: string | undefined;
  PrefixListId?: string | undefined;
  PrefixListOwnerId?: string | undefined;
  State?: TransitGatewayPrefixListReferenceState | undefined;
  Blackhole?: boolean | undefined;
  TransitGatewayAttachment?: TransitGatewayPrefixListAttachment | undefined;
}
export interface CreateTransitGatewayPrefixListReferenceResult {
  TransitGatewayPrefixListReference?:
    | TransitGatewayPrefixListReference
    | undefined;
}
export interface CreateTransitGatewayRouteRequest {
  DestinationCidrBlock: string | undefined;
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId?: string | undefined;
  Blackhole?: boolean | undefined;
  DryRun?: boolean | undefined;
}
export declare const TransitGatewayRouteState: {
  readonly active: "active";
  readonly blackhole: "blackhole";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type TransitGatewayRouteState =
  (typeof TransitGatewayRouteState)[keyof typeof TransitGatewayRouteState];
export interface TransitGatewayRouteAttachment {
  ResourceId?: string | undefined;
  TransitGatewayAttachmentId?: string | undefined;
  ResourceType?: TransitGatewayAttachmentResourceType | undefined;
}
export declare const TransitGatewayRouteType: {
  readonly propagated: "propagated";
  readonly static: "static";
};
export type TransitGatewayRouteType =
  (typeof TransitGatewayRouteType)[keyof typeof TransitGatewayRouteType];
export interface TransitGatewayRoute {
  DestinationCidrBlock?: string | undefined;
  PrefixListId?: string | undefined;
  TransitGatewayRouteTableAnnouncementId?: string | undefined;
  TransitGatewayAttachments?: TransitGatewayRouteAttachment[] | undefined;
  Type?: TransitGatewayRouteType | undefined;
  State?: TransitGatewayRouteState | undefined;
}
export interface CreateTransitGatewayRouteResult {
  Route?: TransitGatewayRoute | undefined;
}
export interface CreateTransitGatewayRouteTableRequest {
  TransitGatewayId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export declare const TransitGatewayRouteTableState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type TransitGatewayRouteTableState =
  (typeof TransitGatewayRouteTableState)[keyof typeof TransitGatewayRouteTableState];
export interface TransitGatewayRouteTable {
  TransitGatewayRouteTableId?: string | undefined;
  TransitGatewayId?: string | undefined;
  State?: TransitGatewayRouteTableState | undefined;
  DefaultAssociationRouteTable?: boolean | undefined;
  DefaultPropagationRouteTable?: boolean | undefined;
  CreationTime?: Date | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateTransitGatewayRouteTableResult {
  TransitGatewayRouteTable?: TransitGatewayRouteTable | undefined;
}
export interface CreateTransitGatewayRouteTableAnnouncementRequest {
  TransitGatewayRouteTableId: string | undefined;
  PeeringAttachmentId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export declare const TransitGatewayRouteTableAnnouncementDirection: {
  readonly incoming: "incoming";
  readonly outgoing: "outgoing";
};
export type TransitGatewayRouteTableAnnouncementDirection =
  (typeof TransitGatewayRouteTableAnnouncementDirection)[keyof typeof TransitGatewayRouteTableAnnouncementDirection];
export declare const TransitGatewayRouteTableAnnouncementState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly failed: "failed";
  readonly failing: "failing";
  readonly pending: "pending";
};
export type TransitGatewayRouteTableAnnouncementState =
  (typeof TransitGatewayRouteTableAnnouncementState)[keyof typeof TransitGatewayRouteTableAnnouncementState];
export interface TransitGatewayRouteTableAnnouncement {
  TransitGatewayRouteTableAnnouncementId?: string | undefined;
  TransitGatewayId?: string | undefined;
  CoreNetworkId?: string | undefined;
  PeerTransitGatewayId?: string | undefined;
  PeerCoreNetworkId?: string | undefined;
  PeeringAttachmentId?: string | undefined;
  AnnouncementDirection?:
    | TransitGatewayRouteTableAnnouncementDirection
    | undefined;
  TransitGatewayRouteTableId?: string | undefined;
  State?: TransitGatewayRouteTableAnnouncementState | undefined;
  CreationTime?: Date | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateTransitGatewayRouteTableAnnouncementResult {
  TransitGatewayRouteTableAnnouncement?:
    | TransitGatewayRouteTableAnnouncement
    | undefined;
}
export interface CreateTransitGatewayVpcAttachmentRequestOptions {
  DnsSupport?: DnsSupportValue | undefined;
  SecurityGroupReferencingSupport?:
    | SecurityGroupReferencingSupportValue
    | undefined;
  Ipv6Support?: Ipv6SupportValue | undefined;
  ApplianceModeSupport?: ApplianceModeSupportValue | undefined;
}
export interface CreateTransitGatewayVpcAttachmentRequest {
  TransitGatewayId: string | undefined;
  VpcId: string | undefined;
  SubnetIds: string[] | undefined;
  Options?: CreateTransitGatewayVpcAttachmentRequestOptions | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface CreateTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment | undefined;
}
export declare const VerifiedAccessEndpointAttachmentType: {
  readonly vpc: "vpc";
};
export type VerifiedAccessEndpointAttachmentType =
  (typeof VerifiedAccessEndpointAttachmentType)[keyof typeof VerifiedAccessEndpointAttachmentType];
export interface CreateVerifiedAccessEndpointPortRange {
  FromPort?: number | undefined;
  ToPort?: number | undefined;
}
export declare const VerifiedAccessEndpointProtocol: {
  readonly http: "http";
  readonly https: "https";
  readonly tcp: "tcp";
};
export type VerifiedAccessEndpointProtocol =
  (typeof VerifiedAccessEndpointProtocol)[keyof typeof VerifiedAccessEndpointProtocol];
export interface CreateVerifiedAccessEndpointCidrOptions {
  Protocol?: VerifiedAccessEndpointProtocol | undefined;
  SubnetIds?: string[] | undefined;
  Cidr?: string | undefined;
  PortRanges?: CreateVerifiedAccessEndpointPortRange[] | undefined;
}
export declare const VerifiedAccessEndpointType: {
  readonly cidr: "cidr";
  readonly load_balancer: "load-balancer";
  readonly network_interface: "network-interface";
  readonly rds: "rds";
};
export type VerifiedAccessEndpointType =
  (typeof VerifiedAccessEndpointType)[keyof typeof VerifiedAccessEndpointType];
export interface CreateVerifiedAccessEndpointLoadBalancerOptions {
  Protocol?: VerifiedAccessEndpointProtocol | undefined;
  Port?: number | undefined;
  LoadBalancerArn?: string | undefined;
  SubnetIds?: string[] | undefined;
  PortRanges?: CreateVerifiedAccessEndpointPortRange[] | undefined;
}
export interface CreateVerifiedAccessEndpointEniOptions {
  NetworkInterfaceId?: string | undefined;
  Protocol?: VerifiedAccessEndpointProtocol | undefined;
  Port?: number | undefined;
  PortRanges?: CreateVerifiedAccessEndpointPortRange[] | undefined;
}
export interface CreateVerifiedAccessEndpointRdsOptions {
  Protocol?: VerifiedAccessEndpointProtocol | undefined;
  Port?: number | undefined;
  RdsDbInstanceArn?: string | undefined;
  RdsDbClusterArn?: string | undefined;
  RdsDbProxyArn?: string | undefined;
  RdsEndpoint?: string | undefined;
  SubnetIds?: string[] | undefined;
}
export interface VerifiedAccessSseSpecificationRequest {
  CustomerManagedKeyEnabled?: boolean | undefined;
  KmsKeyArn?: string | undefined;
}
export interface CreateVerifiedAccessEndpointRequest {
  VerifiedAccessGroupId: string | undefined;
  EndpointType: VerifiedAccessEndpointType | undefined;
  AttachmentType: VerifiedAccessEndpointAttachmentType | undefined;
  DomainCertificateArn?: string | undefined;
  ApplicationDomain?: string | undefined;
  EndpointDomainPrefix?: string | undefined;
  SecurityGroupIds?: string[] | undefined;
  LoadBalancerOptions?:
    | CreateVerifiedAccessEndpointLoadBalancerOptions
    | undefined;
  NetworkInterfaceOptions?: CreateVerifiedAccessEndpointEniOptions | undefined;
  Description?: string | undefined;
  PolicyDocument?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  SseSpecification?: VerifiedAccessSseSpecificationRequest | undefined;
  RdsOptions?: CreateVerifiedAccessEndpointRdsOptions | undefined;
  CidrOptions?: CreateVerifiedAccessEndpointCidrOptions | undefined;
}
export interface VerifiedAccessEndpointPortRange {
  FromPort?: number | undefined;
  ToPort?: number | undefined;
}
export interface VerifiedAccessEndpointCidrOptions {
  Cidr?: string | undefined;
  PortRanges?: VerifiedAccessEndpointPortRange[] | undefined;
  Protocol?: VerifiedAccessEndpointProtocol | undefined;
  SubnetIds?: string[] | undefined;
}
export interface VerifiedAccessEndpointLoadBalancerOptions {
  Protocol?: VerifiedAccessEndpointProtocol | undefined;
  Port?: number | undefined;
  LoadBalancerArn?: string | undefined;
  SubnetIds?: string[] | undefined;
  PortRanges?: VerifiedAccessEndpointPortRange[] | undefined;
}
export interface VerifiedAccessEndpointEniOptions {
  NetworkInterfaceId?: string | undefined;
  Protocol?: VerifiedAccessEndpointProtocol | undefined;
  Port?: number | undefined;
  PortRanges?: VerifiedAccessEndpointPortRange[] | undefined;
}
export interface VerifiedAccessEndpointRdsOptions {
  Protocol?: VerifiedAccessEndpointProtocol | undefined;
  Port?: number | undefined;
  RdsDbInstanceArn?: string | undefined;
  RdsDbClusterArn?: string | undefined;
  RdsDbProxyArn?: string | undefined;
  RdsEndpoint?: string | undefined;
  SubnetIds?: string[] | undefined;
}
export declare const VerifiedAccessEndpointStatusCode: {
  readonly active: "active";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
  readonly updating: "updating";
};
export type VerifiedAccessEndpointStatusCode =
  (typeof VerifiedAccessEndpointStatusCode)[keyof typeof VerifiedAccessEndpointStatusCode];
export interface VerifiedAccessEndpointStatus {
  Code?: VerifiedAccessEndpointStatusCode | undefined;
  Message?: string | undefined;
}
export interface VerifiedAccessEndpoint {
  VerifiedAccessInstanceId?: string | undefined;
  VerifiedAccessGroupId?: string | undefined;
  VerifiedAccessEndpointId?: string | undefined;
  ApplicationDomain?: string | undefined;
  EndpointType?: VerifiedAccessEndpointType | undefined;
  AttachmentType?: VerifiedAccessEndpointAttachmentType | undefined;
  DomainCertificateArn?: string | undefined;
  EndpointDomain?: string | undefined;
  DeviceValidationDomain?: string | undefined;
  SecurityGroupIds?: string[] | undefined;
  LoadBalancerOptions?: VerifiedAccessEndpointLoadBalancerOptions | undefined;
  NetworkInterfaceOptions?: VerifiedAccessEndpointEniOptions | undefined;
  Status?: VerifiedAccessEndpointStatus | undefined;
  Description?: string | undefined;
  CreationTime?: string | undefined;
  LastUpdatedTime?: string | undefined;
  DeletionTime?: string | undefined;
  Tags?: Tag[] | undefined;
  SseSpecification?: VerifiedAccessSseSpecificationResponse | undefined;
  RdsOptions?: VerifiedAccessEndpointRdsOptions | undefined;
  CidrOptions?: VerifiedAccessEndpointCidrOptions | undefined;
}
export interface CreateVerifiedAccessEndpointResult {
  VerifiedAccessEndpoint?: VerifiedAccessEndpoint | undefined;
}
export interface CreateVerifiedAccessGroupRequest {
  VerifiedAccessInstanceId: string | undefined;
  Description?: string | undefined;
  PolicyDocument?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  SseSpecification?: VerifiedAccessSseSpecificationRequest | undefined;
}
export interface VerifiedAccessGroup {
  VerifiedAccessGroupId?: string | undefined;
  VerifiedAccessInstanceId?: string | undefined;
  Description?: string | undefined;
  Owner?: string | undefined;
  VerifiedAccessGroupArn?: string | undefined;
  CreationTime?: string | undefined;
  LastUpdatedTime?: string | undefined;
  DeletionTime?: string | undefined;
  Tags?: Tag[] | undefined;
  SseSpecification?: VerifiedAccessSseSpecificationResponse | undefined;
}
export interface CreateVerifiedAccessGroupResult {
  VerifiedAccessGroup?: VerifiedAccessGroup | undefined;
}
export interface CreateVerifiedAccessInstanceRequest {
  Description?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  FIPSEnabled?: boolean | undefined;
  CidrEndpointsCustomSubDomain?: string | undefined;
}
export interface CreateVerifiedAccessInstanceResult {
  VerifiedAccessInstance?: VerifiedAccessInstance | undefined;
}
export interface CreateVerifiedAccessTrustProviderDeviceOptions {
  TenantId?: string | undefined;
  PublicSigningKeyUrl?: string | undefined;
}
export interface CreateVerifiedAccessNativeApplicationOidcOptions {
  PublicSigningKeyEndpoint?: string | undefined;
  Issuer?: string | undefined;
  AuthorizationEndpoint?: string | undefined;
  TokenEndpoint?: string | undefined;
  UserInfoEndpoint?: string | undefined;
  ClientId?: string | undefined;
  ClientSecret?: string | undefined;
  Scope?: string | undefined;
}
export interface CreateVerifiedAccessTrustProviderOidcOptions {
  Issuer?: string | undefined;
  AuthorizationEndpoint?: string | undefined;
  TokenEndpoint?: string | undefined;
  UserInfoEndpoint?: string | undefined;
  ClientId?: string | undefined;
  ClientSecret?: string | undefined;
  Scope?: string | undefined;
}
export interface CreateVerifiedAccessTrustProviderRequest {
  TrustProviderType: TrustProviderType | undefined;
  UserTrustProviderType?: UserTrustProviderType | undefined;
  DeviceTrustProviderType?: DeviceTrustProviderType | undefined;
  OidcOptions?: CreateVerifiedAccessTrustProviderOidcOptions | undefined;
  DeviceOptions?: CreateVerifiedAccessTrustProviderDeviceOptions | undefined;
  PolicyReferenceName: string | undefined;
  Description?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  SseSpecification?: VerifiedAccessSseSpecificationRequest | undefined;
  NativeApplicationOidcOptions?:
    | CreateVerifiedAccessNativeApplicationOidcOptions
    | undefined;
}
export interface CreateVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider | undefined;
}
export interface CreateVolumeRequest {
  AvailabilityZone: string | undefined;
  Encrypted?: boolean | undefined;
  Iops?: number | undefined;
  KmsKeyId?: string | undefined;
  OutpostArn?: string | undefined;
  Size?: number | undefined;
  SnapshotId?: string | undefined;
  VolumeType?: VolumeType | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  MultiAttachEnabled?: boolean | undefined;
  Throughput?: number | undefined;
  ClientToken?: string | undefined;
  VolumeInitializationRate?: number | undefined;
  Operator?: OperatorRequest | undefined;
  DryRun?: boolean | undefined;
}
export declare const VolumeState: {
  readonly available: "available";
  readonly creating: "creating";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly error: "error";
  readonly in_use: "in-use";
};
export type VolumeState = (typeof VolumeState)[keyof typeof VolumeState];
export interface Volume {
  OutpostArn?: string | undefined;
  Iops?: number | undefined;
  Tags?: Tag[] | undefined;
  VolumeType?: VolumeType | undefined;
  FastRestored?: boolean | undefined;
  MultiAttachEnabled?: boolean | undefined;
  Throughput?: number | undefined;
  SseType?: SSEType | undefined;
  Operator?: OperatorResponse | undefined;
  VolumeInitializationRate?: number | undefined;
  VolumeId?: string | undefined;
  Size?: number | undefined;
  SnapshotId?: string | undefined;
  AvailabilityZone?: string | undefined;
  State?: VolumeState | undefined;
  CreateTime?: Date | undefined;
  Attachments?: VolumeAttachment[] | undefined;
  Encrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
}
export interface CreateVpcRequest {
  CidrBlock?: string | undefined;
  Ipv6Pool?: string | undefined;
  Ipv6CidrBlock?: string | undefined;
  Ipv4IpamPoolId?: string | undefined;
  Ipv4NetmaskLength?: number | undefined;
  Ipv6IpamPoolId?: string | undefined;
  Ipv6NetmaskLength?: number | undefined;
  Ipv6CidrBlockNetworkBorderGroup?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  InstanceTenancy?: Tenancy | undefined;
  AmazonProvidedIpv6CidrBlock?: boolean | undefined;
}
export interface CreateVpcResult {
  Vpc?: Vpc | undefined;
}
export declare const InternetGatewayExclusionMode: {
  readonly allow_bidirectional: "allow-bidirectional";
  readonly allow_egress: "allow-egress";
};
export type InternetGatewayExclusionMode =
  (typeof InternetGatewayExclusionMode)[keyof typeof InternetGatewayExclusionMode];
export interface CreateVpcBlockPublicAccessExclusionRequest {
  DryRun?: boolean | undefined;
  SubnetId?: string | undefined;
  VpcId?: string | undefined;
  InternetGatewayExclusionMode: InternetGatewayExclusionMode | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export declare const VpcBlockPublicAccessExclusionState: {
  readonly create_complete: "create-complete";
  readonly create_failed: "create-failed";
  readonly create_in_progress: "create-in-progress";
  readonly delete_complete: "delete-complete";
  readonly delete_in_progress: "delete-in-progress";
  readonly disable_complete: "disable-complete";
  readonly disable_in_progress: "disable-in-progress";
  readonly update_complete: "update-complete";
  readonly update_failed: "update-failed";
  readonly update_in_progress: "update-in-progress";
};
export type VpcBlockPublicAccessExclusionState =
  (typeof VpcBlockPublicAccessExclusionState)[keyof typeof VpcBlockPublicAccessExclusionState];
export interface VpcBlockPublicAccessExclusion {
  ExclusionId?: string | undefined;
  InternetGatewayExclusionMode?: InternetGatewayExclusionMode | undefined;
  ResourceArn?: string | undefined;
  State?: VpcBlockPublicAccessExclusionState | undefined;
  Reason?: string | undefined;
  CreationTimestamp?: Date | undefined;
  LastUpdateTimestamp?: Date | undefined;
  DeletionTimestamp?: Date | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateVpcBlockPublicAccessExclusionResult {
  VpcBlockPublicAccessExclusion?: VpcBlockPublicAccessExclusion | undefined;
}
export declare const DnsRecordIpType: {
  readonly dualstack: "dualstack";
  readonly ipv4: "ipv4";
  readonly ipv6: "ipv6";
  readonly service_defined: "service-defined";
};
export type DnsRecordIpType =
  (typeof DnsRecordIpType)[keyof typeof DnsRecordIpType];
export interface DnsOptionsSpecification {
  DnsRecordIpType?: DnsRecordIpType | undefined;
  PrivateDnsOnlyForInboundResolverEndpoint?: boolean | undefined;
}
export declare const IpAddressType: {
  readonly dualstack: "dualstack";
  readonly ipv4: "ipv4";
  readonly ipv6: "ipv6";
};
export type IpAddressType = (typeof IpAddressType)[keyof typeof IpAddressType];
export interface SubnetConfiguration {
  SubnetId?: string | undefined;
  Ipv4?: string | undefined;
  Ipv6?: string | undefined;
}
export declare const VpcEndpointType: {
  readonly Gateway: "Gateway";
  readonly GatewayLoadBalancer: "GatewayLoadBalancer";
  readonly Interface: "Interface";
  readonly Resource: "Resource";
  readonly ServiceNetwork: "ServiceNetwork";
};
export type VpcEndpointType =
  (typeof VpcEndpointType)[keyof typeof VpcEndpointType];
export interface CreateVpcEndpointRequest {
  DryRun?: boolean | undefined;
  VpcEndpointType?: VpcEndpointType | undefined;
  VpcId: string | undefined;
  ServiceName?: string | undefined;
  PolicyDocument?: string | undefined;
  RouteTableIds?: string[] | undefined;
  SubnetIds?: string[] | undefined;
  SecurityGroupIds?: string[] | undefined;
  IpAddressType?: IpAddressType | undefined;
  DnsOptions?: DnsOptionsSpecification | undefined;
  ClientToken?: string | undefined;
  PrivateDnsEnabled?: boolean | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  SubnetConfigurations?: SubnetConfiguration[] | undefined;
  ServiceNetworkArn?: string | undefined;
  ResourceConfigurationArn?: string | undefined;
  ServiceRegion?: string | undefined;
}
export interface DnsEntry {
  DnsName?: string | undefined;
  HostedZoneId?: string | undefined;
}
export interface DnsOptions {
  DnsRecordIpType?: DnsRecordIpType | undefined;
  PrivateDnsOnlyForInboundResolverEndpoint?: boolean | undefined;
}
export interface SecurityGroupIdentifier {
  GroupId?: string | undefined;
  GroupName?: string | undefined;
}
export interface SubnetIpPrefixes {
  SubnetId?: string | undefined;
  IpPrefixes?: string[] | undefined;
}
export interface LastError {
  Message?: string | undefined;
  Code?: string | undefined;
}
export declare const State: {
  readonly Available: "Available";
  readonly Deleted: "Deleted";
  readonly Deleting: "Deleting";
  readonly Expired: "Expired";
  readonly Failed: "Failed";
  readonly Partial: "Partial";
  readonly Pending: "Pending";
  readonly PendingAcceptance: "PendingAcceptance";
  readonly Rejected: "Rejected";
};
export type State = (typeof State)[keyof typeof State];
export interface VpcEndpoint {
  VpcEndpointId?: string | undefined;
  VpcEndpointType?: VpcEndpointType | undefined;
  VpcId?: string | undefined;
  ServiceName?: string | undefined;
  State?: State | undefined;
  PolicyDocument?: string | undefined;
  RouteTableIds?: string[] | undefined;
  SubnetIds?: string[] | undefined;
  Groups?: SecurityGroupIdentifier[] | undefined;
  IpAddressType?: IpAddressType | undefined;
  DnsOptions?: DnsOptions | undefined;
  PrivateDnsEnabled?: boolean | undefined;
  RequesterManaged?: boolean | undefined;
  NetworkInterfaceIds?: string[] | undefined;
  DnsEntries?: DnsEntry[] | undefined;
  CreationTimestamp?: Date | undefined;
  Tags?: Tag[] | undefined;
  OwnerId?: string | undefined;
  LastError?: LastError | undefined;
  Ipv4Prefixes?: SubnetIpPrefixes[] | undefined;
  Ipv6Prefixes?: SubnetIpPrefixes[] | undefined;
  FailureReason?: string | undefined;
  ServiceNetworkArn?: string | undefined;
  ResourceConfigurationArn?: string | undefined;
  ServiceRegion?: string | undefined;
}
export declare const ResponseLaunchTemplateDataFilterSensitiveLog: (
  obj: ResponseLaunchTemplateData
) => any;
export declare const LaunchTemplateVersionFilterSensitiveLog: (
  obj: LaunchTemplateVersion
) => any;
export declare const CreateLaunchTemplateVersionResultFilterSensitiveLog: (
  obj: CreateLaunchTemplateVersionResult
) => any;
export declare const CreateMacSystemIntegrityProtectionModificationTaskRequestFilterSensitiveLog: (
  obj: CreateMacSystemIntegrityProtectionModificationTaskRequest
) => any;
export declare const CreateVerifiedAccessNativeApplicationOidcOptionsFilterSensitiveLog: (
  obj: CreateVerifiedAccessNativeApplicationOidcOptions
) => any;
export declare const CreateVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog: (
  obj: CreateVerifiedAccessTrustProviderOidcOptions
) => any;
export declare const CreateVerifiedAccessTrustProviderRequestFilterSensitiveLog: (
  obj: CreateVerifiedAccessTrustProviderRequest
) => any;
export declare const CreateVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: CreateVerifiedAccessTrustProviderResult
) => any;
