import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { RestoreSnapshotTierRequest, RestoreSnapshotTierResult } from "../models/models_8";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link RestoreSnapshotTierCommand}.
 */
export interface RestoreSnapshotTierCommandInput extends RestoreSnapshotTierRequest {
}
/**
 * @public
 *
 * The output of {@link RestoreSnapshotTierCommand}.
 */
export interface RestoreSnapshotTierCommandOutput extends RestoreSnapshotTierResult, __MetadataBearer {
}
declare const RestoreSnapshotTierCommand_base: {
    new (input: RestoreSnapshotTierCommandInput): import("@smithy/smithy-client").CommandImpl<RestoreSnapshotTierCommandInput, RestoreSnapshotTierCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: RestoreSnapshotTierCommandInput): import("@smithy/smithy-client").CommandImpl<RestoreSnapshotTierCommandInput, RestoreSnapshotTierCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Restores an archived Amazon EBS snapshot for use temporarily or permanently, or modifies the restore
 *       period or restore type for a snapshot that was previously temporarily restored.</p>
 *          <p>For more information see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/working-with-snapshot-archiving.html#restore-archived-snapshot">
 *       Restore an archived snapshot</a> and <a href="https://docs.aws.amazon.com/ebs/latest/userguide/working-with-snapshot-archiving.html#modify-temp-restore-period">
 *         modify the restore period or restore type for a temporarily restored snapshot</a> in the <i>Amazon EBS User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, RestoreSnapshotTierCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, RestoreSnapshotTierCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // RestoreSnapshotTierRequest
 *   SnapshotId: "STRING_VALUE", // required
 *   TemporaryRestoreDays: Number("int"),
 *   PermanentRestore: true || false,
 *   DryRun: true || false,
 * };
 * const command = new RestoreSnapshotTierCommand(input);
 * const response = await client.send(command);
 * // { // RestoreSnapshotTierResult
 * //   SnapshotId: "STRING_VALUE",
 * //   RestoreStartTime: new Date("TIMESTAMP"),
 * //   RestoreDuration: Number("int"),
 * //   IsPermanentRestore: true || false,
 * // };
 *
 * ```
 *
 * @param RestoreSnapshotTierCommandInput - {@link RestoreSnapshotTierCommandInput}
 * @returns {@link RestoreSnapshotTierCommandOutput}
 * @see {@link RestoreSnapshotTierCommandInput} for command's `input` shape.
 * @see {@link RestoreSnapshotTierCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class RestoreSnapshotTierCommand extends RestoreSnapshotTierCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: RestoreSnapshotTierRequest;
            output: RestoreSnapshotTierResult;
        };
        sdk: {
            input: RestoreSnapshotTierCommandInput;
            output: RestoreSnapshotTierCommandOutput;
        };
    };
}
