import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyPrivateDnsNameOptionsRequest, ModifyPrivateDnsNameOptionsResult } from "../models/models_7";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ModifyPrivateDnsNameOptionsCommand}.
 */
export interface ModifyPrivateDnsNameOptionsCommandInput extends ModifyPrivateDnsNameOptionsRequest {
}
/**
 * @public
 *
 * The output of {@link ModifyPrivateDnsNameOptionsCommand}.
 */
export interface ModifyPrivateDnsNameOptionsCommandOutput extends ModifyPrivateDnsNameOptionsResult, __MetadataBearer {
}
declare const ModifyPrivateDnsNameOptionsCommand_base: {
    new (input: ModifyPrivateDnsNameOptionsCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyPrivateDnsNameOptionsCommandInput, ModifyPrivateDnsNameOptionsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: ModifyPrivateDnsNameOptionsCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyPrivateDnsNameOptionsCommandInput, ModifyPrivateDnsNameOptionsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Modifies the options for instance hostnames for the specified instance.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyPrivateDnsNameOptionsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyPrivateDnsNameOptionsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // ModifyPrivateDnsNameOptionsRequest
 *   DryRun: true || false,
 *   InstanceId: "STRING_VALUE", // required
 *   PrivateDnsHostnameType: "ip-name" || "resource-name",
 *   EnableResourceNameDnsARecord: true || false,
 *   EnableResourceNameDnsAAAARecord: true || false,
 * };
 * const command = new ModifyPrivateDnsNameOptionsCommand(input);
 * const response = await client.send(command);
 * // { // ModifyPrivateDnsNameOptionsResult
 * //   Return: true || false,
 * // };
 *
 * ```
 *
 * @param ModifyPrivateDnsNameOptionsCommandInput - {@link ModifyPrivateDnsNameOptionsCommandInput}
 * @returns {@link ModifyPrivateDnsNameOptionsCommandOutput}
 * @see {@link ModifyPrivateDnsNameOptionsCommandInput} for command's `input` shape.
 * @see {@link ModifyPrivateDnsNameOptionsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class ModifyPrivateDnsNameOptionsCommand extends ModifyPrivateDnsNameOptionsCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ModifyPrivateDnsNameOptionsRequest;
            output: ModifyPrivateDnsNameOptionsResult;
        };
        sdk: {
            input: ModifyPrivateDnsNameOptionsCommandInput;
            output: ModifyPrivateDnsNameOptionsCommandOutput;
        };
    };
}
