import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { EnableVgwRoutePropagationRequest } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link EnableVgwRoutePropagationCommand}.
 */
export interface EnableVgwRoutePropagationCommandInput extends EnableVgwRoutePropagationRequest {
}
/**
 * @public
 *
 * The output of {@link EnableVgwRoutePropagationCommand}.
 */
export interface EnableVgwRoutePropagationCommandOutput extends __MetadataBearer {
}
declare const EnableVgwRoutePropagationCommand_base: {
    new (input: EnableVgwRoutePropagationCommandInput): import("@smithy/smithy-client").CommandImpl<EnableVgwRoutePropagationCommandInput, EnableVgwRoutePropagationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: EnableVgwRoutePropagationCommandInput): import("@smithy/smithy-client").CommandImpl<EnableVgwRoutePropagationCommandInput, EnableVgwRoutePropagationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Enables a virtual private gateway (VGW) to propagate routes to the specified route
 *             table of a VPC.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, EnableVgwRoutePropagationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, EnableVgwRoutePropagationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // EnableVgwRoutePropagationRequest
 *   GatewayId: "STRING_VALUE", // required
 *   RouteTableId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new EnableVgwRoutePropagationCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param EnableVgwRoutePropagationCommandInput - {@link EnableVgwRoutePropagationCommandInput}
 * @returns {@link EnableVgwRoutePropagationCommandOutput}
 * @see {@link EnableVgwRoutePropagationCommandInput} for command's `input` shape.
 * @see {@link EnableVgwRoutePropagationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @example To enable route propagation
 * ```javascript
 * // This example enables the specified virtual private gateway to propagate static routes to the specified route table.
 * const input = {
 *   GatewayId: "vgw-9a4cacf3",
 *   RouteTableId: "rtb-22574640"
 * };
 * const command = new EnableVgwRoutePropagationCommand(input);
 * const response = await client.send(command);
 * /* response is
 * { /* metadata only *\/ }
 * *\/
 * ```
 *
 * @public
 */
export declare class EnableVgwRoutePropagationCommand extends EnableVgwRoutePropagationCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: EnableVgwRoutePropagationRequest;
            output: {};
        };
        sdk: {
            input: EnableVgwRoutePropagationCommandInput;
            output: EnableVgwRoutePropagationCommandOutput;
        };
    };
}
