import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeVpnConnectionsRequest, DescribeVpnConnectionsResult } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DescribeVpnConnectionsCommand}.
 */
export interface DescribeVpnConnectionsCommandInput extends DescribeVpnConnectionsRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeVpnConnectionsCommand}.
 */
export interface DescribeVpnConnectionsCommandOutput extends DescribeVpnConnectionsResult, __MetadataBearer {
}
declare const DescribeVpnConnectionsCommand_base: {
    new (input: DescribeVpnConnectionsCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeVpnConnectionsCommandInput, DescribeVpnConnectionsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribeVpnConnectionsCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribeVpnConnectionsCommandInput, DescribeVpnConnectionsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes one or more of your VPN connections.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN
 *                 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeVpnConnectionsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeVpnConnectionsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribeVpnConnectionsRequest
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   VpnConnectionIds: [ // VpnConnectionIdStringList
 *     "STRING_VALUE",
 *   ],
 *   DryRun: true || false,
 * };
 * const command = new DescribeVpnConnectionsCommand(input);
 * const response = await client.send(command);
 * // { // DescribeVpnConnectionsResult
 * //   VpnConnections: [ // VpnConnectionList
 * //     { // VpnConnection
 * //       Category: "STRING_VALUE",
 * //       TransitGatewayId: "STRING_VALUE",
 * //       CoreNetworkArn: "STRING_VALUE",
 * //       CoreNetworkAttachmentArn: "STRING_VALUE",
 * //       GatewayAssociationState: "associated" || "not-associated" || "associating" || "disassociating",
 * //       Options: { // VpnConnectionOptions
 * //         EnableAcceleration: true || false,
 * //         StaticRoutesOnly: true || false,
 * //         LocalIpv4NetworkCidr: "STRING_VALUE",
 * //         RemoteIpv4NetworkCidr: "STRING_VALUE",
 * //         LocalIpv6NetworkCidr: "STRING_VALUE",
 * //         RemoteIpv6NetworkCidr: "STRING_VALUE",
 * //         OutsideIpAddressType: "STRING_VALUE",
 * //         TransportTransitGatewayAttachmentId: "STRING_VALUE",
 * //         TunnelInsideIpVersion: "ipv4" || "ipv6",
 * //         TunnelOptions: [ // TunnelOptionsList
 * //           { // TunnelOption
 * //             OutsideIpAddress: "STRING_VALUE",
 * //             TunnelInsideCidr: "STRING_VALUE",
 * //             TunnelInsideIpv6Cidr: "STRING_VALUE",
 * //             PreSharedKey: "STRING_VALUE",
 * //             Phase1LifetimeSeconds: Number("int"),
 * //             Phase2LifetimeSeconds: Number("int"),
 * //             RekeyMarginTimeSeconds: Number("int"),
 * //             RekeyFuzzPercentage: Number("int"),
 * //             ReplayWindowSize: Number("int"),
 * //             DpdTimeoutSeconds: Number("int"),
 * //             DpdTimeoutAction: "STRING_VALUE",
 * //             Phase1EncryptionAlgorithms: [ // Phase1EncryptionAlgorithmsList
 * //               { // Phase1EncryptionAlgorithmsListValue
 * //                 Value: "STRING_VALUE",
 * //               },
 * //             ],
 * //             Phase2EncryptionAlgorithms: [ // Phase2EncryptionAlgorithmsList
 * //               { // Phase2EncryptionAlgorithmsListValue
 * //                 Value: "STRING_VALUE",
 * //               },
 * //             ],
 * //             Phase1IntegrityAlgorithms: [ // Phase1IntegrityAlgorithmsList
 * //               { // Phase1IntegrityAlgorithmsListValue
 * //                 Value: "STRING_VALUE",
 * //               },
 * //             ],
 * //             Phase2IntegrityAlgorithms: [ // Phase2IntegrityAlgorithmsList
 * //               { // Phase2IntegrityAlgorithmsListValue
 * //                 Value: "STRING_VALUE",
 * //               },
 * //             ],
 * //             Phase1DHGroupNumbers: [ // Phase1DHGroupNumbersList
 * //               { // Phase1DHGroupNumbersListValue
 * //                 Value: Number("int"),
 * //               },
 * //             ],
 * //             Phase2DHGroupNumbers: [ // Phase2DHGroupNumbersList
 * //               { // Phase2DHGroupNumbersListValue
 * //                 Value: Number("int"),
 * //               },
 * //             ],
 * //             IkeVersions: [ // IKEVersionsList
 * //               { // IKEVersionsListValue
 * //                 Value: "STRING_VALUE",
 * //               },
 * //             ],
 * //             StartupAction: "STRING_VALUE",
 * //             LogOptions: { // VpnTunnelLogOptions
 * //               CloudWatchLogOptions: { // CloudWatchLogOptions
 * //                 LogEnabled: true || false,
 * //                 LogGroupArn: "STRING_VALUE",
 * //                 LogOutputFormat: "STRING_VALUE",
 * //               },
 * //             },
 * //             EnableTunnelLifecycleControl: true || false,
 * //           },
 * //         ],
 * //       },
 * //       Routes: [ // VpnStaticRouteList
 * //         { // VpnStaticRoute
 * //           DestinationCidrBlock: "STRING_VALUE",
 * //           Source: "Static",
 * //           State: "pending" || "available" || "deleting" || "deleted",
 * //         },
 * //       ],
 * //       Tags: [ // TagList
 * //         { // Tag
 * //           Key: "STRING_VALUE",
 * //           Value: "STRING_VALUE",
 * //         },
 * //       ],
 * //       VgwTelemetry: [ // VgwTelemetryList
 * //         { // VgwTelemetry
 * //           AcceptedRouteCount: Number("int"),
 * //           LastStatusChange: new Date("TIMESTAMP"),
 * //           OutsideIpAddress: "STRING_VALUE",
 * //           Status: "UP" || "DOWN",
 * //           StatusMessage: "STRING_VALUE",
 * //           CertificateArn: "STRING_VALUE",
 * //         },
 * //       ],
 * //       PreSharedKeyArn: "STRING_VALUE",
 * //       VpnConnectionId: "STRING_VALUE",
 * //       State: "pending" || "available" || "deleting" || "deleted",
 * //       CustomerGatewayConfiguration: "STRING_VALUE",
 * //       Type: "ipsec.1",
 * //       CustomerGatewayId: "STRING_VALUE",
 * //       VpnGatewayId: "STRING_VALUE",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param DescribeVpnConnectionsCommandInput - {@link DescribeVpnConnectionsCommandInput}
 * @returns {@link DescribeVpnConnectionsCommandOutput}
 * @see {@link DescribeVpnConnectionsCommandInput} for command's `input` shape.
 * @see {@link DescribeVpnConnectionsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DescribeVpnConnectionsCommand extends DescribeVpnConnectionsCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DescribeVpnConnectionsRequest;
            output: DescribeVpnConnectionsResult;
        };
        sdk: {
            input: DescribeVpnConnectionsCommandInput;
            output: DescribeVpnConnectionsCommandOutput;
        };
    };
}
