import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeByoipCidrsRequest, DescribeByoipCidrsResult } from "../models/models_3";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DescribeByoipCidrsCommand}.
 */
export interface DescribeByoipCidrsCommandInput extends DescribeByoipCidrsRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeByoipCidrsCommand}.
 */
export interface DescribeByoipCidrsCommandOutput extends DescribeByoipCidrsResult, __MetadataBearer {
}
declare const DescribeByoipCidrsCommand_base: {
    new (input: DescribeByoipCidrsCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeByoipCidrsCommandInput, DescribeByoipCidrsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DescribeByoipCidrsCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeByoipCidrsCommandInput, DescribeByoipCidrsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the IP address ranges that were specified in calls to <a>ProvisionByoipCidr</a>.</p>
 *          <p>To describe the address pools that were created when you provisioned the address
 *           ranges, use <a>DescribePublicIpv4Pools</a> or <a>DescribeIpv6Pools</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeByoipCidrsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeByoipCidrsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribeByoipCidrsRequest
 *   DryRun: true || false,
 *   MaxResults: Number("int"), // required
 *   NextToken: "STRING_VALUE",
 * };
 * const command = new DescribeByoipCidrsCommand(input);
 * const response = await client.send(command);
 * // { // DescribeByoipCidrsResult
 * //   ByoipCidrs: [ // ByoipCidrSet
 * //     { // ByoipCidr
 * //       Cidr: "STRING_VALUE",
 * //       Description: "STRING_VALUE",
 * //       AsnAssociations: [ // AsnAssociationSet
 * //         { // AsnAssociation
 * //           Asn: "STRING_VALUE",
 * //           Cidr: "STRING_VALUE",
 * //           StatusMessage: "STRING_VALUE",
 * //           State: "disassociated" || "failed-disassociation" || "failed-association" || "pending-disassociation" || "pending-association" || "associated",
 * //         },
 * //       ],
 * //       StatusMessage: "STRING_VALUE",
 * //       State: "advertised" || "deprovisioned" || "failed-deprovision" || "failed-provision" || "pending-deprovision" || "pending-provision" || "provisioned" || "provisioned-not-publicly-advertisable",
 * //       NetworkBorderGroup: "STRING_VALUE",
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DescribeByoipCidrsCommandInput - {@link DescribeByoipCidrsCommandInput}
 * @returns {@link DescribeByoipCidrsCommandOutput}
 * @see {@link DescribeByoipCidrsCommandInput} for command's `input` shape.
 * @see {@link DescribeByoipCidrsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DescribeByoipCidrsCommand extends DescribeByoipCidrsCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DescribeByoipCidrsRequest;
            output: DescribeByoipCidrsResult;
        };
        sdk: {
            input: DescribeByoipCidrsCommandInput;
            output: DescribeByoipCidrsCommandOutput;
        };
    };
}
