import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { VerifiedAccessTrustProviderFilterSensitiveLog, } from "./models_0";
import { LaunchTemplateVersionFilterSensitiveLog, } from "./models_2";
export const LockState = {
    compliance: "compliance",
    compliance_cooloff: "compliance-cooloff",
    expired: "expired",
    governance: "governance",
};
export const MoveStatus = {
    movingToVpc: "movingToVpc",
    restoringToClassic: "restoringToClassic",
};
export const FindingsFound = {
    false: "false",
    true: "true",
    unknown: "unknown",
};
export const AnalysisStatus = {
    failed: "failed",
    running: "running",
    succeeded: "succeeded",
};
export const NetworkInterfaceAttribute = {
    associatePublicIpAddress: "associatePublicIpAddress",
    attachment: "attachment",
    description: "description",
    groupSet: "groupSet",
    sourceDestCheck: "sourceDestCheck",
};
export const OfferingClassType = {
    CONVERTIBLE: "convertible",
    STANDARD: "standard",
};
export const OfferingTypeValues = {
    All_Upfront: "All Upfront",
    Heavy_Utilization: "Heavy Utilization",
    Light_Utilization: "Light Utilization",
    Medium_Utilization: "Medium Utilization",
    No_Upfront: "No Upfront",
    Partial_Upfront: "Partial Upfront",
};
export const RIProductDescription = {
    Linux_UNIX: "Linux/UNIX",
    Linux_UNIX_Amazon_VPC_: "Linux/UNIX (Amazon VPC)",
    Windows: "Windows",
    Windows_Amazon_VPC_: "Windows (Amazon VPC)",
};
export const RecurringChargeFrequency = {
    Hourly: "Hourly",
};
export const Scope = {
    AVAILABILITY_ZONE: "Availability Zone",
    REGIONAL: "Region",
};
export const ReservedInstanceState = {
    active: "active",
    payment_failed: "payment-failed",
    payment_pending: "payment-pending",
    queued: "queued",
    queued_deleted: "queued-deleted",
    retired: "retired",
};
export const ServiceLinkVirtualInterfaceConfigurationState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const SnapshotAttributeName = {
    createVolumePermission: "createVolumePermission",
    productCodes: "productCodes",
};
export const TieringOperationStatus = {
    archival_completed: "archival-completed",
    archival_failed: "archival-failed",
    archival_in_progress: "archival-in-progress",
    permanent_restore_completed: "permanent-restore-completed",
    permanent_restore_failed: "permanent-restore-failed",
    permanent_restore_in_progress: "permanent-restore-in-progress",
    temporary_restore_completed: "temporary-restore-completed",
    temporary_restore_failed: "temporary-restore-failed",
    temporary_restore_in_progress: "temporary-restore-in-progress",
};
export const EventType = {
    BATCH_CHANGE: "fleetRequestChange",
    ERROR: "error",
    INFORMATION: "information",
    INSTANCE_CHANGE: "instanceChange",
};
export const ExcessCapacityTerminationPolicy = {
    DEFAULT: "default",
    NO_TERMINATION: "noTermination",
};
export const OnDemandAllocationStrategy = {
    LOWEST_PRICE: "lowestPrice",
    PRIORITIZED: "prioritized",
};
export const ReplacementStrategy = {
    LAUNCH: "launch",
    LAUNCH_BEFORE_TERMINATE: "launch-before-terminate",
};
export const SpotInstanceState = {
    active: "active",
    cancelled: "cancelled",
    closed: "closed",
    disabled: "disabled",
    failed: "failed",
    open: "open",
};
export const VerifiedAccessLogDeliveryStatusCode = {
    FAILED: "failed",
    SUCCESS: "success",
};
export const VolumeAttributeName = {
    autoEnableIO: "autoEnableIO",
    productCodes: "productCodes",
};
export const VolumeModificationState = {
    completed: "completed",
    failed: "failed",
    modifying: "modifying",
    optimizing: "optimizing",
};
export const VolumeStatusName = {
    io_enabled: "io-enabled",
    io_performance: "io-performance",
};
export const VolumeStatusInfoStatus = {
    impaired: "impaired",
    insufficient_data: "insufficient-data",
    ok: "ok",
};
export const VpcAttributeName = {
    enableDnsHostnames: "enableDnsHostnames",
    enableDnsSupport: "enableDnsSupport",
    enableNetworkAddressUsageMetrics: "enableNetworkAddressUsageMetrics",
};
export const VpcBlockPublicAccessExclusionsAllowed = {
    allowed: "allowed",
    not_allowed: "not-allowed",
};
export const InternetGatewayBlockMode = {
    block_bidirectional: "block-bidirectional",
    block_ingress: "block-ingress",
    off: "off",
};
export const ManagedBy = {
    account: "account",
    declarative_policy: "declarative-policy",
};
export const VpcBlockPublicAccessState = {
    default_state: "default-state",
    update_complete: "update-complete",
    update_in_progress: "update-in-progress",
};
export const DescribeLaunchTemplateVersionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchTemplateVersions && {
        LaunchTemplateVersions: obj.LaunchTemplateVersions.map((item) => LaunchTemplateVersionFilterSensitiveLog(item)),
    }),
});
export const SpotFleetLaunchSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserData && { UserData: SENSITIVE_STRING }),
});
export const SpotFleetRequestConfigDataFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchSpecifications && {
        LaunchSpecifications: obj.LaunchSpecifications.map((item) => SpotFleetLaunchSpecificationFilterSensitiveLog(item)),
    }),
});
export const SpotFleetRequestConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SpotFleetRequestConfig && {
        SpotFleetRequestConfig: SpotFleetRequestConfigDataFilterSensitiveLog(obj.SpotFleetRequestConfig),
    }),
});
export const DescribeSpotFleetRequestsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const LaunchSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserData && { UserData: SENSITIVE_STRING }),
});
export const SpotInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchSpecification && {
        LaunchSpecification: LaunchSpecificationFilterSensitiveLog(obj.LaunchSpecification),
    }),
});
export const DescribeSpotInstanceRequestsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SpotInstanceRequests && {
        SpotInstanceRequests: obj.SpotInstanceRequests.map((item) => SpotInstanceRequestFilterSensitiveLog(item)),
    }),
});
export const DescribeVerifiedAccessTrustProvidersResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VerifiedAccessTrustProviders && {
        VerifiedAccessTrustProviders: obj.VerifiedAccessTrustProviders.map((item) => VerifiedAccessTrustProviderFilterSensitiveLog(item)),
    }),
});
