import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { VerifiedAccessTrustProviderFilterSensitiveLog, } from "./models_0";
export const LocalGatewayRouteState = {
    active: "active",
    blackhole: "blackhole",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const LocalGatewayRouteType = {
    propagated: "propagated",
    static: "static",
};
export const LocalGatewayRouteTableMode = {
    coip: "coip",
    direct_vpc_routing: "direct-vpc-routing",
};
export const LocalGatewayVirtualInterfaceConfigurationState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const LocalGatewayVirtualInterfaceGroupConfigurationState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    incomplete: "incomplete",
    pending: "pending",
};
export const PrefixListState = {
    create_complete: "create-complete",
    create_failed: "create-failed",
    create_in_progress: "create-in-progress",
    delete_complete: "delete-complete",
    delete_failed: "delete-failed",
    delete_in_progress: "delete-in-progress",
    modify_complete: "modify-complete",
    modify_failed: "modify-failed",
    modify_in_progress: "modify-in-progress",
    restore_complete: "restore-complete",
    restore_failed: "restore-failed",
    restore_in_progress: "restore-in-progress",
};
export const ConnectivityType = {
    PRIVATE: "private",
    PUBLIC: "public",
};
export const NatGatewayState = {
    AVAILABLE: "available",
    DELETED: "deleted",
    DELETING: "deleting",
    FAILED: "failed",
    PENDING: "pending",
};
export const RuleAction = {
    allow: "allow",
    deny: "deny",
};
export const NetworkInterfaceCreationType = {
    branch: "branch",
    efa: "efa",
    efa_only: "efa-only",
    trunk: "trunk",
};
export const NetworkInterfaceType = {
    api_gateway_managed: "api_gateway_managed",
    aws_codestar_connections_managed: "aws_codestar_connections_managed",
    branch: "branch",
    efa: "efa",
    efa_only: "efa-only",
    gateway_load_balancer: "gateway_load_balancer",
    gateway_load_balancer_endpoint: "gateway_load_balancer_endpoint",
    global_accelerator_managed: "global_accelerator_managed",
    interface: "interface",
    iot_rules_managed: "iot_rules_managed",
    lambda: "lambda",
    load_balancer: "load_balancer",
    natGateway: "natGateway",
    network_load_balancer: "network_load_balancer",
    quicksight: "quicksight",
    transit_gateway: "transit_gateway",
    trunk: "trunk",
    vpc_endpoint: "vpc_endpoint",
};
export const NetworkInterfaceStatus = {
    associated: "associated",
    attaching: "attaching",
    available: "available",
    detaching: "detaching",
    in_use: "in-use",
};
export const InterfacePermissionType = {
    EIP_ASSOCIATE: "EIP-ASSOCIATE",
    INSTANCE_ATTACH: "INSTANCE-ATTACH",
};
export const NetworkInterfacePermissionStateCode = {
    granted: "granted",
    pending: "pending",
    revoked: "revoked",
    revoking: "revoking",
};
export const SpreadLevel = {
    host: "host",
    rack: "rack",
};
export const PlacementStrategy = {
    cluster: "cluster",
    partition: "partition",
    spread: "spread",
};
export const PlacementGroupState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const ReplaceRootVolumeTaskState = {
    failed: "failed",
    failed_detached: "failed-detached",
    failing: "failing",
    in_progress: "in-progress",
    pending: "pending",
    succeeded: "succeeded",
};
export const RouteServerPersistRoutesAction = {
    DISABLE: "disable",
    ENABLE: "enable",
    RESET: "reset",
};
export const RouteServerPersistRoutesState = {
    DISABLED: "disabled",
    DISABLING: "disabling",
    ENABLED: "enabled",
    ENABLING: "enabling",
    MODIFYING: "modifying",
    RESETTING: "resetting",
};
export const RouteServerState = {
    AVAILABLE: "available",
    DELETED: "deleted",
    DELETING: "deleting",
    MODIFYING: "modifying",
    PENDING: "pending",
};
export const RouteServerEndpointState = {
    AVAILABLE: "available",
    DELETED: "deleted",
    DELETE_FAILED: "delete-failed",
    DELETING: "deleting",
    FAILED: "failed",
    FAILING: "failing",
    PENDING: "pending",
};
export const RouteServerPeerLivenessMode = {
    BFD: "bfd",
    BGP_KEEPALIVE: "bgp-keepalive",
};
export const RouteServerBfdState = {
    DOWN: "down",
    UP: "up",
};
export const RouteServerBgpState = {
    DOWN: "down",
    UP: "up",
};
export const RouteServerPeerState = {
    AVAILABLE: "available",
    DELETED: "deleted",
    DELETING: "deleting",
    FAILED: "failed",
    FAILING: "failing",
    PENDING: "pending",
};
export const RouteOrigin = {
    CreateRoute: "CreateRoute",
    CreateRouteTable: "CreateRouteTable",
    EnableVgwRoutePropagation: "EnableVgwRoutePropagation",
};
export const RouteState = {
    active: "active",
    blackhole: "blackhole",
};
export const SSEType = {
    none: "none",
    sse_ebs: "sse-ebs",
    sse_kms: "sse-kms",
};
export const SnapshotState = {
    completed: "completed",
    error: "error",
    pending: "pending",
    recoverable: "recoverable",
    recovering: "recovering",
};
export const StorageTier = {
    archive: "archive",
    standard: "standard",
};
export const TransferType = {
    standard: "standard",
    time_based: "time-based",
};
export const CopyTagsFromSource = {
    volume: "volume",
};
export const DatafeedSubscriptionState = {
    Active: "Active",
    Inactive: "Inactive",
};
export const SubnetCidrReservationType = {
    explicit: "explicit",
    prefix: "prefix",
};
export const TrafficMirrorRuleAction = {
    accept: "accept",
    reject: "reject",
};
export const TrafficDirection = {
    egress: "egress",
    ingress: "ingress",
};
export const TrafficMirrorNetworkService = {
    amazon_dns: "amazon-dns",
};
export const TrafficMirrorTargetType = {
    gateway_load_balancer_endpoint: "gateway-load-balancer-endpoint",
    network_interface: "network-interface",
    network_load_balancer: "network-load-balancer",
};
export const AutoAcceptSharedAttachmentsValue = {
    disable: "disable",
    enable: "enable",
};
export const DefaultRouteTableAssociationValue = {
    disable: "disable",
    enable: "enable",
};
export const DefaultRouteTablePropagationValue = {
    disable: "disable",
    enable: "enable",
};
export const MulticastSupportValue = {
    disable: "disable",
    enable: "enable",
};
export const VpnEcmpSupportValue = {
    disable: "disable",
    enable: "enable",
};
export const TransitGatewayState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    modifying: "modifying",
    pending: "pending",
};
export const ProtocolValue = {
    gre: "gre",
};
export const BgpStatus = {
    down: "down",
    up: "up",
};
export const TransitGatewayConnectPeerState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const AutoAcceptSharedAssociationsValue = {
    disable: "disable",
    enable: "enable",
};
export const Igmpv2SupportValue = {
    disable: "disable",
    enable: "enable",
};
export const StaticSourcesSupportValue = {
    disable: "disable",
    enable: "enable",
};
export const TransitGatewayMulticastDomainState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const TransitGatewayPolicyTableState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const TransitGatewayPrefixListReferenceState = {
    available: "available",
    deleting: "deleting",
    modifying: "modifying",
    pending: "pending",
};
export const TransitGatewayRouteState = {
    active: "active",
    blackhole: "blackhole",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const TransitGatewayRouteType = {
    propagated: "propagated",
    static: "static",
};
export const TransitGatewayRouteTableState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const TransitGatewayRouteTableAnnouncementDirection = {
    incoming: "incoming",
    outgoing: "outgoing",
};
export const TransitGatewayRouteTableAnnouncementState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    failed: "failed",
    failing: "failing",
    pending: "pending",
};
export const VerifiedAccessEndpointAttachmentType = {
    vpc: "vpc",
};
export const VerifiedAccessEndpointProtocol = {
    http: "http",
    https: "https",
    tcp: "tcp",
};
export const VerifiedAccessEndpointType = {
    cidr: "cidr",
    load_balancer: "load-balancer",
    network_interface: "network-interface",
    rds: "rds",
};
export const VerifiedAccessEndpointStatusCode = {
    active: "active",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
    updating: "updating",
};
export const VolumeState = {
    available: "available",
    creating: "creating",
    deleted: "deleted",
    deleting: "deleting",
    error: "error",
    in_use: "in-use",
};
export const InternetGatewayExclusionMode = {
    allow_bidirectional: "allow-bidirectional",
    allow_egress: "allow-egress",
};
export const VpcBlockPublicAccessExclusionState = {
    create_complete: "create-complete",
    create_failed: "create-failed",
    create_in_progress: "create-in-progress",
    delete_complete: "delete-complete",
    delete_in_progress: "delete-in-progress",
    disable_complete: "disable-complete",
    disable_in_progress: "disable-in-progress",
    update_complete: "update-complete",
    update_failed: "update-failed",
    update_in_progress: "update-in-progress",
};
export const DnsRecordIpType = {
    dualstack: "dualstack",
    ipv4: "ipv4",
    ipv6: "ipv6",
    service_defined: "service-defined",
};
export const IpAddressType = {
    dualstack: "dualstack",
    ipv4: "ipv4",
    ipv6: "ipv6",
};
export const VpcEndpointType = {
    Gateway: "Gateway",
    GatewayLoadBalancer: "GatewayLoadBalancer",
    Interface: "Interface",
    Resource: "Resource",
    ServiceNetwork: "ServiceNetwork",
};
export const State = {
    Available: "Available",
    Deleted: "Deleted",
    Deleting: "Deleting",
    Expired: "Expired",
    Failed: "Failed",
    Partial: "Partial",
    Pending: "Pending",
    PendingAcceptance: "PendingAcceptance",
    Rejected: "Rejected",
};
export const ResponseLaunchTemplateDataFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserData && { UserData: SENSITIVE_STRING }),
});
export const LaunchTemplateVersionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchTemplateData && {
        LaunchTemplateData: ResponseLaunchTemplateDataFilterSensitiveLog(obj.LaunchTemplateData),
    }),
});
export const CreateLaunchTemplateVersionResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchTemplateVersion && {
        LaunchTemplateVersion: LaunchTemplateVersionFilterSensitiveLog(obj.LaunchTemplateVersion),
    }),
});
export const CreateMacSystemIntegrityProtectionModificationTaskRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MacCredentials && { MacCredentials: SENSITIVE_STRING }),
});
export const CreateVerifiedAccessNativeApplicationOidcOptionsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ClientSecret && { ClientSecret: SENSITIVE_STRING }),
});
export const CreateVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ClientSecret && { ClientSecret: SENSITIVE_STRING }),
});
export const CreateVerifiedAccessTrustProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OidcOptions && {
        OidcOptions: CreateVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog(obj.OidcOptions),
    }),
    ...(obj.NativeApplicationOidcOptions && {
        NativeApplicationOidcOptions: CreateVerifiedAccessNativeApplicationOidcOptionsFilterSensitiveLog(obj.NativeApplicationOidcOptions),
    }),
});
export const CreateVerifiedAccessTrustProviderResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VerifiedAccessTrustProvider && {
        VerifiedAccessTrustProvider: VerifiedAccessTrustProviderFilterSensitiveLog(obj.VerifiedAccessTrustProvider),
    }),
});
