import { SENSITIVE_STRING } from "@smithy/smithy-client";
export const AcceleratorManufacturer = {
    AMAZON_WEB_SERVICES: "amazon-web-services",
    AMD: "amd",
    HABANA: "habana",
    NVIDIA: "nvidia",
    XILINX: "xilinx",
};
export const AcceleratorName = {
    A100: "a100",
    A10G: "a10g",
    H100: "h100",
    INFERENTIA: "inferentia",
    K520: "k520",
    K80: "k80",
    M60: "m60",
    RADEON_PRO_V520: "radeon-pro-v520",
    T4: "t4",
    T4G: "t4g",
    V100: "v100",
    VU9P: "vu9p",
};
export const AcceleratorType = {
    FPGA: "fpga",
    GPU: "gpu",
    INFERENCE: "inference",
};
export const ResourceType = {
    capacity_reservation: "capacity-reservation",
    capacity_reservation_fleet: "capacity-reservation-fleet",
    carrier_gateway: "carrier-gateway",
    client_vpn_endpoint: "client-vpn-endpoint",
    coip_pool: "coip-pool",
    customer_gateway: "customer-gateway",
    declarative_policies_report: "declarative-policies-report",
    dedicated_host: "dedicated-host",
    dhcp_options: "dhcp-options",
    egress_only_internet_gateway: "egress-only-internet-gateway",
    elastic_gpu: "elastic-gpu",
    elastic_ip: "elastic-ip",
    export_image_task: "export-image-task",
    export_instance_task: "export-instance-task",
    fleet: "fleet",
    fpga_image: "fpga-image",
    host_reservation: "host-reservation",
    image: "image",
    import_image_task: "import-image-task",
    import_snapshot_task: "import-snapshot-task",
    instance: "instance",
    instance_connect_endpoint: "instance-connect-endpoint",
    instance_event_window: "instance-event-window",
    internet_gateway: "internet-gateway",
    ipam: "ipam",
    ipam_external_resource_verification_token: "ipam-external-resource-verification-token",
    ipam_pool: "ipam-pool",
    ipam_resource_discovery: "ipam-resource-discovery",
    ipam_resource_discovery_association: "ipam-resource-discovery-association",
    ipam_scope: "ipam-scope",
    ipv4pool_ec2: "ipv4pool-ec2",
    ipv6pool_ec2: "ipv6pool-ec2",
    key_pair: "key-pair",
    launch_template: "launch-template",
    local_gateway: "local-gateway",
    local_gateway_route_table: "local-gateway-route-table",
    local_gateway_route_table_virtual_interface_group_association: "local-gateway-route-table-virtual-interface-group-association",
    local_gateway_route_table_vpc_association: "local-gateway-route-table-vpc-association",
    local_gateway_virtual_interface: "local-gateway-virtual-interface",
    local_gateway_virtual_interface_group: "local-gateway-virtual-interface-group",
    mac_modification_task: "mac-modification-task",
    natgateway: "natgateway",
    network_acl: "network-acl",
    network_insights_access_scope: "network-insights-access-scope",
    network_insights_access_scope_analysis: "network-insights-access-scope-analysis",
    network_insights_analysis: "network-insights-analysis",
    network_insights_path: "network-insights-path",
    network_interface: "network-interface",
    outpost_lag: "outpost-lag",
    placement_group: "placement-group",
    prefix_list: "prefix-list",
    replace_root_volume_task: "replace-root-volume-task",
    reserved_instances: "reserved-instances",
    route_server: "route-server",
    route_server_endpoint: "route-server-endpoint",
    route_server_peer: "route-server-peer",
    route_table: "route-table",
    security_group: "security-group",
    security_group_rule: "security-group-rule",
    service_link_virtual_interface: "service-link-virtual-interface",
    snapshot: "snapshot",
    spot_fleet_request: "spot-fleet-request",
    spot_instances_request: "spot-instances-request",
    subnet: "subnet",
    subnet_cidr_reservation: "subnet-cidr-reservation",
    traffic_mirror_filter: "traffic-mirror-filter",
    traffic_mirror_filter_rule: "traffic-mirror-filter-rule",
    traffic_mirror_session: "traffic-mirror-session",
    traffic_mirror_target: "traffic-mirror-target",
    transit_gateway: "transit-gateway",
    transit_gateway_attachment: "transit-gateway-attachment",
    transit_gateway_connect_peer: "transit-gateway-connect-peer",
    transit_gateway_multicast_domain: "transit-gateway-multicast-domain",
    transit_gateway_policy_table: "transit-gateway-policy-table",
    transit_gateway_route_table: "transit-gateway-route-table",
    transit_gateway_route_table_announcement: "transit-gateway-route-table-announcement",
    verified_access_endpoint: "verified-access-endpoint",
    verified_access_endpoint_target: "verified-access-endpoint-target",
    verified_access_group: "verified-access-group",
    verified_access_instance: "verified-access-instance",
    verified_access_policy: "verified-access-policy",
    verified_access_trust_provider: "verified-access-trust-provider",
    volume: "volume",
    vpc: "vpc",
    vpc_block_public_access_exclusion: "vpc-block-public-access-exclusion",
    vpc_endpoint: "vpc-endpoint",
    vpc_endpoint_connection: "vpc-endpoint-connection",
    vpc_endpoint_connection_device_type: "vpc-endpoint-connection-device-type",
    vpc_endpoint_service: "vpc-endpoint-service",
    vpc_endpoint_service_permission: "vpc-endpoint-service-permission",
    vpc_flow_log: "vpc-flow-log",
    vpc_peering_connection: "vpc-peering-connection",
    vpn_connection: "vpn-connection",
    vpn_connection_device_type: "vpn-connection-device-type",
    vpn_gateway: "vpn-gateway",
};
export const AddressTransferStatus = {
    accepted: "accepted",
    disabled: "disabled",
    pending: "pending",
};
export const TransitGatewayAttachmentResourceType = {
    connect: "connect",
    direct_connect_gateway: "direct-connect-gateway",
    peering: "peering",
    tgw_peering: "tgw-peering",
    vpc: "vpc",
    vpn: "vpn",
};
export const TransitGatewayMulitcastDomainAssociationState = {
    associated: "associated",
    associating: "associating",
    disassociated: "disassociated",
    disassociating: "disassociating",
    failed: "failed",
    pendingAcceptance: "pendingAcceptance",
    rejected: "rejected",
};
export const DynamicRoutingValue = {
    disable: "disable",
    enable: "enable",
};
export const TransitGatewayAttachmentState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    failed: "failed",
    failing: "failing",
    initiating: "initiating",
    initiatingRequest: "initiatingRequest",
    modifying: "modifying",
    pending: "pending",
    pendingAcceptance: "pendingAcceptance",
    rejected: "rejected",
    rejecting: "rejecting",
    rollingBack: "rollingBack",
};
export const ApplianceModeSupportValue = {
    disable: "disable",
    enable: "enable",
};
export const DnsSupportValue = {
    disable: "disable",
    enable: "enable",
};
export const Ipv6SupportValue = {
    disable: "disable",
    enable: "enable",
};
export const SecurityGroupReferencingSupportValue = {
    disable: "disable",
    enable: "enable",
};
export const VpcPeeringConnectionStateReasonCode = {
    active: "active",
    deleted: "deleted",
    deleting: "deleting",
    expired: "expired",
    failed: "failed",
    initiating_request: "initiating-request",
    pending_acceptance: "pending-acceptance",
    provisioning: "provisioning",
    rejected: "rejected",
};
export const Protocol = {
    tcp: "tcp",
    udp: "udp",
};
export const AccountAttributeName = {
    default_vpc: "default-vpc",
    supported_platforms: "supported-platforms",
};
export const InstanceHealthStatus = {
    HEALTHY_STATUS: "healthy",
    UNHEALTHY_STATUS: "unhealthy",
};
export const VpnTunnelProvisioningStatus = {
    available: "available",
    failed: "failed",
    pending: "pending",
};
export const ActivityStatus = {
    ERROR: "error",
    FULFILLED: "fulfilled",
    PENDING_FULFILLMENT: "pending_fulfillment",
    PENDING_TERMINATION: "pending_termination",
};
export const PrincipalType = {
    Account: "Account",
    All: "All",
    OrganizationUnit: "OrganizationUnit",
    Role: "Role",
    Service: "Service",
    User: "User",
};
export const DomainType = {
    standard: "standard",
    vpc: "vpc",
};
export const ServiceManaged = {
    alb: "alb",
    nlb: "nlb",
    rnat: "rnat",
};
export const AddressAttributeName = {
    domain_name: "domain-name",
};
export const AddressFamily = {
    ipv4: "ipv4",
    ipv6: "ipv6",
};
export const AsnAssociationState = {
    associated: "associated",
    disassociated: "disassociated",
    failed_association: "failed-association",
    failed_disassociation: "failed-disassociation",
    pending_association: "pending-association",
    pending_disassociation: "pending-disassociation",
};
export const ByoipCidrState = {
    advertised: "advertised",
    deprovisioned: "deprovisioned",
    failed_deprovision: "failed-deprovision",
    failed_provision: "failed-provision",
    pending_deprovision: "pending-deprovision",
    pending_provision: "pending-provision",
    provisioned: "provisioned",
    provisioned_not_publicly_advertisable: "provisioned-not-publicly-advertisable",
};
export const Affinity = {
    default: "default",
    host: "host",
};
export const AutoPlacement = {
    off: "off",
    on: "on",
};
export const HostMaintenance = {
    off: "off",
    on: "on",
};
export const HostRecovery = {
    off: "off",
    on: "on",
};
export const IpamPoolAllocationResourceType = {
    custom: "custom",
    ec2_public_ipv4_pool: "ec2-public-ipv4-pool",
    eip: "eip",
    ipam_pool: "ipam-pool",
    subnet: "subnet",
    vpc: "vpc",
};
export const AllocationState = {
    available: "available",
    pending: "pending",
    permanent_failure: "permanent-failure",
    released: "released",
    released_permanent_failure: "released-permanent-failure",
    under_assessment: "under-assessment",
};
export const AllocationStrategy = {
    CAPACITY_OPTIMIZED: "capacityOptimized",
    CAPACITY_OPTIMIZED_PRIORITIZED: "capacityOptimizedPrioritized",
    DIVERSIFIED: "diversified",
    LOWEST_PRICE: "lowestPrice",
    PRICE_CAPACITY_OPTIMIZED: "priceCapacityOptimized",
};
export const AllocationType = {
    future: "future",
    used: "used",
};
export const AllowedImagesSettingsDisabledState = {
    disabled: "disabled",
};
export const AllowedImagesSettingsEnabledState = {
    audit_mode: "audit-mode",
    enabled: "enabled",
};
export const AllowsMultipleInstanceTypes = {
    off: "off",
    on: "on",
};
export const NatGatewayAddressStatus = {
    ASSIGNING: "assigning",
    ASSOCIATING: "associating",
    DISASSOCIATING: "disassociating",
    FAILED: "failed",
    SUCCEEDED: "succeeded",
    UNASSIGNING: "unassigning",
};
export const AssociationStatusCode = {
    associated: "associated",
    associating: "associating",
    association_failed: "association-failed",
    disassociated: "disassociated",
    disassociating: "disassociating",
};
export const IamInstanceProfileAssociationState = {
    ASSOCIATED: "associated",
    ASSOCIATING: "associating",
    DISASSOCIATED: "disassociated",
    DISASSOCIATING: "disassociating",
};
export const InstanceEventWindowState = {
    active: "active",
    creating: "creating",
    deleted: "deleted",
    deleting: "deleting",
};
export const WeekDay = {
    friday: "friday",
    monday: "monday",
    saturday: "saturday",
    sunday: "sunday",
    thursday: "thursday",
    tuesday: "tuesday",
    wednesday: "wednesday",
};
export const IpamAssociatedResourceDiscoveryStatus = {
    ACTIVE: "active",
    NOT_FOUND: "not-found",
};
export const IpamResourceDiscoveryAssociationState = {
    ASSOCIATE_COMPLETE: "associate-complete",
    ASSOCIATE_FAILED: "associate-failed",
    ASSOCIATE_IN_PROGRESS: "associate-in-progress",
    DISASSOCIATE_COMPLETE: "disassociate-complete",
    DISASSOCIATE_FAILED: "disassociate-failed",
    DISASSOCIATE_IN_PROGRESS: "disassociate-in-progress",
    ISOLATE_COMPLETE: "isolate-complete",
    ISOLATE_IN_PROGRESS: "isolate-in-progress",
    RESTORE_IN_PROGRESS: "restore-in-progress",
};
export const RouteServerAssociationState = {
    ASSOCIATED: "associated",
    ASSOCIATING: "associating",
    DISASSOCIATING: "disassociating",
};
export const RouteTableAssociationStateCode = {
    associated: "associated",
    associating: "associating",
    disassociated: "disassociated",
    disassociating: "disassociating",
    failed: "failed",
};
export const SecurityGroupVpcAssociationState = {
    associated: "associated",
    associating: "associating",
    association_failed: "association-failed",
    disassociated: "disassociated",
    disassociating: "disassociating",
    disassociation_failed: "disassociation-failed",
};
export const IpSource = {
    amazon: "amazon",
    byoip: "byoip",
    none: "none",
};
export const Ipv6AddressAttribute = {
    private: "private",
    public: "public",
};
export const SubnetCidrBlockStateCode = {
    associated: "associated",
    associating: "associating",
    disassociated: "disassociated",
    disassociating: "disassociating",
    failed: "failed",
    failing: "failing",
};
export const TransitGatewayAssociationState = {
    associated: "associated",
    associating: "associating",
    disassociated: "disassociated",
    disassociating: "disassociating",
};
export const InterfaceProtocolType = {
    GRE: "GRE",
    VLAN: "VLAN",
};
export const VpcCidrBlockStateCode = {
    associated: "associated",
    associating: "associating",
    disassociated: "disassociated",
    disassociating: "disassociating",
    failed: "failed",
    failing: "failing",
};
export const DeviceTrustProviderType = {
    crowdstrike: "crowdstrike",
    jamf: "jamf",
    jumpcloud: "jumpcloud",
};
export const TrustProviderType = {
    device: "device",
    user: "user",
};
export const UserTrustProviderType = {
    iam_identity_center: "iam-identity-center",
    oidc: "oidc",
};
export const VolumeAttachmentState = {
    attached: "attached",
    attaching: "attaching",
    busy: "busy",
    detached: "detached",
    detaching: "detaching",
};
export const AttachmentStatus = {
    attached: "attached",
    attaching: "attaching",
    detached: "detached",
    detaching: "detaching",
};
export const ClientVpnAuthorizationRuleStatusCode = {
    active: "active",
    authorizing: "authorizing",
    failed: "failed",
    revoking: "revoking",
};
export const BundleTaskState = {
    bundling: "bundling",
    cancelling: "cancelling",
    complete: "complete",
    failed: "failed",
    pending: "pending",
    storing: "storing",
    waiting_for_shutdown: "waiting-for-shutdown",
};
export const CapacityReservationFleetState = {
    ACTIVE: "active",
    CANCELLED: "cancelled",
    CANCELLING: "cancelling",
    EXPIRED: "expired",
    EXPIRING: "expiring",
    FAILED: "failed",
    MODIFYING: "modifying",
    PARTIALLY_FULFILLED: "partially_fulfilled",
    SUBMITTED: "submitted",
};
export const ListingState = {
    available: "available",
    cancelled: "cancelled",
    pending: "pending",
    sold: "sold",
};
export const CurrencyCodeValues = {
    USD: "USD",
};
export const ListingStatus = {
    active: "active",
    cancelled: "cancelled",
    closed: "closed",
    pending: "pending",
};
export const BatchState = {
    ACTIVE: "active",
    CANCELLED: "cancelled",
    CANCELLED_RUNNING: "cancelled_running",
    CANCELLED_TERMINATING_INSTANCES: "cancelled_terminating",
    FAILED: "failed",
    MODIFYING: "modifying",
    SUBMITTED: "submitted",
};
export const CancelBatchErrorCode = {
    FLEET_REQUEST_ID_DOES_NOT_EXIST: "fleetRequestIdDoesNotExist",
    FLEET_REQUEST_ID_MALFORMED: "fleetRequestIdMalformed",
    FLEET_REQUEST_NOT_IN_CANCELLABLE_STATE: "fleetRequestNotInCancellableState",
    UNEXPECTED_ERROR: "unexpectedError",
};
export const CancelSpotInstanceRequestState = {
    active: "active",
    cancelled: "cancelled",
    closed: "closed",
    completed: "completed",
    open: "open",
};
export const OidcOptionsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ClientSecret && { ClientSecret: SENSITIVE_STRING }),
});
export const VerifiedAccessTrustProviderFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OidcOptions && { OidcOptions: OidcOptionsFilterSensitiveLog(obj.OidcOptions) }),
});
export const AttachVerifiedAccessTrustProviderResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VerifiedAccessTrustProvider && {
        VerifiedAccessTrustProvider: VerifiedAccessTrustProviderFilterSensitiveLog(obj.VerifiedAccessTrustProvider),
    }),
});
export const S3StorageFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UploadPolicySignature && { UploadPolicySignature: SENSITIVE_STRING }),
});
export const StorageFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.S3 && { S3: S3StorageFilterSensitiveLog(obj.S3) }),
});
export const BundleInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Storage && { Storage: StorageFilterSensitiveLog(obj.Storage) }),
});
export const BundleTaskFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Storage && { Storage: StorageFilterSensitiveLog(obj.Storage) }),
});
export const BundleInstanceResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.BundleTask && { BundleTask: BundleTaskFilterSensitiveLog(obj.BundleTask) }),
});
export const CancelBundleTaskResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.BundleTask && { BundleTask: BundleTaskFilterSensitiveLog(obj.BundleTask) }),
});
