import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CodeCommitServiceException as __BaseException } from "./CodeCommitServiceException";
import {
  ApprovalRule,
  ApprovalRuleTemplate,
  ApprovalState,
  Comment,
  Commit,
  ConflictDetailLevelTypeEnum,
  ConflictResolution,
  ConflictResolutionStrategyTypeEnum,
  FileModeTypeEnum,
  Location,
  OverrideStatus,
  PullRequest,
  PullRequestStatusEnum,
  RepositoryTrigger,
} from "./models_0";
export interface FileVersion {
  commit?: Commit | undefined;
  blobId?: string | undefined;
  path?: string | undefined;
  revisionChildren?: string[] | undefined;
}
export interface ListFileCommitHistoryResponse {
  revisionDag: FileVersion[] | undefined;
  nextToken?: string | undefined;
}
export declare class InvalidAuthorArnException extends __BaseException {
  readonly name: "InvalidAuthorArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidAuthorArnException, __BaseException>
  );
}
export declare class InvalidPullRequestStatusException extends __BaseException {
  readonly name: "InvalidPullRequestStatusException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidPullRequestStatusException,
      __BaseException
    >
  );
}
export interface ListPullRequestsInput {
  repositoryName: string | undefined;
  authorArn?: string | undefined;
  pullRequestStatus?: PullRequestStatusEnum | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ListPullRequestsOutput {
  pullRequestIds: string[] | undefined;
  nextToken?: string | undefined;
}
export declare class InvalidOrderException extends __BaseException {
  readonly name: "InvalidOrderException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidOrderException, __BaseException>
  );
}
export declare class InvalidSortByException extends __BaseException {
  readonly name: "InvalidSortByException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidSortByException, __BaseException>
  );
}
export declare const OrderEnum: {
  readonly ASCENDING: "ascending";
  readonly DESCENDING: "descending";
};
export type OrderEnum = (typeof OrderEnum)[keyof typeof OrderEnum];
export declare const SortByEnum: {
  readonly MODIFIED_DATE: "lastModifiedDate";
  readonly REPOSITORY_NAME: "repositoryName";
};
export type SortByEnum = (typeof SortByEnum)[keyof typeof SortByEnum];
export interface ListRepositoriesInput {
  nextToken?: string | undefined;
  sortBy?: SortByEnum | undefined;
  order?: OrderEnum | undefined;
}
export interface RepositoryNameIdPair {
  repositoryName?: string | undefined;
  repositoryId?: string | undefined;
}
export interface ListRepositoriesOutput {
  repositories?: RepositoryNameIdPair[] | undefined;
  nextToken?: string | undefined;
}
export interface ListRepositoriesForApprovalRuleTemplateInput {
  approvalRuleTemplateName: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ListRepositoriesForApprovalRuleTemplateOutput {
  repositoryNames?: string[] | undefined;
  nextToken?: string | undefined;
}
export declare class InvalidResourceArnException extends __BaseException {
  readonly name: "InvalidResourceArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidResourceArnException, __BaseException>
  );
}
export interface ListTagsForResourceInput {
  resourceArn: string | undefined;
  nextToken?: string | undefined;
}
export interface ListTagsForResourceOutput {
  tags?: Record<string, string> | undefined;
  nextToken?: string | undefined;
}
export declare class ResourceArnRequiredException extends __BaseException {
  readonly name: "ResourceArnRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceArnRequiredException, __BaseException>
  );
}
export declare class InvalidTargetBranchException extends __BaseException {
  readonly name: "InvalidTargetBranchException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTargetBranchException, __BaseException>
  );
}
export interface MergeBranchesByFastForwardInput {
  repositoryName: string | undefined;
  sourceCommitSpecifier: string | undefined;
  destinationCommitSpecifier: string | undefined;
  targetBranch?: string | undefined;
}
export interface MergeBranchesByFastForwardOutput {
  commitId?: string | undefined;
  treeId?: string | undefined;
}
export interface MergeBranchesBySquashInput {
  repositoryName: string | undefined;
  sourceCommitSpecifier: string | undefined;
  destinationCommitSpecifier: string | undefined;
  targetBranch?: string | undefined;
  conflictDetailLevel?: ConflictDetailLevelTypeEnum | undefined;
  conflictResolutionStrategy?: ConflictResolutionStrategyTypeEnum | undefined;
  authorName?: string | undefined;
  email?: string | undefined;
  commitMessage?: string | undefined;
  keepEmptyFolders?: boolean | undefined;
  conflictResolution?: ConflictResolution | undefined;
}
export interface MergeBranchesBySquashOutput {
  commitId?: string | undefined;
  treeId?: string | undefined;
}
export interface MergeBranchesByThreeWayInput {
  repositoryName: string | undefined;
  sourceCommitSpecifier: string | undefined;
  destinationCommitSpecifier: string | undefined;
  targetBranch?: string | undefined;
  conflictDetailLevel?: ConflictDetailLevelTypeEnum | undefined;
  conflictResolutionStrategy?: ConflictResolutionStrategyTypeEnum | undefined;
  authorName?: string | undefined;
  email?: string | undefined;
  commitMessage?: string | undefined;
  keepEmptyFolders?: boolean | undefined;
  conflictResolution?: ConflictResolution | undefined;
}
export interface MergeBranchesByThreeWayOutput {
  commitId?: string | undefined;
  treeId?: string | undefined;
}
export interface MergePullRequestByFastForwardInput {
  pullRequestId: string | undefined;
  repositoryName: string | undefined;
  sourceCommitId?: string | undefined;
}
export interface MergePullRequestByFastForwardOutput {
  pullRequest?: PullRequest | undefined;
}
export declare class PullRequestApprovalRulesNotSatisfiedException extends __BaseException {
  readonly name: "PullRequestApprovalRulesNotSatisfiedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PullRequestApprovalRulesNotSatisfiedException,
      __BaseException
    >
  );
}
export declare class TipOfSourceReferenceIsDifferentException extends __BaseException {
  readonly name: "TipOfSourceReferenceIsDifferentException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      TipOfSourceReferenceIsDifferentException,
      __BaseException
    >
  );
}
export interface MergePullRequestBySquashInput {
  pullRequestId: string | undefined;
  repositoryName: string | undefined;
  sourceCommitId?: string | undefined;
  conflictDetailLevel?: ConflictDetailLevelTypeEnum | undefined;
  conflictResolutionStrategy?: ConflictResolutionStrategyTypeEnum | undefined;
  commitMessage?: string | undefined;
  authorName?: string | undefined;
  email?: string | undefined;
  keepEmptyFolders?: boolean | undefined;
  conflictResolution?: ConflictResolution | undefined;
}
export interface MergePullRequestBySquashOutput {
  pullRequest?: PullRequest | undefined;
}
export interface MergePullRequestByThreeWayInput {
  pullRequestId: string | undefined;
  repositoryName: string | undefined;
  sourceCommitId?: string | undefined;
  conflictDetailLevel?: ConflictDetailLevelTypeEnum | undefined;
  conflictResolutionStrategy?: ConflictResolutionStrategyTypeEnum | undefined;
  commitMessage?: string | undefined;
  authorName?: string | undefined;
  email?: string | undefined;
  keepEmptyFolders?: boolean | undefined;
  conflictResolution?: ConflictResolution | undefined;
}
export interface MergePullRequestByThreeWayOutput {
  pullRequest?: PullRequest | undefined;
}
export declare class InvalidOverrideStatusException extends __BaseException {
  readonly name: "InvalidOverrideStatusException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidOverrideStatusException, __BaseException>
  );
}
export declare class OverrideAlreadySetException extends __BaseException {
  readonly name: "OverrideAlreadySetException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<OverrideAlreadySetException, __BaseException>
  );
}
export interface OverridePullRequestApprovalRulesInput {
  pullRequestId: string | undefined;
  revisionId: string | undefined;
  overrideStatus: OverrideStatus | undefined;
}
export declare class OverrideStatusRequiredException extends __BaseException {
  readonly name: "OverrideStatusRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      OverrideStatusRequiredException,
      __BaseException
    >
  );
}
export declare class CommentContentRequiredException extends __BaseException {
  readonly name: "CommentContentRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CommentContentRequiredException,
      __BaseException
    >
  );
}
export declare class CommentContentSizeLimitExceededException extends __BaseException {
  readonly name: "CommentContentSizeLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CommentContentSizeLimitExceededException,
      __BaseException
    >
  );
}
export declare class InvalidFileLocationException extends __BaseException {
  readonly name: "InvalidFileLocationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidFileLocationException, __BaseException>
  );
}
export declare class InvalidFilePositionException extends __BaseException {
  readonly name: "InvalidFilePositionException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidFilePositionException, __BaseException>
  );
}
export declare class InvalidRelativeFileVersionEnumException extends __BaseException {
  readonly name: "InvalidRelativeFileVersionEnumException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidRelativeFileVersionEnumException,
      __BaseException
    >
  );
}
export interface PostCommentForComparedCommitInput {
  repositoryName: string | undefined;
  beforeCommitId?: string | undefined;
  afterCommitId: string | undefined;
  location?: Location | undefined;
  content: string | undefined;
  clientRequestToken?: string | undefined;
}
export interface PostCommentForComparedCommitOutput {
  repositoryName?: string | undefined;
  beforeCommitId?: string | undefined;
  afterCommitId?: string | undefined;
  beforeBlobId?: string | undefined;
  afterBlobId?: string | undefined;
  location?: Location | undefined;
  comment?: Comment | undefined;
}
export interface PostCommentForPullRequestInput {
  pullRequestId: string | undefined;
  repositoryName: string | undefined;
  beforeCommitId: string | undefined;
  afterCommitId: string | undefined;
  location?: Location | undefined;
  content: string | undefined;
  clientRequestToken?: string | undefined;
}
export interface PostCommentForPullRequestOutput {
  repositoryName?: string | undefined;
  pullRequestId?: string | undefined;
  beforeCommitId?: string | undefined;
  afterCommitId?: string | undefined;
  beforeBlobId?: string | undefined;
  afterBlobId?: string | undefined;
  location?: Location | undefined;
  comment?: Comment | undefined;
}
export interface PostCommentReplyInput {
  inReplyTo: string | undefined;
  clientRequestToken?: string | undefined;
  content: string | undefined;
}
export interface PostCommentReplyOutput {
  comment?: Comment | undefined;
}
export declare class InvalidReactionValueException extends __BaseException {
  readonly name: "InvalidReactionValueException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidReactionValueException, __BaseException>
  );
}
export interface PutCommentReactionInput {
  commentId: string | undefined;
  reactionValue: string | undefined;
}
export declare class ReactionLimitExceededException extends __BaseException {
  readonly name: "ReactionLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ReactionLimitExceededException, __BaseException>
  );
}
export declare class ReactionValueRequiredException extends __BaseException {
  readonly name: "ReactionValueRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ReactionValueRequiredException, __BaseException>
  );
}
export declare class FileContentRequiredException extends __BaseException {
  readonly name: "FileContentRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<FileContentRequiredException, __BaseException>
  );
}
export interface PutFileInput {
  repositoryName: string | undefined;
  branchName: string | undefined;
  fileContent: Uint8Array | undefined;
  filePath: string | undefined;
  fileMode?: FileModeTypeEnum | undefined;
  parentCommitId?: string | undefined;
  commitMessage?: string | undefined;
  name?: string | undefined;
  email?: string | undefined;
}
export interface PutFileOutput {
  commitId: string | undefined;
  blobId: string | undefined;
  treeId: string | undefined;
}
export declare class SameFileContentException extends __BaseException {
  readonly name: "SameFileContentException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<SameFileContentException, __BaseException>
  );
}
export declare class InvalidRepositoryTriggerBranchNameException extends __BaseException {
  readonly name: "InvalidRepositoryTriggerBranchNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidRepositoryTriggerBranchNameException,
      __BaseException
    >
  );
}
export declare class InvalidRepositoryTriggerCustomDataException extends __BaseException {
  readonly name: "InvalidRepositoryTriggerCustomDataException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidRepositoryTriggerCustomDataException,
      __BaseException
    >
  );
}
export declare class InvalidRepositoryTriggerDestinationArnException extends __BaseException {
  readonly name: "InvalidRepositoryTriggerDestinationArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidRepositoryTriggerDestinationArnException,
      __BaseException
    >
  );
}
export declare class InvalidRepositoryTriggerEventsException extends __BaseException {
  readonly name: "InvalidRepositoryTriggerEventsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidRepositoryTriggerEventsException,
      __BaseException
    >
  );
}
export declare class InvalidRepositoryTriggerNameException extends __BaseException {
  readonly name: "InvalidRepositoryTriggerNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidRepositoryTriggerNameException,
      __BaseException
    >
  );
}
export declare class InvalidRepositoryTriggerRegionException extends __BaseException {
  readonly name: "InvalidRepositoryTriggerRegionException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidRepositoryTriggerRegionException,
      __BaseException
    >
  );
}
export declare class MaximumBranchesExceededException extends __BaseException {
  readonly name: "MaximumBranchesExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MaximumBranchesExceededException,
      __BaseException
    >
  );
}
export declare class MaximumRepositoryTriggersExceededException extends __BaseException {
  readonly name: "MaximumRepositoryTriggersExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MaximumRepositoryTriggersExceededException,
      __BaseException
    >
  );
}
export interface PutRepositoryTriggersInput {
  repositoryName: string | undefined;
  triggers: RepositoryTrigger[] | undefined;
}
export interface PutRepositoryTriggersOutput {
  configurationId?: string | undefined;
}
export declare class RepositoryTriggerBranchNameListRequiredException extends __BaseException {
  readonly name: "RepositoryTriggerBranchNameListRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryTriggerBranchNameListRequiredException,
      __BaseException
    >
  );
}
export declare class RepositoryTriggerDestinationArnRequiredException extends __BaseException {
  readonly name: "RepositoryTriggerDestinationArnRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryTriggerDestinationArnRequiredException,
      __BaseException
    >
  );
}
export declare class RepositoryTriggerEventsListRequiredException extends __BaseException {
  readonly name: "RepositoryTriggerEventsListRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryTriggerEventsListRequiredException,
      __BaseException
    >
  );
}
export declare class RepositoryTriggerNameRequiredException extends __BaseException {
  readonly name: "RepositoryTriggerNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryTriggerNameRequiredException,
      __BaseException
    >
  );
}
export declare class RepositoryTriggersListRequiredException extends __BaseException {
  readonly name: "RepositoryTriggersListRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryTriggersListRequiredException,
      __BaseException
    >
  );
}
export interface TagResourceInput {
  resourceArn: string | undefined;
  tags: Record<string, string> | undefined;
}
export declare class TagsMapRequiredException extends __BaseException {
  readonly name: "TagsMapRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TagsMapRequiredException, __BaseException>
  );
}
export interface TestRepositoryTriggersInput {
  repositoryName: string | undefined;
  triggers: RepositoryTrigger[] | undefined;
}
export interface RepositoryTriggerExecutionFailure {
  trigger?: string | undefined;
  failureMessage?: string | undefined;
}
export interface TestRepositoryTriggersOutput {
  successfulExecutions?: string[] | undefined;
  failedExecutions?: RepositoryTriggerExecutionFailure[] | undefined;
}
export declare class InvalidTagKeysListException extends __BaseException {
  readonly name: "InvalidTagKeysListException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTagKeysListException, __BaseException>
  );
}
export declare class TagKeysListRequiredException extends __BaseException {
  readonly name: "TagKeysListRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TagKeysListRequiredException, __BaseException>
  );
}
export interface UntagResourceInput {
  resourceArn: string | undefined;
  tagKeys: string[] | undefined;
}
export declare class InvalidRuleContentSha256Exception extends __BaseException {
  readonly name: "InvalidRuleContentSha256Exception";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidRuleContentSha256Exception,
      __BaseException
    >
  );
}
export interface UpdateApprovalRuleTemplateContentInput {
  approvalRuleTemplateName: string | undefined;
  newRuleContent: string | undefined;
  existingRuleContentSha256?: string | undefined;
}
export interface UpdateApprovalRuleTemplateContentOutput {
  approvalRuleTemplate: ApprovalRuleTemplate | undefined;
}
export interface UpdateApprovalRuleTemplateDescriptionInput {
  approvalRuleTemplateName: string | undefined;
  approvalRuleTemplateDescription: string | undefined;
}
export interface UpdateApprovalRuleTemplateDescriptionOutput {
  approvalRuleTemplate: ApprovalRuleTemplate | undefined;
}
export interface UpdateApprovalRuleTemplateNameInput {
  oldApprovalRuleTemplateName: string | undefined;
  newApprovalRuleTemplateName: string | undefined;
}
export interface UpdateApprovalRuleTemplateNameOutput {
  approvalRuleTemplate: ApprovalRuleTemplate | undefined;
}
export declare class CommentNotCreatedByCallerException extends __BaseException {
  readonly name: "CommentNotCreatedByCallerException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CommentNotCreatedByCallerException,
      __BaseException
    >
  );
}
export interface UpdateCommentInput {
  commentId: string | undefined;
  content: string | undefined;
}
export interface UpdateCommentOutput {
  comment?: Comment | undefined;
}
export interface UpdateDefaultBranchInput {
  repositoryName: string | undefined;
  defaultBranchName: string | undefined;
}
export interface UpdatePullRequestApprovalRuleContentInput {
  pullRequestId: string | undefined;
  approvalRuleName: string | undefined;
  existingRuleContentSha256?: string | undefined;
  newRuleContent: string | undefined;
}
export interface UpdatePullRequestApprovalRuleContentOutput {
  approvalRule: ApprovalRule | undefined;
}
export declare class InvalidApprovalStateException extends __BaseException {
  readonly name: "InvalidApprovalStateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidApprovalStateException, __BaseException>
  );
}
export declare class MaximumNumberOfApprovalsExceededException extends __BaseException {
  readonly name: "MaximumNumberOfApprovalsExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MaximumNumberOfApprovalsExceededException,
      __BaseException
    >
  );
}
export declare class PullRequestCannotBeApprovedByAuthorException extends __BaseException {
  readonly name: "PullRequestCannotBeApprovedByAuthorException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PullRequestCannotBeApprovedByAuthorException,
      __BaseException
    >
  );
}
export interface UpdatePullRequestApprovalStateInput {
  pullRequestId: string | undefined;
  revisionId: string | undefined;
  approvalState: ApprovalState | undefined;
}
export interface UpdatePullRequestDescriptionInput {
  pullRequestId: string | undefined;
  description: string | undefined;
}
export interface UpdatePullRequestDescriptionOutput {
  pullRequest: PullRequest | undefined;
}
export declare class InvalidPullRequestStatusUpdateException extends __BaseException {
  readonly name: "InvalidPullRequestStatusUpdateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidPullRequestStatusUpdateException,
      __BaseException
    >
  );
}
export declare class PullRequestStatusRequiredException extends __BaseException {
  readonly name: "PullRequestStatusRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PullRequestStatusRequiredException,
      __BaseException
    >
  );
}
export interface UpdatePullRequestStatusInput {
  pullRequestId: string | undefined;
  pullRequestStatus: PullRequestStatusEnum | undefined;
}
export interface UpdatePullRequestStatusOutput {
  pullRequest: PullRequest | undefined;
}
export interface UpdatePullRequestTitleInput {
  pullRequestId: string | undefined;
  title: string | undefined;
}
export interface UpdatePullRequestTitleOutput {
  pullRequest: PullRequest | undefined;
}
export interface UpdateRepositoryDescriptionInput {
  repositoryName: string | undefined;
  repositoryDescription?: string | undefined;
}
export declare class EncryptionKeyRequiredException extends __BaseException {
  readonly name: "EncryptionKeyRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<EncryptionKeyRequiredException, __BaseException>
  );
}
export interface UpdateRepositoryEncryptionKeyInput {
  repositoryName: string | undefined;
  kmsKeyId: string | undefined;
}
export interface UpdateRepositoryEncryptionKeyOutput {
  repositoryId?: string | undefined;
  kmsKeyId?: string | undefined;
  originalKmsKeyId?: string | undefined;
}
export interface UpdateRepositoryNameInput {
  oldName: string | undefined;
  newName: string | undefined;
}
