import {
  AwsSdkSigV4AuthInputConfig,
  AwsSdkSigV4AuthResolvedConfig,
  AwsSdkSigV4PreviouslyResolved,
} from "@aws-sdk/core";
import {
  HandlerExecutionContext,
  HttpAuthScheme,
  HttpAuthSchemeParameters,
  HttpAuthSchemeParametersProvider,
  HttpAuthSchemeProvider,
  Provider,
} from "@smithy/types";
import { CodeCommitClientResolvedConfig } from "../CodeCommitClient";
export interface CodeCommitHttpAuthSchemeParameters
  extends HttpAuthSchemeParameters {
  region?: string;
}
export interface CodeCommitHttpAuthSchemeParametersProvider
  extends HttpAuthSchemeParametersProvider<
    CodeCommitClientResolvedConfig,
    HandlerExecutionContext,
    CodeCommitHttpAuthSchemeParameters,
    object
  > {}
export declare const defaultCodeCommitHttpAuthSchemeParametersProvider: (
  config: CodeCommitClientResolvedConfig,
  context: HandlerExecutionContext,
  input: object
) => Promise<CodeCommitHttpAuthSchemeParameters>;
export interface CodeCommitHttpAuthSchemeProvider
  extends HttpAuthSchemeProvider<CodeCommitHttpAuthSchemeParameters> {}
export declare const defaultCodeCommitHttpAuthSchemeProvider: CodeCommitHttpAuthSchemeProvider;
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
  authSchemePreference?: string[] | Provider<string[]>;
  httpAuthSchemes?: HttpAuthScheme[];
  httpAuthSchemeProvider?: CodeCommitHttpAuthSchemeProvider;
}
export interface HttpAuthSchemeResolvedConfig
  extends AwsSdkSigV4AuthResolvedConfig {
  readonly authSchemePreference: Provider<string[]>;
  readonly httpAuthSchemes: HttpAuthScheme[];
  readonly httpAuthSchemeProvider: CodeCommitHttpAuthSchemeProvider;
}
export declare const resolveHttpAuthSchemeConfig: <T>(
  config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved
) => T & HttpAuthSchemeResolvedConfig;
