import {
  HostHeaderInputConfig,
  HostHeaderResolvedConfig,
} from "@aws-sdk/middleware-host-header";
import {
  UserAgentInputConfig,
  UserAgentResolvedConfig,
} from "@aws-sdk/middleware-user-agent";
import {
  RegionInputConfig,
  RegionResolvedConfig,
} from "@smithy/config-resolver";
import {
  EndpointInputConfig,
  EndpointResolvedConfig,
} from "@smithy/middleware-endpoint";
import {
  RetryInputConfig,
  RetryResolvedConfig,
} from "@smithy/middleware-retry";
import { HttpHandlerUserInput as __HttpHandlerUserInput } from "@smithy/protocol-http";
import {
  Client as __Client,
  DefaultsMode as __DefaultsMode,
  SmithyConfiguration as __SmithyConfiguration,
  SmithyResolvedConfiguration as __SmithyResolvedConfiguration,
} from "@smithy/smithy-client";
import {
  AwsCredentialIdentityProvider,
  BodyLengthCalculator as __BodyLengthCalculator,
  CheckOptionalClientConfig as __CheckOptionalClientConfig,
  ChecksumConstructor as __ChecksumConstructor,
  Decoder as __Decoder,
  Encoder as __Encoder,
  HashConstructor as __HashConstructor,
  HttpHandlerOptions as __HttpHandlerOptions,
  Logger as __Logger,
  Provider as __Provider,
  Provider,
  StreamCollector as __StreamCollector,
  UrlParser as __UrlParser,
  UserAgent as __UserAgent,
} from "@smithy/types";
import {
  HttpAuthSchemeInputConfig,
  HttpAuthSchemeResolvedConfig,
} from "./auth/httpAuthSchemeProvider";
import {
  AssociateApprovalRuleTemplateWithRepositoryCommandInput,
  AssociateApprovalRuleTemplateWithRepositoryCommandOutput,
} from "./commands/AssociateApprovalRuleTemplateWithRepositoryCommand";
import {
  BatchAssociateApprovalRuleTemplateWithRepositoriesCommandInput,
  BatchAssociateApprovalRuleTemplateWithRepositoriesCommandOutput,
} from "./commands/BatchAssociateApprovalRuleTemplateWithRepositoriesCommand";
import {
  BatchDescribeMergeConflictsCommandInput,
  BatchDescribeMergeConflictsCommandOutput,
} from "./commands/BatchDescribeMergeConflictsCommand";
import {
  BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandInput,
  BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandOutput,
} from "./commands/BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand";
import {
  BatchGetCommitsCommandInput,
  BatchGetCommitsCommandOutput,
} from "./commands/BatchGetCommitsCommand";
import {
  BatchGetRepositoriesCommandInput,
  BatchGetRepositoriesCommandOutput,
} from "./commands/BatchGetRepositoriesCommand";
import {
  CreateApprovalRuleTemplateCommandInput,
  CreateApprovalRuleTemplateCommandOutput,
} from "./commands/CreateApprovalRuleTemplateCommand";
import {
  CreateBranchCommandInput,
  CreateBranchCommandOutput,
} from "./commands/CreateBranchCommand";
import {
  CreateCommitCommandInput,
  CreateCommitCommandOutput,
} from "./commands/CreateCommitCommand";
import {
  CreatePullRequestApprovalRuleCommandInput,
  CreatePullRequestApprovalRuleCommandOutput,
} from "./commands/CreatePullRequestApprovalRuleCommand";
import {
  CreatePullRequestCommandInput,
  CreatePullRequestCommandOutput,
} from "./commands/CreatePullRequestCommand";
import {
  CreateRepositoryCommandInput,
  CreateRepositoryCommandOutput,
} from "./commands/CreateRepositoryCommand";
import {
  CreateUnreferencedMergeCommitCommandInput,
  CreateUnreferencedMergeCommitCommandOutput,
} from "./commands/CreateUnreferencedMergeCommitCommand";
import {
  DeleteApprovalRuleTemplateCommandInput,
  DeleteApprovalRuleTemplateCommandOutput,
} from "./commands/DeleteApprovalRuleTemplateCommand";
import {
  DeleteBranchCommandInput,
  DeleteBranchCommandOutput,
} from "./commands/DeleteBranchCommand";
import {
  DeleteCommentContentCommandInput,
  DeleteCommentContentCommandOutput,
} from "./commands/DeleteCommentContentCommand";
import {
  DeleteFileCommandInput,
  DeleteFileCommandOutput,
} from "./commands/DeleteFileCommand";
import {
  DeletePullRequestApprovalRuleCommandInput,
  DeletePullRequestApprovalRuleCommandOutput,
} from "./commands/DeletePullRequestApprovalRuleCommand";
import {
  DeleteRepositoryCommandInput,
  DeleteRepositoryCommandOutput,
} from "./commands/DeleteRepositoryCommand";
import {
  DescribeMergeConflictsCommandInput,
  DescribeMergeConflictsCommandOutput,
} from "./commands/DescribeMergeConflictsCommand";
import {
  DescribePullRequestEventsCommandInput,
  DescribePullRequestEventsCommandOutput,
} from "./commands/DescribePullRequestEventsCommand";
import {
  DisassociateApprovalRuleTemplateFromRepositoryCommandInput,
  DisassociateApprovalRuleTemplateFromRepositoryCommandOutput,
} from "./commands/DisassociateApprovalRuleTemplateFromRepositoryCommand";
import {
  EvaluatePullRequestApprovalRulesCommandInput,
  EvaluatePullRequestApprovalRulesCommandOutput,
} from "./commands/EvaluatePullRequestApprovalRulesCommand";
import {
  GetApprovalRuleTemplateCommandInput,
  GetApprovalRuleTemplateCommandOutput,
} from "./commands/GetApprovalRuleTemplateCommand";
import {
  GetBlobCommandInput,
  GetBlobCommandOutput,
} from "./commands/GetBlobCommand";
import {
  GetBranchCommandInput,
  GetBranchCommandOutput,
} from "./commands/GetBranchCommand";
import {
  GetCommentCommandInput,
  GetCommentCommandOutput,
} from "./commands/GetCommentCommand";
import {
  GetCommentReactionsCommandInput,
  GetCommentReactionsCommandOutput,
} from "./commands/GetCommentReactionsCommand";
import {
  GetCommentsForComparedCommitCommandInput,
  GetCommentsForComparedCommitCommandOutput,
} from "./commands/GetCommentsForComparedCommitCommand";
import {
  GetCommentsForPullRequestCommandInput,
  GetCommentsForPullRequestCommandOutput,
} from "./commands/GetCommentsForPullRequestCommand";
import {
  GetCommitCommandInput,
  GetCommitCommandOutput,
} from "./commands/GetCommitCommand";
import {
  GetDifferencesCommandInput,
  GetDifferencesCommandOutput,
} from "./commands/GetDifferencesCommand";
import {
  GetFileCommandInput,
  GetFileCommandOutput,
} from "./commands/GetFileCommand";
import {
  GetFolderCommandInput,
  GetFolderCommandOutput,
} from "./commands/GetFolderCommand";
import {
  GetMergeCommitCommandInput,
  GetMergeCommitCommandOutput,
} from "./commands/GetMergeCommitCommand";
import {
  GetMergeConflictsCommandInput,
  GetMergeConflictsCommandOutput,
} from "./commands/GetMergeConflictsCommand";
import {
  GetMergeOptionsCommandInput,
  GetMergeOptionsCommandOutput,
} from "./commands/GetMergeOptionsCommand";
import {
  GetPullRequestApprovalStatesCommandInput,
  GetPullRequestApprovalStatesCommandOutput,
} from "./commands/GetPullRequestApprovalStatesCommand";
import {
  GetPullRequestCommandInput,
  GetPullRequestCommandOutput,
} from "./commands/GetPullRequestCommand";
import {
  GetPullRequestOverrideStateCommandInput,
  GetPullRequestOverrideStateCommandOutput,
} from "./commands/GetPullRequestOverrideStateCommand";
import {
  GetRepositoryCommandInput,
  GetRepositoryCommandOutput,
} from "./commands/GetRepositoryCommand";
import {
  GetRepositoryTriggersCommandInput,
  GetRepositoryTriggersCommandOutput,
} from "./commands/GetRepositoryTriggersCommand";
import {
  ListApprovalRuleTemplatesCommandInput,
  ListApprovalRuleTemplatesCommandOutput,
} from "./commands/ListApprovalRuleTemplatesCommand";
import {
  ListAssociatedApprovalRuleTemplatesForRepositoryCommandInput,
  ListAssociatedApprovalRuleTemplatesForRepositoryCommandOutput,
} from "./commands/ListAssociatedApprovalRuleTemplatesForRepositoryCommand";
import {
  ListBranchesCommandInput,
  ListBranchesCommandOutput,
} from "./commands/ListBranchesCommand";
import {
  ListFileCommitHistoryCommandInput,
  ListFileCommitHistoryCommandOutput,
} from "./commands/ListFileCommitHistoryCommand";
import {
  ListPullRequestsCommandInput,
  ListPullRequestsCommandOutput,
} from "./commands/ListPullRequestsCommand";
import {
  ListRepositoriesCommandInput,
  ListRepositoriesCommandOutput,
} from "./commands/ListRepositoriesCommand";
import {
  ListRepositoriesForApprovalRuleTemplateCommandInput,
  ListRepositoriesForApprovalRuleTemplateCommandOutput,
} from "./commands/ListRepositoriesForApprovalRuleTemplateCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  MergeBranchesByFastForwardCommandInput,
  MergeBranchesByFastForwardCommandOutput,
} from "./commands/MergeBranchesByFastForwardCommand";
import {
  MergeBranchesBySquashCommandInput,
  MergeBranchesBySquashCommandOutput,
} from "./commands/MergeBranchesBySquashCommand";
import {
  MergeBranchesByThreeWayCommandInput,
  MergeBranchesByThreeWayCommandOutput,
} from "./commands/MergeBranchesByThreeWayCommand";
import {
  MergePullRequestByFastForwardCommandInput,
  MergePullRequestByFastForwardCommandOutput,
} from "./commands/MergePullRequestByFastForwardCommand";
import {
  MergePullRequestBySquashCommandInput,
  MergePullRequestBySquashCommandOutput,
} from "./commands/MergePullRequestBySquashCommand";
import {
  MergePullRequestByThreeWayCommandInput,
  MergePullRequestByThreeWayCommandOutput,
} from "./commands/MergePullRequestByThreeWayCommand";
import {
  OverridePullRequestApprovalRulesCommandInput,
  OverridePullRequestApprovalRulesCommandOutput,
} from "./commands/OverridePullRequestApprovalRulesCommand";
import {
  PostCommentForComparedCommitCommandInput,
  PostCommentForComparedCommitCommandOutput,
} from "./commands/PostCommentForComparedCommitCommand";
import {
  PostCommentForPullRequestCommandInput,
  PostCommentForPullRequestCommandOutput,
} from "./commands/PostCommentForPullRequestCommand";
import {
  PostCommentReplyCommandInput,
  PostCommentReplyCommandOutput,
} from "./commands/PostCommentReplyCommand";
import {
  PutCommentReactionCommandInput,
  PutCommentReactionCommandOutput,
} from "./commands/PutCommentReactionCommand";
import {
  PutFileCommandInput,
  PutFileCommandOutput,
} from "./commands/PutFileCommand";
import {
  PutRepositoryTriggersCommandInput,
  PutRepositoryTriggersCommandOutput,
} from "./commands/PutRepositoryTriggersCommand";
import {
  TagResourceCommandInput,
  TagResourceCommandOutput,
} from "./commands/TagResourceCommand";
import {
  TestRepositoryTriggersCommandInput,
  TestRepositoryTriggersCommandOutput,
} from "./commands/TestRepositoryTriggersCommand";
import {
  UntagResourceCommandInput,
  UntagResourceCommandOutput,
} from "./commands/UntagResourceCommand";
import {
  UpdateApprovalRuleTemplateContentCommandInput,
  UpdateApprovalRuleTemplateContentCommandOutput,
} from "./commands/UpdateApprovalRuleTemplateContentCommand";
import {
  UpdateApprovalRuleTemplateDescriptionCommandInput,
  UpdateApprovalRuleTemplateDescriptionCommandOutput,
} from "./commands/UpdateApprovalRuleTemplateDescriptionCommand";
import {
  UpdateApprovalRuleTemplateNameCommandInput,
  UpdateApprovalRuleTemplateNameCommandOutput,
} from "./commands/UpdateApprovalRuleTemplateNameCommand";
import {
  UpdateCommentCommandInput,
  UpdateCommentCommandOutput,
} from "./commands/UpdateCommentCommand";
import {
  UpdateDefaultBranchCommandInput,
  UpdateDefaultBranchCommandOutput,
} from "./commands/UpdateDefaultBranchCommand";
import {
  UpdatePullRequestApprovalRuleContentCommandInput,
  UpdatePullRequestApprovalRuleContentCommandOutput,
} from "./commands/UpdatePullRequestApprovalRuleContentCommand";
import {
  UpdatePullRequestApprovalStateCommandInput,
  UpdatePullRequestApprovalStateCommandOutput,
} from "./commands/UpdatePullRequestApprovalStateCommand";
import {
  UpdatePullRequestDescriptionCommandInput,
  UpdatePullRequestDescriptionCommandOutput,
} from "./commands/UpdatePullRequestDescriptionCommand";
import {
  UpdatePullRequestStatusCommandInput,
  UpdatePullRequestStatusCommandOutput,
} from "./commands/UpdatePullRequestStatusCommand";
import {
  UpdatePullRequestTitleCommandInput,
  UpdatePullRequestTitleCommandOutput,
} from "./commands/UpdatePullRequestTitleCommand";
import {
  UpdateRepositoryDescriptionCommandInput,
  UpdateRepositoryDescriptionCommandOutput,
} from "./commands/UpdateRepositoryDescriptionCommand";
import {
  UpdateRepositoryEncryptionKeyCommandInput,
  UpdateRepositoryEncryptionKeyCommandOutput,
} from "./commands/UpdateRepositoryEncryptionKeyCommand";
import {
  UpdateRepositoryNameCommandInput,
  UpdateRepositoryNameCommandOutput,
} from "./commands/UpdateRepositoryNameCommand";
import {
  ClientInputEndpointParameters,
  ClientResolvedEndpointParameters,
  EndpointParameters,
} from "./endpoint/EndpointParameters";
import { RuntimeExtension, RuntimeExtensionsConfig } from "./runtimeExtensions";
export { __Client };
export type ServiceInputTypes =
  | AssociateApprovalRuleTemplateWithRepositoryCommandInput
  | BatchAssociateApprovalRuleTemplateWithRepositoriesCommandInput
  | BatchDescribeMergeConflictsCommandInput
  | BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandInput
  | BatchGetCommitsCommandInput
  | BatchGetRepositoriesCommandInput
  | CreateApprovalRuleTemplateCommandInput
  | CreateBranchCommandInput
  | CreateCommitCommandInput
  | CreatePullRequestApprovalRuleCommandInput
  | CreatePullRequestCommandInput
  | CreateRepositoryCommandInput
  | CreateUnreferencedMergeCommitCommandInput
  | DeleteApprovalRuleTemplateCommandInput
  | DeleteBranchCommandInput
  | DeleteCommentContentCommandInput
  | DeleteFileCommandInput
  | DeletePullRequestApprovalRuleCommandInput
  | DeleteRepositoryCommandInput
  | DescribeMergeConflictsCommandInput
  | DescribePullRequestEventsCommandInput
  | DisassociateApprovalRuleTemplateFromRepositoryCommandInput
  | EvaluatePullRequestApprovalRulesCommandInput
  | GetApprovalRuleTemplateCommandInput
  | GetBlobCommandInput
  | GetBranchCommandInput
  | GetCommentCommandInput
  | GetCommentReactionsCommandInput
  | GetCommentsForComparedCommitCommandInput
  | GetCommentsForPullRequestCommandInput
  | GetCommitCommandInput
  | GetDifferencesCommandInput
  | GetFileCommandInput
  | GetFolderCommandInput
  | GetMergeCommitCommandInput
  | GetMergeConflictsCommandInput
  | GetMergeOptionsCommandInput
  | GetPullRequestApprovalStatesCommandInput
  | GetPullRequestCommandInput
  | GetPullRequestOverrideStateCommandInput
  | GetRepositoryCommandInput
  | GetRepositoryTriggersCommandInput
  | ListApprovalRuleTemplatesCommandInput
  | ListAssociatedApprovalRuleTemplatesForRepositoryCommandInput
  | ListBranchesCommandInput
  | ListFileCommitHistoryCommandInput
  | ListPullRequestsCommandInput
  | ListRepositoriesCommandInput
  | ListRepositoriesForApprovalRuleTemplateCommandInput
  | ListTagsForResourceCommandInput
  | MergeBranchesByFastForwardCommandInput
  | MergeBranchesBySquashCommandInput
  | MergeBranchesByThreeWayCommandInput
  | MergePullRequestByFastForwardCommandInput
  | MergePullRequestBySquashCommandInput
  | MergePullRequestByThreeWayCommandInput
  | OverridePullRequestApprovalRulesCommandInput
  | PostCommentForComparedCommitCommandInput
  | PostCommentForPullRequestCommandInput
  | PostCommentReplyCommandInput
  | PutCommentReactionCommandInput
  | PutFileCommandInput
  | PutRepositoryTriggersCommandInput
  | TagResourceCommandInput
  | TestRepositoryTriggersCommandInput
  | UntagResourceCommandInput
  | UpdateApprovalRuleTemplateContentCommandInput
  | UpdateApprovalRuleTemplateDescriptionCommandInput
  | UpdateApprovalRuleTemplateNameCommandInput
  | UpdateCommentCommandInput
  | UpdateDefaultBranchCommandInput
  | UpdatePullRequestApprovalRuleContentCommandInput
  | UpdatePullRequestApprovalStateCommandInput
  | UpdatePullRequestDescriptionCommandInput
  | UpdatePullRequestStatusCommandInput
  | UpdatePullRequestTitleCommandInput
  | UpdateRepositoryDescriptionCommandInput
  | UpdateRepositoryEncryptionKeyCommandInput
  | UpdateRepositoryNameCommandInput;
export type ServiceOutputTypes =
  | AssociateApprovalRuleTemplateWithRepositoryCommandOutput
  | BatchAssociateApprovalRuleTemplateWithRepositoriesCommandOutput
  | BatchDescribeMergeConflictsCommandOutput
  | BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandOutput
  | BatchGetCommitsCommandOutput
  | BatchGetRepositoriesCommandOutput
  | CreateApprovalRuleTemplateCommandOutput
  | CreateBranchCommandOutput
  | CreateCommitCommandOutput
  | CreatePullRequestApprovalRuleCommandOutput
  | CreatePullRequestCommandOutput
  | CreateRepositoryCommandOutput
  | CreateUnreferencedMergeCommitCommandOutput
  | DeleteApprovalRuleTemplateCommandOutput
  | DeleteBranchCommandOutput
  | DeleteCommentContentCommandOutput
  | DeleteFileCommandOutput
  | DeletePullRequestApprovalRuleCommandOutput
  | DeleteRepositoryCommandOutput
  | DescribeMergeConflictsCommandOutput
  | DescribePullRequestEventsCommandOutput
  | DisassociateApprovalRuleTemplateFromRepositoryCommandOutput
  | EvaluatePullRequestApprovalRulesCommandOutput
  | GetApprovalRuleTemplateCommandOutput
  | GetBlobCommandOutput
  | GetBranchCommandOutput
  | GetCommentCommandOutput
  | GetCommentReactionsCommandOutput
  | GetCommentsForComparedCommitCommandOutput
  | GetCommentsForPullRequestCommandOutput
  | GetCommitCommandOutput
  | GetDifferencesCommandOutput
  | GetFileCommandOutput
  | GetFolderCommandOutput
  | GetMergeCommitCommandOutput
  | GetMergeConflictsCommandOutput
  | GetMergeOptionsCommandOutput
  | GetPullRequestApprovalStatesCommandOutput
  | GetPullRequestCommandOutput
  | GetPullRequestOverrideStateCommandOutput
  | GetRepositoryCommandOutput
  | GetRepositoryTriggersCommandOutput
  | ListApprovalRuleTemplatesCommandOutput
  | ListAssociatedApprovalRuleTemplatesForRepositoryCommandOutput
  | ListBranchesCommandOutput
  | ListFileCommitHistoryCommandOutput
  | ListPullRequestsCommandOutput
  | ListRepositoriesCommandOutput
  | ListRepositoriesForApprovalRuleTemplateCommandOutput
  | ListTagsForResourceCommandOutput
  | MergeBranchesByFastForwardCommandOutput
  | MergeBranchesBySquashCommandOutput
  | MergeBranchesByThreeWayCommandOutput
  | MergePullRequestByFastForwardCommandOutput
  | MergePullRequestBySquashCommandOutput
  | MergePullRequestByThreeWayCommandOutput
  | OverridePullRequestApprovalRulesCommandOutput
  | PostCommentForComparedCommitCommandOutput
  | PostCommentForPullRequestCommandOutput
  | PostCommentReplyCommandOutput
  | PutCommentReactionCommandOutput
  | PutFileCommandOutput
  | PutRepositoryTriggersCommandOutput
  | TagResourceCommandOutput
  | TestRepositoryTriggersCommandOutput
  | UntagResourceCommandOutput
  | UpdateApprovalRuleTemplateContentCommandOutput
  | UpdateApprovalRuleTemplateDescriptionCommandOutput
  | UpdateApprovalRuleTemplateNameCommandOutput
  | UpdateCommentCommandOutput
  | UpdateDefaultBranchCommandOutput
  | UpdatePullRequestApprovalRuleContentCommandOutput
  | UpdatePullRequestApprovalStateCommandOutput
  | UpdatePullRequestDescriptionCommandOutput
  | UpdatePullRequestStatusCommandOutput
  | UpdatePullRequestTitleCommandOutput
  | UpdateRepositoryDescriptionCommandOutput
  | UpdateRepositoryEncryptionKeyCommandOutput
  | UpdateRepositoryNameCommandOutput;
export interface ClientDefaults
  extends Partial<__SmithyConfiguration<__HttpHandlerOptions>> {
  requestHandler?: __HttpHandlerUserInput;
  sha256?: __ChecksumConstructor | __HashConstructor;
  urlParser?: __UrlParser;
  bodyLengthChecker?: __BodyLengthCalculator;
  streamCollector?: __StreamCollector;
  base64Decoder?: __Decoder;
  base64Encoder?: __Encoder;
  utf8Decoder?: __Decoder;
  utf8Encoder?: __Encoder;
  runtime?: string;
  disableHostPrefix?: boolean;
  serviceId?: string;
  useDualstackEndpoint?: boolean | __Provider<boolean>;
  useFipsEndpoint?: boolean | __Provider<boolean>;
  region?: string | __Provider<string>;
  profile?: string;
  defaultUserAgentProvider?: Provider<__UserAgent>;
  credentialDefaultProvider?: (input: any) => AwsCredentialIdentityProvider;
  maxAttempts?: number | __Provider<number>;
  retryMode?: string | __Provider<string>;
  logger?: __Logger;
  extensions?: RuntimeExtension[];
  defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
export type CodeCommitClientConfigType = Partial<
  __SmithyConfiguration<__HttpHandlerOptions>
> &
  ClientDefaults &
  UserAgentInputConfig &
  RetryInputConfig &
  RegionInputConfig &
  HostHeaderInputConfig &
  EndpointInputConfig<EndpointParameters> &
  HttpAuthSchemeInputConfig &
  ClientInputEndpointParameters;
export interface CodeCommitClientConfig extends CodeCommitClientConfigType {}
export type CodeCommitClientResolvedConfigType =
  __SmithyResolvedConfiguration<__HttpHandlerOptions> &
    Required<ClientDefaults> &
    RuntimeExtensionsConfig &
    UserAgentResolvedConfig &
    RetryResolvedConfig &
    RegionResolvedConfig &
    HostHeaderResolvedConfig &
    EndpointResolvedConfig<EndpointParameters> &
    HttpAuthSchemeResolvedConfig &
    ClientResolvedEndpointParameters;
export interface CodeCommitClientResolvedConfig
  extends CodeCommitClientResolvedConfigType {}
export declare class CodeCommitClient extends __Client<
  __HttpHandlerOptions,
  ServiceInputTypes,
  ServiceOutputTypes,
  CodeCommitClientResolvedConfig
> {
  readonly config: CodeCommitClientResolvedConfig;
  constructor(
    ...[configuration]: __CheckOptionalClientConfig<CodeCommitClientConfig>
  );
  destroy(): void;
}
