import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CodeCommitClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CodeCommitClient";
import { PutCommentReactionInput } from "../models/models_1";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link PutCommentReactionCommand}.
 */
export interface PutCommentReactionCommandInput extends PutCommentReactionInput {
}
/**
 * @public
 *
 * The output of {@link PutCommentReactionCommand}.
 */
export interface PutCommentReactionCommandOutput extends __MetadataBearer {
}
declare const PutCommentReactionCommand_base: {
    new (input: PutCommentReactionCommandInput): import("@smithy/smithy-client").CommandImpl<PutCommentReactionCommandInput, PutCommentReactionCommandOutput, CodeCommitClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: PutCommentReactionCommandInput): import("@smithy/smithy-client").CommandImpl<PutCommentReactionCommandInput, PutCommentReactionCommandOutput, CodeCommitClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Adds or updates a reaction to a specified comment for the user whose identity is used to make the request. You can only add or
 *         update a reaction for yourself. You cannot add, modify, or delete a reaction for another user.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CodeCommitClient, PutCommentReactionCommand } from "@aws-sdk/client-codecommit"; // ES Modules import
 * // const { CodeCommitClient, PutCommentReactionCommand } = require("@aws-sdk/client-codecommit"); // CommonJS import
 * const client = new CodeCommitClient(config);
 * const input = { // PutCommentReactionInput
 *   commentId: "STRING_VALUE", // required
 *   reactionValue: "STRING_VALUE", // required
 * };
 * const command = new PutCommentReactionCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param PutCommentReactionCommandInput - {@link PutCommentReactionCommandInput}
 * @returns {@link PutCommentReactionCommandOutput}
 * @see {@link PutCommentReactionCommandInput} for command's `input` shape.
 * @see {@link PutCommentReactionCommandOutput} for command's `response` shape.
 * @see {@link CodeCommitClientResolvedConfig | config} for CodeCommitClient's `config` shape.
 *
 * @throws {@link CommentDeletedException} (client fault)
 *  <p>This comment has already been deleted. You cannot edit or delete a deleted comment.</p>
 *
 * @throws {@link CommentDoesNotExistException} (client fault)
 *  <p>No comment exists with the provided ID. Verify that you have used the correct ID, and
 *             then try again.</p>
 *
 * @throws {@link CommentIdRequiredException} (client fault)
 *  <p>The comment ID is missing or null. A comment ID is required.</p>
 *
 * @throws {@link InvalidCommentIdException} (client fault)
 *  <p>The comment ID is not in a valid format. Make sure that you have provided the full comment ID.</p>
 *
 * @throws {@link InvalidReactionValueException} (client fault)
 *  <p>The value of the reaction is not valid. For more information, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">CodeCommit User Guide</a>.</p>
 *
 * @throws {@link ReactionLimitExceededException} (client fault)
 *  <p>The number of reactions has been exceeded. Reactions are limited to one reaction per user for each individual comment ID.</p>
 *
 * @throws {@link ReactionValueRequiredException} (client fault)
 *  <p>A reaction value is required. </p>
 *
 * @throws {@link CodeCommitServiceException}
 * <p>Base exception class for all service exceptions from CodeCommit service.</p>
 *
 *
 * @public
 */
export declare class PutCommentReactionCommand extends PutCommentReactionCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: PutCommentReactionInput;
            output: {};
        };
        sdk: {
            input: PutCommentReactionCommandInput;
            output: PutCommentReactionCommandOutput;
        };
    };
}
