import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_UpdatePullRequestTitleCommand, se_UpdatePullRequestTitleCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class UpdatePullRequestTitleCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "UpdatePullRequestTitle", {})
    .n("CodeCommitClient", "UpdatePullRequestTitleCommand")
    .f(void 0, void 0)
    .ser(se_UpdatePullRequestTitleCommand)
    .de(de_UpdatePullRequestTitleCommand)
    .build() {
}
