import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_OverridePullRequestApprovalRulesCommand, se_OverridePullRequestApprovalRulesCommand, } from "../protocols/Aws_json1_1";
export { $Command };
export class OverridePullRequestApprovalRulesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "OverridePullRequestApprovalRules", {})
    .n("CodeCommitClient", "OverridePullRequestApprovalRulesCommand")
    .f(void 0, void 0)
    .ser(se_OverridePullRequestApprovalRulesCommand)
    .de(de_OverridePullRequestApprovalRulesCommand)
    .build() {
}
