import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_MergePullRequestBySquashCommand, se_MergePullRequestBySquashCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class MergePullRequestBySquashCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "MergePullRequestBySquash", {})
    .n("CodeCommitClient", "MergePullRequestBySquashCommand")
    .f(void 0, void 0)
    .ser(se_MergePullRequestBySquashCommand)
    .de(de_MergePullRequestBySquashCommand)
    .build() {
}
