import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListBranchesCommand, se_ListBranchesCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class ListBranchesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "ListBranches", {})
    .n("CodeCommitClient", "ListBranchesCommand")
    .f(void 0, void 0)
    .ser(se_ListBranchesCommand)
    .de(de_ListBranchesCommand)
    .build() {
}
